/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx;

import at.grid.themis.ontology.javafx.ThemisTask;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.VBox;

public class JavaFxProgressBar
extends VBox {
    private ProgressBar progressBar;
    private ThemisTask task;
    private final Label label = new Label("");
    private final Button cancelButton = new Button("Abbrechen");

    public JavaFxProgressBar(ThemisTask task, boolean withCancel, boolean withCounter) {
        if (task == null) {
            throw new IllegalArgumentException("Task argument is null");
        }
        this.task = task;
        this.setSpacing(10.0);
        this.setPadding(new Insets(10.0));
        this.setAlignment(Pos.CENTER);
        this.label.setMaxWidth(Double.MAX_VALUE);
        this.progressBar = withCounter ? new ProgressBar(0.0) : new ProgressBar();
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
        this.progressBar.setMinHeight(20.0);
        this.getChildren().addAll((Object[])new Node[]{this.label, this.progressBar});
        this.cancelButton.setMinWidth(100.0);
        this.cancelButton.setOnAction(event -> {
            this.cancelButton.setDisable(true);
            this.task.progress("wird abgebrochen ...");
            this.task.cancel(true);
        });
        this.cancelButton.setDisable(!withCancel);
        this.cancelButton.setVisible(withCancel);
        if (withCancel) {
            this.getChildren().add((Object)this.cancelButton);
        }
        this.progressBar.progressProperty().unbind();
        this.label.textProperty().unbind();
        if (withCounter) {
            this.progressBar.progressProperty().bind((ObservableValue)this.task.progressProperty());
        }
        this.label.textProperty().bind((ObservableValue)this.task.messageProperty());
        new Thread((Runnable)((Object)this.task)).start();
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public void disableCancel() {
        this.cancelButton.setDisable(true);
        this.cancelButton.setVisible(false);
        if (this.getChildren().contains((Object)this.cancelButton)) {
            this.getChildren().remove((Object)this.cancelButton);
        }
    }

    public void enableCancel() {
        this.cancelButton.setDisable(false);
        this.cancelButton.setVisible(true);
        if (!this.getChildren().contains((Object)this.cancelButton)) {
            this.getChildren().add((Object)this.cancelButton);
        }
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void enableCounter() {
        this.progressBar = new ProgressBar(0.0);
    }

    public boolean hasCancel() {
        return !this.cancelButton.isDisabled();
    }

    public boolean hasCounter() {
        return this.progressBar != null;
    }
}

