/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.util.ImageHelper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.JDialog;

public class JavaFxSwingDialog {
    final String dialogCode;
    private JDialog swingDialog;
    private VBox root;
    private Scene scene;
    private JFXPanel fxPanel;
    private Dimension minimumSize = new Dimension(400, 400);
    private Dimension currentSize = new Dimension(400, 400);
    private boolean resizeable = true;
    private Frame parentFrame = null;

    public JavaFxSwingDialog(String dialogCode, int minWidth, int minHeight) {
        this(dialogCode, new Dimension(minWidth, minHeight));
    }

    public JavaFxSwingDialog(String dialogCode, Dimension dim) {
        this.dialogCode = dialogCode;
        this.minimumSize.setSize(dim);
        this.fxPanel = new JFXPanel();
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> {
            this.root = new VBox();
            this.scene = new Scene((Parent)this.root);
            this.fxPanel.setScene(this.scene);
        });
    }

    public JavaFxSwingDialog setContent(Node content) {
        if (content instanceof JavaFxDialog) {
            ((JavaFxDialog)content).setDialog(this);
        }
        HBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)content, (Priority)Priority.ALWAYS);
        Platform.runLater(() -> {
            this.root.getChildren().clear();
            this.root.getChildren().add((Object)content);
        });
        return this;
    }

    public void setDialogTitle(String t) {
        if (this.swingDialog != null) {
            this.swingDialog.setTitle(t);
        }
    }

    public JavaFxSwingDialog setParentFrame(Frame f) {
        this.parentFrame = f;
        return this;
    }

    public synchronized void show() {
        String t;
        if (this.dialogCode == null) {
            t = "";
        } else {
            t = ThemisApplication.getInstance().getProject().getResourceText(this.dialogCode);
            if (this.dialogCode.equals(t) && (t = ThemisApplication.getInstance().getProject().getResourceText("dialog." + this.dialogCode + ".title")).contains("dialog.") && t.contains(".title")) {
                t = this.dialogCode;
            }
        }
        this.swingDialog = new JDialog((Window)this.parentFrame, t, Dialog.ModalityType.APPLICATION_MODAL);
        this.swingDialog.setResizable(this.resizeable);
        this.swingDialog.setDefaultCloseOperation(2);
        this.swingDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                JavaFxSwingDialog.this.close();
            }
        });
        try {
            BufferedImage image = ImageHelper.loadImage((URL)JavaFxSwingDialog.class.getResource("/at/grid/themis/ontology/javafx/media/themis.gif"));
            this.swingDialog.setIconImage(image);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.swingDialog.add((Component)this.fxPanel);
        this.currentSize = ThemisUtil.getWindowSize(this.dialogCode, (int)this.minimumSize.getWidth(), (int)this.minimumSize.getHeight(), ThemisApplication.getInstance());
        this.swingDialog.setSize(this.currentSize);
        this.swingDialog.setPreferredSize(this.currentSize);
        this.swingDialog.setMinimumSize(this.minimumSize);
        this.swingDialog.setLocationRelativeTo(this.parentFrame);
        this.swingDialog.pack();
        this.swingDialog.setVisible(true);
    }

    public JavaFxSwingDialog close() {
        ThemisApplication.getInstance().getProject().getLogger().fine("Closing FX/Swing Dialog '" + this.dialogCode + "' ...");
        if (this.swingDialog != null) {
            ThemisUtil.setWindowSize(this.dialogCode, this.swingDialog.getSize(), ThemisApplication.getInstance());
            this.swingDialog.dispose();
        }
        ThemisApplication.getInstance().getProject().getLogger().fine("FX/Swing Dialog '" + this.dialogCode + "' closed");
        return this;
    }

    public Scene getScene() {
        return this.scene;
    }

    public JavaFxSwingDialog setResizeable(boolean resizeable) {
        this.resizeable = resizeable;
        return this;
    }

    public boolean isShown() {
        return this.swingDialog != null && this.swingDialog.isVisible();
    }

    public JFXPanel getFxPanel() {
        return this.fxPanel;
    }
}

