/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx;

import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisApplication;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.openide.util.Exceptions;

public class JavaFxUploadItemPanel
extends VBox {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private ListView<UploadItem> itemList;
    private UploadItem selected;
    private CmsElement referenceElement;
    private String attribute;
    private List<UploadItem> items;

    public JavaFxUploadItemPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setMaxWidth(Double.MAX_VALUE);
        this.setMaxHeight(Double.MAX_VALUE);
        this.setSpacing(10.0);
        this.itemList = this.createItemList();
        this.getChildren().add(this.itemList);
        HBox actionBox = this.createActionBox();
        this.getChildren().add((Object)actionBox);
    }

    private ListView<UploadItem> createItemList() {
        ListView result = new ListView();
        result.setMaxWidth(Double.MAX_VALUE);
        result.setMaxHeight(150.0);
        result.setOrientation(Orientation.HORIZONTAL);
        result.setCellFactory(listView -> {
            ListCell<UploadItem> listCell = new ListCell<UploadItem>(){

                protected void updateItem(UploadItem item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty || item == null) {
                        this.setText(null);
                        this.setGraphic(null);
                    } else {
                        if (item.isImage()) {
                            try {
                                File file = new File(item.getAbsolutePath());
                                Image img = new Image((InputStream)new FileInputStream(file), 100.0, 100.0, true, true);
                                ImageView imageView = new ImageView(img);
                                this.setGraphic((Node)imageView);
                                this.setText(null);
                            }
                            catch (FileNotFoundException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        } else {
                            VBox graphic = new VBox();
                            graphic.setMinHeight(100.0);
                            graphic.setPrefHeight(100.0);
                            graphic.setMaxHeight(100.0);
                            graphic.setMinWidth(100.0);
                            graphic.setPrefWidth(100.0);
                            graphic.setMaxWidth(100.0);
                            graphic.setAlignment(Pos.CENTER);
                            String contentType = item.getContenttype();
                            if (null == contentType || "".equals(contentType)) {
                                contentType = "undefined";
                            }
                            Label label = new Label(contentType);
                            graphic.getChildren().add((Object)label);
                            this.setGraphic((Node)graphic);
                            this.setText(null);
                        }
                        if (JavaFxUploadItemPanel.this.selected == item) {
                            this.setStyle("-fx-background-color: transparent; -fx-border-color: red; -fx-border-width: 3;");
                        } else {
                            this.setStyle("-fx-background-color: transparent; -fx-border-color: white; -fx-border-width: 3;");
                        }
                    }
                }
            };
            listCell.setPadding(Insets.EMPTY);
            return listCell;
        });
        result.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.selected = newValue;
        });
        result.setOnDragOver(event -> {
            if (event.getGestureSource() != result) {
                event.acceptTransferModes(TransferMode.ANY);
            }
            event.consume();
        });
        result.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            List files = db.getFiles();
            for (File file : files) {
                File outputfile = new File(this.app.getProject().getTempfileLocation(), file.getName());
                UploadItem item = this.referenceElement.getUploadAttribute(this.attribute).addUpload(outputfile);
                this.items.add(item);
            }
            this.updateListView();
            event.setDropCompleted(true);
            event.consume();
        });
        return result;
    }

    private HBox createActionBox() {
        HBox result = new HBox();
        result.setSpacing(10.0);
        Button view = new Button("View");
        view.setPrefSize(50.0, 50.0);
        result.getChildren().add((Object)view);
        Button edit = new Button("Edit");
        edit.setPrefSize(50.0, 50.0);
        result.getChildren().add((Object)edit);
        Button delete = new Button("Delete");
        delete.setPrefSize(50.0, 50.0);
        result.getChildren().add((Object)delete);
        return result;
    }

    public void populate(CmsElement referenceElement, String attribute) {
        this.referenceElement = referenceElement;
        this.attribute = attribute;
        this.items = referenceElement.getUploadAttribute(attribute).getUploadItems();
        this.updateListView();
    }

    private void updateListView() {
        this.itemList.getItems().clear();
        this.itemList.getItems().addAll(this.items);
    }
}

