/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx;

import at.grid.themis.ontology.javafx.JavaFxUtilities;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class ThemisFxDialog<T> {
    final String title;
    final boolean resizeable;
    final double minWidth;
    final double minHeight;
    private Node content;
    private Dialog<T> dialog;
    private Optional<T> result;

    public ThemisFxDialog(String title) {
        this(title, true);
    }

    public ThemisFxDialog(String title, boolean resizeable) {
        this(title, 400.0, 300.0, resizeable);
    }

    public ThemisFxDialog(String title, double minWidth, double minHeight, boolean resizeable) {
        this.title = title;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.resizeable = resizeable;
        if (!Platform.isFxApplicationThread()) {
            JavaFxUtilities.ensureInitialized();
        }
    }

    public ThemisFxDialog<T> setContent(Node content) {
        this.content = content;
        return this;
    }

    public Optional<T> show() {
        if (!Platform.isFxApplicationThread()) {
            CountDownLatch latch = new CountDownLatch(1);
            Platform.runLater(() -> {
                this.init();
                this.result = this.dialog.showAndWait();
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.init();
            this.result = this.dialog.showAndWait();
        }
        return this.result;
    }

    private void init() {
        this.dialog = new Dialog();
        this.dialog.setTitle(this.title);
        this.dialog.setResizable(this.resizeable);
        this.dialog.getDialogPane().setMinSize(this.minWidth, this.minHeight);
        this.dialog.getDialogPane().setContent(this.content);
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        Stage stage = (Stage)this.dialog.getDialogPane().getScene().getWindow();
        stage.getIcons().add((Object)new Image(ThemisFxDialog.class.getResource("media/themis.gif").toString()));
        stage.initModality(Modality.APPLICATION_MODAL);
    }

    public void close() {
        if (!Platform.isFxApplicationThread()) {
            CountDownLatch latch = new CountDownLatch(1);
            Platform.runLater(() -> {
                this.dialog.hide();
                this.dialog.close();
            });
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.dialog.hide();
            this.dialog.close();
        }
    }
}

