/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.action.SimpleAction;
import at.grid.themis.ontology.javafx.JavaFxProgressBar;
import at.grid.themis.ontology.javafx.ThemisTask;
import at.grid.util.ProgressHandler;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;

public abstract class ThemisTaskWithFxDialog
extends ThemisTask {
    private final Stage dialogStage = new Stage();
    private final JavaFxProgressBar pane;
    private Object returnValue = null;

    public ThemisTaskWithFxDialog(String title, boolean withCancel, boolean withCounter) {
        this.dialogStage.setTitle(ThemisApplication.getInstance().getProject().getResourceText(title));
        this.dialogStage.setWidth(300.0);
        this.dialogStage.setResizable(false);
        this.dialogStage.initModality(Modality.APPLICATION_MODAL);
        this.pane = new JavaFxProgressBar(this, withCancel, withCounter);
        this.dialogStage.setScene(new Scene((Parent)this.pane));
        this.dialogStage.centerOnScreen();
        this.dialogStage.show();
    }

    public static ThemisTaskWithFxDialog createTask(String title, boolean withCancel, boolean withCounter, final SimpleAction a) {
        return new ThemisTaskWithFxDialog(title, withCancel, withCounter){

            @Override
            public void execute(ProgressHandler ph) {
                a.execute(ph);
            }
        };
    }

    public static ThemisTaskWithFxDialog createTask(String title, SimpleAction a) {
        return ThemisTaskWithFxDialog.createTask(title, false, false, a);
    }

    public ThemisTaskWithFxDialog withCancel() {
        this.pane.enableCancel();
        return this;
    }

    public void disableCancel() {
        this.pane.disableCancel();
    }

    public ThemisTaskWithFxDialog withCounter() {
        this.pane.enableCounter();
        return this;
    }

    protected void setReturnValue(Object o) {
        this.returnValue = o;
    }

    protected Object call() throws Exception {
        this.execute(this);
        this.closeDialog();
        return this.returnValue;
    }

    private void closeDialog() {
        Platform.runLater(() -> {
            if (this.dialogStage != null) {
                this.dialogStage.close();
            }
        });
    }

    public abstract void execute(ProgressHandler var1);

    @Override
    public void setDisplayName(String t) {
        if (this.dialogStage != null) {
            this.dialogStage.setTitle(t);
        }
    }
}

