/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.about;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import java.util.Calendar;
import java.util.Date;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class AboutFxPane
extends VBox {
    public AboutFxPane() {
        this.populate();
    }

    private void populate() {
        this.setPadding(new Insets(16.0));
        this.setSpacing(16.0);
        this.setPrefHeight(-1.0);
        this.setPrefWidth(-1.0);
        this.setAlignment(Pos.TOP_CENTER);
        Image logoImage = new Image(AboutFxPane.class.getResourceAsStream("media/logo.jpg"));
        ImageView logo = new ImageView();
        logo.setPreserveRatio(true);
        logo.setFitWidth(300.0);
        logo.setImage(logoImage);
        this.getChildren().add((Object)logo);
        HBox infoBox = new HBox();
        infoBox.setSpacing(16.0);
        infoBox.setPrefHeight(-1.0);
        infoBox.setPrefWidth(-1.0);
        infoBox.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)infoBox, (Priority)Priority.ALWAYS);
        VBox textBox = new VBox();
        textBox.setSpacing(16.0);
        textBox.setPrefHeight(-1.0);
        textBox.setPrefWidth(-1.0);
        textBox.setAlignment(Pos.CENTER_LEFT);
        textBox.setFillWidth(true);
        HBox.setHgrow((Node)textBox, (Priority)Priority.ALWAYS);
        Label versionLabel = new Label("THEMIS Version " + ThemisProject.VERSION);
        versionLabel.setStyle("-fx-text-fill: grey");
        textBox.getChildren().add((Object)versionLabel);
        Calendar cal = Calendar.getInstance(ThemisApplication.getInstance().getTimeZone(), ThemisApplication.getInstance().getLocale());
        cal.setTime(new Date());
        int curYear = cal.get(1);
        Label copyrightLabel = new Label("Copyright \u00a9; 2010 - " + curYear + " THEMIS Software GmbH");
        textBox.getChildren().add((Object)copyrightLabel);
        GridPane contactGrid = new GridPane();
        contactGrid.setHgap(10.0);
        HBox.setHgrow((Node)contactGrid, (Priority)Priority.ALWAYS);
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setFillWidth(false);
        cc1.setHgrow(Priority.NEVER);
        cc1.setMinWidth(-1.0);
        cc1.setPrefWidth(-1.0);
        cc1.setMaxWidth(-1.0);
        cc1.setPercentWidth(-1.0);
        contactGrid.getColumnConstraints().add((Object)cc1);
        ColumnConstraints cc2 = new ColumnConstraints();
        cc2.setFillWidth(true);
        cc2.setHgrow(Priority.ALWAYS);
        cc2.setMinWidth(-1.0);
        cc2.setPrefWidth(-1.0);
        cc2.setMaxWidth(Double.MAX_VALUE);
        cc2.setPercentWidth(-1.0);
        contactGrid.getColumnConstraints().add((Object)cc2);
        Label telHeadingLabel = JavaFxFactory.createLabel("Telefon");
        Label telLabel = new Label("+43 512 531677");
        contactGrid.addRow(0, new Node[]{telHeadingLabel, telLabel});
        Label emailHeadingLabel = JavaFxFactory.createLabel("E-Mail");
        Label emailLabel = new Label("info@themis-software.com");
        contactGrid.addRow(1, new Node[]{emailHeadingLabel, emailLabel});
        Label websiteHeadingLabel = JavaFxFactory.createLabel("Website");
        Label websiteLabel = new Label("www.themis-software.com");
        contactGrid.addRow(2, new Node[]{websiteHeadingLabel, websiteLabel});
        textBox.getChildren().add((Object)contactGrid);
        infoBox.getChildren().add((Object)textBox);
        Image qrCodeImage = new Image(AboutFxPane.class.getResourceAsStream("media/qr_code.png"));
        ImageView qrCode = new ImageView();
        qrCode.setPreserveRatio(true);
        qrCode.setFitWidth(200.0);
        qrCode.setImage(qrCodeImage);
        infoBox.getChildren().add((Object)qrCode);
        this.getChildren().add((Object)infoBox);
    }
}

