/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.attributepanel;

import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.element.CmsElement;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.attribute.manager.ThemisAttributeManager;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.javafx.attributepanel.ThemisSingleAttributeFxPane;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class ThemisAttributeFxPanel
extends ScrollPane {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    CmsElement ele = null;
    GridPane gridPane = new GridPane();
    int row = 0;
    HashMap<String, ThemisSingleAttributeFxPane> components = new HashMap();

    public ThemisAttributeFxPanel(CmsElement ele) {
        this.ele = ele;
        this.setFitToHeight(true);
        this.setFitToWidth(true);
    }

    public ThemisAttributeFxPanel populate(CmsElement element) {
        this.ele = element;
        return this.populate();
    }

    public ThemisAttributeFxPanel populate() {
        this.gridPane = new GridPane();
        ColumnConstraints ccLabel = new ColumnConstraints();
        ccLabel.setFillWidth(false);
        ccLabel.setHgrow(Priority.NEVER);
        ccLabel.setHalignment(HPos.LEFT);
        ccLabel.setMinWidth(-1.0);
        ccLabel.setPrefWidth(-1.0);
        ccLabel.setMaxWidth(-1.0);
        ccLabel.setPercentWidth(0.0);
        this.gridPane.getColumnConstraints().add((Object)ccLabel);
        ColumnConstraints ccNode = new ColumnConstraints();
        ccNode.setFillWidth(true);
        ccNode.setHgrow(Priority.ALWAYS);
        ccNode.setHalignment(HPos.LEFT);
        ccNode.setMinWidth(-1.0);
        ccNode.setPrefWidth(-1.0);
        ccNode.setMaxWidth(-1.0);
        ccNode.setPercentWidth(-1.0);
        this.gridPane.getColumnConstraints().add((Object)ccNode);
        ThemisAttributeManager tam = this.settings.getAttributeManager(this.ele.getElementcode());
        ArrayList<ThemisAttribute> atts = tam.getAttributes();
        this.row = 0;
        for (ThemisAttribute att : atts) {
            if (!att.isUsed()) continue;
            ThemisSingleAttributeFxPane attPane = new ThemisSingleAttributeFxPane(att, this.ele);
            attPane.addToGridPane(this.gridPane, this.row++);
            this.components.put(att.getId(), attPane);
        }
        this.setContent((Node)this.gridPane);
        return this;
    }

    private void applyToAttribute(ThemisAttribute att) {
        ThemisSingleAttributeFxPane attPane = this.components.get(att.getId());
        if (attPane == null) {
            return;
        }
        Node n = attPane.getContent();
        if (n == null) {
            return;
        }
        boolean foundSpecial = false;
        if (att.getTarget() == ThemisAttribute.Target.OBSERVATION) {
            switch (att.getId()) {
                case "repeat": {
                    foundSpecial = true;
                    this.applyRepeatAttribute((HBox)n);
                    break;
                }
                case "documents": {
                    foundSpecial = true;
                    this.applyDocumentsAttribute(attPane);
                }
            }
        } else if (att.getTarget() == ThemisAttribute.Target.LOCATION) {
            switch (att.getId()) {
                case "group": {
                    foundSpecial = true;
                    this.applyRelationAttribute((ComboBox<CmsBasicElement>)((ComboBox)n), att);
                    break;
                }
                case "icon": {
                    foundSpecial = true;
                    this.applyRelationAttribute((ComboBox<CmsBasicElement>)((ComboBox)((HBox)n).getChildren().get(1)), att);
                    break;
                }
                case "size": {
                    foundSpecial = true;
                    this.applyMeasureAttribtue((GridPane)n);
                    break;
                }
                case "documents": {
                    foundSpecial = true;
                    this.applyDocumentsAttribute(attPane);
                }
            }
        }
        if (!foundSpecial) {
            switch (att.getTypeId()) {
                case BOOLEAN: {
                    this.ele.getBooleanAttribute(att.getCmsCode()).setValue(((CheckBox)n).isSelected());
                    break;
                }
                case DATE: {
                    LocalDate ldt = (LocalDate)((DatePicker)n).getValue();
                    if (ldt != null) {
                        DateAttribute attribute = this.ele.getDateAttribute(att.getCmsCode());
                        if (null == attribute) break;
                        attribute.setDate((java.util.Date)Date.valueOf(ldt));
                        break;
                    }
                    CmsAttribute attribute = this.ele.getAttribute(att.getCmsCode());
                    if (null == attribute) break;
                    attribute.clear();
                    break;
                }
                case LIST: {
                    Object sel = ((ComboBox)n).getSelectionModel().getSelectedItem();
                    if (sel != null && sel instanceof KeytableRecord) {
                        this.ele.getKeyAttribute(att.getCmsCode()).setValue(((KeytableRecord)sel).id);
                        break;
                    }
                    this.ele.getAttribute(att.getCmsCode()).clear();
                    break;
                }
                case LONGTEXT: {
                    this.ele.setAttributeValue(att.getCmsCode(), ((TextArea)n).getText());
                    break;
                }
                case NUMBER: 
                case TEXT: {
                    this.ele.setAttributeValue(att.getCmsCode(), ((TextField)n).getText());
                    break;
                }
                case RELATION: {
                    ComboBox relationCombo = (ComboBox)n;
                    this.applyRelationAttribute((ComboBox<CmsBasicElement>)relationCombo, att);
                    break;
                }
                case UPLOAD: {
                    CmsAttribute cmsatt = this.ele.getAttribute(att.getCmsCode());
                    boolean debug = false;
                    break;
                }
                case NONE: {
                    break;
                }
            }
        }
    }

    private void applyRepeatAttribute(HBox repeatBox) {
        TextField text = (TextField)repeatBox.getChildren().get(0);
        int v = Util.parseInt((String)text.getText(), (int)0);
        ComboBox repeatCombo = (ComboBox)repeatBox.getChildren().get(1);
        Object sel = repeatCombo.getSelectionModel().getSelectedItem();
        if (sel != null && sel instanceof KeytableRecord && v > 0) {
            this.ele.getIntegerAttribute("duedate").setValue(v);
            this.ele.getKeyAttribute("repeat").setValue(((KeytableRecord)sel).id);
        } else {
            this.ele.getAttribute("duedate").clear();
            this.ele.getAttribute("repeat").clear();
        }
    }

    private void applyDocumentsAttribute(ThemisSingleAttributeFxPane attPane) {
        HBox documentBox = (HBox)attPane.getContent();
        HashMap<Long, CmsInfo> newDocs = attPane.getNewDocuments();
        GridPane documentGrid = (GridPane)documentBox.getChildren().get(0);
        for (Node child : documentGrid.getChildren()) {
            if (!(child instanceof ListView)) continue;
            ListView doumentList = (ListView)child;
            for (CmsBasicElement info : doumentList.getItems()) {
                if (newDocs.containsKey(info.getId())) {
                    newDocs.get(info.getId()).save();
                }
                this.ele.getRelationAttribute("infos").add(info.getId());
            }
        }
    }

    private void applyRelationAttribute(ComboBox<CmsBasicElement> relationCombo, ThemisAttribute att) {
        CmsBasicElement selected = (CmsBasicElement)relationCombo.getSelectionModel().getSelectedItem();
        if (selected != null) {
            this.ele.getRelationAttribute(att.getCmsCode()).set(selected.getId());
        } else {
            this.ele.getRelationAttribute(att.getCmsCode()).clear();
        }
    }

    public CmsElement apply(boolean doSave) {
        ThemisAttributeManager tam = this.settings.getAttributeManager(this.ele.getElementcode());
        ArrayList<ThemisAttribute> atts = tam.getAttributes();
        this.row = 0;
        for (ThemisAttribute att : atts) {
            if (!att.isUsed()) continue;
            this.applyToAttribute(att);
        }
        if (doSave) {
            this.ele.save();
            switch (this.ele.getElementcode()) {
                case "event": {
                    ThemisApplication.getInstance().getProject().createActionLog("event_edit", this.ele.getId(), "");
                    ThemisApplication.getInstance().getActionProvider().invokeAction(ThemisAction.EVENT_SAVED);
                }
            }
        }
        return this.ele;
    }

    private void applyMeasureAttribtue(GridPane n) {
    }
}

