/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.attributepanel;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsIcon;
import at.grid.themis.ontology.element.CmsInfo;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.openide.util.Exceptions;

public class ThemisSingleAttributeFxPane {
    ThemisProject project = ThemisApplication.getInstance().getProject();
    ThemisAttribute att;
    CmsElement ele;
    Label lbl;
    Node n;
    HashMap<Long, Image> icons = new HashMap();
    List<CmsBasicElement> docs;
    HashMap<Long, CmsInfo> newDocuments = new HashMap();

    public ThemisSingleAttributeFxPane(ThemisAttribute att, CmsElement ele) {
        this.att = att;
        this.ele = ele;
    }

    public Label getLabel() {
        return this.lbl;
    }

    public Node getContent() {
        return this.n;
    }

    public HashMap<Long, CmsInfo> getNewDocuments() {
        return this.newDocuments;
    }

    public void addToGridPane(GridPane gridPane, int row) {
        double minHeight = 30.0;
        this.lbl = new Label(this.att.getLabel());
        this.lbl.setMinHeight(minHeight);
        this.lbl.setStyle("-fx-font-weight: bold;");
        this.n = null;
        boolean foundSpecial = false;
        if (this.att.getTarget() == ThemisAttribute.Target.OBSERVATION) {
            switch (this.att.getId()) {
                case "repeat": {
                    foundSpecial = true;
                    this.n = this.getRepeatView();
                    break;
                }
                case "repeatunit": 
                case "duedate": 
                case "donedate": {
                    return;
                }
                case "responsible": {
                    foundSpecial = true;
                    this.n = this.getContactsView(this.att);
                    break;
                }
                case "documents": {
                    foundSpecial = true;
                    this.n = this.getDocumentsView(this.att);
                }
            }
        } else if (this.att.getTarget() == ThemisAttribute.Target.LOCATION) {
            switch (this.att.getId()) {
                case "group": {
                    foundSpecial = true;
                    this.n = this.getGroupView(this.att);
                    break;
                }
                case "icon": {
                    foundSpecial = true;
                    this.n = this.getIconView(this.att);
                    break;
                }
                case "size": {
                    foundSpecial = true;
                    this.n = this.getMeasureView();
                    break;
                }
                case "documents": {
                    foundSpecial = true;
                    this.n = this.getDocumentsView(this.att);
                }
            }
        }
        if (!foundSpecial) {
            switch (this.att.getTypeId()) {
                case BOOLEAN: {
                    this.n = new CheckBox();
                    ((CheckBox)this.n).setSelected(this.ele.getBooleanAttribute(this.att.getCmsCode()).isSet());
                    ((CheckBox)this.n).setMinHeight(minHeight);
                    break;
                }
                case DATE: {
                    Date dt;
                    this.n = new DatePicker();
                    ((DatePicker)this.n).setMaxWidth(Double.MAX_VALUE);
                    ((DatePicker)this.n).setMinHeight(minHeight);
                    DateAttribute dateAttribute = this.ele.getDateAttribute(this.att.getCmsCode());
                    if (dateAttribute == null || (dt = dateAttribute.getDate()) == null) break;
                    LocalDate ldt = dt.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    ((DatePicker)this.n).setValue((Object)ldt);
                    break;
                }
                case LIST: {
                    KeyAttribute cmsatt = this.ele.getKeyAttribute(this.att.getCmsCode());
                    if (cmsatt == null) break;
                    this.n = this.getComboBox(cmsatt.getTableCode(), true, cmsatt.getId());
                    ((ComboBox)this.n).setMinHeight(minHeight);
                    ((ComboBox)this.n).setMaxWidth(Double.MAX_VALUE);
                    break;
                }
                case LONGTEXT: {
                    TextArea textArea = new TextArea(this.ele == null ? "" : this.ele.getAttributeValue(this.att.getCmsCode()));
                    textArea.setMinHeight(100.0);
                    textArea.setWrapText(true);
                    this.n = textArea;
                    break;
                }
                case NUMBER: 
                case TEXT: {
                    this.n = new TextField(this.ele == null ? "" : this.ele.getAttributeValue(this.att.getCmsCode()));
                    ((TextField)this.n).setMinHeight(minHeight);
                    break;
                }
                case RELATION: {
                    this.n = new Label("");
                    ((Label)this.n).setMinHeight(minHeight);
                    break;
                }
                case UPLOAD: {
                    this.n = this.getUploadView(this.att);
                    break;
                }
                case NONE: {
                    this.n = new Label("");
                    ((Label)this.n).setMinHeight(minHeight);
                    break;
                }
                case COMPLEX: {
                    this.n = new Label("");
                    ((Label)this.n).setMinHeight(minHeight);
                }
            }
        }
        if (this.n != null) {
            RowConstraints rc = new RowConstraints();
            rc.setMinHeight(-1.0);
            rc.setPrefHeight(-1.0);
            rc.setMaxHeight(-1.0);
            rc.setPercentHeight(-1.0);
            rc.setVgrow(Priority.NEVER);
            rc.setValignment(VPos.TOP);
            GridPane.setValignment((Node)this.n, (VPos)VPos.TOP);
            GridPane.setHalignment((Node)this.n, (HPos)HPos.LEFT);
            GridPane.setHgrow((Node)this.n, (Priority)Priority.ALWAYS);
            GridPane.setMargin((Node)this.n, (Insets)new Insets(5.0));
            GridPane.setValignment((Node)this.lbl, (VPos)VPos.TOP);
            GridPane.setHalignment((Node)this.lbl, (HPos)HPos.LEFT);
            GridPane.setHgrow((Node)this.lbl, (Priority)Priority.NEVER);
            GridPane.setMargin((Node)this.lbl, (Insets)new Insets(5.0));
            gridPane.addRow(row, new Node[]{this.lbl, this.n});
        }
    }

    private HBox getRepeatView() {
        HBox result = new HBox();
        result.setSpacing(8.0);
        result.setAlignment(Pos.CENTER_LEFT);
        TextField repeatFld = new TextField(this.ele.getAttributeValue("duedate"));
        repeatFld.setMinHeight(30.0);
        result.getChildren().add((Object)repeatFld);
        KeyAttribute keyAttribute = this.ele.getKeyAttribute("repeat");
        if (keyAttribute != null) {
            ComboBox<KeytableRecord> repeatCombo = this.getComboBox("repeat", true, keyAttribute.getId());
            HBox.setHgrow(repeatCombo, (Priority)Priority.ALWAYS);
            result.getChildren().add(repeatCombo);
        }
        return result;
    }

    private GridPane getMeasureView() {
        GridPane result = new GridPane();
        result.setHgap(8.0);
        result.setVgap(8.0);
        HBox.setHgrow((Node)result, (Priority)Priority.ALWAYS);
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setFillWidth(true);
        cc1.setHgrow(Priority.ALWAYS);
        cc1.setHalignment(HPos.LEFT);
        cc1.setMinWidth(-1.0);
        cc1.setPrefWidth(-1.0);
        cc1.setMaxWidth(-1.0);
        cc1.setPercentWidth(-1.0);
        result.getColumnConstraints().add((Object)cc1);
        ColumnConstraints cc2 = new ColumnConstraints();
        cc2.setFillWidth(false);
        cc2.setHgrow(Priority.NEVER);
        cc2.setHalignment(HPos.LEFT);
        cc2.setMinWidth(-1.0);
        cc2.setPrefWidth(-1.0);
        cc2.setMaxWidth(-1.0);
        cc2.setPercentWidth(0.0);
        result.getColumnConstraints().add((Object)cc2);
        ColumnConstraints cc3 = new ColumnConstraints();
        cc3.setFillWidth(true);
        cc3.setHgrow(Priority.ALWAYS);
        cc3.setHalignment(HPos.LEFT);
        cc3.setMinWidth(-1.0);
        cc3.setPrefWidth(-1.0);
        cc3.setMaxWidth(-1.0);
        cc3.setPercentWidth(-1.0);
        result.getColumnConstraints().add((Object)cc3);
        TextField infoFld = new TextField();
        infoFld.setMinHeight(30.0);
        Label areaLabel = new Label("Fl\u00e4che");
        areaLabel.setStyle("-fx-font-weight: bold;");
        TextField areaFld = new TextField();
        areaFld.setMinHeight(30.0);
        result.addRow(0, new Node[]{infoFld, areaLabel, areaFld});
        return result;
    }

    private ComboBox<CmsBasicElement> getContactsView(ThemisAttribute att) {
        ComboBox result = new ComboBox();
        result.setMaxWidth(Double.MAX_VALUE);
        result.setMinHeight(30.0);
        ArrayList<CmsBasicElement> contacts = this.project.getContacts();
        result.getItems().addAll(contacts);
        result.getItems().add(0, null);
        long selected = this.ele.getRelationAttribute(att.getCmsCode()).getFirstElementId();
        if (selected > 0L) {
            contacts.forEach(contact -> {
                if (contact.getId() == selected) {
                    result.getSelectionModel().select(contact);
                }
            });
        }
        return result;
    }

    private HBox getDocumentsView(ThemisAttribute att) {
        HBox result = new HBox();
        result.setSpacing(8.0);
        result.setAlignment(Pos.CENTER_LEFT);
        GridPane grid = new GridPane();
        grid.setHgap(8.0);
        grid.setVgap(8.0);
        grid.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)grid, (Priority)Priority.ALWAYS);
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setPercentWidth(50.0);
        grid.getColumnConstraints().add((Object)cc1);
        ColumnConstraints cc2 = new ColumnConstraints();
        cc2.setPercentWidth(50.0);
        grid.getColumnConstraints().add((Object)cc2);
        List<CmsBasicElement> documents = this.loadDocuments();
        ComboBox<KeytableRecord> typeCombo = this.getComboBox("documenttype", true, -1L);
        typeCombo.setMinHeight(30.0);
        typeCombo.setMaxWidth(Double.MAX_VALUE);
        ComboBox docCombo = new ComboBox();
        docCombo.setMinHeight(30.0);
        docCombo.setMaxWidth(Double.MAX_VALUE);
        docCombo.getItems().addAll(documents);
        ListView docList = new ListView();
        docList.setMinHeight(120.0);
        docList.setPrefHeight(120.0);
        docList.setOnDragOver(event -> {
            if (event.getDragboard().hasFiles()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
            event.consume();
        });
        docList.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            if (db.hasFiles()) {
                for (File file : db.getFiles()) {
                    docList.getItems().add((Object)this.addNewDocument(file));
                }
            }
            event.setDropCompleted(true);
            event.consume();
        });
        GridPane.setColumnSpan((Node)docList, (Integer)2);
        grid.addRow(1, new Node[]{docList});
        RelationAttribute infosAttribute = this.ele.getRelationAttribute(att.getCmsCode());
        for (CmsElementSummary doc : infosAttribute.getElements()) {
            for (CmsBasicElement document : documents) {
                if (doc.getId() != document.getId()) continue;
                docList.getItems().add((Object)document);
                docCombo.getItems().remove((Object)document);
            }
        }
        typeCombo.getSelectionModel().selectedItemProperty().addListener((ov, oldValue, newValue) -> {
            List<CmsBasicElement> filteredDocs = this.filterDocuments((KeytableRecord)newValue, (List<CmsBasicElement>)docList.getItems());
            docCombo.getItems().clear();
            docCombo.getItems().addAll(filteredDocs);
            docCombo.getSelectionModel().selectFirst();
        });
        grid.addRow(0, new Node[]{typeCombo, docCombo});
        result.getChildren().add((Object)grid);
        VBox btnBox = new VBox();
        btnBox.setSpacing(8.0);
        btnBox.setAlignment(Pos.TOP_CENTER);
        Button addBtn = new Button();
        addBtn.setGraphic((Node)new ImageView(new Image(ThemisSingleAttributeFxPane.class.getResourceAsStream("media/add.png"), 20.0, 20.0, true, true)));
        addBtn.setPrefHeight(30.0);
        addBtn.setPrefWidth(30.0);
        addBtn.setMinHeight(30.0);
        addBtn.setMinWidth(30.0);
        addBtn.setOnAction(ev -> {
            CmsBasicElement selectedDoc = (CmsBasicElement)docCombo.getSelectionModel().getSelectedItem();
            if (selectedDoc != null) {
                docList.getItems().add((Object)selectedDoc);
                docCombo.getItems().remove((Object)selectedDoc);
            }
        });
        btnBox.getChildren().add((Object)addBtn);
        Button removeBtn = new Button();
        removeBtn.setGraphic((Node)new ImageView(new Image(ThemisSingleAttributeFxPane.class.getResourceAsStream("media/remove.png"), 20.0, 20.0, true, true)));
        removeBtn.setPrefHeight(30.0);
        removeBtn.setPrefWidth(30.0);
        removeBtn.setMinHeight(30.0);
        removeBtn.setMinWidth(30.0);
        removeBtn.setOnAction(ev -> {
            CmsBasicElement selectedDoc = (CmsBasicElement)docList.getSelectionModel().getSelectedItem();
            if (selectedDoc != null) {
                docList.getItems().remove((Object)selectedDoc);
                if (this.newDocuments.containsKey(selectedDoc.getId())) {
                    this.newDocuments.remove(selectedDoc.getId());
                } else {
                    List<CmsBasicElement> filtered = this.filterDocuments((KeytableRecord)typeCombo.getSelectionModel().getSelectedItem(), (List<CmsBasicElement>)docList.getItems());
                    docCombo.getItems().clear();
                    docCombo.getItems().addAll(filtered);
                }
            }
        });
        btnBox.getChildren().add((Object)removeBtn);
        Button chooseBtn = new Button();
        chooseBtn.setGraphic((Node)new ImageView(new Image(ThemisSingleAttributeFxPane.class.getResourceAsStream("media/folder.png"), 20.0, 20.0, true, true)));
        chooseBtn.setPrefHeight(30.0);
        chooseBtn.setPrefWidth(30.0);
        chooseBtn.setMinHeight(30.0);
        chooseBtn.setMinWidth(30.0);
        chooseBtn.setOnAction(ev -> {
            FileChooser fileChooser = new FileChooser();
            List files = fileChooser.showOpenMultipleDialog(null);
            if (null != files) {
                for (File file : files) {
                    docList.getItems().add((Object)this.addNewDocument(file));
                }
            }
        });
        btnBox.getChildren().add((Object)chooseBtn);
        Button viewBtn = new Button();
        viewBtn.setGraphic((Node)new ImageView(new Image(ThemisSingleAttributeFxPane.class.getResourceAsStream("media/open.png"), 20.0, 20.0, true, true)));
        viewBtn.setPrefHeight(30.0);
        viewBtn.setPrefWidth(30.0);
        viewBtn.setMinHeight(30.0);
        viewBtn.setMinWidth(30.0);
        viewBtn.setOnAction(ev -> {
            UploadAttribute upload;
            UploadItem item;
            CmsInfo info;
            CmsBasicElement element = (CmsBasicElement)docList.getSelectionModel().getSelectedItem();
            if (null != element && (info = this.newDocuments.containsKey(element.getId()) ? this.newDocuments.get(element.getId()) : (CmsInfo)this.project.loadElement(element.getId(), this.project.getUser())) != null && null != (item = (upload = info.getUploadAttribute("files")).getUploadItem(0))) {
                try {
                    Desktop.getDesktop().open(item.getFile());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        btnBox.getChildren().add((Object)viewBtn);
        result.getChildren().add((Object)btnBox);
        return result;
    }

    private List<CmsBasicElement> filterDocuments(KeytableRecord docType, List<CmsBasicElement> chosenDocs) {
        ArrayList<CmsBasicElement> result = new ArrayList<CmsBasicElement>();
        List<CmsBasicElement> documents = this.loadDocuments();
        documents.removeAll(chosenDocs);
        if (docType != null) {
            documents.forEach(document -> {
                CmsInfo doc;
                if (document != null && (doc = (CmsInfo)this.project.loadElement(document.getId(), this.project.getUser())) != null && docType.id == doc.getKeyAttribute("documenttype").getId()) {
                    result.add((CmsBasicElement)document);
                }
            });
        } else {
            result.addAll(documents);
        }
        return result;
    }

    private List<CmsBasicElement> loadDocuments() {
        ArrayList<CmsBasicElement> result = new ArrayList<CmsBasicElement>();
        if (this.docs == null) {
            CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("info");
            s.addSelectMeta();
            s.addSelectAllAttributes("info");
            s.setSort("el.title");
            SearchResult searchResult = s.search();
            this.docs = searchResult.getResultAsBasicElements();
        }
        result.addAll(this.docs);
        return result;
    }

    private HBox getUploadView(ThemisAttribute att) {
        HBox result = new HBox();
        result.setSpacing(8.0);
        result.setAlignment(Pos.CENTER_LEFT);
        ListView fileList = new ListView();
        fileList.setMinHeight(120.0);
        fileList.setPrefHeight(120.0);
        fileList.setOnDragOver(event -> {
            if (event.getDragboard().hasFiles()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
            event.consume();
        });
        fileList.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            if (db.hasFiles()) {
                UploadAttribute cmsatt = (UploadAttribute)att.getCmsAttribute();
                for (File file : db.getFiles()) {
                    UploadItem item = cmsatt.addUpload(file);
                    fileList.getItems().add((Object)item);
                }
            }
            event.setDropCompleted(true);
            event.consume();
        });
        UploadAttribute cmsatt = (UploadAttribute)att.getCmsAttribute();
        for (UploadItem item : cmsatt.getAllUploadItems()) {
            fileList.getItems().add((Object)item);
        }
        VBox btnBox = new VBox();
        btnBox.setSpacing(8.0);
        btnBox.setAlignment(Pos.TOP_CENTER);
        Button addBtn = new Button();
        addBtn.setGraphic((Node)new ImageView(new Image(ThemisSingleAttributeFxPane.class.getResourceAsStream("media/add.png"), 20.0, 20.0, true, true)));
        addBtn.setPrefHeight(30.0);
        addBtn.setPrefWidth(30.0);
        addBtn.setMinHeight(30.0);
        addBtn.setMinWidth(30.0);
        addBtn.setOnAction(ev -> {
            FileChooser fileChooser = new FileChooser();
            List files = fileChooser.showOpenMultipleDialog(null);
            if (null != files) {
                for (File file : files) {
                    UploadItem item = ((UploadAttribute)att.getCmsAttribute()).addUpload(file);
                    fileList.getItems().add((Object)item);
                }
            }
        });
        btnBox.getChildren().add((Object)addBtn);
        Button removeBtn = new Button();
        removeBtn.setGraphic((Node)new ImageView(new Image(ThemisSingleAttributeFxPane.class.getResourceAsStream("media/remove.png"), 20.0, 20.0, true, true)));
        removeBtn.setPrefHeight(30.0);
        removeBtn.setPrefWidth(30.0);
        removeBtn.setMinHeight(30.0);
        removeBtn.setMinWidth(30.0);
        removeBtn.setOnAction(ev -> {});
        btnBox.getChildren().add((Object)removeBtn);
        Button viewBtn = new Button();
        viewBtn.setGraphic((Node)new ImageView(new Image(ThemisSingleAttributeFxPane.class.getResourceAsStream("media/open.png"), 20.0, 20.0, true, true)));
        viewBtn.setPrefHeight(30.0);
        viewBtn.setPrefWidth(30.0);
        viewBtn.setMinHeight(30.0);
        viewBtn.setMinWidth(30.0);
        viewBtn.setOnAction(ev -> {
            UploadItem item = (UploadItem)fileList.getSelectionModel().getSelectedItem();
            if (null != item) {
                try {
                    Desktop.getDesktop().open(item.getFile());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        btnBox.getChildren().add((Object)viewBtn);
        HBox.setHgrow((Node)fileList, (Priority)Priority.ALWAYS);
        result.getChildren().add((Object)fileList);
        result.getChildren().add((Object)btnBox);
        return result;
    }

    private ComboBox<CmsBasicElement> getGroupView(ThemisAttribute att) {
        RelationAttribute groupAttribute = this.ele.getRelationAttribute(att.getCmsCode());
        long currentGroupId = groupAttribute.getFirstElementId();
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("locationgroup");
        s.setSort("el.title");
        s.addSelectMeta();
        SearchResult search = s.search();
        ArrayList groupRecords = search.getResultAsBasicElements();
        ComboBox groupCombo = new ComboBox();
        groupCombo.setMaxWidth(Double.MAX_VALUE);
        groupCombo.setMinHeight(30.0);
        HBox.setHgrow((Node)groupCombo, (Priority)Priority.ALWAYS);
        groupCombo.getItems().addAll((Collection)groupRecords);
        groupCombo.getItems().add(0, null);
        if (currentGroupId > 0L) {
            long cid = currentGroupId;
            groupRecords.forEach(record -> {
                if (cid == record.getId()) {
                    groupCombo.getSelectionModel().select(record);
                }
            });
        }
        return groupCombo;
    }

    private HBox getIconView(ThemisAttribute att) {
        HBox result = new HBox();
        result.setSpacing(8.0);
        result.setAlignment(Pos.CENTER_LEFT);
        result.setMaxWidth(Double.MAX_VALUE);
        RelationAttribute iconAttribute = this.ele.getRelationAttribute(att.getCmsCode());
        long currentIconId = iconAttribute.getFirstElementId();
        result.getChildren().add((Object)this.getIconDisplay(currentIconId));
        ArrayList<CmsBasicElement> iconRecords = this.project.getIcons();
        ComboBox iconCombo = new ComboBox();
        iconCombo.setMaxWidth(Double.MAX_VALUE);
        iconCombo.setMinHeight(30.0);
        HBox.setHgrow((Node)iconCombo, (Priority)Priority.ALWAYS);
        iconCombo.setCellFactory(p -> new ListCell<CmsBasicElement>(){

            protected void updateItem(CmsBasicElement item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty && item != null) {
                    this.setText(item.getTitle());
                    Image iconImage = ThemisSingleAttributeFxPane.this.icons.get(item.getId());
                    if (iconImage == null) {
                        try {
                            CmsIcon icon = (CmsIcon)ThemisSingleAttributeFxPane.this.project.loadElement(item.getId(), ThemisSingleAttributeFxPane.this.project.getUser());
                            File iconFile = icon.getUploadAttribute("file").getFirstUploadItemFile();
                            if (iconFile != null) {
                                iconImage = new Image((InputStream)new FileInputStream(iconFile), 20.0, 20.0, true, true);
                                ThemisSingleAttributeFxPane.this.icons.put(item.getId(), iconImage);
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (iconImage != null) {
                        this.setGraphic((Node)new ImageView(iconImage));
                    }
                } else {
                    this.setText(null);
                    this.setGraphic(null);
                }
            }
        });
        iconCombo.getItems().addAll(iconRecords);
        iconCombo.getItems().add(0, null);
        result.getChildren().add((Object)iconCombo);
        if (currentIconId > 0L) {
            long cid = currentIconId;
            iconRecords.forEach(record -> {
                if (cid == record.getId()) {
                    iconCombo.getSelectionModel().select(record);
                }
            });
        }
        iconCombo.getSelectionModel().selectedItemProperty().addListener((ov, oldElement, newElement) -> {
            result.getChildren().remove(0);
            Node newIcon = newElement != null ? this.getIconDisplay(newElement.getId()) : this.getIconDisplay(-1L);
            result.getChildren().add(0, (Object)newIcon);
        });
        return result;
    }

    private Node getIconDisplay(long currentIconId) {
        Region result = new Region();
        result.setPrefHeight(30.0);
        result.setPrefWidth(30.0);
        result.setStyle("-fx-border-color: #cccccc;");
        try {
            File iconFile;
            CmsElement iconElement;
            if (currentIconId > 0L && (iconElement = this.project.loadElement(currentIconId, this.project.getUser())) != null && (iconFile = iconElement.getUploadAttribute("file").getFirstUploadItemFile()) != null) {
                result = new ImageView(new Image((InputStream)new FileInputStream(iconFile), 30.0, 30.0, true, true));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return result;
    }

    private ComboBox<KeytableRecord> getComboBox(String tableCode, boolean withNone, long id) {
        ArrayList recs;
        ComboBox result = new ComboBox();
        result.setMinHeight(30.0);
        result.setMaxWidth(Double.MAX_VALUE);
        Keytable keytable = this.project.getKeytable(tableCode);
        if (keytable != null && (recs = (ArrayList)keytable.getTable().get(this.project.getUser().getCurrentLanguage())) != null) {
            if (withNone) {
                result.getItems().add(0, null);
            }
            for (KeytableRecord rec : recs) {
                result.getItems().add((Object)rec);
                if (rec.id != id) continue;
                result.getSelectionModel().select((Object)rec);
            }
        }
        return result;
    }

    private CmsBasicElement addNewDocument(File file) {
        CmsInfo info = (CmsInfo)this.project.createElement("info");
        UploadAttribute att = info.getUploadAttribute("files");
        att.addUpload(file);
        info.setTitle(file.getName());
        this.newDocuments.put(info.getId(), info);
        return new CmsBasicElement(info.getId(), file.getName());
    }
}

