/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.demo;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.ThemisTaskWithFxDialog;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.themis.ontology.template.TemplateDescription;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ListView;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class SelectDemoProjectFxPanel
extends VBox {
    private Accordion accordion;
    private ListView<TemplateDescription> lstProject;
    private ListView<TemplateDescription> lstProjecttemplate;
    private ListView<TemplateDescription> lstReporttemplate;
    private TextField fldTitle;
    private TextArea fldDescription;
    private ImageView imgExample;
    ThemisApplication app = ThemisApplication.getInstance();
    DemoPackManager demo = DemoPackManager.getInstance();
    TemplateDescription currentItem = null;

    public SelectDemoProjectFxPanel() {
        this.render();
        this.initialize();
    }

    private void render() {
        SplitPane split = new SplitPane();
        this.accordion = new Accordion();
        this.accordion.setMinWidth(200.0);
        this.accordion.setPrefWidth(200.0);
        TitledPane exampleProjects = new TitledPane();
        exampleProjects.setText("Beispielprojekte");
        this.lstProject = new ListView();
        exampleProjects.setContent(this.lstProject);
        this.accordion.getPanes().add((Object)exampleProjects);
        TitledPane projectTemplates = new TitledPane();
        projectTemplates.setText("Projektvorlagen");
        this.lstProjecttemplate = new ListView();
        projectTemplates.setContent(this.lstProjecttemplate);
        this.accordion.getPanes().add((Object)projectTemplates);
        TitledPane reportTemplates = new TitledPane();
        reportTemplates.setText("Berichtsvorlagen");
        this.lstReporttemplate = new ListView();
        reportTemplates.setContent(this.lstReporttemplate);
        this.accordion.getPanes().add((Object)reportTemplates);
        split.getItems().add((Object)this.accordion);
        VBox root = new VBox();
        root.setSpacing(10.0);
        root.setPadding(new Insets(10.0));
        root.setMinWidth(200.0);
        root.setPrefWidth(600.0);
        root.getChildren().add((Object)JavaFxFactory.createLabelHeading("Titel"));
        this.fldTitle = JavaFxFactory.createTextField("");
        this.fldTitle.setEditable(false);
        root.getChildren().add((Object)this.fldTitle);
        root.getChildren().add((Object)JavaFxFactory.createLabelHeading("Beschreibung"));
        this.fldDescription = JavaFxFactory.createTextArea("");
        this.fldDescription.setEditable(false);
        this.fldDescription.setWrapText(true);
        root.getChildren().add((Object)this.fldDescription);
        root.getChildren().add((Object)JavaFxFactory.createLabelHeading("Beispiel"));
        this.imgExample = new ImageView();
        HBox box = new HBox();
        box.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)box, (Priority)Priority.ALWAYS);
        box.getChildren().add((Object)this.imgExample);
        root.getChildren().add((Object)box);
        split.getItems().add((Object)root);
        this.getChildren().add((Object)split);
    }

    private void initialize() {
        if (this.demo.isNewVersionAvailable()) {
            if (this.app.getDialog().showConfirmDialog("Es stehen neue Vorlagen zum Download zur Verf\u00fcgung. Sollen diese heruntergeladen werden?")) {
                ThemisTaskWithFxDialog.createTask("Vorlagen werden heruntergeladen", true, true, ph -> this.demo.downloadTemplates(ph));
            } else {
                this.demo.setIgnoreNewVersion();
            }
        }
        for (TemplateDescription td : this.demo.getProjects()) {
            if (!td.checkLicense()) continue;
            this.lstProject.getItems().add((Object)td);
        }
        for (TemplateDescription td : this.demo.getProjectTemplates()) {
            if (!td.checkLicense()) continue;
            this.lstProjecttemplate.getItems().add((Object)td);
        }
        for (TemplateDescription td : this.demo.getProtokollTemplates()) {
            if (!td.checkLicense()) continue;
            this.lstReporttemplate.getItems().add((Object)td);
        }
        this.accordion.setExpandedPane((TitledPane)this.accordion.getPanes().get(0));
        ChangeListener<TemplateDescription> changeListener = new ChangeListener<TemplateDescription>(){

            public void changed(ObservableValue<? extends TemplateDescription> ov, TemplateDescription prevSelect, TemplateDescription curSelect) {
                SelectDemoProjectFxPanel.this.showTemplateDetails(curSelect);
            }
        };
        this.lstProject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)changeListener);
        this.lstProjecttemplate.getSelectionModel().selectedItemProperty().addListener((ChangeListener)changeListener);
        this.lstReporttemplate.getSelectionModel().selectedItemProperty().addListener((ChangeListener)changeListener);
        this.showTemplateDetails(null);
    }

    private void showTemplateDetails(TemplateDescription item) {
        this.currentItem = item;
        if (item == null) {
            this.fldTitle.setText("");
            this.fldDescription.setText("");
            this.imgExample.setImage(null);
        } else {
            this.fldTitle.setText(item.title);
            this.fldDescription.setText(item.description);
            try {
                this.imgExample.setImage(null);
                URL imageUrl = item.getImageURL();
                if (imageUrl != null) {
                    InputStream is = imageUrl.openStream();
                    Image img = new Image(is);
                    this.imgExample.setImage(img);
                    this.imgExample.setFitHeight(200.0);
                    this.imgExample.setFitWidth(img.getWidth() * 200.0 / img.getHeight());
                    is.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public TemplateDescription getCurrentItem() {
        return this.currentItem;
    }
}

