/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.demo;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.themis.ontology.template.TemplateDescription;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class SelectDemoReportTemplateFxPanel
extends VBox {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final DemoPackManager demo = DemoPackManager.getInstance();
    private final ListView<TemplateDescription> lstReportTemplates = new ListView();
    private final VBox bxPreview = new VBox();

    public SelectDemoReportTemplateFxPanel() {
        this.setSpacing(10.0);
        this.setPadding(new Insets(10.0));
        this.getChildren().add((Object)JavaFxFactory.createLabelHeading2("Verf\u00fcgbare Protokollvorlagen:"));
        HBox box = new HBox();
        box.setSpacing(10.0);
        VBox.setVgrow((Node)box, (Priority)Priority.ALWAYS);
        this.lstReportTemplates.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.lstReportTemplates.setMinHeight(100.0);
        this.lstReportTemplates.setMinWidth(300.0);
        this.lstReportTemplates.setMaxWidth(300.0);
        this.lstReportTemplates.setCellFactory(p -> new ListCell<TemplateDescription>(){

            protected void updateItem(TemplateDescription item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    this.setText(null);
                } else {
                    CheckBox ckb = new CheckBox();
                    ckb.setSelected(SelectDemoReportTemplateFxPanel.this.lstReportTemplates.getSelectionModel().getSelectedItems().contains((Object)item));
                    ckb.setOnAction(t -> {
                        if (ckb.isSelected()) {
                            SelectDemoReportTemplateFxPanel.this.lstReportTemplates.getSelectionModel().select((Object)item);
                        } else {
                            int i = SelectDemoReportTemplateFxPanel.this.lstReportTemplates.getItems().indexOf((Object)item);
                            SelectDemoReportTemplateFxPanel.this.lstReportTemplates.getSelectionModel().clearSelection(i);
                        }
                    });
                    this.setGraphic((Node)ckb);
                    this.setText(item.title);
                }
            }
        });
        this.lstReportTemplates.getSelectionModel().selectedItemProperty().addListener((ov, oldItem, newItem) -> {
            this.updatePreview((TemplateDescription)newItem);
            this.lstReportTemplates.refresh();
        });
        box.getChildren().add(this.lstReportTemplates);
        this.bxPreview.setSpacing(10.0);
        HBox.setHgrow((Node)this.bxPreview, (Priority)Priority.ALWAYS);
        box.getChildren().add((Object)this.bxPreview);
        this.getChildren().add((Object)box);
        this.getChildren().add((Object)JavaFxFactory.createLabelHint("Es k\u00f6nnen eine oder mehrere Vorlagen in der Liste ausgew\u00e4hlt werden. Mit \"Laden\" werden die Protokollvorlagen in das Projekt \u00fcbernommen."));
    }

    public SelectDemoReportTemplateFxPanel populate() {
        this.lstReportTemplates.getItems().clear();
        ArrayList<TemplateDescription> templates = this.demo.getProtokollTemplates();
        this.lstReportTemplates.getItems().addAll(templates);
        if (!this.lstReportTemplates.getItems().isEmpty()) {
            this.lstReportTemplates.getSelectionModel().selectFirst();
        }
        return this;
    }

    private void updatePreview(TemplateDescription item) {
        this.bxPreview.getChildren().clear();
        if (item != null) {
            this.bxPreview.getChildren().add((Object)JavaFxFactory.createLabelHeading2(item.title));
            this.bxPreview.getChildren().add((Object)JavaFxFactory.createLabel(item.description));
            if (item.image != null && !item.image.trim().isEmpty()) {
                byte[] imageBytes = Base64.getDecoder().decode(item.image);
                Image image = new Image((InputStream)new ByteArrayInputStream(imageBytes));
                ImageView img = new ImageView(image);
                this.bxPreview.getChildren().add((Object)img);
            }
        }
    }

    public SelectDemoReportTemplateFxPanel apply() {
        return this;
    }

    public List<TemplateDescription> getSelected() {
        return this.lstReportTemplates.getSelectionModel().getSelectedItems();
    }
}

