/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.formeditor;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsFormular;
import at.grid.themis.ontology.element.CmsFormularHistory;
import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.formeditor.FormItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import org.apache.commons.io.FileUtils;
import org.openide.util.Exceptions;

public class FormEditorFxPanel
extends JavaFxDialog {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    CmsFormularHistory formhistory;
    GridPane root;
    private boolean viewer;
    private boolean manage;
    Button btnSave;
    TextField fldFormName = JavaFxFactory.createTextField("");
    TextField fldFormAlias = JavaFxFactory.createTextField("");

    public FormEditorFxPanel(CmsFormularHistory fh) {
        this.formhistory = fh;
        this.viewer = fh == null || fh.getEventId() != this.project.getSelectionManager().getCurrentEventId();
        this.manage = false;
        if (this.formhistory != null) {
            FormItem.setEvent(this.formhistory.getEvent());
        }
        if (!this.viewer) {
            this.btnSave = this.addSaveButton("Speichern");
        }
        this.addCancelButton("Abbrechen");
        this.populate();
    }

    public void changeHistory(CmsFormularHistory fh) {
        if (this.formhistory != null) {
            this.formhistory.getFormContentFromItems();
        }
        this.formhistory = fh;
        this.viewer = fh == null || fh.getEventId() != this.project.getSelectionManager().getCurrentEventId();
        this.populate();
    }

    public void populate() {
        if (this.root == null) {
            return;
        }
        this.root.getChildren().clear();
        if (this.formhistory == null) {
            this.root.add((Node)JavaFxFactory.createLabel("Es sind keine Daten zum Anzeigen vorhanden."), 0, 0, 3, 1);
            return;
        }
        ArrayList<CmsFormularHistory> formHistories = this.formhistory.getParent().getFormHistories();
        int currentIndex = formHistories.indexOf(this.formhistory);
        ComboBox histories = JavaFxFactory.createComboBox(formHistories, this.formhistory, false);
        histories.setOnAction(e -> {
            CmsFormularHistory fh = (CmsFormularHistory)histories.getSelectionModel().getSelectedItem();
            if (fh != null) {
                this.changeHistory(fh);
            }
        });
        int row = 0;
        if (!this.manage) {
            this.root.add((Node)JavaFxFactory.createHBox(new Node[]{JavaFxFactory.createButton("", "/at/grid/themis/ontology/media/nextLeft24.gif", "Fr\u00fchere Fassung", e -> {
                if (currentIndex > 0) {
                    this.changeHistory((CmsFormularHistory)formHistories.get(currentIndex - 1));
                }
            }), histories, JavaFxFactory.createButton("", "/at/grid/themis/ontology/media/nextRight24.gif", "Sp\u00e4tere Fassung", e -> {
                if (currentIndex < formHistories.size() - 1) {
                    this.changeHistory((CmsFormularHistory)formHistories.get(currentIndex + 1));
                }
            }), JavaFxFactory.createLabel("    "), JavaFxFactory.createButton("", "/at/grid/themis/ontology/media/clearEntries24.gif", "Formular zur\u00fccksetzen", e -> {
                if (!this.viewer) {
                    Alert a = new Alert(Alert.AlertType.NONE, "Die im Formular erfassten Inhalte werden gel\u00f6scht. Formular wirklich zur\u00fccksetzen?", new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
                    a.initOwner(this.getWindow());
                    if (a.showAndWait().get() == ButtonType.OK) {
                        for (FormItem item : this.formhistory.getItems()) {
                            if (item.isAutoValue()) {
                                item.setValue(item.getAutoValue());
                                continue;
                            }
                            item.clearComponent();
                        }
                    }
                }
            }), JavaFxFactory.createButton("", "/at/grid/themis/ontology/media/copy24.gif", "Inhalte aus letzter Fassung \u00fcbernehmen", e -> {
                Alert a;
                if (!this.viewer && currentIndex > 0 && (a = new Alert(Alert.AlertType.NONE, "Die Inhalte des Formulars werden mit denen der vorausgegangenen Erfassung \u00fcberschrieben. Formularinhalte wirklich \u00fcbernehmen?", new ButtonType[]{ButtonType.OK, ButtonType.CANCEL})).showAndWait().get() == ButtonType.OK) {
                    this.formhistory.updateFormContent((CmsFormularHistory)formHistories.get(currentIndex - 1));
                }
            }), JavaFxFactory.createLabel(this.viewer ? "     (kann nicht bearbeitet werden)" : ""), JavaFxFactory.createHorizontalSpacer(), JavaFxFactory.createButton("", "/at/grid/themis/ontology/media/open_external24.gif", "Formularstruktur neu laden", e -> {
                if (!this.viewer) {
                    String currentXml = this.formhistory.getFormContentFromItems();
                    this.formhistory.setFormContent(this.formhistory.getParent().getFormXml());
                    this.formhistory.updateFormContent(currentXml);
                    this.populate();
                }
            }), JavaFxFactory.createButton("", "/at/grid/themis/ontology/media/action_settings24.gif", "Formular verwalten", e -> {
                this.manage = true;
                this.populate();
            })}), 0, row++, 2, 1);
            for (FormItem item : this.formhistory.getItems()) {
                this.root.add((Node)new Separator(Orientation.HORIZONTAL), 0, row++, 3, 1);
                row = item.addToPanel(this.root, row, this.viewer);
            }
        } else {
            this.root.add((Node)JavaFxFactory.createLabelHeading("Formular verwalten"), 0, row++);
            this.root.add((Node)JavaFxFactory.createLabel("Name des Formulars"), 0, row);
            this.fldFormName.setText(this.formhistory.getParent().getFormName());
            this.root.add((Node)this.fldFormName, 1, row++);
            this.root.add((Node)JavaFxFactory.createLabel("Formular-Alias"), 0, row);
            this.fldFormAlias.setText(this.formhistory.getParent().getFormAlias());
            this.root.add((Node)this.fldFormAlias, 1, row++);
            this.root.add((Node)JavaFxFactory.createLabel("Formular-Struktur neu laden"), 0, row);
            this.root.add((Node)JavaFxFactory.createButton("Struktur laden", e -> this.loadFormStructure()), 1, row++);
            if (this.btnSave != null) {
                this.btnSave.setText("\u00dcbernehmen");
            }
        }
    }

    @Override
    public boolean save() {
        if (this.manage) {
            String newAlias;
            if (!"".equals(this.fldFormName.getText())) {
                this.formhistory.getParent().setFormName(this.fldFormName.getText());
            }
            if (!"".equals(newAlias = this.fldFormAlias.getText())) {
                CmsFormular formByAlias = this.project.getFormByAlias(newAlias);
                if (formByAlias != null && formByAlias.getId() != this.formhistory.getParent().getId()) {
                    new Alert(Alert.AlertType.NONE, "Dieser Alias '" + newAlias + "' wird schon im Formular '" + formByAlias.getFormName() + "' vewendet", new ButtonType[0]).showAndWait();
                } else {
                    this.formhistory.getParent().setFormAlias(newAlias);
                }
            }
            this.manage = false;
            if (this.btnSave != null) {
                this.btnSave.setText("Speichern");
            }
            this.populate();
            return false;
        }
        if (!this.viewer) {
            if (this.formhistory.getParent() == null) {
                // empty if block
            }
            this.formhistory.getParent().save();
            this.app.getActionProvider().invokeAction(ThemisAction.FORM_SAVED);
            return true;
        }
        return false;
    }

    private void loadFormStructure() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Formularstruktur laden");
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Formularstruktur (*.xml)", new String[]{"*.xml"}));
        chooser.setInitialDirectory(this.app.getSettings().getExportFolder().getValue(true));
        File f = chooser.showOpenDialog(null);
        if (f != null) {
            this.app.getSettings().getExportFolder().setValue(f.getParentFile());
            try {
                String xml = FileUtils.readFileToString((File)f, (String)"UTF-8");
                this.formhistory.getParent().setFormXml(xml);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected ScrollPane getMainPanel() {
        this.root = JavaFxFactory.createGridPane();
        this.root.getColumnConstraints().add((Object)this.getColumnConstraintsLabel());
        this.root.getColumnConstraints().add((Object)this.getColumnConstraintsField());
        ScrollPane scroll = new ScrollPane((Node)this.root);
        scroll.setFitToWidth(true);
        return scroll;
    }

    public static ColumnConstraints getColumnConstraintsNumber() {
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setHgrow(Priority.NEVER);
        c1.setPrefWidth(-1.0);
        c1.setMaxWidth(-1.0);
        c1.setHalignment(HPos.LEFT);
        c1.setPercentWidth(0.0);
        return c1;
    }

    public static ColumnConstraints getColumnConstraintsLabel() {
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setMinWidth(200.0);
        c1.setMaxWidth(500.0);
        return c1;
    }

    public static ColumnConstraints getColumnConstraintsField() {
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setMinWidth(200.0);
        c1.setMaxWidth(Double.MAX_VALUE);
        return c1;
    }
}

