/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.formeditor;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsFilter;
import at.grid.themis.ontology.element.CmsFormularHistory;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.javafx.formeditor.FormItemCheckbox;
import at.grid.themis.ontology.javafx.formeditor.FormItemDate;
import at.grid.themis.ontology.javafx.formeditor.FormItemHeading1;
import at.grid.themis.ontology.javafx.formeditor.FormItemHeading2;
import at.grid.themis.ontology.javafx.formeditor.FormItemInfo;
import at.grid.themis.ontology.javafx.formeditor.FormItemLongtext;
import at.grid.themis.ontology.javafx.formeditor.FormItemSelect;
import at.grid.themis.ontology.javafx.formeditor.FormItemShorttext;
import at.grid.themis.ontology.javafx.formeditor.FormItemText;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.util.ExtStringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import org.jdom.Content;
import org.jdom.Element;

public abstract class FormItem {
    private static ThemisApplication app = ThemisApplication.getInstance();
    CmsFormularHistory parent;
    private static int counter;
    Element xml;
    Node component;
    Label lblNumber;
    Label lblLabel;
    HashMap<String, Integer> filterResults = new HashMap();
    private static Placeholder ph;

    public FormItem(Element xml) {
        this.xml = xml;
    }

    public static void setEvent(CmsEvent ev) {
        ph.setEvent(ev);
    }

    public void setParent(CmsFormularHistory p) {
        this.parent = p;
    }

    public void startCounter() {
        counter = 1;
    }

    public static FormItem createItem(Element xml) {
        String type;
        switch (type = xml.getAttributeValue("type", "none").toLowerCase()) {
            case "heading1": {
                return new FormItemHeading1(xml);
            }
            case "heading2": {
                return new FormItemHeading2(xml);
            }
            case "info": {
                return new FormItemInfo(xml);
            }
            case "text": {
                return new FormItemText(xml);
            }
            case "shorttext": {
                return new FormItemShorttext(xml);
            }
            case "date": {
                return new FormItemDate(xml);
            }
            case "longtext": {
                return new FormItemLongtext(xml);
            }
            case "checkbox": {
                return new FormItemCheckbox(xml);
            }
            case "select": {
                return new FormItemSelect(xml);
            }
        }
        return null;
    }

    public void reset() {
        this.filterResults.clear();
    }

    public String getType() {
        String classname = this.getClass().getSimpleName();
        if (classname.startsWith("FormItem")) {
            return classname.substring(8).toLowerCase();
        }
        return "unknown";
    }

    public String getId() {
        return this.xml.getAttributeValue("id", "");
    }

    public String getNumber() {
        return "#" + this.getId();
    }

    public Element getElement() {
        return this.xml;
    }

    public String getLabel() {
        return this.xml.getChildText("label");
    }

    public void setValue(String txt) {
        Element v = this.xml.getChild("value");
        if (v == null) {
            v = new Element("value");
            this.xml.addContent((Content)v);
        }
        v.setText(txt);
    }

    public String getValue() {
        return this.xml.getChildText("value");
    }

    public boolean hasValue() {
        return this.getValue() != null && !"".equals(this.getValue().trim());
    }

    public ArrayList<String> getOptions() {
        String options = this.xml.getAttributeValue("options");
        if (options == null || "".equals(options)) {
            List optionElements = this.xml.getChildren("option");
            if (optionElements == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> result = new ArrayList<String>();
            for (Element o : optionElements) {
                result.add(o.getText());
            }
            return result;
        }
        return new ArrayList<String>(Arrays.asList(options.split(";")));
    }

    public String getCondition() {
        return this.xml.getAttributeValue("condition");
    }

    public boolean checkCondition() {
        String c = this.getCondition();
        if (c == null || "".equals(c)) {
            return true;
        }
        StringTokenizer tok = new StringTokenizer(c, ".");
        String type = tok.nextToken();
        String code = tok.nextToken();
        String val = tok.nextToken();
        if (type == null || code == null || val == null) {
            ThemisApplication.getLogger().severe("Error in form condition for item '" + this.getId() + "', condition: '" + c + "'");
            return true;
        }
        switch (type.toLowerCase()) {
            case "form": {
                if (this.parent == null) {
                    return true;
                }
                FormItem item = this.parent.getItemById(code);
                if (item == null) {
                    return true;
                }
                switch (val.toLowerCase()) {
                    case "isnotempty": 
                    case "istnichtleer": {
                        return item.hasValue();
                    }
                    case "isempty": 
                    case "istleer": {
                        return !item.hasValue();
                    }
                }
                if (val.toLowerCase().startsWith("value=")) {
                    String requiredValue = val.substring(6);
                    String isVal = item.getComponentValue();
                    return requiredValue.equals(isVal);
                }
                return true;
            }
            case "filter": {
                int count = this.getFilterResult(code);
                switch (val.toLowerCase()) {
                    case "isempty": 
                    case "istleer": {
                        return count == 0;
                    }
                    case "isnotempty": 
                    case "istnichtleer": {
                        return count > 0;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public int getFilterResult(String filtername) {
        if (this.filterResults.containsKey(filtername)) {
            return this.filterResults.get(filtername);
        }
        CmsFilter filter = app.getProject().getFilterByName(filtername);
        if (filter == null) {
            return -1;
        }
        ThemisFilter f = new ThemisFilter(app);
        f.setTriggerEnabled(false);
        f.loadFilter(filter);
        int count = f.getFilteredElementIds().size();
        this.filterResults.put(filtername, count);
        return count;
    }

    public boolean isEmpty() {
        return this.getValue() == null || "".equals(this.getValue());
    }

    public boolean isAutoValue() {
        return this.xml.getAttributeValue("auto") != null;
    }

    public boolean isPrefill() {
        return this.xml.getAttributeValue("prefill") != null;
    }

    public boolean isAllowEdit() {
        String allowEdit = this.xml.getAttributeValue("edit");
        return allowEdit == null || "true".equalsIgnoreCase(allowEdit);
    }

    public boolean isReadOnly() {
        return !this.isAllowEdit();
    }

    public String getPrefillValue() {
        String prefill = this.xml.getAttributeValue("prefill");
        if (prefill == null) {
            return "";
        }
        return this.getAutoValue(prefill);
    }

    public String getAutoValue() {
        String autovalue = this.xml.getAttributeValue("auto");
        if (autovalue == null) {
            return "";
        }
        return this.getAutoValue(autovalue);
    }

    private String getAutoValue(String specification) {
        ExtStringTokenizer tok = new ExtStringTokenizer(specification, ".");
        String type = tok.nextToken();
        String code = tok.nextTokenOrDefault("unknown");
        String spec = tok.nextTokenOrDefault("");
        switch (type) {
            case "filter": {
                int count = this.getFilterResult(code);
                if (count < 0) {
                    return "";
                }
                switch (spec) {
                    case "": 
                    case "count": 
                    case "anzahl": {
                        return Integer.toString(count);
                    }
                    case "isempty": 
                    case "istleer": {
                        return count == 0 ? "X" : "";
                    }
                    case "isnotempty": 
                    case "istnichtleer": {
                        return count > 0 ? "X" : "";
                    }
                }
                return "";
            }
            case "text": {
                return ph.apply("#!#" + code + "#!#");
            }
        }
        return "";
    }

    public String getLabelSize() {
        String sizeNormal = "normal";
        if (this.xml == null) {
            return sizeNormal;
        }
        Element label = this.xml.getChild("label");
        if (label == null) {
            return sizeNormal;
        }
        if (label.getAttribute("size") != null) {
            return label.getAttributeValue("size");
        }
        return sizeNormal;
    }

    public int addToPanel(GridPane root, int row, boolean viewer) {
        if (!viewer) {
            if (this.isAutoValue()) {
                this.setValue(this.getAutoValue());
            } else if (this.isPrefill() && (this.getValue() == null || "".equals(this.getValue()))) {
                this.setValue(this.getPrefillValue());
            }
        }
        int newRow = this.createFormComponents(root, row);
        this.setAvailability(viewer);
        return newRow;
    }

    public void setAvailability(boolean viewer) {
        if (this.component != null) {
            if (!this.checkCondition()) {
                this.setDisabled();
            } else if (viewer || this.isAutoValue() || this.isReadOnly()) {
                this.setReadOnly();
            } else {
                this.setEnabled();
            }
        }
    }

    public void updateForm() {
        if (this.parent != null) {
            boolean viewer = this.parent.getEventId() != ThemisApplication.getInstance().getProject().getSelectionManager().getCurrentEventId();
            for (FormItem i : this.parent.getItems()) {
                i.setAvailability(viewer);
            }
        }
    }

    public abstract void setComponentDisabled();

    public void setReadOnly() {
        this.setEnabled();
        this.setComponentDisabled();
    }

    public void setDisabled() {
        this.clearComponent();
        this.disable(true, true);
    }

    public void setEnabled() {
        this.disable(false, false);
    }

    public void disable(boolean flgComponent, boolean flgLabel) {
        if (this.component != null) {
            this.component.setDisable(flgComponent);
            if (flgComponent) {
                this.clearComponent();
            }
        }
        if (this.lblLabel != null) {
            this.lblLabel.setDisable(flgLabel);
            this.lblLabel.setStyle("-fx-opacity: " + (flgLabel ? "0.5" : "1"));
        }
        if (this.lblNumber != null) {
            this.lblNumber.setDisable(flgLabel);
            this.lblLabel.setStyle("-fx-opacity: " + (flgLabel ? "0.5" : "1"));
        }
    }

    public void applyValue() {
        if (this.component != null) {
            this.getElement().getChild("value").setText(this.getComponentValue());
        }
    }

    public abstract String getComponentValue();

    public abstract void clearComponent();

    public abstract int createFormComponents(GridPane var1, int var2);

    public String toString() {
        return this.getClass().getSimpleName() + " #" + this.getId() + "  -> " + this.getValue();
    }

    public Element getXml() {
        return this.xml;
    }

    public ArrayList<String> getRequiredFilternames() {
        String code;
        String type;
        ExtStringTokenizer tok;
        ArrayList<String> result = new ArrayList<String>();
        String c = this.getCondition();
        if (c != null) {
            tok = new ExtStringTokenizer(c, ".");
            type = tok.nextTokenOrDefault("");
            code = tok.nextTokenOrDefault("");
            if ("filter".equalsIgnoreCase(type)) {
                result.add(code);
            }
        }
        if ((c = this.getAutoValue()) != null) {
            tok = new ExtStringTokenizer(c, ".");
            type = tok.nextTokenOrDefault("");
            code = tok.nextTokenOrDefault("");
            if ("filter".equalsIgnoreCase(type)) {
                result.add(code);
            }
        }
        return result;
    }

    static {
        ph = new Placeholder(null);
    }
}

