/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.imagepanel;

import at.grid.data.Box2D;
import at.grid.data.Coordinates2D;
import at.grid.data.grid.AbstractDataGrid;
import at.grid.data.grid.GridGeometry;
import at.grid.gui.BasicGeometry;
import at.grid.gui.GeometryDisplay;
import at.grid.gui.ImageListener;
import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.gui.event.Action;
import at.grid.gui.event.ActionListener;
import at.grid.gui.event.ActionProvider;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.image.ImageView;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ImagePanelFx
extends ImageView
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    public static final int PAN = 1;
    public static final int DRAW_POINT = 2;
    public static final int DRAW_LINE = 3;
    public static final int DRAW_POLYGON = 4;
    public static final int DRAW_FREE = 7;
    public static final int DRAW_ARROW = 8;
    public static final int DRAW_CIRCLE = 9;
    public static final int DRAW_CLOUD = 10;
    public static final int DRAW_STAR = 11;
    public static final int DRAW_RECT = 12;
    public static final int MOVEOBJECT = 5;
    public static final int MOVELABEL = 13;
    public static final int MEASURE = 6;
    public static final int DRAW_BLACK = 14;
    private final float FONT_SIZE = 12.0f;
    BufferedImage backgroundImage;
    Map<String, BufferedImage> foregroundImages = new HashMap<String, BufferedImage>();
    double zoom = 1.0;
    double minZoom = 0.25;
    boolean minZoomEnabled = false;
    double zoomfactor = 1.5;
    GridGeometry geometry = null;
    Point corner = new Point(0.0, 0.0);
    Point drag0;
    Geometry jts_drag0;
    Point dragCorner = new Point(this.corner);
    boolean dragged = false;
    JLabel lblCoordinates;
    JLabel lblInfo;
    int lastImageX;
    int lastImageY;
    int status;
    ActionProvider actionProvider = null;
    Action geometryAction = null;
    Action selectionAction = null;
    Action dropAction = null;
    Action clickAction = null;
    Action rightclickAction = null;
    Action moveAction = null;
    Action moveLabelAction = null;
    SimpleGeometry geo = new SimpleGeometry(0);
    ArrayList<SimpleGeometry> geometries = new ArrayList();
    ArrayList geometryreference = new ArrayList();
    ArrayList<Geometry> jts_geometries = new ArrayList();
    ArrayList<ImageText> texts = new ArrayList();
    Image position = this.readIcon("position.png");
    Image position_sel = this.readIcon("position_sel.png");
    Image position_off = this.readIcon("position_off.png");
    Font font = new Font("Arial", 1, 12);
    ActionListener actionListener;
    ImageListener imageListener;
    boolean fullExtent = false;
    private float iconscale = 1.0f;
    double displayScale = 0.25;
    public AbstractDataGrid datagrid = null;
    private boolean dragable = true;
    private float transparency = 1.0f;
    private boolean scaleIcons = true;
    private int iconMinimumSize = 0;
    private int iconSize = 30;
    private static ImagePanelFx panel = null;
    private boolean allowMoveLabel = true;
    private boolean allowMoveGeometry = true;
    private boolean allowZoom = true;
    private int displayWidth = 0;
    private Logger logger = null;

    public ImagePanelFx(Logger log) {
        this.logger = log;
        this.setBackgroundColor(Color.white);
        this.setStatus(1);
        this.geo.setShowVerteces(true);
        this.createDropTarget();
    }

    public ImagePanelFx(Logger log, boolean minZoomEnabled) {
        this(log);
        this.minZoomEnabled = minZoomEnabled;
    }

    public static ImagePanelFx getInstance() {
        if (panel == null) {
            panel = new ImagePanelFx(Logger.getLogger(ImagePanelFx.class.getName()));
        }
        return panel;
    }

    public static ImagePanelFx getInstance(Logger log) {
        if (panel == null) {
            panel = new ImagePanelFx(log);
        }
        return panel;
    }

    public void createDropTarget() {
    }

    public ActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public Action getDropAction() {
        return this.dropAction;
    }

    public void setBackgroundColor(Color c) {
        this.setBackgroundColor(c);
    }

    public Image readIcon(String name) {
        try {
            return ImageIO.read(ImagePanelFx.class.getResource(name));
        }
        catch (Exception ex) {
            this.logger.severe("Cannot read icon '" + name + "' " + ex.getMessage());
            return null;
        }
    }

    public static Image readIcon(File file) {
        try {
            if (file.isFile()) {
                return ImageHelper.loadImage((File)file);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ImagePanelFx.class.getName()).log(Level.SEVERE, "Cannot read icon '" + file.getAbsolutePath() + "'", ex);
        }
        return null;
    }

    public void setActionListener(ActionListener l) {
        this.actionListener = l;
    }

    public void setImageListener(ImageListener l) {
        this.imageListener = l;
    }

    public void setActionProvider(ActionProvider prov) {
        this.actionProvider = prov;
    }

    public void setGeometryAction(Action act) {
        this.geometryAction = act;
    }

    public void setSelectionAction(Action act) {
        this.selectionAction = act;
    }

    public void setDropAction(Action act) {
        this.dropAction = act;
    }

    public void setClickAction(Action act) {
        this.clickAction = act;
    }

    public void setRightclickAction(Action act) {
        this.rightclickAction = act;
    }

    public void setMoveAction(Action act) {
        this.moveAction = act;
    }

    public void setMoveLabelAction(Action act) {
        this.moveLabelAction = act;
    }

    public void setDragable(boolean drag) {
        this.dragable = drag;
    }

    public void setScaleIcons(boolean scale) {
        this.scaleIcons = scale;
    }

    public void setIconMinimumSize(int px) {
        this.iconMinimumSize = px;
    }

    public void setDisplayScale(double scale) {
        this.displayScale = scale;
    }

    public void setIconSize(int sz) {
        this.iconSize = sz;
    }

    public void setIconScale(double sc) {
    }

    public boolean isAllowMoveLabel() {
        return this.allowMoveLabel;
    }

    public void setAllowMoveLabel(boolean allowMoveLabel) {
        this.allowMoveLabel = allowMoveLabel;
    }

    public boolean isAllowMoveGeometry() {
        return this.allowMoveGeometry;
    }

    public void setAllowMoveGeometry(boolean allowMoveGeometry) {
        this.allowMoveGeometry = allowMoveGeometry;
    }

    public boolean isAllowZoom() {
        return this.allowZoom;
    }

    public void setAllowZoom(boolean allowZoom) {
        this.allowZoom = allowZoom;
    }

    public void setCoordinatesLabel(JLabel lblCoordinates) {
        this.lblCoordinates = lblCoordinates;
    }

    public void setInfoLabel(JLabel lblInfo) {
        this.lblInfo = lblInfo;
    }

    public void setInfoLabel(AbstractDataGrid gd, JLabel lblInfo) {
        this.lblInfo = lblInfo;
        this.datagrid = gd;
    }

    public void showCoordinates() {
        this.showCoordinates(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void showCoordinates(int x, int y) {
        Point p;
        if (this.hasGeometry()) {
            Coordinates2D c = this.image2real(this.screen2Image(x, y));
            p = new Point(c.x, c.y);
        } else {
            p = this.screen2Image(x, y);
        }
        if (this.lblCoordinates != null) {
            this.lblCoordinates.setText((int)p.getX() + " / " + (int)p.getY());
        }
        if (this.imageListener != null) {
            this.imageListener.imagePosition((int)p.getX(), (int)p.getY());
        }
        if (this.datagrid != null) {
            try {
                double v = this.datagrid.getValue(p.getX(), p.getY());
                this.lblInfo.setText(Double.toString(Util.round((double)v, (int)2)));
            }
            catch (Exception e) {
                this.lblInfo.setText("-");
            }
        }
    }

    public void setIconPosition(File f) {
        this.position = ImagePanelFx.readIcon(f);
    }

    public void setIconPositionSel(File f) {
        this.position_sel = ImagePanelFx.readIcon(f);
    }

    public void setIconPositionInactive(File f) {
        this.position_off = ImagePanelFx.readIcon(f);
    }

    @Deprecated
    public void setColor(Color c) {
    }

    @Deprecated
    public void setColorSel(Color c) {
    }

    @Deprecated
    public void setColorInactive(Color c) {
    }

    @Deprecated
    public void setColorEdit(Color c) {
    }

    @Deprecated
    public void setColors(Color c, Color c_edit, Color c_off, Color c_sel) {
    }

    public void setGeometry(double cornerx, double cornery, double size) {
        this.geometry = new GridGeometry(this.getWidth(), this.getHeight(), new Coordinates2D(cornerx, cornery), size);
    }

    public void setGeometry(GridGeometry geo) {
        this.geometry = geo;
    }

    public boolean hasGeometry() {
        return this.geometry != null;
    }

    public GridGeometry getGeometry() {
        return this.geometry;
    }

    public void setBackgroundTransparency(float t) {
        this.transparency = t;
    }

    public Point screen2Image(int x, int y) {
        double panelZoom = this.getPanelZoom();
        Point p = new Point();
        if (x != Integer.MIN_VALUE) {
            p.setX((double)x / (panelZoom * this.zoom) - this.corner.getX());
        }
        if (y != Integer.MIN_VALUE) {
            p.setY((double)y / (panelZoom * this.zoom) - this.corner.getY());
        }
        return p;
    }

    public Point image2screen(double x, double y) {
        double panelZoom = this.getPanelZoom();
        Point p = new Point();
        p.setX((x + this.corner.getX()) * panelZoom * this.zoom);
        p.setY((y + this.corner.getY()) * panelZoom * this.zoom);
        return p;
    }

    public double scaleImage2screen(double v) {
        return v * this.getPanelZoom() * this.zoom;
    }

    public double scaleScreen2image(double v) {
        return v / (this.getPanelZoom() * this.zoom);
    }

    public Coordinates2D image2real(Point p) {
        return this.image2real(p.getX(), p.getY());
    }

    public Coordinates2D image2real(double x, double y) {
        if (this.geometry == null) {
            return new Coordinates2D(x, y);
        }
        return this.geometry.getCoordinates((int)x, (int)y);
    }

    public Point getPointOnScreen(Point p) {
        if (p == null) {
            return null;
        }
        Point ps = this.image2screen(p.getX(), p.getY());
        ps.setX((double)((int)ps.getX()));
        ps.setY((double)((int)ps.getY()));
        return ps;
    }

    public int[][] getPointArrayOnScreen(ArrayList<Point> points) {
        if (points == null) {
            return new int[2][0];
        }
        int[][] result = new int[2][points.size()];
        for (int ii = 0; ii < points.size(); ++ii) {
            Point p = points.get(ii);
            Point ps = this.image2screen(p.getX(), p.getY());
            result[0][ii] = (int)ps.getX();
            result[1][ii] = (int)ps.getY();
        }
        return result;
    }

    protected void setImage(BufferedImage out, BufferedImage i) {
        if (i == null) {
            out = null;
        }
        this.repaint();
    }

    public void setBackgroundImage(File f) throws IOException {
        this.setBackgroundImage(ImageIO.read(f));
    }

    public void setBackgroundImage(File f, double rotationangle) throws IOException {
        this.setBackgroundImage(ImageIO.read(f), rotationangle);
    }

    public void removeBackgroundImage() {
        this.backgroundImage = null;
    }

    public void setBackgroundImage(BufferedImage i) {
        this.setBackgroundImage(i, 0.0);
    }

    public void setBackgroundImageObject(BufferedImage i) {
        this.backgroundImage = i;
    }

    public void setBackgroundImage(BufferedImage i, double rotationangle) {
        if (i == null) {
            this.backgroundImage = null;
        } else if (rotationangle != 0.0) {
            int width = i.getWidth();
            int height = i.getHeight();
            double diag = Math.sqrt(width * width + height * height);
            AffineTransform at = new AffineTransform();
            if (rotationangle == 90.0 || rotationangle == 270.0) {
                this.backgroundImage = new BufferedImage(height, width, 2);
                at.translate(height / 2, width / 2);
                at.rotate(Math.toRadians(rotationangle));
                at.translate(-width / 2, -height / 2);
            } else if (rotationangle == 180.0) {
                this.backgroundImage = new BufferedImage(width, height, 2);
                at.translate(width / 2, height / 2);
                at.rotate(Math.toRadians(rotationangle));
                at.translate(-width / 2, -height / 2);
            } else {
                this.backgroundImage = new BufferedImage((int)diag, (int)diag, 2);
                at.translate(diag / 2.0, diag / 2.0);
                at.rotate(Math.toRadians(rotationangle));
                at.translate(-diag / 2.0, -diag / 2.0);
            }
            Graphics2D g2 = this.backgroundImage.createGraphics();
            g2.dispose();
        }
        this.repaint();
    }

    public void clearBackgroundImage() {
        this.backgroundImage = null;
        this.repaint();
    }

    public void addForegroundImage(String code, BufferedImage i) {
        if (i != null) {
            BufferedImage fg = new BufferedImage(i.getWidth(), i.getHeight(), 2);
            this.repaint();
        }
    }

    public void removeForegroundImage(String code) {
        this.foregroundImages.remove(code);
        this.repaint();
    }

    public void clearForegroundImages() {
        this.foregroundImages.clear();
        this.repaint();
    }

    public synchronized void addGeometry(SimpleGeometry geom) {
        Geometry g = geom.toJTS();
        this.geometryreference.add(geom.getReference());
        this.geometries.add(geom);
        this.jts_geometries.add(g);
        this.repaint();
    }

    public void addText(String txt, int size, int x, int y) {
        this.texts.add(new ImageText(txt, size, x, y));
        this.repaint();
    }

    protected Dimension getIconDimensions(Image i, double imageScale) {
        int iHeight = i.getHeight(null);
        int iWidth = i.getWidth(null);
        if (this.scaleIcons) {
            if (iWidth == 0) {
                iWidth = 1;
                iHeight = 1;
            }
            iHeight = (int)((double)(iHeight * this.iconSize / iWidth) * imageScale);
            iWidth = (int)((double)this.iconSize * imageScale);
        } else if (iWidth > 0) {
            iHeight = iHeight * this.iconSize / iWidth;
            iWidth = this.iconSize;
        }
        if (this.iconMinimumSize > 0 && iWidth < this.iconMinimumSize) {
            iHeight = i.getHeight(null) * this.iconMinimumSize / i.getWidth(null);
            iWidth = this.iconMinimumSize;
        }
        return new Dimension(iWidth, iHeight);
    }

    private double getDisplayScale() {
        return this.displayScale;
    }

    public Point getLabelpoint(SimpleGeometry geom) {
        int labeloffset = 0;
        double scale = this.getDisplayScale() * this.getPanelZoom() / 0.15;
        double imageScale = this.zoom * scale * (double)geom.getSizeFactor();
        GeometryDisplay display = geom.getDisplay();
        Point labelpoint = null;
        if (geom.hasLabelpoint()) {
            labelpoint = new Point(geom.getLabelpoint());
        }
        Point offset = geom.getLabelOffset();
        if (labelpoint != null) {
            return this.image2screen(labelpoint.getX(), labelpoint.getY());
        }
        switch (geom.getType()) {
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (geom.size() <= 0) break;
                labelpoint = this.getPointOnScreen(geom.getPoint());
                labeloffset = (int)(5.0 + (double)geom.getDisplay().linewidth / 1.5);
                labelpoint.translate((double)labeloffset, (double)(-labeloffset));
                break;
            }
            case 3: 
            case 8: {
                if (geom.size() <= 0) break;
                labelpoint = this.getPointOnScreen(geom.getCenterPoint());
                break;
            }
            default: {
                if (this.getPointOnScreen(geom.getPoint()) == null) break;
                labelpoint = new Point(this.getPointOnScreen(geom.getPoint()));
                if (geom.hasLabelOffset() && display.getPointmarker() != null) {
                    labelpoint.translate(geom.getLabelOffset().getX() * imageScale, geom.getLabelOffset().getY() * imageScale);
                    break;
                }
                if (display.getPointmarker() != null) {
                    Dimension iDim = this.getIconDimensions(display.getPointmarker(), imageScale);
                    labeloffset = (int)(geom.getSizeFactor() * (float)iDim.width / 2.0f);
                } else {
                    labeloffset = (int)((double)(geom.getSizeFactor() * (float)display.size) * scale * (this.scaleIcons ? this.zoom * 0.45 : 0.5));
                }
                float labelFontSize = (float)((double)geom.getDisplay().fontsize * (this.scaleIcons ? this.zoom * scale : 1.0));
                labeloffset = (int)((float)labeloffset + labelFontSize / 3.0f);
                if (labelpoint == null) break;
                labelpoint.translate((double)labeloffset, (double)(-labeloffset));
            }
        }
        return labelpoint;
    }

    public void updateGeometry(SimpleGeometry geom) {
        for (SimpleGeometry g : this.geometries) {
            if (g.getId() != geom.getId()) continue;
            g.updatePoints((BasicGeometry)geom);
            this.repaint();
            return;
        }
        this.addGeometry(geom);
        this.repaint();
    }

    public void removeGeometries() {
        this.removeGeometries(false);
    }

    public void removeGeometries(boolean keepCurrent) {
        this.geometries.clear();
        this.geometryreference.clear();
        this.jts_geometries.clear();
        if (!keepCurrent) {
            this.geo.clear();
        }
        this.texts.clear();
        this.repaint();
    }

    public void removeGeometry(SimpleGeometry geom) {
        this.removeGeometry(geom.getId());
    }

    public void removeGeometry(long idGeometry) {
        int idx = 0;
        int idxRemove = -1;
        for (SimpleGeometry g : this.geometries) {
            if (g.getId() == idGeometry) {
                idxRemove = idx;
                break;
            }
            ++idx;
        }
        if (idxRemove >= 0) {
            this.geometries.remove(idxRemove);
            this.geometryreference.remove(idxRemove);
            this.jts_geometries.remove(idxRemove);
            this.repaint();
        }
    }

    public ArrayList<SimpleGeometry> getGeometries() {
        return this.geometries;
    }

    public void setPositionIcons(Image pos, Image pos_sel, Image pos_off) {
        if (pos != null) {
            this.position = pos;
        }
        if (pos_sel != null) {
            this.position_sel = pos_sel;
        }
        if (pos_off != null) {
            this.position_off = pos_off;
        }
    }

    public boolean hasSelected() {
        for (SimpleGeometry g : this.geometries) {
            if (!g.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void setSelection(ArrayList<Long> ids) {
        boolean changed = false;
        if (ids.size() == 1) {
            this.setSelection(ids.get(0));
            return;
        }
        for (SimpleGeometry g : this.geometries) {
            changed = g.setSelected(ids.contains(g.getId())) || changed;
        }
        if (changed) {
            this.repaint();
        }
    }

    public void setSelection(long id) {
        boolean changed = false;
        Iterator<SimpleGeometry> iterator = this.geometries.iterator();
        while (iterator.hasNext()) {
            SimpleGeometry g;
            changed = g.setSelected((g = iterator.next()).getId() == id) || changed;
        }
        if (changed) {
            this.repaint();
        }
    }

    public double getPanelZoom() {
        if (this.backgroundImage == null || this.fullExtent) {
            return this.displayWidth == 0 ? 1.0 : (double)(this.displayWidth / this.getImageWidth());
        }
        int w = this.getWidth();
        int h = this.getHeight();
        return Math.min((double)w / (double)this.backgroundImage.getWidth(), (double)h / (double)this.backgroundImage.getHeight());
    }

    public double getTotalZoom() {
        double panelzoom = this.getPanelZoom();
        return this.zoom * panelzoom;
    }

    public void zoomIn() {
        this.zoom(this.zoomfactor);
    }

    public void zoomOut() {
        this.zoom(1.0 / this.zoomfactor);
    }

    public void setZoom(double factor) {
        this.zoom = factor;
        this.repaint();
    }

    public void zoomTo(SimpleGeometry geo) {
        double h;
        Point centerPoint = geo.getCenterPoint();
        Box2D box = geo.getBox();
        double w = box.getWidth();
        if (w == 0.0) {
            w = this.backgroundImage.getWidth() / 20;
        }
        if ((h = box.getHeight()) == 0.0) {
            h = this.backgroundImage.getHeight() / 20;
        }
        int imageWidth = this.getImageWidth();
        int imageHeight = this.getImageHeight();
        this.zoom = Math.min((double)imageWidth / (4.0 * w), (double)imageHeight / (4.0 * h));
        double newHeight = 2.0 * h;
        double newWidth = 2.0 * w;
        if (newHeight > newWidth * (double)imageHeight / (double)imageWidth) {
            newWidth = newHeight * (double)imageWidth / (double)imageHeight;
        } else {
            newHeight = newWidth * (double)imageHeight / (double)imageWidth;
        }
        this.corner.setX(-(centerPoint.getX() - newWidth));
        this.corner.setY(-(centerPoint.getY() - newHeight));
        this.dragCorner = new Point(this.corner.getX(), this.corner.getY());
        this.repaint();
    }

    public void reset() {
        this.corner.setLocation(0.0, 0.0);
        this.setZoom(1.0);
    }

    private void zoom(double factor) {
        int x = this.getWidth() / 2;
        int y = this.getHeight() / 2;
        Point p = this.screen2Image(x, y);
        double lastZoom = this.zoom;
        this.zoom *= factor;
        if (this.minZoomEnabled && this.zoom < this.minZoom) {
            this.zoom = this.minZoom;
        }
        if (this.zoom == lastZoom) {
            return;
        }
        Point p2 = this.screen2Image(x, y);
        this.corner.translate(p2.getX() - p.getX(), p2.getY() - p.getY());
        this.dragCorner = null;
        this.repaint();
    }

    private void repaint() {
    }

    public synchronized void paintComponent(Graphics g) {
        long performanceMillis = new Date().getTime();
        double panelzoom = this.getPanelZoom();
        Graphics2D g2 = (Graphics2D)g;
        if (this.backgroundImage != null) {
            this.drawImage(this.backgroundImage, g2, panelzoom);
        }
        int imagewidth = this.getImageWidth();
        for (BufferedImage img : this.foregroundImages.values()) {
            if (img == null) continue;
            this.drawImage(img, g2, panelzoom);
        }
        int counter = 0;
        for (SimpleGeometry geom : this.geometries) {
            if (!geom.isSelected()) {
                this.drawGeometry(g2, imagewidth, geom, this.getLabelpoint(geom), null);
            }
            ++counter;
        }
        counter = 0;
        for (SimpleGeometry geom : this.geometries) {
            if (geom.isSelected()) {
                this.drawGeometry(g2, imagewidth, geom, this.getLabelpoint(geom), null);
            }
            ++counter;
        }
        for (ImageText t : this.texts) {
            this.drawText(g2, imagewidth, t);
        }
        if (this.status != 1 && !this.geo.isOfType(0)) {
            this.geo.setShowVerteces(true);
            this.drawGeometry(g2, imagewidth, this.geo, this.getLabelpoint(this.geo), null);
        }
    }

    private void drawImage(BufferedImage i, Graphics2D g2, double panelzoom) {
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage iout = new BufferedImage(width, height, 2);
        Graphics2D gg = iout.createGraphics();
        gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        gg.scale(this.zoom * panelzoom, this.zoom * panelzoom);
        gg.setComposite(AlphaComposite.Src.derive(this.transparency));
        gg.drawImage((Image)i, (int)this.corner.getX(), (int)this.corner.getY(), null);
        gg.setColor(Color.black);
        gg.drawRect((int)this.corner.getX(), (int)this.corner.getY(), this.getImageWidth(), this.getImageHeight());
        gg.dispose();
    }

    public void drawText(Graphics2D gg, int imagewidth, ImageText txt) {
        float labelFontSize = txt.fontsize;
        Font labelFont = this.font.deriveFont(labelFontSize);
        FontMetrics metrics = gg.getFontMetrics(labelFont);
        int labelHeight = metrics.getHeight();
        int labelTextWidth = metrics.stringWidth(txt.txt);
        double labelDeltaX = 0.0;
        if (imagewidth > 0) {
            double labelTextWidthImage = this.scaleScreen2image(labelTextWidth);
            Point labelpointImage = this.screen2Image(txt.x, txt.y);
            if (labelpointImage.getX() + labelTextWidthImage > (double)imagewidth) {
                labelDeltaX = this.scaleImage2screen(labelpointImage.getX() + labelTextWidthImage - (double)imagewidth);
            }
        }
        gg.setColor(Color.black);
        gg.setFont(labelFont);
        gg.drawString(txt.txt, txt.x - (int)labelDeltaX, txt.y - 2);
    }

    public synchronized void drawGeometry(Graphics2D gg, int imagewidth, SimpleGeometry geometry, Point labelpoint, Color c) {
        int l;
        int[][] points;
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gg.setRenderingHints(qualityHints);
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (c == null) {
            c = geometry.isSelected() ? geometry.getDisplaySel().color : (geometry.isOff() ? geometry.getDisplayOff().color : geometry.getDisplayStandard().color);
        }
        double displayScale = this.getDisplayScale() * this.getPanelZoom() / 0.15;
        float labelFontSize = (float)((double)geometry.getDisplay().fontsize * (this.scaleIcons ? this.zoom * displayScale : 1.0));
        Font labelFont = this.font.deriveFont(labelFontSize);
        FontMetrics metrics = gg.getFontMetrics(labelFont);
        int labelHeight = metrics.getHeight();
        int labelTextWidth = geometry.hasLabel() ? metrics.stringWidth(geometry.getLabel()) : 0;
        int displaysize = (int)((float)geometry.getDisplay().size * geometry.getSizeFactor());
        int n = displaysize = displaysize <= 0 ? 1 : displaysize;
        if (this.scaleIcons) {
            displaysize = (int)((double)displaysize * (this.zoom * displayScale));
        }
        double labelDeltaX = 0.0;
        double labelDeltaY = 0.0;
        if (imagewidth > 0 && labelpoint != null) {
            double labelTextWidthImage = this.scaleScreen2image(labelTextWidth);
            Point labelpointImage = this.screen2Image((int)labelpoint.getX(), (int)labelpoint.getY());
            if (labelpointImage.getX() + labelTextWidthImage > (double)imagewidth) {
                labelDeltaX = this.scaleImage2screen(labelpointImage.getX() + labelTextWidthImage - (double)imagewidth);
            }
        }
        if (geometry.getType() == 1 && !geometry.hasPointMarker()) {
            labelDeltaY = -0.3 * (double)displaysize;
        }
        int labelBorder = Math.round((float)labelHeight / 4.0f);
        if (geometry.hasLabelpoint()) {
            points = new int[2][2];
            points[0][0] = (int)labelpoint.getX() - labelBorder - (int)labelDeltaX + (labelTextWidth + 2 * labelBorder) / 2;
            points[1][0] = (int)labelpoint.getY() - labelHeight - labelBorder + (labelHeight + 2 * labelBorder) / 2;
            Point ptGeo = this.image2screen(geometry.getFirstPoint().getX(), geometry.getFirstPoint().getY());
            points[0][1] = (int)ptGeo.getX();
            points[1][1] = (int)ptGeo.getY();
            gg.setColor(new Color(0.3f, 0.3f, 0.3f));
            gg.setStroke(new BasicStroke(2.0f));
            gg.drawPolyline(points[0], points[1], 2);
        }
        if (geometry.getType() == 2) {
            if (geometry.size() > 0) {
                points = this.getPointArrayOnScreen(geometry.getPoints());
                gg.setColor(geometry.getDisplay().color);
                gg.setStroke(geometry.getDisplay().getStoke());
                gg.drawPolyline(points[0], points[1], geometry.size());
            }
        } else if (geometry.getType() == 5) {
            if (geometry.size() > 1) {
                points = this.getPointArrayOnScreen(geometry.getPoints());
                double dx = points[0][1] - points[0][0];
                double dy = points[1][1] - points[1][0];
                l = (int)Math.sqrt(dx * dx + dy * dy);
                gg.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0f * geometry.getFill())));
                gg.fillOval(points[0][0] - l / 2, points[1][0] - l / 2, l, l);
                gg.setColor(c);
                gg.setStroke(geometry.getDisplay().getStoke());
                gg.drawOval(points[0][0] - l / 2, points[1][0] - l / 2, l, l);
            }
        } else if (geometry.getType() == 6) {
            if (geometry.size() > 1) {
                points = this.getPointArrayOnScreen(geometry.getPoints());
                float dx = points[0][1] - points[0][0];
                float dy = points[1][1] - points[1][0];
                int cx = points[0][0];
                int cy = points[1][0];
                l = (int)Math.sqrt(dx * dx + dy * dy);
                gg.setColor(geometry.getDisplay().color);
                gg.setStroke(geometry.getDisplay().getStoke());
                gg.draw(new QuadCurve2D.Double((float)cx - 1.0f * (dx /= 2.0f), (float)cy - 2.0f * (dy /= 2.0f), (float)cx + 0.0f * dx, (float)cy - 4.0f * dy, (float)cx + 1.0f * dx, (float)cy - 2.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx + 1.0f * dx, (float)cy - 2.0f * dy, (float)cx + 3.0f * dx, (float)cy - 3.0f * dy, (float)cx + 3.0f * dx, (float)cy - 1.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx + 3.0f * dx, (float)cy - 1.0f * dy, (float)cx + 5.0f * dx, (float)cy + 0.0f * dy, (float)cx + 3.0f * dx, (float)cy + 1.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx + 3.0f * dx, (float)cy + 1.0f * dy, (float)cx + 3.0f * dx, (float)cy + 3.0f * dy, (float)cx + 1.0f * dx, (float)cy + 2.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx + 1.0f * dx, (float)cy + 2.0f * dy, (float)cx + 0.0f * dx, (float)cy + 4.0f * dy, (float)cx - 1.0f * dx, (float)cy + 2.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx - 1.0f * dx, (float)cy + 2.0f * dy, (float)cx - 3.0f * dx, (float)cy + 3.0f * dy, (float)cx - 3.0f * dx, (float)cy + 1.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx - 3.0f * dx, (float)cy + 1.0f * dy, (float)cx - 5.0f * dx, (float)cy + 0.0f * dy, (float)cx - 3.0f * dx, (float)cy - 1.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx - 3.0f * dx, (float)cy - 1.0f * dy, (float)cx - 3.0f * dx, (float)cy - 3.0f * dy, (float)cx - 1.0f * dx, (float)cy - 2.0f * dy));
            }
        } else if (geometry.getType() == 7) {
            if (geometry.size() > 1) {
                points = this.getPointArrayOnScreen(geometry.getPoints());
                float dx = points[0][1] - points[0][0];
                float dy = points[1][1] - points[1][0];
                int cx = points[0][0];
                int cy = points[1][0];
                l = (int)Math.sqrt(dx * dx + dy * dy);
                gg.setColor(geometry.getDisplay().color);
                gg.setStroke(geometry.getDisplay().getStoke());
                gg.draw(new QuadCurve2D.Double((float)cx - 1.0f * (dx /= 2.0f), (float)cy - 2.0f * (dy /= 2.0f), cx, cy, (float)cx + 1.0f * dx, (float)cy - 2.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx + 1.0f * dx, (float)cy - 2.0f * dy, cx, cy, (float)cx + 3.0f * dx, (float)cy - 1.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx + 3.0f * dx, (float)cy - 1.0f * dy, cx, cy, (float)cx + 3.0f * dx, (float)cy + 1.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx + 3.0f * dx, (float)cy + 1.0f * dy, cx, cy, (float)cx + 1.0f * dx, (float)cy + 2.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx + 1.0f * dx, (float)cy + 2.0f * dy, cx, cy, (float)cx - 1.0f * dx, (float)cy + 2.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx - 1.0f * dx, (float)cy + 2.0f * dy, cx, cy, (float)cx - 3.0f * dx, (float)cy + 1.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx - 3.0f * dx, (float)cy + 1.0f * dy, cx, cy, (float)cx - 3.0f * dx, (float)cy - 1.0f * dy));
                gg.draw(new QuadCurve2D.Double((float)cx - 3.0f * dx, (float)cy - 1.0f * dy, cx, cy, (float)cx - 1.0f * dx, (float)cy - 2.0f * dy));
            }
        } else if (geometry.getType() == 4) {
            if (geometry.size() > 1) {
                points = this.getPointArrayOnScreen(geometry.getPoints());
                int[][] pointsArrow = new int[2][3];
                double dx = points[0][1] - points[0][0];
                double dy = points[1][1] - points[1][0];
                double l2 = Math.sqrt(dx * dx + dy * dy);
                double factor = 14.0;
                pointsArrow[0][1] = points[0][1];
                pointsArrow[1][1] = points[1][1];
                pointsArrow[0][0] = (int)((double)points[0][1] - factor * 2.0 * (dx /= l2) - factor * (dy /= l2));
                pointsArrow[1][0] = (int)((double)points[1][1] - factor * 2.0 * dy + factor * dx);
                pointsArrow[0][2] = (int)((double)points[0][1] - factor * 2.0 * dx + factor * dy);
                pointsArrow[1][2] = (int)((double)points[1][1] - factor * 2.0 * dy - factor * dx);
                points[0][1] = points[0][1] - (int)(15.0 * dx);
                points[1][1] = points[1][1] - (int)(15.0 * dy);
                gg.setColor(geometry.getDisplay().color);
                gg.setStroke(geometry.getDisplay().getStoke());
                gg.drawPolyline(points[0], points[1], geometry.size());
                gg.setStroke(new BasicStroke(1.0f));
                gg.fillPolygon(pointsArrow[0], pointsArrow[1], 3);
            }
        } else if (geometry.getType() == 3 || geometry.getType() == 8) {
            if (geometry.size() > 0) {
                points = this.getPointArrayOnScreen(geometry.getPoints());
                Color cc = gg.getColor();
                if (geometry.getType() == 3) {
                    gg.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0f * geometry.getFill())));
                } else {
                    gg.setColor(Color.BLACK);
                }
                gg.fillPolygon(points[0], points[1], geometry.size());
                if (geometry.getType() == 3) {
                    gg.setColor(c);
                }
                gg.setStroke(new BasicStroke(5.0f));
                gg.drawPolygon(points[0], points[1], geometry.size());
                gg.setColor(cc);
            }
        } else if (geometry.getType() == 1 && geometry.size() > 0) {
            Point p = this.getPointOnScreen(geometry.getPoint());
            double imageScale = this.zoom * displayScale * (double)geometry.getSizeFactor();
            if (geometry.hasPointMarker()) {
                Image i = geometry.getPointMarker();
                Dimension iDim = this.getIconDimensions(i, imageScale);
                if (geometry.doMoveIconWithLabel() && geometry.hasLabel() && labelpoint != null) {
                    gg.setColor(geometry.getDisplay().color);
                    gg.setStroke(new BasicStroke(5.0f));
                    gg.fillOval((int)(p.getX() - (double)(displaysize / 2)), (int)(p.getY() - (double)(displaysize / 2)), displaysize, displaysize);
                    p.setX(labelpoint.getX());
                    p.setY(labelpoint.getY());
                    if (geometry.hasLabelOffset()) {
                        p.translate(imageScale * -geometry.getLabelOffset().getX() + (double)(labelFontSize / 3.0f), imageScale * -geometry.getLabelOffset().getY() - (double)(0.0f * (labelFontSize / 3.0f)));
                    }
                }
                gg.drawImage(i.getScaledInstance(iDim.width, iDim.height, 2), (int)p.getX() - iDim.width / 2, (int)p.getY() - iDim.height / 2, null);
                if (geometry.isSelected()) {
                    gg.setColor(geometry.getDisplay().color);
                    gg.setStroke(new BasicStroke(3.0f));
                    gg.drawRect((int)(p.getX() - (double)(iDim.width / 2)), (int)(p.getY() - (double)(iDim.width / 2)), iDim.width, iDim.width);
                }
            } else {
                gg.setColor(geometry.getDisplay().color);
                gg.setStroke(new BasicStroke(5.0f));
                if (geometry.getDisplay().type == 4) {
                    gg.fillOval((int)(p.getX() - (double)(displaysize / 2)), (int)(p.getY() - (double)(displaysize / 2)), displaysize, displaysize);
                } else if (geometry.getDisplay().type == 3) {
                    gg.drawRect((int)(p.getX() - (double)(displaysize / 2)), (int)(p.getY() - (double)(displaysize / 2)), displaysize, displaysize);
                } else if (geometry.getDisplay().type == 2) {
                    gg.setStroke(new BasicStroke(5.0f));
                    gg.drawLine((int)(p.getX() - (double)(displaysize / 2)), (int)p.getY(), (int)(p.getX() + (double)(displaysize / 2)), (int)p.getY());
                    gg.drawLine((int)p.getX(), (int)(p.getY() - (double)(displaysize / 2)), (int)p.getX(), (int)(p.getY() + (double)(displaysize / 2)));
                } else if (geometry.getDisplay().type == 1) {
                    gg.setStroke(new BasicStroke(5.0f));
                    gg.drawLine((int)(p.getX() - (double)(displaysize / 2)), (int)(p.getY() - (double)(displaysize / 2)), (int)(p.getX() + (double)(displaysize / 2)), (int)(p.getY() + (double)(displaysize / 2)));
                    gg.drawLine((int)(p.getX() - (double)(displaysize / 2)), (int)(p.getY() + (double)(displaysize / 2)), (int)(p.getX() + (double)(displaysize / 2)), (int)(p.getY() - (double)(displaysize / 2)));
                }
            }
        }
        if (geometry.doShowVerteces() && (geometry.getType() == 2 || geometry.getType() == 3)) {
            gg.setColor(c);
            gg.setStroke(new BasicStroke(5.0f));
            int r = 8;
            for (Point p : geometry.getPoints()) {
                Point ps = this.image2screen(p.getX(), p.getY());
                gg.fillOval((int)(ps.getX() - (double)(r / 2)), (int)(ps.getY() - (double)(r / 2)), r, r);
            }
        }
        if (geometry.hasLabel() && labelpoint != null) {
            if (geometry.getDisplay().getLabelWithBackground()) {
                c = geometry.isSelected() ? geometry.getDisplaySel().labelcolor : geometry.getDisplay().labelcolor;
                gg.setColor(c);
                gg.fillRoundRect((int)labelpoint.getX() - labelBorder - (int)labelDeltaX, (int)labelpoint.getY() - labelHeight - labelBorder - (int)labelDeltaY, labelTextWidth + 2 * labelBorder, labelHeight + 2 * labelBorder, 10, 10);
            }
            c = geometry.isSelected() ? geometry.getDisplaySel().labeltextcolor : geometry.getDisplay().labeltextcolor;
            gg.setColor(c);
            gg.setFont(labelFont);
            gg.drawString(geometry.getLabel(), (int)labelpoint.getX() - (int)labelDeltaX, (int)labelpoint.getY() - (int)labelDeltaY - 2);
        }
    }

    public int getWidth() {
        int w = 0;
        return w == 0 ? this.getImageWidth() : w;
    }

    public int getHeight() {
        int h = 0;
        return h == 0 ? this.getImageHeight() : h;
    }

    public int getImageWidth() {
        return this.backgroundImage == null ? 0 : this.backgroundImage.getWidth();
    }

    public int getImageHeight() {
        return this.backgroundImage == null ? 0 : this.backgroundImage.getHeight();
    }

    public BufferedImage getAsBufferedImage() {
        return this.getAsBufferedImage(true);
    }

    public BufferedImage getAsBufferedImage(boolean full) {
        return this.getAsBufferedImage(0, full);
    }

    public BufferedImage getAsBufferedImage(int width, boolean full) {
        BufferedImage buffy;
        this.displayWidth = width;
        if (width > 0) {
            int height = this.getImageHeight() * width / this.getImageWidth();
            buffy = new BufferedImage(width, height, 1);
        } else {
            buffy = new BufferedImage(this.getImageWidth(), this.getImageHeight(), 1);
        }
        Graphics g = buffy.getGraphics();
        if (full) {
            this.fullExtent = true;
        }
        this.paintComponent(g);
        g.dispose();
        if (full) {
            this.fullExtent = false;
        }
        return buffy;
    }

    public BufferedImage getImageSubset(int x0, int y0, int w, int h) {
        return Util.resizeImage((BufferedImage)this.getAsBufferedImage(true).getSubimage(x0, y0, w, h), (int)w);
    }

    public Box2D getCurrentExtent() {
        if (this.hasGeometry()) {
            Coordinates2D c1 = this.image2real(this.screen2Image(0, 0));
            Coordinates2D c2 = this.image2real(this.screen2Image(this.getWidth() - 1, this.getHeight() - 1));
            return new Box2D(c1, c2);
        }
        Point pt1 = this.screen2Image(0, 0);
        Point pt2 = this.screen2Image(this.getWidth() - 1, this.getHeight() - 1);
        return new Box2D(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
    }

    public void setFontSize(float size) {
        this.font = this.font.deriveFont(size);
    }

    public void setIconScale(float scale) {
        this.iconscale = scale;
        this.font = this.font.deriveFont(12.0f * scale);
    }

    public final void setStatus(int newstatus) {
        this.setStatus(newstatus, null);
    }

    public final void setStatus(int newstatus, Image icon) {
        this.status = newstatus;
        this.geo.clear();
        this.geo.setShowVerteces(true);
        this.geo.setFill(0.0f);
        switch (newstatus) {
            case 2: {
                this.geo.setType(1);
                if (icon != null) {
                    this.geo.setPointMarker(icon);
                }
                this.geo.setNextId();
                break;
            }
            case 3: {
                this.geo.setType(2);
                this.geo.setNextId();
                break;
            }
            case 4: {
                this.geo.setType(3);
                this.geo.setNextId();
                break;
            }
            case 7: {
                this.geo.setType(2);
                this.geo.setNextId();
                break;
            }
            case 8: {
                this.geo.setType(4);
                this.geo.setNextId();
                break;
            }
            case 9: {
                this.geo.setType(5);
                this.geo.setNextId();
                break;
            }
            case 10: {
                this.geo.setType(6);
                this.geo.setNextId();
                break;
            }
            case 11: {
                this.geo.setType(7);
                this.geo.setNextId();
                break;
            }
            case 12: {
                this.geo.setType(3);
                this.geo.setNextId();
                break;
            }
            case 6: {
                this.geo.setType(2);
                break;
            }
            case 14: {
                this.geo.setType(8);
                this.geo.setNextId();
                this.geo.setFill(1.0f);
                break;
            }
            default: {
                this.geo.setShowVerteces(false);
            }
        }
        this.repaint();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDrawing() {
        return this.status == 3 || this.status == 2 || this.status == 4 || this.status == 7 || this.status == 9 || this.status == 10 || this.status == 11 || this.status == 12 || this.status == 14 || this.status == 8;
    }

    public void saveDrawing() {
        this.cancelDrawing();
    }

    public void cancelDrawing() {
        this.setStatus(1);
    }

    public SimpleGeometry getCurrentGeometryObject() {
        return this.geo;
    }

    public void setCurrentGeometryObject(SimpleGeometry geo) {
        this.geo = geo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        double displayScale;
        double pixelBuffer;
        com.vividsolutions.jts.geom.Point clickScreen;
        com.vividsolutions.jts.geom.Point clickGeo;
        Point clicked;
        ArrayList<Long> selids;
        ArrayList<SimpleGeometry> sels;
        int clickCount = e.getClickCount();
        if (this.status == 1 || this.status == 5) {
            sels = new ArrayList<SimpleGeometry>();
            selids = new ArrayList<Long>();
            clicked = this.screen2Image(e.getX(), e.getY());
            clickGeo = new GeometryFactory().createPoint(new Coordinate(clicked.getX(), clicked.getY()));
            clickScreen = new GeometryFactory().createPoint(new Coordinate((double)e.getX(), (double)e.getY()));
            this.logger.fine("ImagePanel click in map: clicked=" + clicked.toString());
            pixelBuffer = 15.0 / this.getTotalZoom();
            displayScale = this.getDisplayScale() * this.getPanelZoom() / 0.15;
        } else {
            if (this.status == 2) {
                if (e.getButton() == 1) {
                    this.geo.add(this.screen2Image(e.getX(), e.getY()));
                    if (this.actionProvider != null && this.geometryAction != null) {
                        this.actionProvider.invokeAction(this.geometryAction, (Object)this.geo);
                    }
                }
                this.repaint();
                return;
            }
            if (this.status != 3 && this.status != 4) {
                if (this.status != 6) return;
            }
            if (e.getButton() == 1) {
                this.geo.add(this.screen2Image(e.getX(), e.getY()));
            } else if (e.getButton() == 3) {
                this.geo.removeLast();
            }
            if (this.actionProvider != null && this.geometryAction != null && this.status != 6) {
                this.actionProvider.invokeAction(this.geometryAction, (Object)this.geo);
            }
            if (this.status == 6) {
                if (this.geo.getPoints().size() > 1) {
                    if (this.geometry != null) {
                        this.geo.setLabel(Long.toString(Math.round(this.geo.transform(this.getHeight(), this.geometry).getLength())));
                    } else {
                        this.geo.setLabel(Long.toString(Math.round(this.geo.getLength())));
                    }
                } else {
                    this.geo.setLabel("");
                }
            }
            this.repaint();
            return;
        }
        for (int ii = 0; ii < this.geometries.size(); ++ii) {
            SimpleGeometry currentGeo = this.geometries.get(ii);
            if (!currentGeo.isSelectable()) continue;
            try {
                if (currentGeo.isPoint()) {
                    Point pointScreen = this.getPointOnScreen(currentGeo.getPoint());
                    if (currentGeo.hasPointMarker()) {
                        Dimension dim = this.getIconDimensions(currentGeo.getPointMarker(), 1.0);
                        pixelBuffer = (int)((double)((float)(dim.height + dim.width) / 1.5f) * this.zoom);
                    } else {
                        pixelBuffer = (int)((double)((float)currentGeo.getDisplay().size * currentGeo.getSizeFactor()) * this.zoom);
                    }
                    if (this.scaleIcons) {
                        pixelBuffer *= displayScale;
                    }
                    pixelBuffer = Math.max(pixelBuffer, 7.0);
                    double dx = Math.abs(pointScreen.getX() - clickScreen.getX());
                    double dy = Math.abs(pointScreen.getY() - clickScreen.getY());
                    if (!(dx < pixelBuffer) || !(dy < pixelBuffer)) continue;
                    sels.add(currentGeo);
                    selids.add(currentGeo.getId());
                    continue;
                }
                Geometry jtsgeo = this.jts_geometries.get(ii);
                if (!jtsgeo.buffer(pixelBuffer).contains((Geometry)clickGeo)) continue;
                sels.add(currentGeo);
                selids.add(currentGeo.getId());
                continue;
            }
            catch (Exception jtsgeo) {
                // empty catch block
            }
        }
        this.logger.fine("ImagePanel click in map: sels.size()=" + sels.size());
        if (sels.size() > 1) {
            boolean hasItems = false;
            JPopupMenu menu = new JPopupMenu("Auswahl");
            for (SimpleGeometry g : sels) {
                if (g.getReference() == null) continue;
                JMenuItem item = new JMenuItem(g.getReference().toString());
                item.addActionListener((java.awt.event.ActionListener)g.getReference());
                menu.add(item);
                hasItems = true;
            }
            this.logger.fine("ImagePanel click in map: multi menu prepared");
            if (!hasItems) {
                // empty if block
            }
        } else if (!sels.isEmpty()) {
            this.logger.fine("ImagePanel click in map: single action");
            if (((SimpleGeometry)sels.get(0)).getReference() != null) {
                ((java.awt.event.ActionListener)((SimpleGeometry)sels.get(0)).getReference()).actionPerformed(null);
            }
        }
        if (this.imageListener != null) {
            this.imageListener.imageClicked((int)clicked.getX(), (int)clicked.getY());
        }
        if (this.actionProvider != null && this.selectionAction != null) {
            this.actionProvider.invokeAction(this.selectionAction, selids, e.getX(), e.getY());
        }
        SimpleGeometry clickgeo = new SimpleGeometry(1);
        clickgeo.add(this.screen2Image(e.getX(), e.getY()));
        if (e.getButton() == 1) {
            if (this.actionProvider != null && this.clickAction != null) {
                this.actionProvider.invokeAction(this.clickAction, (Object)clickgeo, e.getX(), e.getY());
            }
        } else if (e.getButton() == 3 && this.actionProvider != null && this.rightclickAction != null) {
            this.actionProvider.invokeAction(this.rightclickAction, (Object)clickgeo);
        }
        if (this.actionProvider != null) return;
        for (SimpleGeometry g : this.geometries) {
            g.setStatus(1);
        }
        Iterator<Object> iterator = sels.iterator();
        while (iterator.hasNext()) {
            SimpleGeometry g = (SimpleGeometry)iterator.next();
            g.setStatus(3);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.drag0 == null) {
            this.drag0 = new Point(e.getPoint());
            this.dragCorner = null;
            Point drag0pt = this.screen2Image((int)this.drag0.getX(), (int)this.drag0.getY());
            this.jts_drag0 = new GeometryFactory().createPoint(new Coordinate(drag0pt.getX(), drag0pt.getY()));
        }
        if (this.status == 1 && !this.isDrawing() && this.dragable) {
            if (this.status != 6) {
                this.status = 1;
            }
            double scale = this.getDisplayScale() * this.getPanelZoom() / 0.15;
            for (int ii = 0; ii < this.geometries.size(); ++ii) {
                SimpleGeometry currentGeo = this.geometries.get(ii);
                Point labelGripPoint = this.getLabelpoint(currentGeo);
                float labelFontSize = (float)((double)currentGeo.getDisplay().fontsize * (this.scaleIcons ? this.zoom * scale : 1.0));
                if (labelGripPoint != null) {
                    labelGripPoint.translate((double)(labelFontSize / 2.0f), (double)(-labelFontSize / 2.0f));
                }
                if (!currentGeo.isSelected()) continue;
                if (this.allowMoveLabel) {
                    Point point = new Point(this.drag0.getX(), this.drag0.getY());
                    if (labelGripPoint.distance(point) < (double)labelFontSize) {
                        this.status = 13;
                        continue;
                    }
                }
                if (!this.allowMoveGeometry || !this.jts_geometries.get(ii).buffer(15.0 / this.getTotalZoom()).contains(this.jts_drag0)) continue;
                this.status = 5;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.status == 7 || this.status == 12 || this.status == 14) {
            if (this.actionProvider != null && this.geometryAction != null) {
                this.actionProvider.invokeAction(this.geometryAction, (Object)this.geo);
            }
            this.addGeometry(new SimpleGeometry(this.geo, false));
            this.drag0 = null;
            this.dragCorner = null;
            this.geo.clear();
        } else if (this.status == 1 || this.status == 6 || this.isDrawing()) {
            if (this.dragCorner != null) {
                this.dragCorner.setLocation(this.corner);
            }
            if (this.drag0 != null) {
                double dx = this.drag0.getX() - (double)e.getX();
                double d = this.drag0.getY() - (double)e.getY();
            }
        } else if (this.status == 5 && this.drag0 != null) {
            if (this.dragged && this.moveAction != null) {
                SimpleGeometry movedto = new SimpleGeometry(1);
                movedto.add(this.screen2Image(e.getX(), e.getY()));
                if (this.actionProvider != null) {
                    this.actionProvider.invokeAction(this.moveAction, (Object)movedto);
                } else if (this.actionListener != null) {
                    this.actionListener.onAction(this.moveAction, (Object)movedto);
                }
            }
            this.status = 1;
        } else if (this.status == 13 && this.drag0 != null) {
            if (this.dragged && this.moveLabelAction != null) {
                SimpleGeometry movedto = new SimpleGeometry(1);
                movedto.add(this.screen2Image(e.getX(), e.getY()));
                double dist = this.drag0.distance(movedto.getPoint());
                if (this.actionProvider != null) {
                    this.actionProvider.invokeAction(this.moveLabelAction, (Object)movedto);
                } else if (this.actionListener != null) {
                    this.actionListener.onAction(this.moveLabelAction, (Object)movedto);
                }
            }
            this.status = 1;
        }
        this.drag0 = null;
        this.dragCorner = null;
        this.jts_drag0 = null;
        this.dragged = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.drag0 == null) {
            return;
        }
        Point drag0pt = this.screen2Image((int)this.drag0.getX(), (int)this.drag0.getY());
        boolean newDrag = false;
        double panelzoom = this.getPanelZoom();
        java.awt.Point pt = e.getPoint();
        if (Math.abs(pt.getX() - this.drag0.getX()) + Math.abs(pt.getY() - this.drag0.getY()) < 1.0) {
            return;
        }
        this.dragged = true;
        if (this.status == 7) {
            this.geo.add(this.screen2Image(e.getX(), e.getY()));
            this.drag0 = new Point(e.getPoint());
            this.dragCorner = null;
        } else if (this.status == 12 || this.status == 14) {
            long id1;
            SimpleGeometry sg;
            long id;
            int idxRemove;
            if (newDrag && (idxRemove = this.geometries.size() - 1) >= 0 && (id = (sg = this.geometries.get(idxRemove)).getId()) >= (id1 = this.geo.getId())) {
                this.geometries.remove(idxRemove);
                this.geometryreference.remove(idxRemove);
                this.jts_geometries.remove(idxRemove);
                this.repaint();
            }
            Point ptscreen = this.screen2Image(e.getX(), e.getY());
            this.geo.clear();
            this.geo.add(drag0pt.getX(), drag0pt.getY());
            this.geo.add(ptscreen.getX(), drag0pt.getY());
            this.geo.add(ptscreen.getX(), ptscreen.getY());
            this.geo.add(drag0pt.getX(), ptscreen.getY());
        } else if (this.status == 8 || this.status == 10 || this.status == 11 || this.status == 9) {
            Point newpoint = this.screen2Image(e.getX(), e.getY());
            if (this.geo.size() < 2) {
                this.geo.add(this.screen2Image(e.getX(), e.getY()));
                this.geo.add(newpoint);
            } else {
                ((Point)this.geo.getPoints().get(0)).setLocation(drag0pt.getX(), drag0pt.getY());
                ((Point)this.geo.getPoints().get(1)).setLocation(newpoint.getX(), newpoint.getY());
            }
        } else if (this.status == 1 || this.status == 6 || this.isDrawing()) {
            if (this.dragCorner == null) {
                this.dragCorner = new Point(this.corner);
            }
            this.corner.setLocation(this.dragCorner.getX() + (double)((int)((e.getPoint().getX() - this.drag0.getX()) / (this.zoom * panelzoom))), this.dragCorner.getY() + (double)((int)((e.getPoint().getY() - this.drag0.getY()) / (this.zoom * panelzoom))));
        } else if (this.status == 5) {
            for (SimpleGeometry g : this.geometries) {
                if (!g.isSelected()) continue;
                for (Point p : g.getPoints()) {
                    p.translate((e.getPoint().getX() - this.drag0.getX()) / (this.zoom * panelzoom), (e.getPoint().getY() - this.drag0.getY()) / (this.zoom * panelzoom));
                }
            }
            this.drag0 = new Point(e.getPoint());
            this.dragCorner = null;
        } else if (this.status == 13) {
            for (SimpleGeometry g : this.geometries) {
                if (!g.isSelected()) continue;
                Point lp = g.getLabelpoint();
                if (lp != null) {
                    double diffX = (e.getPoint().getX() - this.drag0.getX()) / (this.zoom * panelzoom);
                    double diffY = (e.getPoint().getY() - this.drag0.getY()) / (this.zoom * panelzoom);
                    lp.translate(diffX, diffY);
                    continue;
                }
                Point newP = this.getLabelpoint(g);
                g.setLabelpoint(this.screen2Image((int)newP.getX(), (int)newP.getY()));
            }
            this.drag0 = new Point(e.getPoint());
            this.dragCorner = null;
        }
        this.showCoordinates();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.showCoordinates(e.getX(), e.getY());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.isAllowZoom()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        Point p = this.screen2Image(x, y);
        double lastZoom = this.zoom;
        this.zoom = e.getWheelRotation() < 0 ? (this.zoom *= this.zoomfactor) : (this.zoom /= this.zoomfactor);
        if (this.minZoomEnabled && this.zoom < this.minZoom) {
            this.zoom = this.minZoom;
        }
        if (this.zoom == lastZoom) {
            return;
        }
        Point p2 = this.screen2Image(x, y);
        this.corner.translate((double)((int)(p2.getX() - p.getX())), (double)((int)(p2.getY() - p.getY())));
        this.dragCorner = null;
        this.showCoordinates();
        this.repaint();
    }

    private static class ImageText {
        String txt;
        int fontsize;
        int x;
        int y;

        public ImageText(String txt, int size, int x, int y) {
            this.txt = txt;
            this.fontsize = size;
            this.x = x;
            this.y = y;
        }
    }
}

