/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.io;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.importer.ThemisCsvExporter;
import at.grid.themis.ontology.importer.ThemisGenericExporter;
import at.grid.themis.ontology.importer.ThemisXlsExporter;
import at.grid.themis.ontology.javafx.JavaFxDialogs;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.JavaFxIcon;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.PlaceholderReference;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;

public class ExportCsvFxPanel
extends VBox {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private Placeholder placeholder = new Placeholder(new CmsReport());
    private Properties mapping;
    private Properties groupFunction = new Properties();
    private ExportType exportType;
    private Button btnStatus;
    private Button btnEvent;
    private Button btnPeriod;
    private Button btnSelection;
    private final VBox configBox = new VBox();
    private ComboBox<CmsBasicElement> cbFilter;
    private ComboBox<CmsElementSummary> cbEvent;
    private final Label lblEntriesCount = JavaFxFactory.createLabel("");
    private final TextField fldSeparator = JavaFxFactory.createTextField(";");
    private final ListView<PlaceholderReference> lstPlaceholder = new ListView();
    private final ListView<PlaceholderReference> lstExportPlaceholder = new ListView();
    private final ListView<PlaceholderReference> lstGroupPlaceholder = new ListView();
    private final TextField fldFolder = JavaFxFactory.createTextField("");
    private final TextField fldFilename = JavaFxFactory.createTextField("");
    private final ComboBox<ExportFormat> cbFormat = JavaFxFactory.createComboBox(Arrays.asList(ExportFormat.values()), (Object)ExportFormat.CSV, false);

    public ExportCsvFxPanel() {
        this.setSpacing(10.0);
        this.setPadding(new Insets(10.0));
        this.prepareFilterCombobox();
        this.prepareEventsCombobox();
        this.getChildren().add((Object)JavaFxFactory.createLabelHeading("1. Export konfigurieren"));
        this.getChildren().add((Object)this.createConfigurationBox());
        this.getChildren().add((Object)JavaFxFactory.createLabelHeading("2. Attribute ausw\u00e4hlen"));
        this.getChildren().add((Object)this.createAttributeBox());
        this.getChildren().add((Object)JavaFxFactory.createLabelHeading("3. Datei ausw\u00e4hlen"));
        this.getChildren().add((Object)this.createFileSelectionBox());
    }

    private void prepareFilterCombobox() {
        ArrayList<CmsBasicElement> filters = this.project.getFilters();
        filters.add(0, new CmsBasicElement(-3L, "Anstehende Termine"));
        filters.add(0, new CmsBasicElement(-2L, "Offene M\u00e4ngel"));
        filters.add(0, new CmsBasicElement(-1L, "aktueller Filter"));
        filters.add(0, new CmsBasicElement(-9L, "kein Filter (alle Eintr\u00e4ge)"));
        this.cbFilter = JavaFxFactory.createComboBox(filters, filters.get(0), false);
        this.cbFilter.getSelectionModel().selectedItemProperty().addListener((ov, oldValue, newValue) -> this.updateCount(ExportType.status, (CmsBasicElement)newValue));
        Callback factory = p -> new ListCell<CmsBasicElement>(){

            protected void updateItem(CmsBasicElement item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(item.getTitle());
                }
            }
        };
        this.cbFilter.setButtonCell((ListCell)factory.call(null));
        this.cbFilter.setCellFactory(factory);
        this.cbFilter.setMaxWidth(2.147483647E9);
        HBox.setHgrow(this.cbFilter, (Priority)Priority.ALWAYS);
    }

    private void prepareEventsCombobox() {
        ArrayList<CmsElementSummary> events = this.project.getEvents();
        final CmsEvent currentEvent = this.app.getProject().getSelectionManager().getCurrentEvent();
        this.cbEvent = JavaFxFactory.createComboBox(events, events.isEmpty() ? null : events.get(0), false);
        this.cbEvent.getSelectionModel().selectedItemProperty().addListener((ov, oldValue, newValue) -> this.updateCount(ExportType.event, new CmsBasicElement(newValue.getId(), newValue.getTitle())));
        Callback factory = p -> new ListCell<CmsElementSummary>(){

            protected void updateItem(CmsElementSummary item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText("");
                } else {
                    String title = item.getTitle();
                    if (currentEvent != null && item.getId() == currentEvent.getId()) {
                        title = title + " <aktuell>";
                    }
                    this.setText(title);
                }
            }
        };
        this.cbEvent.setButtonCell((ListCell)factory.call(null));
        this.cbEvent.setCellFactory(factory);
        this.cbEvent.setMaxWidth(2.147483647E9);
        HBox.setHgrow(this.cbEvent, (Priority)Priority.ALWAYS);
    }

    private GridPane createFileSelectionBox() {
        GridPane result = new GridPane();
        result.setHgap(10.0);
        result.setVgap(10.0);
        result.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
        result.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
        result.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
        int row = 0;
        Label lblFolder = JavaFxFactory.createLabel("Verzeichnis:");
        this.fldFolder.setDisable(true);
        Button btnFolder = JavaFxFactory.createButton("Ausw\u00e4hlen", e -> {
            File dir = JavaFxDialogs.showDirectoryChooser(new File(this.fldFolder.getText()));
            if (dir != null) {
                this.fldFolder.setText(dir.getAbsolutePath());
            }
        });
        result.addRow(row++, new Node[]{lblFolder, this.fldFolder, btnFolder});
        Label lblFilename = JavaFxFactory.createLabel("Dateiname:");
        result.addRow(row++, new Node[]{lblFilename, this.fldFilename, this.cbFormat});
        return result;
    }

    private VBox createConfigurationBox() {
        VBox result = new VBox();
        result.setSpacing(10.0);
        HBox buttonBox = new HBox();
        buttonBox.setSpacing(10.0);
        this.btnStatus = JavaFxFactory.createButton("Status", e -> this.updateExportType(ExportType.status));
        this.btnStatus.setMaxWidth(2.147483647E9);
        HBox.setHgrow((Node)this.btnStatus, (Priority)Priority.ALWAYS);
        buttonBox.getChildren().add((Object)this.btnStatus);
        this.btnEvent = JavaFxFactory.createButton("Ereignis", e -> this.updateExportType(ExportType.event));
        this.btnEvent.setMaxWidth(2.147483647E9);
        HBox.setHgrow((Node)this.btnEvent, (Priority)Priority.ALWAYS);
        buttonBox.getChildren().add((Object)this.btnEvent);
        this.btnPeriod = JavaFxFactory.createButton("Periode", e -> this.updateExportType(ExportType.period));
        this.btnPeriod.setMaxWidth(2.147483647E9);
        this.btnPeriod.setDisable(true);
        HBox.setHgrow((Node)this.btnPeriod, (Priority)Priority.ALWAYS);
        buttonBox.getChildren().add((Object)this.btnPeriod);
        this.btnSelection = JavaFxFactory.createButton("Auswahl", e -> this.updateExportType(ExportType.selection));
        this.btnSelection.setMaxWidth(2.147483647E9);
        this.btnSelection.setDisable(this.project.getSelectionManager().getSelectedObservationIds().size() < 1);
        HBox.setHgrow((Node)this.btnSelection, (Priority)Priority.ALWAYS);
        buttonBox.getChildren().add((Object)this.btnSelection);
        result.getChildren().add((Object)buttonBox);
        this.configBox.setSpacing(10.0);
        result.getChildren().add((Object)this.configBox);
        HBox box = new HBox();
        box.setSpacing(10.0);
        Label lblEntries = JavaFxFactory.createLabel("Inhalt:");
        lblEntries.setMinWidth(100.0);
        box.getChildren().add((Object)lblEntries);
        this.lblEntriesCount.setMaxWidth(2.147483647E9);
        HBox.setHgrow((Node)this.lblEntriesCount, (Priority)Priority.ALWAYS);
        box.getChildren().add((Object)this.lblEntriesCount);
        Label lblSeparator = JavaFxFactory.createLabel("Trennzeichen:");
        lblSeparator.setMinWidth(100.0);
        box.getChildren().add((Object)lblSeparator);
        HBox.setHgrow((Node)this.fldSeparator, (Priority)Priority.ALWAYS);
        box.getChildren().add((Object)this.fldSeparator);
        result.getChildren().add((Object)box);
        return result;
    }

    private void updateExportType(ExportType type) {
        this.exportType = type;
        this.lblEntriesCount.setText("-");
        this.btnStatus.setDefaultButton(ExportType.status.equals((Object)this.exportType));
        this.btnEvent.setDefaultButton(ExportType.event.equals((Object)this.exportType));
        this.btnPeriod.setDefaultButton(ExportType.period.equals((Object)this.exportType));
        this.btnSelection.setDefaultButton(ExportType.selection.equals((Object)this.exportType));
        this.configBox.getChildren().clear();
        switch (this.exportType) {
            case status: {
                this.configBox.getChildren().add((Object)this.createStatusSelection());
                this.updateCount(this.exportType, (CmsBasicElement)this.cbFilter.getSelectionModel().getSelectedItem());
                break;
            }
            case event: {
                this.configBox.getChildren().add((Object)this.createEventSelection());
                CmsElementSummary event = (CmsElementSummary)this.cbEvent.getSelectionModel().getSelectedItem();
                this.updateCount(this.exportType, new CmsBasicElement(event.getId(), event.getTitle()));
                break;
            }
            case period: {
                this.configBox.getChildren().add((Object)this.createPeriodSelection());
                break;
            }
            case selection: {
                this.configBox.getChildren().add((Object)JavaFxFactory.createLabel(""));
                this.updateCount(this.exportType, null);
                break;
            }
            default: {
                this.configBox.getChildren().add((Object)JavaFxFactory.createLabel(""));
            }
        }
    }

    private HBox createEventSelection() {
        HBox box = new HBox();
        box.setSpacing(10.0);
        Label lblFilter = JavaFxFactory.createLabel("Ereignis:");
        lblFilter.setMinWidth(100.0);
        box.getChildren().add((Object)lblFilter);
        box.getChildren().add(this.cbEvent);
        return box;
    }

    private HBox createStatusSelection() {
        HBox box = new HBox();
        box.setSpacing(10.0);
        Label lblFilter = JavaFxFactory.createLabel("Filter:");
        lblFilter.setMinWidth(100.0);
        box.getChildren().add((Object)lblFilter);
        this.prepareFilterCombobox();
        box.getChildren().add(this.cbFilter);
        return box;
    }

    private HBox createPeriodSelection() {
        HBox box = new HBox();
        box.setSpacing(10.0);
        Label lblFilter = JavaFxFactory.createLabel("Periode:");
        lblFilter.setMinWidth(100.0);
        box.getChildren().add((Object)lblFilter);
        return box;
    }

    private HBox createAttributeBox() {
        HBox result = new HBox();
        result.setSpacing(10.0);
        VBox availableBox = this.createAvailableAttributesBox();
        result.getChildren().add((Object)availableBox);
        VBox vBox = new VBox();
        vBox.setSpacing(10.0);
        HBox.setHgrow((Node)vBox, (Priority)Priority.ALWAYS);
        VBox groupBox = this.createGroupAttributesBox();
        vBox.getChildren().add((Object)groupBox);
        VBox exportBox = this.createExportAttributesBox();
        vBox.getChildren().add((Object)exportBox);
        result.getChildren().add((Object)vBox);
        return result;
    }

    private VBox createGroupAttributesBox() {
        VBox result = new VBox();
        result.setSpacing(10.0);
        HBox.setHgrow((Node)result, (Priority)Priority.ALWAYS);
        result.getChildren().add((Object)JavaFxFactory.createLabelHeading2("Attribute f\u00fcr Gruppierung:"));
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        VBox buttonBox1 = new VBox();
        buttonBox1.setSpacing(10.0);
        Button btnAddToExport = JavaFxFactory.createSvgButton(JavaFxIcon.CHEVRON_RIGHT, e -> {
            ArrayList selected = new ArrayList();
            selected.addAll(this.lstPlaceholder.getSelectionModel().getSelectedItems());
            this.lstGroupPlaceholder.getItems().addAll(selected);
        });
        buttonBox1.getChildren().add((Object)btnAddToExport);
        Button btnRemoveFromExport = JavaFxFactory.createSvgButton(JavaFxIcon.CHEVRON_LEFT, e -> {
            ArrayList selected = new ArrayList();
            selected.addAll(this.lstGroupPlaceholder.getSelectionModel().getSelectedItems());
            this.lstGroupPlaceholder.getItems().removeAll(selected);
        });
        buttonBox1.getChildren().add((Object)btnRemoveFromExport);
        hBox.getChildren().add((Object)buttonBox1);
        this.lstGroupPlaceholder.setMinHeight(100.0);
        this.lstGroupPlaceholder.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        HBox.setHgrow(this.lstGroupPlaceholder, (Priority)Priority.ALWAYS);
        hBox.getChildren().add(this.lstGroupPlaceholder);
        VBox buttonBox2 = new VBox();
        buttonBox2.setSpacing(10.0);
        Button btnUp = JavaFxFactory.createSvgButton(JavaFxIcon.CHEVRON_UP, e -> {
            int index = this.lstGroupPlaceholder.getSelectionModel().getSelectedIndex();
            if (index > 0) {
                PlaceholderReference item = (PlaceholderReference)this.lstGroupPlaceholder.getItems().remove(index);
                this.lstGroupPlaceholder.getItems().add(index - 1, (Object)item);
                this.lstGroupPlaceholder.getSelectionModel().clearSelection();
                this.lstGroupPlaceholder.getSelectionModel().select((Object)item);
            }
        });
        buttonBox2.getChildren().add((Object)btnUp);
        Button btnDown = JavaFxFactory.createSvgButton(JavaFxIcon.CHEVRON_DOWN, e -> {
            int index = this.lstGroupPlaceholder.getSelectionModel().getSelectedIndex();
            if (index < this.lstGroupPlaceholder.getItems().size() - 1) {
                PlaceholderReference item = (PlaceholderReference)this.lstGroupPlaceholder.getItems().remove(index);
                this.lstGroupPlaceholder.getItems().add(index + 1, (Object)item);
                this.lstGroupPlaceholder.getSelectionModel().clearSelection();
                this.lstGroupPlaceholder.getSelectionModel().select((Object)item);
            }
        });
        buttonBox2.getChildren().add((Object)btnDown);
        hBox.getChildren().add((Object)buttonBox2);
        result.getChildren().add((Object)hBox);
        return result;
    }

    private VBox createExportAttributesBox() {
        VBox result = new VBox();
        result.setSpacing(10.0);
        HBox.setHgrow((Node)result, (Priority)Priority.ALWAYS);
        result.getChildren().add((Object)JavaFxFactory.createLabelHeading2("Ausgew\u00e4hlte Attribute:"));
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        VBox buttonBox1 = new VBox();
        buttonBox1.setSpacing(10.0);
        Button btnAddToGroup = JavaFxFactory.createSvgButton(JavaFxIcon.CHEVRON_RIGHT, e -> {
            ArrayList selected = new ArrayList();
            selected.addAll(this.lstPlaceholder.getSelectionModel().getSelectedItems());
            this.lstExportPlaceholder.getItems().addAll(selected);
        });
        buttonBox1.getChildren().add((Object)btnAddToGroup);
        Button btnRemoveFromGroup = JavaFxFactory.createSvgButton(JavaFxIcon.CHEVRON_LEFT, e -> {
            ArrayList selected = new ArrayList();
            selected.addAll(this.lstExportPlaceholder.getSelectionModel().getSelectedItems());
            this.lstExportPlaceholder.getItems().removeAll(selected);
        });
        buttonBox1.getChildren().add((Object)btnRemoveFromGroup);
        hBox.getChildren().add((Object)buttonBox1);
        this.lstExportPlaceholder.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.lstExportPlaceholder.setCellFactory(param -> new ListCell<PlaceholderReference>(){

            protected void updateItem(PlaceholderReference item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    String label = item.toString();
                    if (ExportCsvFxPanel.this.groupFunction.get(item.getPlaceholderKey()) != null) {
                        label = "[" + ExportCsvFxPanel.this.groupFunction.get(item.getPlaceholderKey()) + "] " + label;
                    }
                    this.setText(label);
                }
            }
        });
        HBox.setHgrow(this.lstExportPlaceholder, (Priority)Priority.ALWAYS);
        hBox.getChildren().add(this.lstExportPlaceholder);
        VBox buttonBox2 = new VBox();
        buttonBox2.setSpacing(10.0);
        Button btnUp = JavaFxFactory.createSvgButton(JavaFxIcon.CHEVRON_UP, e -> {
            int index = this.lstExportPlaceholder.getSelectionModel().getSelectedIndex();
            if (index > 0) {
                PlaceholderReference item = (PlaceholderReference)this.lstExportPlaceholder.getItems().remove(index);
                this.lstExportPlaceholder.getItems().add(index - 1, (Object)item);
                this.lstExportPlaceholder.getSelectionModel().clearSelection();
                this.lstExportPlaceholder.getSelectionModel().select((Object)item);
            }
        });
        buttonBox2.getChildren().add((Object)btnUp);
        Button btnDown = JavaFxFactory.createSvgButton(JavaFxIcon.CHEVRON_DOWN, e -> {
            int index = this.lstExportPlaceholder.getSelectionModel().getSelectedIndex();
            if (index < this.lstExportPlaceholder.getItems().size() - 1) {
                PlaceholderReference item = (PlaceholderReference)this.lstExportPlaceholder.getItems().remove(index);
                this.lstExportPlaceholder.getItems().add(index + 1, (Object)item);
                this.lstExportPlaceholder.getSelectionModel().clearSelection();
                this.lstExportPlaceholder.getSelectionModel().select((Object)item);
            }
        });
        buttonBox2.getChildren().add((Object)btnDown);
        buttonBox2.getChildren().add((Object)JavaFxFactory.createVerticalSpacer());
        buttonBox2.getChildren().add((Object)JavaFxFactory.createButton("1", e -> {
            PlaceholderReference ph = (PlaceholderReference)this.lstExportPlaceholder.getSelectionModel().getSelectedItem();
            if (ph != null) {
                this.groupFunction.remove(ph.getPlaceholderKey());
                this.lstExportPlaceholder.refresh();
            }
        }));
        buttonBox2.getChildren().add((Object)JavaFxFactory.createButton("n", e -> {
            PlaceholderReference ph = (PlaceholderReference)this.lstExportPlaceholder.getSelectionModel().getSelectedItem();
            if (ph != null) {
                this.groupFunction.put(ph.getPlaceholderKey(), "n");
                this.lstExportPlaceholder.refresh();
            }
        }));
        buttonBox2.getChildren().add((Object)JavaFxFactory.createButton("S", e -> {
            PlaceholderReference ph = (PlaceholderReference)this.lstExportPlaceholder.getSelectionModel().getSelectedItem();
            if (ph != null) {
                this.groupFunction.put(ph.getPlaceholderKey(), "S");
                this.lstExportPlaceholder.refresh();
            }
        }));
        hBox.getChildren().add((Object)buttonBox2);
        result.getChildren().add((Object)hBox);
        return result;
    }

    private VBox createAvailableAttributesBox() {
        VBox result = new VBox();
        result.setSpacing(10.0);
        HBox.setHgrow((Node)result, (Priority)Priority.ALWAYS);
        result.getChildren().add((Object)JavaFxFactory.createLabelHeading2("Verf\u00fcgbare Attribute:"));
        HBox searchBox = new HBox();
        searchBox.setSpacing(10.0);
        searchBox.getChildren().add((Object)JavaFxFactory.createLabel("Suche:"));
        TextField fldSearch = JavaFxFactory.createTextField("");
        fldSearch.textProperty().addListener((ov, od, nw) -> {
            ArrayList<PlaceholderReference> placeholders = this.filterPlaceholders((String)nw);
            this.lstPlaceholder.getItems().clear();
            this.lstPlaceholder.getItems().addAll(placeholders);
        });
        HBox.setHgrow((Node)fldSearch, (Priority)Priority.ALWAYS);
        searchBox.getChildren().add((Object)fldSearch);
        Button btnClear = JavaFxFactory.createButton("", e -> fldSearch.setText(""));
        btnClear.setGraphic((Node)new JavaFxIcon(JavaFxIcon.CANCEL, (Paint)Color.RED, 14.0));
        searchBox.getChildren().add((Object)btnClear);
        result.getChildren().add((Object)searchBox);
        this.lstPlaceholder.setMinHeight(210.0);
        this.lstPlaceholder.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        VBox.setVgrow(this.lstPlaceholder, (Priority)Priority.ALWAYS);
        result.getChildren().add(this.lstPlaceholder);
        return result;
    }

    public File export(ProgressHandler ph) {
        String key;
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ph.progress("Export wird vorbereitet ...");
        String separator = this.fldSeparator.getText();
        if (separator == null || separator.trim().length() < 1) {
            this.app.getDialog().showErrorDialog("Es ist kein CSV-Trennzeichen defineirt.");
            return null;
        }
        if (this.lstExportPlaceholder.getItems().size() < 1) {
            this.app.getDialog().showErrorDialog("Es sind keine Attribute f\u00fcr den Export ausgew\u00e4hlt.");
            return null;
        }
        String folder = this.fldFolder.getText().trim();
        if (folder.length() < 1) {
            this.app.getDialog().showErrorDialog("Es sind kein Verzeichnis definiert.");
            return null;
        }
        String filename = this.fldFilename.getText().trim();
        if (filename.length() < 1) {
            this.app.getDialog().showErrorDialog("Es sind kein Dateiname definiert.");
            return null;
        }
        ExportFormat format = (ExportFormat)((Object)this.cbFormat.getSelectionModel().getSelectedItem());
        File file = new File(folder, filename + "." + format.toString().toLowerCase());
        if (file.exists() && this.app.getDialog().showConfirmDialog("ask.overwrite-file", "", new String[]{file.getName()})) {
            Util.delete((File)file);
        }
        if (file.exists()) {
            this.app.getDialog().showErrorDialog("Datei kann nicht angelegt werden.");
            return null;
        }
        ph.progress("Daten werden vorbereitet ...");
        ThemisGenericExporter exporter = null;
        switch (format) {
            case XLSX: {
                exporter = new ThemisXlsExporter();
                break;
            }
            case CSV: {
                exporter = new ThemisCsvExporter(separator);
            }
        }
        if (exporter == null) {
            this.app.getDialog().showErrorDialog("Es kann kein Export durchgef\u00fchrt werden, es ist kein Ausgabeformat definiert.");
            return null;
        }
        if (!this.lstGroupPlaceholder.getItems().isEmpty()) {
            exporter.setGroupFunction(this.groupFunction);
        }
        for (PlaceholderReference ta : this.lstGroupPlaceholder.getItems()) {
            key = ta.getPlaceholderKey();
            exporter.addHeader(key, this.placeholder.getPlaceholderLabel(key));
        }
        for (PlaceholderReference ta : this.lstExportPlaceholder.getItems()) {
            key = ta.getPlaceholderKey();
            exporter.addHeader(key, this.placeholder.getPlaceholderLabel(key));
        }
        List<DataRecord> recs = this.getData();
        if (this.lstGroupPlaceholder.getItems().isEmpty()) {
            this.prepareDataWithoutGroups(exporter, recs);
        } else {
            this.prepareDataWithGroups(exporter, recs);
        }
        ph.progress("Daten werden exportiert ...");
        exporter.runExport(file);
        return file;
    }

    private void prepareDataWithGroups(ThemisGenericExporter exporter, List<DataRecord> recs) {
        Placeholder p = new Placeholder(new CmsReport());
        ArrayList<String> groupnames = new ArrayList<String>();
        HashMap<String, Properties> data = new HashMap<String, Properties>();
        ArrayList<UploadItem> uploads = new ArrayList<UploadItem>();
        for (DataRecord rec : recs) {
            String k;
            boolean newGroup = false;
            String groupname = "";
            for (PlaceholderReference ta : this.lstGroupPlaceholder.getItems()) {
                String k2 = ta.getPlaceholderKey();
                String v = p.getPlaceholderContent(k2, rec);
                groupname = groupname + v;
            }
            Properties groupProps = (Properties)data.get(groupname);
            if (groupProps == null) {
                newGroup = true;
                groupProps = new Properties();
                groupnames.add(groupname);
            }
            for (PlaceholderReference ta : this.lstGroupPlaceholder.getItems()) {
                k = ta.getPlaceholderKey();
                groupProps.setProperty(k, p.getPlaceholderContent(k, rec));
            }
            block11: for (PlaceholderReference ta : this.lstExportPlaceholder.getItems()) {
                k = ta.getPlaceholderKey();
                String grpfnct = this.groupFunction.getProperty(k, "1");
                switch (grpfnct.toLowerCase()) {
                    case "s": {
                        double val = Util.parseDouble((String)groupProps.getProperty(k), (double)0.0);
                        groupProps.setProperty(k, Double.toString(val += Util.parseDouble((String)p.getPlaceholderContent(k, rec), (double)0.0)));
                        continue block11;
                    }
                    case "n": {
                        int count = Util.parseInt((String)groupProps.getProperty(k), (int)0) + 1;
                        groupProps.setProperty(k, Integer.toString(count));
                        continue block11;
                    }
                }
                if (!newGroup) continue;
                groupProps.setProperty(k, p.getPlaceholderContent(k, rec));
            }
            data.put(groupname, groupProps);
        }
        for (String groupname : groupnames) {
            exporter.addData((Properties)data.get(groupname));
        }
        exporter.addUploads(uploads);
    }

    private void prepareDataWithoutGroups(ThemisGenericExporter exporter, List<DataRecord> recs) {
        Placeholder p = new Placeholder(new CmsReport());
        for (DataRecord rec : recs) {
            Properties props = new Properties();
            ArrayList<UploadItem> uploads = new ArrayList<UploadItem>();
            for (PlaceholderReference ta : this.lstExportPlaceholder.getItems()) {
                CmsElementSummary event;
                String k = ta.getPlaceholderKey();
                Long locId = rec.getLong("meta_id");
                CmsLocation loc = (CmsLocation)this.app.getProject().loadElement(locId, this.app.getProject().getUser());
                Long obsId = rec.getLong("observationid");
                CmsObservation obs = (CmsObservation)this.app.getProject().loadElement(obsId, this.app.getProject().getUser());
                CmsHistory hist = null;
                if (this.exportType == ExportType.event && (event = (CmsElementSummary)this.cbEvent.getSelectionModel().getSelectedItem()) != null) {
                    hist = obs.getHistory(event.getId());
                }
                props.setProperty(k, p.getPlaceholderContent(k, loc, obs, hist, rec));
                ArrayList<UploadItem> phUploads = p.getPlaceholderUploads(k, loc, obs, hist);
                if (phUploads.isEmpty()) continue;
                String filenames = "";
                for (UploadItem u : phUploads) {
                    if (!filenames.isEmpty()) {
                        filenames = filenames + ", ";
                    }
                    filenames = filenames + u.getFilename();
                }
                props.setProperty(k, filenames);
                uploads.addAll(phUploads);
            }
            exporter.addData(props);
            exporter.addUploads(uploads);
        }
    }

    public ExportCsvFxPanel populate() {
        return this.populate(null);
    }

    public ExportCsvFxPanel populate(ProgressHandler ph) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ph.progress("Dialog wird vorbereitet ...");
        this.lstPlaceholder.getItems().clear();
        ph.progress("Platzhalter werden geladen ...");
        this.mapping = new Properties();
        try {
            this.mapping = Placeholder.loadMapping("placeholder_mapping.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ph.progress("Platzhalter werden verarbeitet ...");
        ArrayList<PlaceholderReference> placeholders = this.filterPlaceholders("");
        this.lstPlaceholder.getItems().addAll(placeholders);
        File exportFolder = this.app.getSettings().getExportFolder().getValue(true);
        if (exportFolder != null) {
            this.fldFolder.setText(exportFolder.getAbsolutePath());
        }
        ArrayList<String> fieldsUsed = this.app.getSettings().getExportAttributesUsed();
        for (String string : fieldsUsed) {
            PlaceholderReference pr = placeholders.stream().filter(p -> p.getPlaceholderKey().equals(string)).findFirst().orElse(null);
            if (pr == null) continue;
            this.lstExportPlaceholder.getItems().add((Object)pr);
        }
        ArrayList<String> fieldsGroup = this.app.getSettings().getExportAttributesGroup();
        for (String used : fieldsGroup) {
            PlaceholderReference pr = placeholders.stream().filter(p -> p.getPlaceholderKey().equals(used)).findFirst().orElse(null);
            if (pr == null) continue;
            this.lstGroupPlaceholder.getItems().add((Object)pr);
        }
        this.fldSeparator.setText(this.app.getSettings().getCsvSeparator());
        this.groupFunction = this.app.getSettings().getExportAttributesGroupFunction();
        File file = this.app.getSettings().getFolderReportOutput().getValue(true);
        if (file != null) {
            this.fldFolder.setText(file.getAbsolutePath());
        }
        this.updateExportType(ExportType.status);
        return this;
    }

    public void apply() {
        this.apply(null);
    }

    public void apply(ProgressHandler ph) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ph.progress("Einstellungen werden gespeichert ...");
        this.app.getSettings().setCsvSeparator(this.fldSeparator.getText());
        ArrayList<String> fieldsUsed = new ArrayList<String>();
        for (Object ref : this.lstExportPlaceholder.getItems()) {
            fieldsUsed.add(((PlaceholderReference)ref).getPlaceholderKey());
        }
        ArrayList<String> fieldsGroup = new ArrayList<String>();
        for (PlaceholderReference ref : this.lstGroupPlaceholder.getItems()) {
            fieldsGroup.add(ref.getPlaceholderKey());
        }
        this.app.getSettings().setExportAttributes(fieldsGroup, fieldsUsed, this.groupFunction);
        String folder = this.fldFolder.getText();
        if (folder != null && !folder.trim().isEmpty()) {
            this.app.getSettings().getFolderReportOutput().setValue(folder.trim());
        }
    }

    private ArrayList<PlaceholderReference> filterPlaceholders(String filter) {
        ArrayList<PlaceholderReference> placeholders = new ArrayList<PlaceholderReference>();
        block18: for (String k : this.mapping.stringPropertyNames()) {
            PlaceholderReference pr;
            String v = this.mapping.getProperty(k);
            if (v == null) continue;
            switch (v.toLowerCase()) {
                case "obs.observation-risk": 
                case "obs.rowheight": 
                case "obs.repeat": 
                case "obs.image-number": 
                case "obs.image-file": 
                case "obs.image-info": 
                case "obs.image-comment": 
                case "obs.history-responsible": 
                case "obs.histories-dates": 
                case "obs.histories-count": 
                case "obs.location-counter-grouping": 
                case "obs.location-plansnippet-per-location": 
                case "rep.event-signature": {
                    continue block18;
                }
            }
            if (v.contains("dummy") || v.contains("#") || v.contains("image-numbers") || v.contains("obs.location-image-") || v.startsWith("obs.head1") || v.startsWith("obs.foot1") || v.startsWith("obs.pagebreak") || v.startsWith("rep.report") || v.startsWith("doc.") || !v.startsWith("loc.") && !v.startsWith("obs.") || !(pr = new PlaceholderReference(k, v)).toString().toLowerCase().contains(filter.toLowerCase())) continue;
            placeholders.add(pr);
        }
        placeholders.sort((o1, o2) -> o1.toString().compareTo(o2.toString()));
        return placeholders;
    }

    private void updateCount(ExportType exportType, CmsBasicElement value) {
        int count = -1;
        switch (exportType) {
            case status: {
                ThemisFilter filter = new ThemisFilter(this.app, false, false);
                if (value != null) {
                    switch ((int)value.getId()) {
                        case -1: {
                            filter.setFilter(this.app.getFilter());
                            break;
                        }
                        case -2: {
                            filter.setMangelFilter();
                            break;
                        }
                        case -3: {
                            filter.setDuedateFilter();
                            break;
                        }
                        case -9: {
                            filter.clearAll(false, (Object)this);
                            break;
                        }
                        default: {
                            String filtername = value.getTitle();
                            filter.loadFilter(this.project.getFilterByName(filtername));
                        }
                    }
                }
                count = filter.getFilteredObservations().size();
                break;
            }
            case event: {
                if (value == null) break;
                CmsEvent ev = (CmsEvent)this.project.loadElement(value.getId(), this.project.getUser());
                count = ev.getRelationAttribute("histories").size();
                break;
            }
            case selection: {
                count = this.project.getSelectionManager().getSelectedObservationIds().size();
                break;
            }
        }
        this.lblEntriesCount.setText(count >= 0 ? Integer.toString(count) : "-");
    }

    private List<DataRecord> getData() {
        String sql;
        StringBuilder sort = new StringBuilder();
        int sortcount = 0;
        for (PlaceholderReference ta : this.lstGroupPlaceholder.getItems()) {
            if (sortcount > 3) break;
            sql = this.placeholder.getPlaceholderSql(ta.getPlaceholderKey());
            if (sql == null) continue;
            if (sort.length() > 0) {
                sort.append(",");
            }
            sort.append(sql);
            ++sortcount;
        }
        for (PlaceholderReference ta : this.lstExportPlaceholder.getItems()) {
            if (sortcount > 3) break;
            sql = this.placeholder.getPlaceholderSql(ta.getPlaceholderKey());
            if (sql == null) continue;
            if (sort.length() > 0) {
                sort.append(",");
            }
            sort.append(sql);
            ++sortcount;
        }
        List<DataRecord> recs = new ArrayList<DataRecord>();
        switch (this.exportType) {
            case status: {
                recs = this.getDataFromFilter(sort.toString());
                break;
            }
            case event: {
                recs = this.getDataFromEvent(sort.toString());
                break;
            }
            case selection: {
                recs = this.getDataFromSelection(sort.toString());
                break;
            }
        }
        return recs;
    }

    private List<DataRecord> getDataFromFilter(String sort) {
        ThemisFilter filter = new ThemisFilter(this.app, false, false);
        filter.clearAll(false, null);
        CmsBasicElement value = (CmsBasicElement)this.cbFilter.getSelectionModel().getSelectedItem();
        if (value != null) {
            switch ((int)value.getId()) {
                case -1: {
                    filter.setFilter(this.app.getFilter());
                    break;
                }
                case -2: {
                    filter.setMangelFilter();
                    break;
                }
                case -3: {
                    filter.setDuedateFilter();
                    break;
                }
                case -9: {
                    filter.clearAll(false, (Object)this);
                    break;
                }
                default: {
                    String filtername = value.getTitle();
                    filter.loadFilter(this.project.getFilterByName(filtername));
                }
            }
        }
        return filter.getFilteredObservations(sort, null);
    }

    private List<DataRecord> getDataFromSelection(String sort) {
        ThemisFilter filter = new ThemisFilter(this.app, false, false);
        filter.clearAll(false, null);
        return filter.getSelectedObservations(sort);
    }

    private List<DataRecord> getDataFromEvent(String sort) {
        ArrayList<DataRecord> result = new ArrayList<DataRecord>();
        CmsElementSummary event = (CmsElementSummary)this.cbEvent.getSelectionModel().getSelectedItem();
        if (event != null) {
            ThemisFilter filter = new ThemisFilter(this.app, false, false);
            filter.clearAll(false, null);
            filter.getEventId().addItem(event.getId(), null);
            ArrayList<Long> observations = filter.getFilteredObservationIds(sort, null);
            for (Long id : observations) {
                CmsObservation observation;
                CmsHistory history;
                CmsElement element = this.project.loadElement(id, this.project.getUser());
                if (!(element instanceof CmsObservation) || (history = (observation = (CmsObservation)element).getHistory(event.getId())) == null) continue;
                observation.applyHistory(history);
                DataRecord rec = new DataRecord((CmsApplication)this.project);
                for (CmsAttribute att : observation.getAttributes()) {
                    String code = att.getCode();
                    if ("meta_id".equals(code)) {
                        code = "observationid";
                    } else if ("meta_title".equals(code)) {
                        code = "observationtitle";
                    }
                    rec.put(code, att.getValue());
                }
                result.add(rec);
            }
        }
        return result;
    }

    private static enum ExportFormat {
        XLSX,
        CSV;

    }

    private static enum ExportType {
        status,
        event,
        period,
        selection;

    }
}

