/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.jobmanager;

import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.ThemisAlert;
import at.grid.themis.ontology.server.ThemisCloudProjectInfo;
import at.grid.themis.ontology.server.ThemisJob;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class CreateJobFxPanel
extends JavaFxDialog {
    private static final boolean SHOW_USER = false;
    private final ThemisFilter jobFilter;
    private final ThemisCloudProjectInfo info;
    private ThemisJob job;
    private GridPane root;
    private ComboBox<CmsBasicElement> fldSelection;
    private ComboBox<String> fldAccessCodes;
    private TextField fldJobTitle;
    private Label lblCount;
    private TextField fldUser;
    private DatePicker fldDate;

    public CreateJobFxPanel(ThemisCloudProjectInfo info) {
        this.jobFilter = this.app.getFilter().getCopy();
        this.info = info;
        this.populate();
        this.addSaveButton("Auftrag hochladen");
        this.addCancelButton("Abbrechen");
    }

    private void populate() {
        int filterSize = this.jobFilter.getFilteredObservationIds().size();
        this.lblCount.setText(filterSize + " Beobachtungen");
        this.fldSelection.getItems().addAll((Object[])new CmsBasicElement[]{new CmsBasicElement(1L, "Filter: " + filterSize)});
        this.fldSelection.getItems().addAll((Object[])new CmsBasicElement[]{new CmsBasicElement(1L, "Auswahl: " + this.project.getSelectionManager().getSelectedObservationIds().size())});
        this.fldSelection.getSelectionModel().select(0);
        this.fldAccessCodes.getItems().add((Object)"*");
        for (ThemisCloudProjectInfo.ServerAccess access : this.info.getAccessCodes()) {
            this.fldAccessCodes.getItems().add((Object)access.getCode());
        }
        this.fldAccessCodes.getSelectionModel().select(0);
    }

    public ThemisJob getJob() {
        return this.job;
    }

    @Override
    public boolean save() {
        String jobTitle = this.fldJobTitle.getText();
        if (jobTitle == null || jobTitle.trim().isEmpty()) {
            ThemisAlert.error(this.project.getResourceText("error.job-template-no-title"));
            return false;
        }
        this.job = new ThemisJob();
        if (this.fldSelection.getSelectionModel().getSelectedIndex() == 1) {
            this.job.setContent(ThemisJob.Content.Selection);
        }
        this.job.setTitle(jobTitle.trim());
        if (this.fldAccessCodes.getSelectionModel().getSelectedIndex() == 0) {
            this.job.setAccessCode("*");
        } else {
            this.job.setAccessCode((String)this.fldAccessCodes.getSelectionModel().getSelectedItem());
        }
        LocalDate d = (LocalDate)this.fldDate.getValue();
        if (d != null) {
            this.job.setDuedate(Date.from(d.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        }
        this.job.setStatus(ThemisJob.Status.open);
        this.job.addHistoryUpload(this.project.getUser().getUsername(), ThemisJob.Status.open.toString());
        return true;
    }

    protected ScrollPane getMainPanel() {
        int row = 0;
        int cols = 4;
        this.root = JavaFxFactory.createGridPane();
        this.root.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
        this.root.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
        this.root.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
        this.root.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
        this.fldJobTitle = JavaFxFactory.createTextField("");
        this.fldDate = JavaFxFactory.createDatePicker(null);
        this.fldDate.setMaxWidth(Double.MAX_VALUE);
        this.fldAccessCodes = JavaFxFactory.createComboBox(new ArrayList(), null, false);
        this.lblCount = JavaFxFactory.createLabel("");
        this.fldSelection = JavaFxFactory.createComboBox(new ArrayList(), null, false);
        this.root.add((Node)JavaFxFactory.createLabelHeading("Auftragsdetails"), 0, row++, cols, 1);
        this.root.add((Node)JavaFxFactory.createLabel("Umfang"), 0, row, 1, 1);
        if (!this.project.getSelectionManager().getSelectedObservationIds().isEmpty()) {
            this.root.add(this.fldSelection, 1, row++, cols - 1, 1);
        } else {
            this.root.add((Node)this.lblCount, 1, row++, cols - 1, 1);
        }
        this.root.add((Node)JavaFxFactory.createLabel("Auftragstitel"), 0, row, 1, 1);
        this.root.add((Node)this.fldJobTitle, 1, row++, cols - 1, 1);
        this.root.add((Node)JavaFxFactory.createLabel("Freigabe"), 0, row, 1, 1);
        this.root.add(this.fldAccessCodes, 1, row++, cols - 1, 1);
        this.root.add((Node)JavaFxFactory.createLabel("Zu erledigen bis"), 0, row, 1, 1);
        this.root.add((Node)this.fldDate, 1, row++, cols - 1, 1);
        ScrollPane scroll = new ScrollPane((Node)this.root);
        scroll.setFitToWidth(true);
        return scroll;
    }
}

