/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.jobmanager;

import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.ThemisAlert;
import at.grid.themis.ontology.server.ThemisCloudProjectInfo;
import at.grid.themis.ontology.server.ThemisJob;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class EditJobFxPanel
extends JavaFxDialog {
    private static final boolean SHOW_USER = false;
    private final ThemisJob job;
    private final ThemisCloudProjectInfo info;
    private ComboBox<String> fldAccessCodes;
    private TextField fldJobTitle;
    private TextField fldUsername;
    private DatePicker fldDate;

    public EditJobFxPanel(ThemisJob job, ThemisCloudProjectInfo info) {
        this.job = job;
        this.info = info;
        this.initialise((Node)this.getMainPanel());
        this.addCancelButton("Abbrechen");
        this.addSaveButton("Speichern");
    }

    public ThemisJob getJob() {
        return this.job;
    }

    @Override
    public boolean save() {
        String jobTitle = this.fldJobTitle.getText();
        if (jobTitle == null || jobTitle.trim().isEmpty()) {
            ThemisAlert.error(this.project.getResourceText("error.job-template-no-title"));
            return false;
        }
        this.job.setTitle(jobTitle.trim());
        if (this.fldAccessCodes.getSelectionModel().getSelectedIndex() == 0) {
            this.job.setAccessCode("*");
        } else {
            this.job.setAccessCode((String)this.fldAccessCodes.getSelectionModel().getSelectedItem());
        }
        LocalDate d = (LocalDate)this.fldDate.getValue();
        if (d != null) {
            this.job.setDuedate(Date.from(d.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        } else {
            this.job.setDuedate(null);
        }
        this.job.addHistoryUpload(this.project.getUser().getUsername(), ThemisJob.Status.open.toString() + " (modified)");
        this.project.getLogger().info("... returning from edit panel");
        return true;
    }

    protected ScrollPane getMainPanel() {
        this.fldJobTitle = JavaFxFactory.createTextField(this.job.getTitle());
        this.fldDate = JavaFxFactory.createDatePicker(this.job.getDuedate());
        this.fldDate.setMaxWidth(Double.MAX_VALUE);
        ArrayList<String> accesscodes = new ArrayList<String>();
        accesscodes.add("*");
        for (ThemisCloudProjectInfo.ServerAccess access : this.info.getAccessCodes()) {
            accesscodes.add(access.getCode());
        }
        String code = this.job.getAccessCode();
        if (code == null || code.trim().isEmpty()) {
            code = (String)accesscodes.get(0);
        }
        this.fldAccessCodes = JavaFxFactory.createComboBox(accesscodes, code, false);
        GridPane root = JavaFxFactory.createGridPane();
        int row = 0;
        int cols = 4;
        root.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
        root.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
        root.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
        root.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
        root.add((Node)JavaFxFactory.createLabelHeading("Auftrag bearbeiten"), 0, row++, cols, 1);
        root.add((Node)JavaFxFactory.createLabel("Auftragstitel"), 0, row, 1, 1);
        root.add((Node)this.fldJobTitle, 1, row++, cols - 1, 1);
        root.add((Node)JavaFxFactory.createLabel("Freigabe"), 0, row, 1, 1);
        root.add(this.fldAccessCodes, 1, row++, cols - 1, 1);
        root.add((Node)JavaFxFactory.createLabel("Datum"), 0, row, 1, 1);
        root.add((Node)this.fldDate, 1, row++, cols - 1, 1);
        ScrollPane scroll = new ScrollPane((Node)root);
        scroll.setFitToWidth(true);
        return scroll;
    }
}

