/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.libraries;

import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.libraries.LibraryInfo;
import at.grid.themis.ontology.javafx.libraries.LibraryLicenseInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.util.Exceptions;

public class LibrariesFxPane
extends HBox {
    public LibrariesFxPane() {
        this.populate();
    }

    private void populate() {
        this.setPadding(new Insets(16.0));
        this.setSpacing(16.0);
        VBox librariesList = this.createLibrariesList();
        librariesList.setMinWidth(200.0);
        HBox.setHgrow((Node)librariesList, (Priority)Priority.NEVER);
        this.getChildren().add(0, (Object)librariesList);
    }

    private VBox createLibrariesList() {
        VBox result = new VBox();
        result.setSpacing(16.0);
        Label headingLabel = JavaFxFactory.createLabelHeading("Bibliotheken");
        result.getChildren().add((Object)headingLabel);
        ListView librariesList = new ListView();
        librariesList.setPrefWidth(200.0);
        VBox.setVgrow((Node)librariesList, (Priority)Priority.ALWAYS);
        librariesList.setCellFactory(i -> new ListCell<LibraryInfo>(){

            protected void updateItem(LibraryInfo info, boolean empty) {
                super.updateItem((Object)info, empty);
                if (empty) {
                    this.setText("");
                } else {
                    this.setText(info.getName());
                }
            }
        });
        librariesList.getSelectionModel().selectedItemProperty().addListener((ov, oldValue, newValue) -> {
            if (this.getChildren().size() > 1) {
                this.getChildren().remove(1);
            }
            if (newValue != null) {
                VBox detailBox = this.createDetailBox((LibraryInfo)newValue);
                this.getChildren().add((Object)detailBox);
            }
        });
        result.getChildren().add((Object)librariesList);
        List<LibraryInfo> infos = this.readFromFile();
        librariesList.getItems().addAll(infos);
        if (!librariesList.getItems().isEmpty()) {
            librariesList.getSelectionModel().selectFirst();
        }
        return result;
    }

    private List<LibraryInfo> readFromFile() {
        ArrayList<LibraryInfo> result = new ArrayList<LibraryInfo>();
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(LibrariesFxPane.class.getResourceAsStream("media/libraries.xml"));
            Element root = doc.getRootElement();
            List librarieElements = root.getChildren();
            for (Element license : librarieElements) {
                String name = license.getChildText("name");
                String website = license.getChildText("website");
                String note = license.getChildText("note");
                ArrayList<String> jars = new ArrayList<String>();
                List jarsElements = license.getChild("jars").getChildren();
                for (Element jar : jarsElements) {
                    String jarName = jar.getValue();
                    jars.add(jarName);
                }
                jars.sort((a, b) -> a.compareTo((String)b));
                ArrayList<LibraryLicenseInfo> licenses = new ArrayList<LibraryLicenseInfo>();
                List licensesElements = license.getChild("licenses").getChildren();
                for (Element licenseElement : licensesElements) {
                    String licenseName = licenseElement.getChildText("name");
                    String licenseUrl = licenseElement.getChildText("url");
                    String licenseText = licenseElement.getChildText("text");
                    licenses.add(new LibraryLicenseInfo(licenseName, licenseUrl, licenseText));
                }
                licenses.sort((a, b) -> a.getName().compareTo(b.getName()));
                result.add(new LibraryInfo(name, website, note, jars, licenses));
            }
            result.sort((a, b) -> a.getName().compareTo(b.getName()));
        }
        catch (IOException | JDOMException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    private VBox createDetailBox(LibraryInfo info) {
        VBox result = new VBox();
        result.setSpacing(16.0);
        Label headingLabel = JavaFxFactory.createLabelHeading("Bibliothek - \u00dcbersicht");
        result.getChildren().add((Object)headingLabel);
        GridPane infoGrid = new GridPane();
        infoGrid.setHgap(10.0);
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setFillWidth(false);
        cc1.setHgrow(Priority.NEVER);
        cc1.setMinWidth(-1.0);
        cc1.setPrefWidth(-1.0);
        cc1.setMaxWidth(-1.0);
        cc1.setPercentWidth(-1.0);
        infoGrid.getColumnConstraints().add((Object)cc1);
        ColumnConstraints cc2 = new ColumnConstraints();
        cc2.setFillWidth(true);
        cc2.setHgrow(Priority.ALWAYS);
        cc2.setMinWidth(-1.0);
        cc2.setPrefWidth(-1.0);
        cc2.setMaxWidth(Double.MAX_VALUE);
        cc2.setPercentWidth(-1.0);
        infoGrid.getColumnConstraints().add((Object)cc2);
        Label nameLabel = JavaFxFactory.createLabel("Name");
        TextField nameField = JavaFxFactory.createTextField(info.getName());
        nameField.setEditable(false);
        infoGrid.addRow(0, new Node[]{nameLabel, nameField});
        Label websiteLabel = JavaFxFactory.createLabel("Website");
        TextField websiteField = JavaFxFactory.createTextField(info.getWebsite());
        websiteField.setEditable(false);
        infoGrid.addRow(1, new Node[]{websiteLabel, websiteField});
        result.getChildren().add((Object)infoGrid);
        Label licensesLabel = JavaFxFactory.createLabel("Lizenzen");
        result.getChildren().add((Object)licensesLabel);
        HBox licensesBox = new HBox();
        licensesBox.setSpacing(16.0);
        VBox.setVgrow((Node)licensesBox, (Priority)Priority.ALWAYS);
        ListView licensesList = new ListView();
        licensesList.getItems().addAll(info.getLicenses());
        licensesList.setPrefHeight(200.0);
        licensesList.setMaxHeight(Double.MAX_VALUE);
        licensesList.setFocusTraversable(false);
        HBox.setHgrow((Node)licensesList, (Priority)Priority.NEVER);
        licensesList.setCellFactory(i -> new ListCell<LibraryLicenseInfo>(){

            protected void updateItem(LibraryLicenseInfo info, boolean empty) {
                super.updateItem((Object)info, empty);
                if (empty) {
                    this.setText("");
                } else {
                    this.setText(info.getName());
                }
            }
        });
        licensesBox.getChildren().add((Object)licensesList);
        VBox licenseInfoBox = new VBox();
        licenseInfoBox.setSpacing(16.0);
        HBox.setHgrow((Node)licenseInfoBox, (Priority)Priority.ALWAYS);
        TextField licenseUrl = JavaFxFactory.createTextField("");
        licenseUrl.setEditable(false);
        VBox.setVgrow((Node)licenseUrl, (Priority)Priority.NEVER);
        licenseInfoBox.getChildren().add((Object)licenseUrl);
        TextArea licenseArea = JavaFxFactory.createTextArea("");
        licenseArea.setWrapText(true);
        licenseArea.setEditable(false);
        licenseArea.setPrefHeight(200.0);
        licensesList.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow((Node)licenseArea, (Priority)Priority.ALWAYS);
        licenseInfoBox.getChildren().add((Object)licenseArea);
        licensesBox.getChildren().add((Object)licenseInfoBox);
        result.getChildren().add((Object)licensesBox);
        licensesList.getSelectionModel().selectedItemProperty().addListener((ov, oldValue, newValue) -> {
            licenseUrl.setText("");
            licenseArea.setText("");
            if (newValue != null) {
                licenseUrl.setText(newValue.getUrl());
                licenseArea.setText(newValue.getText());
            }
        });
        if (!licensesList.getItems().isEmpty()) {
            licensesList.getSelectionModel().selectFirst();
        }
        return result;
    }
}

