/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.project;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.JavaFxIcon;
import at.grid.themis.ontology.javafx.project.ProjectInfoFxPanel;
import at.grid.themis.ontology.javafx.wizard.JavaFxPage;
import at.grid.themis.ontology.javafx.wizard.JavaFxWizard;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.server.ThemisCloudProjectInfo;
import at.grid.themis.ontology.server.ThemisCloudServer;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.themis.ontology.template.TemplateDescription;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Date;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.TextField;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import org.jdom.JDOMException;

public abstract class CreateProjectWizard
extends JavaFxWizard {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private final PageTitleAndFile page1;
    private final PageProjectTemplate page2;
    private final PagePlan page3;
    private final PageEvent page4;
    private final PageServerCode page5;
    private final PageSummary page6;
    private final ProjectInfoFxPanel page7;
    int maxPlanCount = -1;
    long firstPlanId = -1L;

    public CreateProjectWizard(File projectFolder) {
        this.page1 = new PageTitleAndFile(projectFolder != null ? projectFolder.getAbsolutePath() : "");
        this.page2 = new PageProjectTemplate();
        this.page3 = new PagePlan();
        this.page4 = new PageEvent();
        this.page5 = new PageServerCode();
        this.page6 = new PageSummary();
        this.page7 = new ProjectInfoFxPanel();
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.FULL)) {
            this.addPage(new JavaFxPage("Projektvorlage", (Node)this.page2, true));
        }
        this.addPage(new JavaFxPage("Projektdatei", (Node)this.page1, true));
        this.addPage(new JavaFxPage("Projektinformation", (Node)this.page7, true));
        this.addPage(new JavaFxPage("Pl\u00e4ne", (Node)this.page3, true));
        this.addPage(new JavaFxPage("Ereignis", (Node)this.page4, true));
        if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.FULL)) {
            this.addPage(new JavaFxPage("THEMIS Server", (Node)this.page5, true));
        }
        this.addPage(new JavaFxPage("Zusammenfassung", (Node)this.page6, true));
        switch (this.app.getLicense().getLicenseDetails().getLicenseLevel()) {
            case NONE: {
                return;
            }
            case APP: {
                this.maxPlanCount = 15;
            }
        }
        this.selectPage(0);
    }

    @Override
    protected boolean onPageChange(JavaFxPage oldPage, JavaFxPage newPage) {
        if (oldPage.getPage() == this.page1) {
            this.page6.setProjectFolder(this.page1.getProjectFolder());
            this.page6.setProjectFileName(this.page1.getProjectFileName());
            return this.page1.validate();
        }
        if (oldPage.getPage() == this.page7) {
            this.page6.setProjectTitle(this.page7.getProjectTitle());
            return true;
        }
        if (oldPage.getPage() == this.page2) {
            TemplateDescription template = this.page2.getProjectStandardTemplate();
            if (template != null) {
                this.page6.setProjectTemplate(template.title);
            } else {
                File t = this.page2.getProjectCustomTemplate();
                if (t != null) {
                    this.page6.setProjectTemplate(t.getAbsolutePath());
                }
            }
            return this.page2.validate();
        }
        if (oldPage.getPage() == this.page3) {
            this.page6.setPlans(this.page3.getPlans());
            this.page6.setPapersize(this.page3.getPaperSize());
            return this.page3.validate();
        }
        if (oldPage.getPage() == this.page4) {
            this.page6.setEventTitle(this.page4.getEventTitle());
            this.page6.setEventDate(this.page4.getEventDate());
            return this.page4.validate();
        }
        if (oldPage.getPage() == this.page5) {
            this.page6.setServerCode(this.page5.getServerCode());
            return this.page5.validate();
        }
        if (oldPage.getPage() == this.page6) {
            return this.page6.validate();
        }
        return false;
    }

    @Override
    protected void onPageChanged(JavaFxPage page) {
        if (page.getPage() == this.page1) {
            this.page1.fldProjectFileName.requestFocus();
        } else if (page.getPage() == this.page2) {
            this.page2.fldProjectTemplate.requestFocus();
        } else if (page.getPage() == this.page4) {
            this.page4.fldEventTitle.requestFocus();
        } else if (page.getPage() == this.page5) {
            this.page5.fldServerCode.requestFocus();
        }
    }

    public ThemisFolder getProjectFolder() {
        File projectFolder = this.page1.getProjectFolder();
        if (projectFolder == null) {
            this.app.getDialog().showErrorDialog("error.noProjectRootFolderDefined");
            this.selectPage(1);
            return null;
        }
        String projectFileName = this.page1.getProjectFileName();
        if (projectFileName == null || projectFileName.trim().isEmpty()) {
            this.app.getDialog().showErrorDialog("error.noProjectFilenameDefined");
            this.selectPage(1);
            return null;
        }
        File folder = new File(projectFolder, projectFileName);
        if (folder.exists()) {
            this.app.getDialog().showErrorDialog("error.project-already-exists");
            return null;
        }
        return new ThemisFolder(folder);
    }

    public long getFirstPlanId() {
        return this.firstPlanId;
    }

    public String applyConfiguration(ProgressHandler ph) {
        String result = null;
        try {
            ThemisCloudProjectInfo i;
            ThemisCloudServer s;
            File projectLogoFile;
            ArrayList<Long> planIds;
            File templateFile;
            if (!this.app.getProject().isOpen()) {
                result = "error.updateproject.no-project-open";
                return result;
            }
            ph.switchToDeterminate(5);
            File tempFile = this.project.getTempfileLocation();
            ph.increaseProgress(1);
            TemplateDescription standardTemplate = this.page2.getProjectStandardTemplate();
            if (standardTemplate != null) {
                ph.progress(this.project.getResourceText("task.create-project.prepare-template"));
                boolean success = standardTemplate.saveToFile(tempFile);
                if (success) {
                    String fn = standardTemplate.file;
                    if (fn.toLowerCase().endsWith(".zip")) {
                        fn = Util.getFileNameWithoutExtension((File)new File(tempFile, standardTemplate.file)) + ".xlsx";
                    }
                    templateFile = new File(tempFile, fn);
                } else {
                    templateFile = null;
                }
            } else {
                templateFile = this.page2.getProjectCustomTemplate();
            }
            if (ThemisLicense.isLicenseLevelExact(ThemisLicense.LicenseLevel.APP)) {
                String productEdition;
                templateFile = new File(tempFile, Long.toString(new java.util.Date().getTime()) + ".themis");
                ph.progress(this.project.getResourceText("task.create-project.load-template"));
                switch (productEdition = ThemisApplication.getInstance().getLicense().getProductEdition()) {
                    case "Brandschutzbuch": {
                        URL url = CreateProjectWizard.class.getResource("/at/grid/themis/ontology/media/vorlagen/projektvorlage_brandschutzbuch.themis");
                        Util.copy((InputStream)url.openStream(), (OutputStream)new FileOutputStream(templateFile));
                    }
                }
            }
            if (templateFile != null) {
                ph.progress(this.project.getResourceText("task.create-project.load-template"));
                if (templateFile.getName().toLowerCase().endsWith(".themis")) {
                    ThemisFile tf = new ThemisFile(ph).setAsProjectTemplate();
                    tf.loadFromFile(templateFile, true);
                } else {
                    this.app.getSettings().setTemplateUseTexts(true);
                    this.app.getSettings().setTemplateUseLists(true);
                    this.app.getSettings().setTemplateUseIcons(true);
                    this.app.getSettings().setTemplateUseSettings(true);
                    this.app.getSettings().setTemplateUseContacts(true);
                    this.app.getSettings().setTemplateUseDocuments(true);
                    this.project.getTemplateManger().loadTemplate(templateFile);
                }
                this.app.getActionProvider().invokeAction(ThemisAction.TEMPLATES_CHANGED);
            }
            ph.increaseProgress(1);
            String buildingTitle = this.page3.getBuilding();
            CmsLocation building = null;
            long idBuilding = -1L;
            if (!"".equals(buildingTitle)) {
                building = (CmsLocation)this.project.createElement("location");
                building.setAttributeValue("title", buildingTitle);
                building.setAsBuilding();
                building.save();
                idBuilding = building.getId();
            }
            ArrayList<File> files = new ArrayList<File>();
            files.addAll(this.page3.getPlans());
            if (!files.isEmpty()) {
                ph.progress(this.project.getResourceText("task.create-project.load-plans"));
            }
            if (!(planIds = this.project.getPlanManager().createNewPlanElements(files, idBuilding, CmsPlan.Papersize.A3, 0, ph)).isEmpty()) {
                this.firstPlanId = planIds.get(0);
                this.app.getActionProvider().invokeAction(ThemisAction.PLAN_SAVED);
            }
            ph.increaseProgress(1);
            LocalDate eventDate = this.page4.getEventDate();
            if (eventDate != null) {
                ph.progress(this.project.getResourceText("task.create-project.create-event"));
                CmsEvent ev = (CmsEvent)this.project.createElement("event");
                Date dt = Date.valueOf(eventDate);
                ev.getDateAttribute("date").setDate((java.util.Date)dt);
                String eventtitle = this.page4.getEventTitle();
                if ("".equals(eventtitle)) {
                    eventtitle = "Ereignis";
                }
                ev.setAttributeValue("title", eventtitle);
                ev.save();
                this.project.getSelectionManager().setCurrentEvent(ev, true, (Object)this);
                this.app.getActionProvider().invokeAction(ThemisAction.EVENT_SET_AS_CURRENT);
            }
            ph.increaseProgress(1);
            String serverCode = this.page5.getServerCode();
            if (!"".equals(serverCode)) {
                ph.progress(this.project.getResourceText("task.create-project.create-server"));
                ThemisApplication.getInstance().getSettings().setThemisServerCode(serverCode);
            }
            ph.increaseProgress(1);
            ph.progress(this.project.getResourceText("task.create-project.saving"));
            this.page7.apply();
            String projectLogo = ThemisApplication.getInstance().getConfiguration("system.project.logo", null);
            if (projectLogo != null && !projectLogo.isEmpty() && (projectLogoFile = new File(projectLogo)).exists()) {
                this.project.getProjectElement().getUploadAttribute("projectlogo").addUpload(projectLogoFile);
            }
            if ((s = this.project.getThemisServer()) != null && (i = s.uploadProjectInfo(this.project, true)).isProjectTitleDiffers()) {
                this.project.setThemisServer(null);
                Alert a = new Alert(Alert.AlertType.NONE, this.project.getResourceText("error.server.uuid-already-on-server", i.getTitle()), new ButtonType[]{ButtonType.OK});
                a.initOwner(this.getWindow());
                a.showAndWait();
            }
            return result;
        }
        catch (IOException | IllegalArgumentException | JDOMException e) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("Fehler beim anlegen des Projekts: " + e.getLocalizedMessage());
            return "error.updateproject";
        }
    }

    private class PageSummary
    extends GridPane {
        File projectFolder;
        String projectFileName;
        String projectTitle;
        String projectTemplate;
        List<File> plans;
        CmsPlan.Papersize papersize;
        String eventTitle;
        LocalDate eventDate;
        String serverCode;

        public PageSummary() {
            this.render();
        }

        private void render() {
            Label value;
            Label label;
            this.setVgap(0.0);
            this.setHgap(8.0);
            this.getColumnConstraints().clear();
            this.getChildren().clear();
            int row = 0;
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
            Label lblHeading = JavaFxFactory.createLabelHeading("Zusammenfassung");
            lblHeading.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblHeading.setWrapText(true);
            this.add((Node)lblHeading, 0, row++, 2, 1);
            Label lblInfo = JavaFxFactory.createLabelHeading("Es sind alle Einstellungen gesetzt. Klicken Sie unten auf 'Fertig', um das Projekt zu erzeugen. Dieser Vorgang kann ein paar Sekunden dauern.");
            lblInfo.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblInfo.setWrapText(true);
            lblInfo.setStyle("-fx-text-fill: grey");
            this.add((Node)lblInfo, 0, row++, 2, 1);
            if (this.projectFolder != null) {
                label = JavaFxFactory.createLabelHeading("Ordner:");
                label.setStyle("-fx-font-weight: bold");
                value = JavaFxFactory.createLabel(this.projectFolder.getPath());
                this.addRow(row++, new Node[]{label, value});
            }
            if (this.projectFileName != null && this.projectFileName.trim().length() > 0) {
                label = JavaFxFactory.createLabelHeading("Dateiname:");
                label.setStyle("-fx-font-weight: bold");
                value = JavaFxFactory.createLabel(this.projectFileName);
                this.addRow(row++, new Node[]{label, value});
            }
            if (this.projectTitle != null && this.projectTitle.trim().length() > 0) {
                label = JavaFxFactory.createLabelHeading("Projekttitel:");
                label.setStyle("-fx-font-weight: bold");
                value = JavaFxFactory.createLabel(this.projectTitle);
                this.addRow(row++, new Node[]{label, value});
            }
            if (this.projectTemplate != null && this.projectTemplate.trim().length() > 0) {
                label = JavaFxFactory.createLabelHeading("Vorlage:");
                label.setStyle("-fx-font-weight: bold");
                value = JavaFxFactory.createLabel(this.projectTemplate);
                this.addRow(row++, new Node[]{label, value});
            }
            if (this.plans != null && !this.plans.isEmpty()) {
                label = JavaFxFactory.createLabelHeading("Pl\u00e4ne:");
                label.setStyle("-fx-font-weight: bold");
                value = JavaFxFactory.createLabel(String.valueOf(this.plans.size()));
                this.addRow(row++, new Node[]{label, value});
            }
            if (this.eventTitle != null && !this.eventTitle.trim().isEmpty() || this.eventDate != null) {
                Label lable = JavaFxFactory.createLabelHeading("Ereignis:");
                lable.setStyle("-fx-font-weight: bold");
                String event = "";
                if (this.eventTitle != null && !this.eventTitle.trim().isEmpty()) {
                    event = event + this.eventTitle.trim() + " ";
                }
                if (this.eventDate != null) {
                    event = event + "(" + this.eventDate.format(DateTimeFormatter.ofPattern("dd.MM.yyy")) + ")";
                }
                Label value2 = JavaFxFactory.createLabel(event);
                this.addRow(row++, new Node[]{lable, value2});
            }
            if (this.serverCode != null && !this.serverCode.trim().isEmpty()) {
                label = JavaFxFactory.createLabelHeading("THEMIS Server Code:");
                label.setStyle("-fx-font-weight: bold");
                value = JavaFxFactory.createLabel(this.serverCode);
                this.addRow(row++, new Node[]{label, value});
            }
        }

        public void setProjectFolder(File folder) {
            this.projectFolder = folder;
            this.render();
        }

        public void setProjectFileName(String name) {
            this.projectFileName = name;
            this.render();
        }

        public void setProjectTitle(String title) {
            this.projectTitle = title;
            this.render();
        }

        public void setProjectTemplate(String template) {
            this.projectTemplate = template;
            this.render();
        }

        public void setPlans(List<File> plans) {
            this.plans = plans;
            this.render();
        }

        public void setPapersize(CmsPlan.Papersize papersize) {
            this.papersize = papersize;
            this.render();
        }

        public void setEventTitle(String title) {
            this.eventTitle = title;
            this.render();
        }

        public void setEventDate(LocalDate date) {
            this.eventDate = date;
            this.render();
        }

        public void setServerCode(String code) {
            this.serverCode = code;
            this.render();
        }

        public boolean validate() {
            return true;
        }
    }

    private class PageServerCode
    extends GridPane {
        private final TextField fldServerCode;

        public PageServerCode() {
            int row = 0;
            this.setVgap(0.0);
            this.setHgap(8.0);
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
            Label lblHeading = JavaFxFactory.createLabelHeading("THEMIS Server");
            lblHeading.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblHeading.setWrapText(true);
            this.add((Node)lblHeading, 0, row++, 3, 1);
            Label lblInfo = JavaFxFactory.createLabelHeading("Wenn Daten \u00fcber den THEMIS Server ausgetauscht werden sollen, kann hier der Server-Code hinterlegt werden.");
            lblInfo.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblInfo.setWrapText(true);
            lblInfo.setStyle("-fx-text-fill: grey");
            this.add((Node)lblInfo, 0, row++, 3, 1);
            Label lblCode = JavaFxFactory.createLabelHeading("Code:");
            lblCode.setStyle("-fx-font-weight: bold");
            this.fldServerCode = JavaFxFactory.createTextField("");
            Button clearButton = JavaFxFactory.createButton("", e -> this.fldServerCode.clear());
            clearButton.setGraphic((Node)new JavaFxIcon(JavaFxIcon.CANCEL, "#F44336", 16.0));
            this.addRow(row++, new Node[]{lblCode, this.fldServerCode, clearButton});
            String servercode = CreateProjectWizard.this.app.getSettings().getDefaultThemisServerCode();
            Region spacer = new Region();
            spacer.setMinHeight(20.0);
            this.addRow(row++, new Node[]{spacer});
            Label lblServerCode = JavaFxFactory.createLabelHeading("In den Systemeinstellungen ist ein allgemeiner Server-Code hinterlegt. Per Klick auf 'Standard \u00fcbernehmen' k\u00f6nnen Sie diesen Server-Code direkt verwenden.");
            lblServerCode.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblServerCode.setWrapText(true);
            lblServerCode.setStyle("-fx-text-fill: grey");
            this.add((Node)lblServerCode, 0, row++, 3, 1);
            Button applyServerButton = JavaFxFactory.createButton("Standard \u00fcbernehmen", e -> this.fldServerCode.setText(servercode));
            applyServerButton.setDisable(servercode.isEmpty());
            GridPane.setColumnSpan((Node)applyServerButton, (Integer)Integer.MAX_VALUE);
            this.addRow(row++, new Node[]{applyServerButton});
        }

        public boolean validate() {
            return true;
        }

        public void setServerCode(String c) {
            this.fldServerCode.setText(c);
        }

        public String getServerCode() {
            return this.fldServerCode.getText();
        }
    }

    private class PageEvent
    extends GridPane {
        private final TextField fldEventTitle;
        private final DatePicker pickerEventDate;

        public PageEvent() {
            int row = 0;
            this.setVgap(0.0);
            this.setHgap(8.0);
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
            Label lblHeading = JavaFxFactory.createLabelHeading("Ereignis");
            lblHeading.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblHeading.setWrapText(true);
            this.add((Node)lblHeading, 0, row++, 2, 1);
            Label lblEventInfo = JavaFxFactory.createLabelHeading("Bevor Sie mit der Arbeit beginnen, m\u00fcssen Sie ein Ereignis anlegen. Sie k\u00f6nnen Datum und Titel frei w\u00e4hlen.");
            lblEventInfo.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblEventInfo.setWrapText(true);
            lblEventInfo.setStyle("-fx-text-fill: grey");
            this.add((Node)lblEventInfo, 0, row++, 2, 1);
            this.fldEventTitle = JavaFxFactory.createTextField("");
            this.pickerEventDate = JavaFxFactory.createDatePicker(null);
            Label lblTemplate = JavaFxFactory.createLabelHeading("Vorlage:");
            lblTemplate.setStyle("-fx-font-weight: bold");
            HBox buttonBox = new HBox();
            buttonBox.setMaxWidth(Double.MAX_VALUE);
            Button prepare = JavaFxFactory.createButton("Vorbereitung", e -> {
                this.fldEventTitle.setText("Vorbereitung");
                this.pickerEventDate.setValue((Object)new java.util.Date().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            });
            prepare.setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)prepare, (Priority)Priority.ALWAYS);
            Button event = JavaFxFactory.createButton("Begehung", e -> {
                this.fldEventTitle.setText("Begehung");
                this.pickerEventDate.setValue((Object)new java.util.Date().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            });
            event.setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)event, (Priority)Priority.ALWAYS);
            Button clear = JavaFxFactory.createButton("Kein Ereignis", e -> {
                this.fldEventTitle.setText("");
                this.pickerEventDate.setValue(null);
            });
            clear.setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)clear, (Priority)Priority.ALWAYS);
            buttonBox.getChildren().add((Object)prepare);
            buttonBox.getChildren().add((Object)event);
            buttonBox.getChildren().add((Object)clear);
            this.addRow(row++, new Node[]{lblTemplate, buttonBox});
            Label lblTitle = JavaFxFactory.createLabelHeading("Titel:");
            lblTitle.setStyle("-fx-font-weight: bold");
            this.addRow(row++, new Node[]{lblTitle, this.fldEventTitle});
            Label lblDate = JavaFxFactory.createLabelHeading("Datum:");
            lblDate.setStyle("-fx-font-weight: bold");
            this.addRow(row++, new Node[]{lblDate, this.pickerEventDate});
        }

        public boolean validate() {
            return true;
        }

        public String getEventTitle() {
            return this.fldEventTitle.getText();
        }

        public LocalDate getEventDate() {
            return (LocalDate)this.pickerEventDate.getValue();
        }
    }

    private class PagePlan
    extends GridPane {
        private final ThemisApplication app = ThemisApplication.getInstance();
        private final ComboBox<CmsPlan.Papersize> comboPlanPaperSizes;
        private final ListView<File> lstPlanFiles;
        private final TextField fldPlanBuilding;

        public PagePlan() {
            int row = 0;
            this.setVgap(0.0);
            this.setHgap(8.0);
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
            Label lblHeading = JavaFxFactory.createLabelHeading("Pl\u00e4ne");
            lblHeading.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblHeading.setWrapText(true);
            this.add((Node)lblHeading, 0, row++, 3, 1);
            Label lblPlanInfo = JavaFxFactory.createLabelHeading("Hier k\u00f6nnen Sie Pl\u00e4ne in das Projekt laden. Ziehen Sie dazu einfach die Plandateien in das Listenfeld oder w\u00e4hlen sie mit 'Hinzuf\u00fcgen' neue Dateien aus. Die Pl\u00e4ne k\u00f6nnen sp\u00e4ter noch bearbeitet werden.");
            lblPlanInfo.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblPlanInfo.setWrapText(true);
            lblPlanInfo.setStyle("-fx-text-fill: grey");
            this.add((Node)lblPlanInfo, 0, row++, 3, 1);
            Label lblBuilding = JavaFxFactory.createLabelHeading("Geb\u00e4ude:");
            lblBuilding.setStyle("-fx-font-weight: bold");
            this.fldPlanBuilding = JavaFxFactory.createTextField("");
            this.lstPlanFiles = JavaFxFactory.createListView(null, null);
            this.lstPlanFiles.setOnDragOver(ev -> {
                Dragboard db = ev.getDragboard();
                if (db.hasFiles()) {
                    ev.acceptTransferModes(TransferMode.ANY);
                }
            });
            this.lstPlanFiles.setOnDragDropped(ev -> {
                Dragboard db = ev.getDragboard();
                if (db.hasFiles()) {
                    List files = db.getFiles();
                    this.lstPlanFiles.getItems().addAll((Collection)files);
                }
            });
            this.add((Node)this.lstPlanFiles, 0, row, 2, 2);
            Button btnAdd = JavaFxFactory.createButton("Hinzuf\u00fcgen", e -> {
                int count = this.lstPlanFiles.getItems().size();
                boolean showWarning = false;
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Pl\u00e4ne ausw\u00e4hlen");
                chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PDF oder JPG (*.pdf, *.jpg, *.jpeg)", new String[]{"*.pdf", "*.jpg", "*.jpeg"}));
                chooser.setInitialDirectory(this.app.getSettings().getFolderPlanImport().getValue(true));
                List files = chooser.showOpenMultipleDialog(null);
                if (files != null) {
                    for (File ff : files) {
                        if (count < CreateProjectWizard.this.maxPlanCount || CreateProjectWizard.this.maxPlanCount < 0) {
                            this.lstPlanFiles.getItems().add((Object)ff);
                            continue;
                        }
                        showWarning = true;
                    }
                    this.app.getSettings().getFolderPlanImport().setValue(((File)files.get(0)).getParentFile());
                }
                if (showWarning) {
                    // empty if block
                }
            });
            btnAdd.setMinWidth(100.0);
            this.add((Node)btnAdd, 2, row++, 1, 1);
            Button btnRemove = JavaFxFactory.createButton("Entfernen", e -> {
                ObservableList selected = this.lstPlanFiles.getSelectionModel().getSelectedItems();
                this.lstPlanFiles.getItems().removeAll((Collection)selected);
            });
            btnRemove.setMinWidth(100.0);
            this.add((Node)btnRemove, 2, row++, 1, 1);
            Label lblPlanFormat = JavaFxFactory.createLabelHeading("Format:");
            lblPlanFormat.setStyle("-fx-font-weight: bold");
            this.comboPlanPaperSizes = JavaFxFactory.createComboBox(this.getPlanPapersizes(), null, true);
            this.addRow(row++, new Node[]{lblPlanFormat, this.comboPlanPaperSizes});
            Label lblFormatInfo = JavaFxFactory.createLabelHeading("Anmerkung: Sie k\u00f6nnen die Pl\u00e4nen in einem einheitlichen Format speichern.");
            lblFormatInfo.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblFormatInfo.setWrapText(true);
            lblFormatInfo.setStyle("-fx-text-fill: grey");
            this.add((Node)lblFormatInfo, 0, row++, 3, 1);
        }

        private ArrayList<CmsPlan.Papersize> getPlanPapersizes() {
            ArrayList<CmsPlan.Papersize> list = new ArrayList<CmsPlan.Papersize>();
            list.add(CmsPlan.Papersize.A4);
            list.add(CmsPlan.Papersize.A3);
            list.add(CmsPlan.Papersize.A2);
            list.add(CmsPlan.Papersize.A1);
            list.add(CmsPlan.Papersize.A0);
            return list;
        }

        public boolean validate() {
            return true;
        }

        public List<File> getPlans() {
            return this.lstPlanFiles.getItems();
        }

        public String getBuilding() {
            return this.fldPlanBuilding.getText();
        }

        public CmsPlan.Papersize getPaperSize() {
            Object selected = this.comboPlanPaperSizes.getSelectionModel().getSelectedItem();
            if (selected instanceof CmsPlan.Papersize) {
                return (CmsPlan.Papersize)((Object)selected);
            }
            return null;
        }
    }

    private class PageProjectTemplate
    extends GridPane {
        private final ThemisApplication app = ThemisApplication.getInstance();
        private final ComboBox comboProjectTemplate;
        private final TextField fldProjectTemplate;

        public PageProjectTemplate() {
            int row = 0;
            this.setVgap(0.0);
            this.setHgap(8.0);
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            Label lblHeading = JavaFxFactory.createLabelHeading("Art des Projekts (Projektvorlage)");
            lblHeading.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblHeading.setWrapText(true);
            this.add((Node)lblHeading, 0, row++, 3, 1);
            Label lblProjectTemplateInfo = JavaFxFactory.createLabelHeading("Sie k\u00f6nnen jetzt eine Projektvorlage ausw\u00e4hlen. Dabei k\u00f6nnen Sie eine der hinterlegten Standardvorlagen oder eine eigene Vorlage aus einer Datei laden.");
            lblProjectTemplateInfo.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblProjectTemplateInfo.setWrapText(true);
            lblProjectTemplateInfo.setStyle("-fx-text-fill: grey");
            this.add((Node)lblProjectTemplateInfo, 0, row++, 3, 1);
            Label lblProjectTemplate = JavaFxFactory.createLabelHeading("Vorlage:");
            lblProjectTemplate.setStyle("-fx-font-weight: bold");
            this.fldProjectTemplate = JavaFxFactory.createTextField("");
            Label lblProjectFolder = JavaFxFactory.createLabelHeading("Vorlagendatei:");
            lblProjectFolder.setStyle("-fx-font-weight: bold");
            Button btnProjectTemplate = JavaFxFactory.createButton("Ausw\u00e4hlen", e -> {
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Vorlage ausw\u00e4hlen");
                File file = this.fldProjectTemplate.getText() != null && !this.fldProjectTemplate.getText().trim().isEmpty() ? new File(this.fldProjectTemplate.getText().trim()).getParentFile() : this.app.getSettings().getFolderProjectTemplate().getValue(true);
                chooser.setInitialDirectory(file);
                FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Projektvorlage (*.themis, *.xlsx)", new String[]{"*.themis", "*.xlsx"});
                chooser.getExtensionFilters().add((Object)filter);
                File f = chooser.showOpenDialog(null);
                if (f != null) {
                    this.fldProjectTemplate.setText(f.getAbsolutePath());
                    this.app.getSettings().getFolderProjectTemplate().setValue(f.getParentFile());
                }
            });
            btnProjectTemplate.setMinWidth(100.0);
            this.comboProjectTemplate = JavaFxFactory.createComboBox(this.getAvailableTemplates(), null, true);
            this.comboProjectTemplate.valueProperty().addListener((ov, t, t1) -> {
                if (!(t1 instanceof TemplateDescription)) {
                    lblProjectFolder.setVisible(false);
                    this.fldProjectTemplate.setVisible(false);
                    btnProjectTemplate.setVisible(false);
                } else if (((TemplateDescription)t1).isFile()) {
                    lblProjectFolder.setVisible(true);
                    this.fldProjectTemplate.setVisible(true);
                    btnProjectTemplate.setVisible(true);
                } else {
                    lblProjectFolder.setVisible(false);
                    this.fldProjectTemplate.setVisible(false);
                    btnProjectTemplate.setVisible(false);
                    if (((TemplateDescription)t1).hasHint()) {
                        Alert alert = new Alert(Alert.AlertType.NONE, ((TemplateDescription)t1).getHint(), new ButtonType[]{ButtonType.OK});
                        alert.initOwner(CreateProjectWizard.this.getWindow());
                        alert.setTitle("Hinweis");
                        alert.showAndWait();
                    }
                }
            });
            this.comboProjectTemplate.setOnAction(e -> {
                if (this.comboProjectTemplate.getSelectionModel().getSelectedIndex() > 0) {
                    this.fldProjectTemplate.setText("");
                }
            });
            this.fldProjectTemplate.setOnDragOver(ev -> {
                Dragboard db = ev.getDragboard();
                if (db.hasFiles()) {
                    ev.acceptTransferModes(TransferMode.ANY);
                }
            });
            this.fldProjectTemplate.setOnDragDropped(ev -> {
                List files;
                Dragboard db = ev.getDragboard();
                if (db.hasFiles() && !(files = db.getFiles()).isEmpty()) {
                    this.fldProjectTemplate.setText(((File)files.get(0)).getAbsolutePath());
                }
            });
            this.addRow(row++, new Node[]{lblProjectTemplate, this.comboProjectTemplate});
            this.comboProjectTemplate.getSelectionModel().selectFirst();
            this.addRow(row++, new Node[]{lblProjectFolder, this.fldProjectTemplate, btnProjectTemplate});
        }

        private ArrayList<TemplateDescription> getAvailableTemplates() {
            ArrayList<TemplateDescription> list = new ArrayList<TemplateDescription>();
            list.add(TemplateDescription.createFileSource());
            for (TemplateDescription td : DemoPackManager.getInstance().getProjectTemplates()) {
                list.add(td);
            }
            return list;
        }

        public boolean validate() {
            return true;
        }

        private TemplateDescription getProjectStandardTemplate() {
            int template = this.comboProjectTemplate.getSelectionModel().getSelectedIndex();
            if (template > 1) {
                return (TemplateDescription)this.comboProjectTemplate.getSelectionModel().getSelectedItem();
            }
            return null;
        }

        private File getProjectCustomTemplate() {
            String templateFile = this.fldProjectTemplate.getText().trim();
            if (templateFile.isEmpty()) {
                return null;
            }
            return new File(templateFile);
        }
    }

    private class PageTitleAndFile
    extends GridPane {
        private final ThemisApplication app = ThemisApplication.getInstance();
        private final RowConstraints projectFolderErrorConstratins = new RowConstraints(0.0, 0.0, 0.0, Priority.NEVER, VPos.CENTER, false);
        private final RowConstraints projectFileNameErrorConstratins = new RowConstraints(0.0, 0.0, 0.0, Priority.NEVER, VPos.CENTER, false);
        private final RowConstraints projectNameErrorConstratins = new RowConstraints(0.0, 0.0, 0.0, Priority.NEVER, VPos.CENTER, false);
        private final TextField fldProjectFolder;
        private final TextField fldProjectFileName;
        private final Label lblProjectFolderError;
        private final Label lblProjectFileNameError;

        public PageTitleAndFile(String folder) {
            int row = 0;
            this.setVgap(0.0);
            this.setHgap(8.0);
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
            this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            this.getRowConstraints().add((Object)this.projectFolderErrorConstratins);
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            this.getRowConstraints().add((Object)this.projectFileNameErrorConstratins);
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            this.getRowConstraints().add((Object)JavaFxFactory.getRowConstraints());
            this.getRowConstraints().add((Object)this.projectNameErrorConstratins);
            Label lblProjectFile = JavaFxFactory.createLabelHeading("Projektdatei");
            lblProjectFile.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblProjectFile.setWrapText(true);
            this.add((Node)lblProjectFile, 0, row++, 3, 1);
            Label lblProjectFileInfo = JavaFxFactory.createLabelHeading("Definieren Sie den Namen und Speicherort der Projektdatei.");
            lblProjectFileInfo.setTextOverrun(OverrunStyle.ELLIPSIS);
            lblProjectFileInfo.setWrapText(true);
            lblProjectFileInfo.setStyle("-fx-text-fill: grey");
            this.add((Node)lblProjectFileInfo, 0, row++, 3, 1);
            Label lblProjectFolder = JavaFxFactory.createLabelHeading("Ordner:");
            lblProjectFolder.setStyle("-fx-font-weight: bold");
            this.fldProjectFolder = JavaFxFactory.createTextField(folder);
            this.fldProjectFolder.setDisable(true);
            this.fldProjectFolder.textProperty().addListener((ov, prev, next) -> this.validateProjectFolder());
            Button btnProjectFolder = JavaFxFactory.createButton("Ausw\u00e4hlen", e -> {
                DirectoryChooser chooser = new DirectoryChooser();
                chooser.setTitle("Zielordner f\u00fcr das Projekt ausw\u00e4hlen");
                String ff = this.fldProjectFolder.getText();
                if (ff != null && ff.trim().length() > 0) {
                    chooser.setInitialDirectory(new File(ff.trim()));
                } else {
                    chooser.setInitialDirectory(this.app.getSettings().getFolderOpenProject().getValue(true));
                }
                File f = chooser.showDialog(null);
                if (f != null) {
                    this.fldProjectFolder.setText(f.getAbsolutePath());
                    this.app.getSettings().getFolderOpenProject().setValue(f);
                }
            });
            btnProjectFolder.setMinWidth(100.0);
            this.addRow(row++, new Node[]{lblProjectFolder, this.fldProjectFolder, btnProjectFolder});
            this.lblProjectFolderError = JavaFxFactory.createLabelHeading("");
            this.lblProjectFolderError.setVisible(false);
            this.lblProjectFolderError.setStyle("-fx-text-fill: red");
            this.add((Node)this.lblProjectFolderError, 1, row++, 1, 1);
            Label lblProjectFileName = JavaFxFactory.createLabelHeading("Dateiname:");
            lblProjectFileName.setStyle("-fx-font-weight: bold");
            this.fldProjectFileName = JavaFxFactory.createTextField("");
            this.fldProjectFileName.textProperty().addListener((ov, prev, next) -> this.validateProjectFileName());
            this.addRow(row++, new Node[]{lblProjectFileName, this.fldProjectFileName});
            this.lblProjectFileNameError = JavaFxFactory.createLabelHeading("");
            this.lblProjectFileNameError.setVisible(false);
            this.lblProjectFileNameError.setStyle("-fx-text-fill: red");
            this.add((Node)this.lblProjectFileNameError, 1, row++, 1, 1);
            Region spacer = new Region();
            spacer.setMinHeight(20.0);
            this.addRow(row++, new Node[]{spacer});
        }

        private boolean validateProjectFolder() {
            boolean isValid = false;
            this.lblProjectFolderError.setVisible(false);
            this.projectFolderErrorConstratins.setMinHeight(0.0);
            this.projectFolderErrorConstratins.setMaxHeight(0.0);
            this.projectFolderErrorConstratins.setPrefHeight(0.0);
            String error = "Bitte w\u00e4hlen Sie einen Ordner aus.";
            String path = this.fldProjectFolder.getText();
            if (path != null && !path.trim().isEmpty()) {
                File folder = new File(path.trim());
                if (folder.exists() && folder.isDirectory()) {
                    isValid = true;
                } else {
                    error = "Der ausgew\u00e4hlte Ordner existiert nicht.";
                }
            }
            if (!isValid) {
                this.lblProjectFolderError.setText(error);
                this.lblProjectFolderError.setVisible(true);
                this.projectFolderErrorConstratins.setMinHeight(10.0);
                this.projectFolderErrorConstratins.setMaxHeight(-1.0);
                this.projectFolderErrorConstratins.setPrefHeight(-1.0);
            }
            return isValid;
        }

        private boolean validateProjectFileName() {
            boolean isValid = false;
            this.lblProjectFileNameError.setVisible(false);
            this.projectFileNameErrorConstratins.setMinHeight(0.0);
            this.projectFileNameErrorConstratins.setMaxHeight(0.0);
            this.projectFileNameErrorConstratins.setPrefHeight(0.0);
            if (!this.validateProjectFolder()) {
                return false;
            }
            String error = null;
            String folder = this.fldProjectFolder.getText().trim();
            String filename = this.fldProjectFileName.getText().trim();
            if (filename != null && !filename.trim().isEmpty()) {
                if (!Util.isValidFilename((String)filename)) {
                    error = "Bitte geben Sie einen g\u00fcltigen Dateinamen ein!";
                    isValid = false;
                } else {
                    File file = new File(folder.trim(), filename.trim());
                    if (file.exists()) {
                        error = "Es existiert bereits ein Projekt mit diesem Dateinamen!";
                        isValid = false;
                    } else {
                        isValid = true;
                    }
                }
            } else {
                error = "Bitte geben Sie einen g\u00fcltigen Dateinamen ein!";
                isValid = false;
            }
            if (!isValid) {
                this.lblProjectFileNameError.setText(error);
                this.lblProjectFileNameError.setVisible(true);
                this.projectFileNameErrorConstratins.setMinHeight(10.0);
                this.projectFileNameErrorConstratins.setMaxHeight(-1.0);
                this.projectFileNameErrorConstratins.setPrefHeight(-1.0);
            }
            return isValid;
        }

        private boolean validateProjectTitel() {
            return true;
        }

        public boolean validate() {
            return true;
        }

        public File getProjectFolder() {
            String folder = this.fldProjectFolder.getText();
            if (folder == null || folder.trim().isEmpty()) {
                return null;
            }
            return new File(folder.trim());
        }

        public String getProjectFileName() {
            return this.fldProjectFileName.getText().trim();
        }
    }
}

