/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.project;

import at.grid.themis.ontology.javafx.JavaFxFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class ImageFxPanel
extends VBox {
    File image;

    public ImageFxPanel() {
        this.getChildren().clear();
        this.setPadding(new Insets(16.0));
        this.setSpacing(16.0);
        this.setAlignment(Pos.CENTER);
        Node imageView = this.createImageView();
        this.getChildren().add((Object)imageView);
        Node buttonView = this.createButtonView();
        this.getChildren().add((Object)buttonView);
    }

    public void populate(File image) {
        this.image = image;
        if (this.getChildren().size() > 1) {
            this.getChildren().remove(0);
        }
        Node imageView = this.createImageView();
        this.getChildren().add(0, (Object)imageView);
    }

    private Node createImageView() {
        Label imageView = new Label("Kein Bild gew\u00e4hlt");
        if (this.image != null) {
            try {
                FileInputStream stream = new FileInputStream(this.image);
                Image image = new Image((InputStream)stream, 750.0, 750.0, true, true);
                imageView = new ImageView(image);
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                imageView = new Label("Fehler beim Laden des Bildes!");
            }
        }
        HBox imgPane = new HBox();
        imgPane.setAlignment(Pos.CENTER);
        imgPane.setPadding(new Insets(16.0));
        imgPane.setStyle("-fx-border-color: grey");
        imgPane.setMaxWidth(750.0);
        imgPane.setMaxHeight(750.0);
        imgPane.getChildren().add((Object)imageView);
        HBox.setHgrow((Node)imgPane, (Priority)Priority.NEVER);
        return imgPane;
    }

    private Node createButtonView() {
        HBox result = new HBox();
        result.setAlignment(Pos.CENTER);
        result.setSpacing(16.0);
        Button addButton = JavaFxFactory.createButton("Neu", e -> SwingUtilities.invokeLater(() -> {
            File fl;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            int r = chooser.showOpenDialog(null);
            if (r == 0 && (fl = chooser.getSelectedFile()) != null && (fl.getName().endsWith(".jpg") || fl.getName().endsWith(".jpeg") || fl.getName().endsWith(".png"))) {
                Platform.runLater(() -> {
                    this.image = fl;
                    if (this.getChildren().size() > 1) {
                        this.getChildren().remove(0);
                    }
                    Node imageView = this.createImageView();
                    this.getChildren().add(0, (Object)imageView);
                });
            }
        }));
        addButton.setPrefWidth(150.0);
        result.getChildren().add((Object)addButton);
        Button deleteButton = JavaFxFactory.createButton("Entfernen", e -> {
            this.image = null;
            if (this.getChildren().size() > 1) {
                this.getChildren().remove(0);
            }
            Node imageView = this.createImageView();
            this.getChildren().add(0, (Object)imageView);
        });
        deleteButton.setPrefWidth(150.0);
        result.getChildren().add((Object)deleteButton);
        return result;
    }
}

