/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.project;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import java.awt.Desktop;
import java.io.IOException;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class ProjectFileFxPanel
extends VBox {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private final TextField folderFld;
    private final TextField filenameFld;

    public ProjectFileFxPanel() {
        this.setSpacing(16.0);
        Label heading = JavaFxFactory.createLabelHeading("Datei und Ordner");
        this.getChildren().add((Object)heading);
        GridPane pane = new GridPane();
        pane.setHgap(16.0);
        pane.setVgap(8.0);
        pane.setMinSize(300.0, 400.0);
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
        Label folderLbl = JavaFxFactory.createLabel("Ordner");
        this.folderFld = JavaFxFactory.createTextField("");
        this.folderFld.setDisable(true);
        Button openFolderBtn = JavaFxFactory.createButton("\u00d6ffnen", e -> {
            if (this.project.isOpen()) {
                try {
                    Desktop.getDesktop().open(this.project.getProjectFolder().getParentFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        openFolderBtn.setMinHeight(40.0);
        openFolderBtn.setMinWidth(40.0);
        openFolderBtn.setMaxHeight(40.0);
        openFolderBtn.setMaxWidth(40.0);
        openFolderBtn.setPadding(new Insets(10.0));
        Image openFolderImage = new Image(ProjectFileFxPanel.class.getResourceAsStream("/at/grid/themis/ontology/media/action_folder_16.gif"));
        openFolderBtn.setGraphic((Node)new ImageView(openFolderImage));
        HBox box = new HBox();
        box.setSpacing(16.0);
        HBox.setHgrow((Node)this.folderFld, (Priority)Priority.ALWAYS);
        box.getChildren().add((Object)this.folderFld);
        box.getChildren().add((Object)openFolderBtn);
        if (!this.project.isThemisFileDirectAccess()) {
            pane.addRow(0, new Node[]{folderLbl, box});
        }
        Label filenameLbl = JavaFxFactory.createLabel("Datei");
        this.filenameFld = JavaFxFactory.createTextField("");
        this.filenameFld.setDisable(true);
        if (!this.project.isThemisFileDirectAccess()) {
            pane.addRow(1, new Node[]{filenameLbl, this.filenameFld});
        }
        this.getChildren().add((Object)pane);
    }

    public ProjectFileFxPanel populate() {
        CmsProject p = this.project.getProjectElement();
        this.folderFld.setText(this.project.getProjectFolder().getParent());
        this.filenameFld.setText(this.project.getProjectFolder().getName());
        return this;
    }

    public void apply() {
    }
}

