/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.project;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class ProjectInfoFxPanel
extends VBox {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private final TextField fldTitle;
    private final TextField fldNumber;
    private final TextArea fldLocation;
    private final TextArea fldCustomer;
    private final TextArea fldInfo;

    public ProjectInfoFxPanel() {
        this.setSpacing(6.0);
        Label heading = JavaFxFactory.createLabelHeading("Projektinformationen");
        this.getChildren().add((Object)heading);
        GridPane pane = new GridPane();
        pane.setHgap(16.0);
        pane.setVgap(8.0);
        pane.setMinSize(300.0, 400.0);
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
        Text lblHint = JavaFxFactory.createTextHint("Hier k\u00f6nnen Informationen zum Projekt erfasst werden, die im Protokoll bzw. Bericht z.B. im Protokollkopf ausgegeben werden k\u00f6nnen. Der Projekttitel wird auch im Startbildschirm angezeigt. Die Projektinformationen k\u00f6nnen jederzeit bearbeitet werden.");
        lblHint.wrappingWidthProperty().bind((ObservableValue)pane.widthProperty());
        lblHint.setTextAlignment(TextAlignment.JUSTIFY);
        pane.add((Node)lblHint, 0, 0, 2, 1);
        Label lblTitle = JavaFxFactory.createLabel("Titel");
        this.fldTitle = JavaFxFactory.createTextField("");
        pane.addRow(2, new Node[]{lblTitle, this.fldTitle});
        Label lblNumber = JavaFxFactory.createLabel("Nummer");
        this.fldNumber = JavaFxFactory.createTextField("");
        pane.addRow(3, new Node[]{lblNumber, this.fldNumber});
        Label lblLocation = JavaFxFactory.createLabel("Ort");
        this.fldLocation = JavaFxFactory.createTextArea("");
        pane.addRow(4, new Node[]{lblLocation, this.fldLocation});
        Label lblCustomer = JavaFxFactory.createLabel("Auftraggeber");
        this.fldCustomer = JavaFxFactory.createTextArea("");
        pane.addRow(5, new Node[]{lblCustomer, this.fldCustomer});
        Label lblInfo = JavaFxFactory.createLabel("Sonstiges");
        this.fldInfo = JavaFxFactory.createTextArea("");
        pane.addRow(6, new Node[]{lblInfo, this.fldInfo});
        this.getChildren().add((Object)pane);
    }

    public ProjectInfoFxPanel populate() {
        if (this.project.isOpen()) {
            CmsProject p = this.project.getProjectElement();
            this.fldTitle.setText(p.getAttributeValue("projecttitle"));
            this.fldNumber.setText(p.getAttributeValue("projectnumber"));
            this.fldLocation.setText(p.getAttributeValue("projectlocation"));
            this.fldCustomer.setText(p.getAttributeValue("customer"));
            this.fldInfo.setText(p.getAttributeValue("info"));
        }
        return this;
    }

    public void apply() {
        if (this.project.isOpen()) {
            CmsProject p = this.project.getProjectElement();
            p.setAttributeValue("projecttitle", this.fldTitle.getText().trim());
            p.setAttributeValue("projectnumber", this.fldNumber.getText().trim());
            p.setAttributeValue("projectlocation", this.fldLocation.getText().trim());
            p.setAttributeValue("customer", this.fldCustomer.getText().trim());
            p.setAttributeValue("info", this.fldInfo.getText().trim());
            p.save();
        }
    }

    public String getProjectTitle() {
        return this.fldTitle.getText().trim();
    }
}

