/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.project;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisProjectStatus;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.ThemisAlert;
import at.grid.themis.ontology.javafx.ThemisTaskWithFxDialog;
import java.io.File;
import java.util.ArrayList;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

public class ProjectMaintenanceFxPanel
extends VBox {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();

    public ProjectMaintenanceFxPanel() {
        this.setSpacing(16.0);
        Label heading = JavaFxFactory.createLabelHeading("Projektwartung");
        this.getChildren().add((Object)heading);
        GridPane pane = new GridPane();
        pane.setHgap(16.0);
        pane.setVgap(8.0);
        pane.setMinSize(300.0, 400.0);
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
        ColumnConstraints cc = JavaFxFactory.getColumnConstraintsButton();
        cc.setMinWidth(50.0);
        cc.setHalignment(HPos.RIGHT);
        pane.getColumnConstraints().add((Object)cc);
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
        Label photos = JavaFxFactory.createLabel("Bilder mit falscher Gr\u00f6\u00dfe");
        Button correctPhotos = JavaFxFactory.createButton("Pr\u00fcfen & Korrigieren", e -> {
            if (!this.project.isOpen()) {
                return;
            }
            int pixel = this.app.getSettings().getImageUploadSize();
            float quality = this.app.getSettings().getImageUploadQuality();
            ArrayList<File> files = ThemisUtil.getImageFiles(this.project.getThemisFile(), pixel);
            if (files.size() > 0) {
                if (ThemisAlert.confirmYesNo("Sollen " + files.size() + " Bilder korrigiert werden?")) {
                    ThemisUtil.updateImage(files, pixel, 100.0f * quality, null);
                }
            } else {
                ThemisAlert.inform("Keine Aktualisierung erforderlich", ButtonType.OK);
            }
        });
        correctPhotos.setMinWidth(100.0);
        pane.addRow(0, new Node[]{photos, correctPhotos});
        Label photoDescription = JavaFxFactory.createLabel("Es wird die Gr\u00f6\u00dfe der Bilder mit der hinterlegten Konfiguration in den Projekteinstellungen abgeglichen. Sind die Bilder gr\u00f6\u00dfer als die hinterlegte maximale Pixelgr\u00f6\u00dfe, werden diese zur Korrektur aufgelistet. Derzeit ist eine maximale Pixelgr\u00f6\u00dfe von " + this.app.getSettings().getImageUploadSize() + "px angegeben.");
        photoDescription.setStyle("-fx-text-fill: gray");
        photoDescription.setWrapText(true);
        pane.addRow(1, new Node[]{photoDescription});
        Label icons = JavaFxFactory.createLabel("Icons mit falscher Gr\u00f6\u00dfe");
        Button correctIcons = JavaFxFactory.createButton("Pr\u00fcfen & Korrigieren", e -> {
            if (!this.project.isOpen()) {
                return;
            }
            ArrayList<File> files = ThemisUtil.getIconFiles(this.project.getThemisFile(), 100);
            if (files.size() > 0) {
                if (ThemisAlert.confirmYesNo("Sollen " + files.size() + " Icons korrigiert werden?")) {
                    ThemisUtil.updateImage(files, 100, 70.0f, null);
                }
            } else {
                ThemisAlert.inform("Keine Aktualisierung erforderlich", ButtonType.OK);
            }
        });
        correctIcons.setMinWidth(100.0);
        pane.addRow(2, new Node[]{icons, correctIcons});
        Label iconsDescription = JavaFxFactory.createLabel("F\u00fcr die Icons wird eine Maximalgr\u00f6\u00dfe von 100px angenommen. Alle Icons, die gr\u00f6\u00dfer als diese Maximalgr\u00f6\u00dfe sind, werden hier zur Korrektur aufgelistet.");
        iconsDescription.setStyle("-fx-text-fill: gray");
        iconsDescription.setWrapText(true);
        pane.addRow(3, new Node[]{iconsDescription});
        Label folderStructure = JavaFxFactory.createLabel("Ordnerstruktur des Projekts");
        Button correctFolderStructure = JavaFxFactory.createButton("Pr\u00fcfen & Korrigieren", e -> {
            if (!this.project.isOpen()) {
                return;
            }
            ThemisProjectStatus status = new ThemisProjectStatus();
            ThemisTaskWithFxDialog.createTask("Struktur wird \u00fcberpr\u00fcft", ph -> status.setUploadStatus(ThemisUtil.checkUploadFileStatus(ph)));
            if (status.hasUploadIssues()) {
                ArrayList<String> infos = new ArrayList<String>();
                if (status.countMissingUploads() > 0) {
                    infos.add("Fehlende Dateien: " + status.countMissingUploads());
                }
                if (status.countMoveUploads() > 0) {
                    infos.add("Speicherort korrigieren: " + status.countMoveUploads());
                }
                if (status.countNotUsedUploads() > 0) {
                    infos.add("Nicht verwendet: " + status.countNotUsedUploads());
                }
                if (status.countErrorUploads() > 0) {
                    infos.add("Mit Fehler: " + status.countErrorUploads());
                }
                infos.add("Soll die Korrektur durchgef\u00fchrt werden?");
                String info = String.join((CharSequence)"\n", infos);
                if (ThemisAlert.confirmYesNo(info)) {
                    ThemisTaskWithFxDialog.createTask("Ordnerstruktur wird aktualisiert", ph -> ThemisUtil.updateUploadFiles(true, ph));
                }
            } else {
                ThemisAlert.inform("Keine Aktualisierung erforderlich", ButtonType.OK);
            }
        });
        pane.addRow(4, new Node[]{folderStructure, correctFolderStructure});
        Label folderStructureDescription = JavaFxFactory.createLabel("THEMIS Projekte, welche mit einer \u00e4lteren Version von THEMIS erstellt wurden, weisen eine andere Ordnerstruktur auf. Dadurch kann es zu Fehlern, wie Bilder oder Icons werden nicht angezeigt bzw. gefunden und \u00e4hnlichem, kommen.");
        folderStructureDescription.setStyle("-fx-text-fill: gray");
        folderStructureDescription.setWrapText(true);
        pane.addRow(5, new Node[]{folderStructureDescription});
        this.getChildren().add((Object)pane);
    }

    public ProjectMaintenanceFxPanel populate() {
        return this;
    }

    public void apply() {
    }
}

