/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.project;

import at.grid.cms.content.UploadItem;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.util.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.openide.util.Exceptions;

public class ProjectMediaFxPanel
extends VBox {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    File imageFile = null;
    File logoFile = null;

    private void render() {
        this.setSpacing(16.0);
        this.getChildren().clear();
        Label heading = JavaFxFactory.createLabelHeading("Projektmedien");
        this.getChildren().add((Object)heading);
        GridPane pane = new GridPane();
        pane.setHgap(16.0);
        pane.setVgap(8.0);
        pane.setMinSize(300.0, 400.0);
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
        Label photoHeading = JavaFxFactory.createLabelHeading("Foto");
        Label logoHeading = JavaFxFactory.createLabelHeading("Logo");
        pane.addRow(0, new Node[]{photoHeading, logoHeading});
        Node photoContainer = this.createImageContainer(this.imageFile, e -> {
            File f;
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Projektbild ausw\u00e4hlen");
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Projektbild (*.png, *.jpg, *.jpeg)", new String[]{"*.png", " *.pdf", "*.jpg", "*.jpeg"}));
            if (this.imageFile != null) {
                chooser.setInitialDirectory(this.imageFile.getParentFile());
            }
            if ((f = chooser.showOpenDialog(null)) != null) {
                this.imageFile = f;
                this.render();
            }
        }, e -> {
            this.imageFile = null;
            this.render();
        }, e -> {
            File f;
            DragEvent event = (DragEvent)e;
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasFiles() && Util.isImageFile((String)(f = (File)db.getFiles().get(0)).getName())) {
                this.imageFile = f;
                this.render();
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
        Node logoContainer = this.createImageContainer(this.logoFile, e -> {
            File f;
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Projektlogo ausw\u00e4hlen");
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Projektlogo (*.png, *.jpg, *.jpeg)", new String[]{"*.png", " *.pdf", "*.jpg", "*.jpeg"}));
            if (this.logoFile != null) {
                chooser.setInitialDirectory(this.logoFile.getParentFile());
            }
            if ((f = chooser.showOpenDialog(null)) != null) {
                this.logoFile = f;
                this.render();
            }
        }, e -> {
            this.logoFile = null;
            this.render();
        }, e -> {
            File f;
            DragEvent event = (DragEvent)e;
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasFiles() && Util.isImageFile((String)(f = (File)db.getFiles().get(0)).getName())) {
                this.logoFile = f;
                this.render();
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
        pane.addRow(1, new Node[]{photoContainer, logoContainer});
        this.getChildren().add((Object)pane);
    }

    private Node createImageContainer(File file, EventHandler onAdd, EventHandler onRemove, EventHandler onDrop) {
        VBox result = new VBox();
        Label child = new Label("Kein Bild gew\u00e4hlt");
        if (file != null) {
            try {
                FileInputStream stream = new FileInputStream(file);
                Image image = new Image((InputStream)stream, 220.0, 220.0, true, true);
                child = new ImageView(image);
                Util.closeStream((Closeable)stream);
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                child = new Label("Fehler beim Laden des Bildes!");
            }
        }
        HBox container = new HBox();
        container.setAlignment(Pos.CENTER);
        container.setStyle("-fx-border-color: grey");
        container.setMinWidth(220.0);
        container.setMinHeight(220.0);
        container.setMaxWidth(220.0);
        container.setMaxHeight(220.0);
        container.getChildren().add((Object)child);
        container.setOnDragOver(event -> {
            if (event.getGestureSource() != container && event.getDragboard().hasFiles()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
            event.consume();
        });
        container.setOnDragDropped(onDrop);
        result.getChildren().add((Object)container);
        HBox controls = new HBox();
        controls.setAlignment(Pos.CENTER);
        controls.setSpacing(16.0);
        controls.setPadding(new Insets(16.0));
        controls.setMinWidth(220.0);
        controls.setMaxWidth(220.0);
        HBox.setHgrow((Node)controls, (Priority)Priority.NEVER);
        Button add = JavaFxFactory.createButton("", onAdd);
        add.setMinHeight(40.0);
        add.setMinWidth(40.0);
        add.setMaxHeight(40.0);
        add.setMaxWidth(40.0);
        Image addImg = new Image(ProjectMediaFxPanel.class.getResourceAsStream("/at/grid/themis/ontology/media/action_add_32.gif"));
        add.setGraphic((Node)new ImageView(addImg));
        controls.getChildren().add((Object)add);
        Button remove = JavaFxFactory.createButton("", onRemove);
        remove.setMinHeight(40.0);
        remove.setMinWidth(40.0);
        remove.setMaxHeight(40.0);
        remove.setMaxWidth(40.0);
        remove.setPadding(new Insets(10.0));
        Image removeImg = new Image(ProjectMediaFxPanel.class.getResourceAsStream("/at/grid/themis/ontology/media/action_remove_32.gif"));
        remove.setGraphic((Node)new ImageView(removeImg));
        controls.getChildren().add((Object)remove);
        result.getChildren().add((Object)controls);
        return result;
    }

    public ProjectMediaFxPanel populate() {
        List logoItems;
        CmsProject p = this.project.getProjectElement();
        List imageItems = p.getUploadAttribute("projectimage").getUploadItems();
        if (!imageItems.isEmpty()) {
            this.imageFile = ((UploadItem)imageItems.get(imageItems.size() - 1)).getFile();
        }
        if (!(logoItems = p.getUploadAttribute("projectlogo").getUploadItems()).isEmpty()) {
            this.logoFile = ((UploadItem)logoItems.get(logoItems.size() - 1)).getFile();
        }
        this.render();
        return this;
    }

    public void apply() {
        this.saveMedia("projectimage", this.imageFile);
        this.saveMedia("projectlogo", this.logoFile);
    }

    private void saveMedia(String uploadAttribute, File file) {
        if (this.project.isOpen()) {
            try {
                CmsProject projectEle = this.project.getProjectElement();
                if (file != null) {
                    projectEle.getUploadAttribute(uploadAttribute).addUpload(file);
                } else {
                    projectEle.getUploadAttribute(uploadAttribute).clear();
                }
                projectEle.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

