/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.project;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import java.awt.Desktop;
import java.io.IOException;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class ProjectWartungFxPanel
extends ScrollPane {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private final TextField folderFld;
    private final TextField filenameFld;
    private final TextField titleFld;
    private final TextField numberFld;
    private final TextArea locationArea;
    private final TextArea customerArea;
    private final TextArea infoArea;

    public ProjectWartungFxPanel() {
        this.setFitToHeight(true);
        this.setFitToWidth(true);
        this.setPadding(new Insets(16.0));
        VBox root = new VBox();
        root.setSpacing(16.0);
        Label heading = JavaFxFactory.createLabelHeading("Projektinformationen");
        root.getChildren().add((Object)heading);
        GridPane pane = new GridPane();
        pane.setHgap(16.0);
        pane.setVgap(8.0);
        pane.setMinSize(300.0, 400.0);
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setHgrow(Priority.NEVER);
        c1.setFillWidth(false);
        c1.setHgrow(Priority.NEVER);
        c1.setHalignment(HPos.LEFT);
        c1.setMinWidth(-1.0);
        c1.setPrefWidth(-1.0);
        c1.setMaxWidth(-1.0);
        c1.setPercentWidth(0.0);
        pane.getColumnConstraints().add((Object)c1);
        ColumnConstraints c2 = new ColumnConstraints();
        c2.setFillWidth(true);
        c2.setHgrow(Priority.ALWAYS);
        c2.setHalignment(HPos.LEFT);
        c2.setMinWidth(-1.0);
        c2.setPrefWidth(-1.0);
        c2.setMaxWidth(-1.0);
        c2.setPercentWidth(-1.0);
        pane.getColumnConstraints().add((Object)c2);
        Label folderLbl = JavaFxFactory.createLabel("Ordner");
        this.folderFld = JavaFxFactory.createTextField("");
        this.folderFld.setDisable(true);
        Button openFolderBtn = JavaFxFactory.createButton("\u00d6ffnen", e -> {
            if (this.project.isOpen()) {
                try {
                    Desktop.getDesktop().open(this.project.getProjectFolder().getParentFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        openFolderBtn.setMinHeight(40.0);
        openFolderBtn.setMinWidth(40.0);
        openFolderBtn.setMaxHeight(40.0);
        openFolderBtn.setMaxWidth(40.0);
        openFolderBtn.setPadding(new Insets(10.0));
        Image openFolderImage = new Image(ProjectWartungFxPanel.class.getResourceAsStream("/at/grid/themis/ontology/media/action_folder_16.gif"));
        openFolderBtn.setGraphic((Node)new ImageView(openFolderImage));
        HBox box = new HBox();
        box.setSpacing(16.0);
        HBox.setHgrow((Node)this.folderFld, (Priority)Priority.ALWAYS);
        box.getChildren().add((Object)this.folderFld);
        box.getChildren().add((Object)openFolderBtn);
        pane.addRow(0, new Node[]{folderLbl, box});
        Label filenameLbl = JavaFxFactory.createLabel("Datei");
        this.filenameFld = JavaFxFactory.createTextField("");
        this.filenameFld.setDisable(true);
        pane.addRow(1, new Node[]{filenameLbl, this.filenameFld});
        Label titleLbl = JavaFxFactory.createLabel("Titel");
        this.titleFld = JavaFxFactory.createTextField("");
        pane.addRow(2, new Node[]{titleLbl, this.titleFld});
        Label numberLbl = JavaFxFactory.createLabel("Nummer");
        this.numberFld = JavaFxFactory.createTextField("");
        pane.addRow(3, new Node[]{numberLbl, this.numberFld});
        Label locationLbl = JavaFxFactory.createLabel("Ort");
        this.locationArea = JavaFxFactory.createTextArea("");
        pane.addRow(4, new Node[]{locationLbl, this.locationArea});
        Label customerLbl = JavaFxFactory.createLabel("Auftraggeber");
        this.customerArea = JavaFxFactory.createTextArea("");
        pane.addRow(5, new Node[]{customerLbl, this.customerArea});
        Label infoLbl = JavaFxFactory.createLabel("Sonstiges");
        this.infoArea = JavaFxFactory.createTextArea("");
        pane.addRow(6, new Node[]{infoLbl, this.infoArea});
        root.getChildren().add((Object)pane);
        this.setContent((Node)root);
    }

    public ProjectWartungFxPanel populate() {
        CmsProject p = this.project.getProjectElement();
        this.folderFld.setText(this.project.getProjectFolder().getParent());
        this.filenameFld.setText(this.project.getProjectFolder().getName());
        this.titleFld.setText(p.getAttributeValue("projecttitle"));
        this.numberFld.setText(p.getAttributeValue("projectnumber"));
        this.locationArea.setText(p.getAttributeValue("projectlocation"));
        this.customerArea.setText(p.getAttributeValue("customer"));
        this.infoArea.setText(p.getAttributeValue("info"));
        return this;
    }

    public void apply() {
        CmsProject p = this.project.getProjectElement();
        p.setAttributeValue("projecttitle", this.titleFld.getText());
        p.setAttributeValue("projectnumber", this.numberFld.getText());
        p.setAttributeValue("projectlocation", this.locationArea.getText());
        p.setAttributeValue("customer", this.customerArea.getText());
        p.setAttributeValue("info", this.infoArea.getText());
        p.save();
    }
}

