/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.server;

import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.JavaFxIcon;
import at.grid.themis.ontology.javafx.ThemisTaskWithFxDialog;
import at.grid.themis.ontology.server.ThemisCloudProjectInfo;
import at.grid.themis.ontology.server.ThemisCloudServer;
import at.grid.util.ProgressHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.swing.SwingUtilities;
import org.jdom.JDOMException;
import org.openide.util.Exceptions;

public class ConfigureServerFxPanel
extends GridPane {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private List<ThemisFolder> folder = new ArrayList<ThemisFolder>();
    private final Label lblProjectsCount = JavaFxFactory.createLabel("");
    private final TextField fldServerCode = JavaFxFactory.createTextField("");
    private final TextField fldAccessCode = JavaFxFactory.createTextField("");
    private final CheckBox chkAutoDownload = JavaFxFactory.createCheckbox("Abgeschlossene Auftr\u00e4ge beim \u00d6ffnen automatisch vom Server laden", true);
    private final CheckBox chkAutoUpload = JavaFxFactory.createCheckbox("Projekt beim Schlie\u00dfen automatisch auf den Server laden", true);

    public ConfigureServerFxPanel() {
        this.setPadding(new Insets(10.0));
        this.setVgap(5.0);
        this.setHgap(5.0);
        this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
        this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
        this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
        this.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
        int row = 0;
        Label lblSetup = JavaFxFactory.createLabelHeading2("Server einrichten:");
        GridPane.setColumnSpan((Node)lblSetup, (Integer)Integer.MAX_VALUE);
        this.addRow(row++, new Node[]{lblSetup});
        Label lblServerCode = JavaFxFactory.createLabel("Server-Code:");
        String defaultCode = this.app.getSettings().getDefaultThemisServerCode();
        Button btnStandardServerCode = JavaFxFactory.createButton("Standard", e -> {
            if (defaultCode != null && !defaultCode.trim().isEmpty()) {
                this.fldServerCode.setText(defaultCode);
            }
        });
        btnStandardServerCode.setMinWidth(120.0);
        btnStandardServerCode.setDisable(defaultCode == null || defaultCode.trim().isEmpty());
        Button btnDeleteServerCode = JavaFxFactory.createButton("L\u00f6schen", e -> this.fldServerCode.setText(""));
        btnDeleteServerCode.setMinWidth(120.0);
        this.addRow(row++, new Node[]{lblServerCode, this.fldServerCode, btnStandardServerCode, btnDeleteServerCode});
        Label lblHintConfigure = JavaFxFactory.createLabelHint("Mit \"Einrichten\" werden die Projekte auf dem angegebenen Server konfiguriert und hochgeladen. Zus\u00e4tzlich wird der automatische Datenabgleich beim \u00d6ffnen bzw. Schlie\u00dfen des Projektes aktiviert. Falls ein Projekt bereits mit einem Server verkn\u00fcpft ist, wird dieses \u00fcbersprungen.");
        GridPane.setColumnSpan((Node)lblHintConfigure, (Integer)Integer.MAX_VALUE);
        this.addRow(row++, new Node[]{lblHintConfigure});
        Button btnSetup = JavaFxFactory.createButton("Einrichten", ev -> ThemisTaskWithFxDialog.createTask("task.configure-server.setup", true, true, ph -> {
            ArrayList<String> errors = this.setup(ph);
            SwingUtilities.invokeLater(() -> {
                if (!errors.isEmpty()) {
                    if (errors.size() == 1) {
                        this.app.getDialog().showErrorDialog((String)errors.get(0));
                    } else {
                        this.app.getDialog().showErrorDialog("- " + String.join((CharSequence)"<br>- ", errors));
                    }
                }
            });
        }));
        btnSetup.setGraphic((Node)new JavaFxIcon(JavaFxIcon.CHECK_CIRCLE, (Paint)Color.GREEN, 16.0));
        btnSetup.setMinWidth(120.0);
        this.add((Node)btnSetup, 3, row++);
        Region spacer = JavaFxFactory.createVerticalSpacer();
        GridPane.setColumnSpan((Node)spacer, (Integer)Integer.MAX_VALUE);
        this.addRow(row++, new Node[]{spacer});
        Separator separator = new Separator();
        GridPane.setColumnSpan((Node)separator, (Integer)Integer.MAX_VALUE);
        this.addRow(row++, new Node[]{separator});
        Label lblConfigure = JavaFxFactory.createLabelHeading2("Server konfigurieren:");
        GridPane.setColumnSpan((Node)lblConfigure, (Integer)Integer.MAX_VALUE);
        this.addRow(row++, new Node[]{lblConfigure});
        Label lblAccessCode = JavaFxFactory.createLabel("Freigabe:");
        GridPane.setColumnSpan((Node)this.fldAccessCode, (Integer)2);
        this.addRow(row, new Node[]{lblAccessCode, this.fldAccessCode});
        Button btnAccessCode = JavaFxFactory.createButton("L\u00f6schen", e -> this.fldAccessCode.setText(""));
        btnAccessCode.setMinWidth(120.0);
        this.add((Node)btnAccessCode, 3, row++);
        Label lblAutoSync = JavaFxFactory.createLabel("Automatismen:");
        GridPane.setColumnSpan((Node)this.chkAutoDownload, (Integer)Integer.MAX_VALUE);
        this.addRow(row++, new Node[]{lblAutoSync, this.chkAutoDownload});
        GridPane.setColumnSpan((Node)this.chkAutoUpload, (Integer)Integer.MAX_VALUE);
        this.add((Node)this.chkAutoUpload, 1, row++);
        Label lblHintOverride = JavaFxFactory.createLabelHint("Mit \"Konfigurieren\" werden die Einstellungen f\u00fcr den autoamtischen Datenabgleich \u00fcbernommen. Falls definiert, wird eine Freigabe f\u00fcr die Projekte angelegt. Projekte, welche mit keinem Server verkn\u00fcpft sind, werden \u00fcbersprungen.");
        GridPane.setColumnSpan((Node)lblHintOverride, (Integer)Integer.MAX_VALUE);
        this.addRow(row++, new Node[]{lblHintOverride});
        Button btnConfigure = JavaFxFactory.createButton("Konfigurieren", ev -> ThemisTaskWithFxDialog.createTask("task.configure-server.configure", true, true, ph -> {
            ArrayList<String> errors = this.configure(ph);
            SwingUtilities.invokeLater(() -> {
                if (!errors.isEmpty()) {
                    if (errors.size() == 1) {
                        this.app.getDialog().showErrorDialog((String)errors.get(0));
                    } else {
                        this.app.getDialog().showErrorDialog("- " + String.join((CharSequence)"<br>- ", errors));
                    }
                }
            });
        }));
        btnConfigure.setGraphic((Node)new JavaFxIcon(JavaFxIcon.CHECK_CIRCLE, (Paint)Color.GREEN, 16.0));
        btnConfigure.setMinWidth(120.0);
        this.add((Node)btnConfigure, 3, row++);
    }

    public ConfigureServerFxPanel populate(List<ThemisFolder> folder) {
        this.folder = folder;
        this.lblProjectsCount.setText(String.valueOf(this.folder.size()));
        return this;
    }

    public ArrayList<String> delete(ProgressHandler ph) {
        ArrayList<String> errors = new ArrayList<String>();
        ph.switchToDeterminate(this.folder.size());
        int counter = 0;
        for (ThemisFolder themis : this.folder) {
            ++counter;
            if (ph.isCancelled()) break;
            ph.progress("Server wird gel\u00f6scht ... (" + counter + "/" + this.folder.size() + ")", counter);
            if (themis.getProjectLock().isLocked()) {
                errors.add(this.project.getResourceText("{0} (error.project-locked-server)", themis.getFolderName()));
                continue;
            }
            this.project.open(themis, null, null, false, ThemisUtil.isOnNetworkDrive(themis.getProjectFolder()), false, false, false, null);
            if (!this.project.isOpen()) {
                errors.add(this.project.getResourceText("{0} (error.project-not-opened)", themis.getFolderName()));
                continue;
            }
            ThemisCloudServer server = this.project.getThemisServer();
            if (server == null) {
                this.project.close(new Closing().withoutAsking().withoutExport().withoutTrigger(), null);
                continue;
            }
            try {
                server.deleteProject(this.project.getProjectElement().getUUIDasString());
                this.project.setThemisServer(null);
                this.app.getSettings().setAutoImportFromServer(false);
                this.app.getSettings().setAutoExportFullProject(false);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                errors.add(this.project.getResourceText("{0} (error.deleting-server - " + ex.getLocalizedMessage() + ")", themis.getFolderName()));
            }
            this.app.getSettings().save();
            this.project.close(new Closing().withoutAsking().withoutExport().withoutTrigger(), null);
        }
        return errors;
    }

    public ArrayList<String> setup(ProgressHandler ph) {
        ArrayList<String> errors = new ArrayList<String>();
        String serverCode = this.fldServerCode.getText().trim();
        if (serverCode.isEmpty()) {
            errors.add(this.project.getResourceText("error.server-code-missing"));
            return errors;
        }
        String accessCode = this.fldAccessCode.getText().trim();
        ph.switchToDeterminate(this.folder.size());
        int counter = 0;
        for (ThemisFolder themis : this.folder) {
            ++counter;
            if (ph.isCancelled()) break;
            ph.progress("Server wird eingerichtet ... (" + counter + "/" + this.folder.size() + ")", counter);
            if (themis.getProjectLock().isLocked()) {
                errors.add(this.project.getResourceText("error.project-locked-server", themis.getFolderName()));
                continue;
            }
            this.project.open(themis, null, null, false, ThemisUtil.isOnNetworkDrive(themis.getProjectFolder()), false, false, false, null);
            if (!this.project.isOpen()) {
                errors.add(this.project.getResourceText("error.project-not-opened", themis.getFolderName()));
                continue;
            }
            if (this.project.hasThemisServer()) {
                errors.add(this.project.getResourceText("error.project-has-server", themis.getFolderName()));
                this.project.close(new Closing().withoutAsking().withoutExport().withoutTrigger(), null);
                continue;
            }
            ThemisCloudServer server = ThemisCloudServer.fromCode(serverCode);
            if (server == null) {
                errors.add(this.project.getResourceText("error.invalid-server-code", themis.getFolderName()));
                this.project.close(new Closing().withoutAsking().withoutExport().withoutTrigger(), null);
                continue;
            }
            this.app.getSettings().setThemisServerCode(server.getServerCode());
            this.project.setThemisServer(server);
            try {
                ThemisCloudProjectInfo info = server.uploadProjectInfo(this.project, true);
                if (info.isProjectTitleDiffers()) {
                    this.project.setThemisServer(null);
                    errors.add(this.project.getResourceText("error.project-title-differs", themis.getFolderName()));
                } else {
                    server.uploadProject(this.project, null);
                    if (!info.hasAccessCode(accessCode)) {
                        info.addAccessCode(new ThemisCloudProjectInfo.ServerAccess(accessCode, ""));
                        server.updateProjectInfo(info);
                    }
                    this.app.getSettings().setAutoImportFromServer(true);
                    this.app.getSettings().setAutoExportFullProject(true);
                }
            }
            catch (IOException | JDOMException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                errors.add(this.project.getResourceText("error.configure-server", themis.getFolderName()));
            }
            this.app.getSettings().save();
            this.project.close(new Closing().withoutAsking().withoutExport().withoutTrigger(), null);
        }
        return errors;
    }

    public ArrayList<String> configure(ProgressHandler ph) {
        ArrayList<String> errors = new ArrayList<String>();
        String accessCode = this.fldAccessCode.getText().trim();
        if (accessCode.isEmpty()) {
            errors.add(this.project.getResourceText("error.server-access-code-missing"));
            return errors;
        }
        ph.switchToDeterminate(this.folder.size());
        int counter = 0;
        for (ThemisFolder themis : this.folder) {
            ++counter;
            if (ph.isCancelled()) break;
            ph.progress("Einstellungen werden vorgenommen ... (" + counter + "/" + this.folder.size() + ")", counter);
            if (themis.getProjectLock().isLocked()) {
                errors.add(this.project.getResourceText("error.project-locked-server", themis.getFolderName()));
                continue;
            }
            this.project.open(themis, null, null, false, ThemisUtil.isOnNetworkDrive(themis.getProjectFolder()), false, false, false, null);
            if (!this.project.isOpen()) {
                errors.add(this.project.getResourceText("error.project-not-opened", themis.getFolderName()));
                continue;
            }
            ThemisCloudServer server = this.project.getThemisServer();
            if (server == null) {
                errors.add(this.project.getResourceText("error.invalid-server-code", themis.getFolderName()));
                this.project.close(new Closing().withoutAsking().withoutExport().withoutTrigger(), null);
                continue;
            }
            try {
                ThemisCloudProjectInfo info = server.uploadProjectInfo(this.project, true);
                if (info.isProjectTitleDiffers()) {
                    this.project.setThemisServer(null);
                    errors.add(this.project.getResourceText("error.project-title-differs", themis.getFolderName()));
                } else {
                    if (accessCode != null && !accessCode.trim().isEmpty() && !info.hasAccessCode(accessCode)) {
                        info.addAccessCode(new ThemisCloudProjectInfo.ServerAccess(accessCode, ""));
                        server.updateProjectInfo(info);
                    }
                    this.app.getSettings().setAutoImportFromServer(this.chkAutoDownload.isSelected());
                    this.app.getSettings().setAutoExportFullProject(this.chkAutoUpload.isSelected());
                }
            }
            catch (IOException | JDOMException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                errors.add(this.project.getResourceText("error.configure-server", themis.getFolderName()));
            }
            this.app.getSettings().save();
            this.project.close(new Closing().withoutAsking().withoutExport().withoutTrigger(), null);
        }
        return errors;
    }
}

