/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.signature;

import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class SignatureFxPanel
extends StackPane {
    private String name;
    private Canvas canvas;

    public SignatureFxPanel(String name) {
        this.name = name;
        this.populate();
    }

    private void populate() {
        this.setPadding(new Insets(16.0));
        this.setMinWidth(600.0);
        this.setMinHeight(200.0);
        this.canvas = new Canvas(600.0, 200.0);
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.setStroke((Paint)Color.BLUE);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            gc.beginPath();
            gc.moveTo(e.getX(), e.getY());
            gc.stroke();
        });
        this.canvas.addEventHandler(MouseEvent.MOUSE_DRAGGED, e -> {
            gc.lineTo(e.getX(), e.getY());
            gc.stroke();
        });
        this.canvas.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> {});
        Pane pane = new Pane();
        pane.setStyle("-fx-background-color: white; -fx-border-color: lightgrey");
        pane.getChildren().add((Object)this.canvas);
        this.getChildren().add((Object)pane);
        gc.setFont(new Font("Calibri", 14.0));
        gc.fillText(this.name + " - " + new SimpleDateFormat("dd.MM.yyyy HH:mm").format(new Date()), 10.0, (double)Math.round(this.canvas.getHeight() - 10.0));
    }

    public BufferedImage save() {
        WritableImage image = this.canvas.snapshot(null, null);
        return SwingFXUtils.fromFXImage((Image)image, null);
    }
}

