/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.signature;

import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.signature.SignatureFxPanel;
import at.grid.themis.ontology.signature.ThemisSignature;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;

public class SignatureManagementFxPanel
extends HBox {
    private boolean signatureAlertIsShown = false;
    private VBox signatureListBox = new VBox();
    private ListView<ThemisSignature> signatureList = new ListView();

    public SignatureManagementFxPanel() {
        this(new ArrayList<ThemisSignature>());
    }

    public SignatureManagementFxPanel(ArrayList<ThemisSignature> signatures) {
        this.setPadding(new Insets(5.0));
        this.populate(signatures);
    }

    private void populate(ArrayList<ThemisSignature> signatures) {
        this.getChildren().clear();
        if (signatures.isEmpty()) {
            signatures.add(new ThemisSignature());
        }
        this.signatureList.setMinWidth(200.0);
        this.signatureList.setMaxWidth(200.0);
        this.signatureList.getItems().clear();
        this.signatureList.getItems().addAll(signatures);
        this.signatureList.setCellFactory(param -> new ListCell<ThemisSignature>(){

            public void updateItem(ThemisSignature item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText(null);
                    this.setStyle(null);
                } else {
                    String title = item.getName().trim();
                    if (item.getFunction().trim().length() > 0) {
                        title = title + " (" + item.getFunction().trim() + ")";
                    }
                    if (title.trim().length() < 1) {
                        title = "<Unterschrift>";
                    }
                    this.setText(title);
                    String color = item.getSignature() == null ? "#ef9a9a" : "#c5e1a5";
                    boolean selected = SignatureManagementFxPanel.this.signatureList.getSelectionModel().getSelectedItem() == item;
                    this.setStyle("-fx-text-fill: white; -fx-background-color: " + color + (selected ? "; -fx-font-weight: bold;" : ""));
                }
            }
        });
        this.signatureList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (this.getChildren().size() > 1) {
                this.getChildren().remove(1);
            }
            if (newValue != null) {
                VBox box = this.createSignaturePanel((ThemisSignature)newValue);
                this.getChildren().add((Object)box);
            }
            this.signatureList.refresh();
        });
        VBox.setVgrow(this.signatureList, (Priority)Priority.ALWAYS);
        HBox buttonBox = new HBox();
        buttonBox.setSpacing(5.0);
        buttonBox.setPadding(new Insets(5.0, 5.0, 5.0, 0.0));
        Button addButton = new Button();
        addButton.setGraphic((Node)new ImageView(new Image(SignatureManagementFxPanel.class.getResourceAsStream("/at/grid/themis/ontology/media/add2_24.gif"), 24.0, 24.0, true, true)));
        addButton.setOnAction(e -> this.addSignature());
        buttonBox.getChildren().add((Object)addButton);
        Button removeButton = new Button();
        removeButton.setGraphic((Node)new ImageView(new Image(SignatureManagementFxPanel.class.getResourceAsStream("/at/grid/themis/ontology/media/remove24.gif"), 24.0, 24.0, true, true)));
        removeButton.setOnAction(e -> this.removeSignature());
        buttonBox.getChildren().add((Object)removeButton);
        this.signatureListBox.getChildren().clear();
        this.signatureListBox.getChildren().add(this.signatureList);
        this.signatureListBox.getChildren().add((Object)buttonBox);
        this.getChildren().add((Object)this.signatureListBox);
        if (!signatures.isEmpty()) {
            this.signatureList.getSelectionModel().selectFirst();
        }
    }

    private VBox createSignaturePanel(ThemisSignature signature) {
        VBox result = new VBox();
        result.setSpacing(5.0);
        result.setMaxWidth(Double.MAX_VALUE);
        result.setPadding(new Insets(8.0));
        GridPane grid = new GridPane();
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setFillWidth(false);
        cc1.setHgrow(Priority.NEVER);
        cc1.setHalignment(HPos.LEFT);
        cc1.setMinWidth(-1.0);
        cc1.setPrefWidth(-1.0);
        cc1.setMaxWidth(-1.0);
        cc1.setPercentWidth(0.0);
        ColumnConstraints cc2 = new ColumnConstraints();
        cc2.setFillWidth(true);
        cc2.setHgrow(Priority.ALWAYS);
        cc2.setHalignment(HPos.LEFT);
        cc2.setMinWidth(-1.0);
        cc2.setPrefWidth(-1.0);
        cc2.setMaxWidth(-1.0);
        cc2.setPercentWidth(-1.0);
        grid.getColumnConstraints().add((Object)cc1);
        grid.getColumnConstraints().add((Object)cc2);
        grid.getColumnConstraints().add((Object)cc1);
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        HBox signatureNode = new HBox();
        Label lblName = JavaFxFactory.createLabel("Name");
        TextField fldName = JavaFxFactory.createTextField(signature.getName());
        fldName.textProperty().addListener((observable, oldValue, newValue) -> {
            if (signature.getSignature() != null) {
                if (!this.signatureAlertIsShown) {
                    this.signatureAlertIsShown = true;
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("Unterschrift wird l\u00f6schen");
                    alert.setHeaderText("Achtung wenn Sie den Namen \u00e4ndern wird die Unterschrift gel\u00f6scht.");
                    Optional buttonType = alert.showAndWait();
                    ButtonType type = (ButtonType)buttonType.get();
                    if (type == ButtonType.OK) {
                        signature.setName((String)newValue);
                        signature.setSignature(null);
                        signatureNode.getChildren().clear();
                    } else {
                        fldName.setText(oldValue);
                    }
                    this.signatureAlertIsShown = false;
                }
            } else {
                signature.setName((String)newValue);
            }
            this.signatureList.refresh();
        });
        GridPane.setColumnSpan((Node)fldName, (Integer)3);
        grid.addRow(0, new Node[]{lblName, fldName});
        Label lblFunction = JavaFxFactory.createLabel("Funktion");
        TextField fldFunction = JavaFxFactory.createTextField(signature.getFunction());
        fldFunction.textProperty().addListener((observable, oldValue, newValue) -> {
            signature.setFunction((String)newValue);
            this.signatureList.refresh();
        });
        GridPane.setColumnSpan((Node)fldFunction, (Integer)3);
        grid.addRow(1, new Node[]{lblFunction, fldFunction});
        Label lblSignature = JavaFxFactory.createLabel("Unterschrift");
        signatureNode.setPrefWidth(600.0);
        signatureNode.setPrefHeight(200.0);
        signatureNode.setAlignment(Pos.CENTER);
        if (signature.getSignature() != null) {
            WritableImage image = SwingFXUtils.toFXImage((BufferedImage)signature.getSignature(), null);
            ImageView imageView = new ImageView((Image)image);
            imageView.setFitHeight(200.0);
            imageView.setPreserveRatio(true);
            signatureNode.getChildren().add((Object)imageView);
        }
        signatureNode.setStyle("-fx-background-color: white; -fx-border-color: lightgrey;");
        Button btnSignature = JavaFxFactory.createButton("Unterschreiben", e -> {
            if (signature.getName() == null || signature.getName().trim().length() < 1) {
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.setTitle("Unterschrift");
                alert.setHeaderText("Bitte definieren Sie zuerst einen Namen f\u00fcr die Unterschrift.");
                alert.showAndWait();
            } else {
                Dialog dlg = new Dialog();
                dlg.initModality(Modality.APPLICATION_MODAL);
                dlg.setTitle("Unterschreiben");
                SignatureFxPanel signaturePanel = new SignatureFxPanel(signature.getName());
                dlg.getDialogPane().setContent((Node)signaturePanel);
                ButtonType submitButtonType = new ButtonType("\u00dcbernehmen", ButtonBar.ButtonData.OK_DONE);
                ButtonType cancelButtonType = new ButtonType("Abbrechen", ButtonBar.ButtonData.CANCEL_CLOSE);
                dlg.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{submitButtonType, cancelButtonType});
                dlg.setResultConverter(dialogButton -> {
                    if (dialogButton == submitButtonType) {
                        return signaturePanel.save();
                    }
                    return null;
                });
                Optional image = dlg.showAndWait();
                if (image.isPresent()) {
                    BufferedImage img = (BufferedImage)image.get();
                    signature.setSignature(img);
                    signatureNode.getChildren().clear();
                    WritableImage sig = SwingFXUtils.toFXImage((BufferedImage)signature.getSignature(), null);
                    ImageView imageView = new ImageView((Image)sig);
                    imageView.setFitHeight(200.0);
                    imageView.setPreserveRatio(true);
                    signatureNode.getChildren().add((Object)imageView);
                    this.signatureList.refresh();
                }
            }
        });
        Button btnDeleteSignature = JavaFxFactory.createButton("L\u00f6schen", e -> {
            signature.setSignature(null);
            signatureNode.getChildren().clear();
            this.signatureList.refresh();
        });
        btnDeleteSignature.setMaxWidth(Double.MAX_VALUE);
        VBox buttons = new VBox();
        buttons.setSpacing(5.0);
        buttons.getChildren().addAll((Object[])new Node[]{btnSignature, btnDeleteSignature});
        grid.addRow(2, new Node[]{lblSignature, signatureNode, buttons});
        result.getChildren().add((Object)grid);
        return result;
    }

    private void addSignature() {
        ThemisSignature signature = new ThemisSignature();
        this.signatureList.getItems().add((Object)signature);
        this.signatureList.getSelectionModel().select((Object)signature);
    }

    private void removeSignature() {
        ThemisSignature signature = (ThemisSignature)this.signatureList.getSelectionModel().getSelectedItem();
        if (signature != null) {
            if (this.getChildren().size() > 1) {
                this.getChildren().remove(1);
            }
            ArrayList<ThemisSignature> signatures = new ArrayList<ThemisSignature>();
            signatures.addAll((Collection<ThemisSignature>)this.signatureList.getItems());
            signatures.remove(signature);
            if (signatures.isEmpty()) {
                signatures.add(new ThemisSignature());
            }
            this.signatureList.getItems().clear();
            this.signatureList.getItems().addAll(signatures);
            this.signatureList.getSelectionModel().selectFirst();
        }
    }

    public List<ThemisSignature> getSignatures() {
        ArrayList<ThemisSignature> signatures = new ArrayList<ThemisSignature>();
        this.signatureList.getItems().stream().forEach(sig -> {
            if (!sig.isEmpty()) {
                signatures.add((ThemisSignature)sig);
            }
        });
        return signatures;
    }
}

