/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.templateeditor;

import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.gui.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsObservationTemplate;
import at.grid.themis.ontology.javafx.attributepanel.ThemisAttributeFxPanel;
import at.grid.themis.ontology.javafx.templateeditor.TemplateEditorTreeCell;
import at.grid.themis.ontology.template.TemplateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class TemplateEditorPane
extends GridPane {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private final TemplateManager manager = this.project.getTemplateManger();
    private VBox treeBox;
    private HBox loadingBox;
    private TreeView<CmsElement> treeView;
    private TreeItem<CmsElement> tree;
    private TextField searchField;
    private ThemisAttributeFxPanel attributePanel;
    ArrayList<CmsElement> elementsToBeDeleted = new ArrayList();

    public TemplateEditorPane() {
        this.initialize();
    }

    private void initialize() {
        this.setMaxWidth(Double.MAX_VALUE);
        this.setMaxHeight(Double.MAX_VALUE);
        ColumnConstraints cc = new ColumnConstraints();
        cc.setPercentWidth(50.0);
        this.getColumnConstraints().clear();
        this.getColumnConstraints().add((Object)cc);
        this.getColumnConstraints().add((Object)cc);
        RowConstraints rc = new RowConstraints();
        rc.setPercentHeight(100.0);
        this.getRowConstraints().clear();
        this.getRowConstraints().add((Object)rc);
        this.treeBox = this.generateTreeBox();
        this.add((Node)this.treeBox, 0, 0);
    }

    private VBox generateTreeBox() {
        VBox result = new VBox();
        result.setSpacing(16.0);
        result.setPadding(new Insets(16.0));
        result.setStyle("-fx-background-color: white; -fx-border-color: #cccccc; -fx-border-radius: 0; -fx-border-width: 1;");
        HBox.setHgrow((Node)result, (Priority)Priority.ALWAYS);
        HBox searchBox = this.generateSearchBox();
        result.getChildren().add((Object)searchBox);
        this.loadingBox = this.generateLoadingBox();
        result.getChildren().add((Object)this.loadingBox);
        GridPane buttonGrid = this.generateButtonGrid();
        result.getChildren().add((Object)buttonGrid);
        GridPane.setFillHeight((Node)result, (Boolean)Boolean.TRUE);
        GridPane.setFillWidth((Node)result, (Boolean)Boolean.TRUE);
        return result;
    }

    private HBox generateLoadingBox() {
        HBox result = new HBox();
        result.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)result, (Priority)Priority.ALWAYS);
        result.setStyle("-fx-background-color: white; -fx-border-color: #cccccc; -fx-border-radius: 0; -fx-border-width: 1;");
        Label loadingLabel = new Label("Textvorlagen werden geladen ...");
        result.getChildren().add((Object)loadingLabel);
        return result;
    }

    private void setExpandedForTree(TreeItem<CmsElement> tree, boolean expanded) {
        for (TreeItem child : tree.getChildren()) {
            this.setExpandedForTree((TreeItem<CmsElement>)child, expanded);
        }
        tree.setExpanded(expanded);
    }

    private HBox generateSearchBox() {
        HBox result = new HBox();
        result.setMinHeight(-1.0);
        result.setSpacing(16.0);
        result.setAlignment(Pos.CENTER_LEFT);
        Label searchLabel = new Label("Suche:");
        searchLabel.setStyle("-fx-font-weight: bold");
        searchLabel.setMinWidth(-1.0);
        HBox.setHgrow((Node)searchLabel, (Priority)Priority.NEVER);
        result.getChildren().add((Object)searchLabel);
        this.searchField = new TextField();
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (null != this.treeView) {
                if ("".equals(oldValue)) {
                    this.tree = this.treeView.getRoot();
                }
                TreeItem<CmsElement> filtered = this.filterTree(this.tree, (String)newValue);
                if ("".equals(newValue)) {
                    this.setExpandedForTree(filtered, false);
                    filtered.setExpanded(true);
                }
                this.treeView.setRoot(filtered);
            }
        });
        HBox.setHgrow((Node)this.searchField, (Priority)Priority.ALWAYS);
        result.getChildren().add((Object)this.searchField);
        Button clearSearchButton = this.generateIconButton("clear.png");
        clearSearchButton.setOnAction(event -> this.searchField.setText(""));
        clearSearchButton.setMinWidth(-1.0);
        HBox.setHgrow((Node)clearSearchButton, (Priority)Priority.NEVER);
        result.getChildren().add((Object)clearSearchButton);
        return result;
    }

    private TreeItem<CmsElement> filterTree(TreeItem<CmsElement> root, String filter) {
        TreeItem filtered = new TreeItem(root.getValue());
        filtered.setExpanded(true);
        for (TreeItem child : root.getChildren()) {
            TreeItem<CmsElement> filteredChild = this.filterTree((TreeItem<CmsElement>)child, filter);
            if (!((CmsElement)filteredChild.getValue()).getTitle().toLowerCase().contains(filter.toLowerCase()) && filteredChild.getChildren().isEmpty()) continue;
            filteredChild.setExpanded(true);
            filtered.getChildren().add(filteredChild);
        }
        return filtered;
    }

    private TreeView generateTreeView() {
        TreeView result = new TreeView();
        VBox.setVgrow((Node)result, (Priority)Priority.ALWAYS);
        result.setMaxWidth(Double.MAX_VALUE);
        result.setMaxHeight(Double.MAX_VALUE);
        result.setShowRoot(true);
        result.getSelectionModel().selectedItemProperty().addListener((observable, oldItem, newItem) -> {
            if (this.getChildren().size() > 1) {
                if (this.attributePanel != null) {
                    CmsElement element = this.attributePanel.apply(false);
                    if (oldItem != null) {
                        oldItem.setValue((Object)element);
                    }
                }
                this.getChildren().remove(1);
            }
            if (newItem != null && newItem.getParent() != null) {
                VBox detailBox = new VBox();
                detailBox.setSpacing(16.0);
                detailBox.setPadding(new Insets(16.0));
                detailBox.setStyle("-fx-background-color: white; -fx-border-color: #cccccc; -fx-border-radius: 0; -fx-border-width: 1;");
                HBox.setHgrow((Node)detailBox, (Priority)Priority.ALWAYS);
                ThemisAttributeFxPanel panel = this.getAttributePanel((CmsElement)newItem.getValue());
                detailBox.getChildren().add((Object)panel);
                GridPane.setFillHeight((Node)detailBox, (Boolean)Boolean.TRUE);
                GridPane.setFillWidth((Node)detailBox, (Boolean)Boolean.TRUE);
                this.add((Node)detailBox, 1, 0);
            }
        });
        result.setOnKeyReleased(event -> {
            if (event.getCode().equals((Object)KeyCode.DELETE)) {
                this.delete();
            }
        });
        result.setCellFactory((Callback)new Callback<TreeView<CmsElement>, TreeCell<CmsElement>>(){
            private TreeItem<CmsElement> draggedItem;
            private TreeCell<CmsElement> dropZone;

            public TreeCell<CmsElement> call(TreeView<CmsElement> view) {
                TemplateEditorTreeCell cell = new TemplateEditorTreeCell(){

                    @Override
                    public void addNew(TemplateEditorTreeCell parentCell, String type) {
                        if (!TemplateEditorPane.this.isFiltered()) {
                            CmsElement ele = TemplateEditorPane.this.project.createElement(type, TemplateEditorPane.this.project.getUser());
                            TreeItem newItem = new TreeItem((Object)ele);
                            TreeItem parentItem = parentCell.getTreeItem();
                            if ("observationtemplate".equals(ele.getElementcode())) {
                                TreeItem child;
                                int lastObsIndex = 0;
                                Iterator iterator = parentItem.getChildren().iterator();
                                while (iterator.hasNext() && "observationtemplate".equals(((CmsElement)(child = (TreeItem)iterator.next()).getValue()).getElementcode())) {
                                    ++lastObsIndex;
                                }
                                parentItem.getChildren().add(lastObsIndex, (Object)newItem);
                            } else if ("locationtemplate".equals(ele.getElementcode())) {
                                TreeItem child;
                                int lastLocIndex = 0;
                                Iterator iterator = parentItem.getChildren().iterator();
                                while (iterator.hasNext() && !"locationgroup".equals(((CmsElement)(child = (TreeItem)iterator.next()).getValue()).getElementcode())) {
                                    ++lastLocIndex;
                                }
                                parentItem.getChildren().add(lastLocIndex, (Object)newItem);
                            } else {
                                parentItem.getChildren().add((Object)newItem);
                            }
                            TemplateEditorPane.this.treeView.getSelectionModel().select((Object)newItem);
                        } else {
                            Dialogs.showWarningDialog((String)"Bitte l\u00f6schen Sie zuerst den Filter!");
                        }
                    }
                };
                cell.setOnDragDetected(event -> {
                    this.draggedItem = cell.getTreeItem();
                    if (null != this.draggedItem) {
                        view.startFullDrag();
                        event.consume();
                    }
                });
                cell.setOnMouseDragOver(event -> {
                    TreeItem targetItem;
                    if (null != this.dropZone) {
                        this.dropZone.setStyle(this.getDefaultStyle((CmsElement)this.dropZone.getItem()));
                    }
                    if (null == (targetItem = cell.getTreeItem())) {
                        return;
                    }
                    if (targetItem.equals(this.draggedItem)) {
                        return;
                    }
                    this.dropZone = cell;
                    if (null != this.dropZone) {
                        boolean putAfter;
                        String color = event.isControlDown() ? "#222D53A0" : "#EB9125A0";
                        Point2D sceneCoordinates = cell.localToScene(0.0, 0.0);
                        double height = cell.getHeight();
                        double y = event.getSceneY() - sceneCoordinates.getY();
                        boolean putBefore = y < height * 0.25;
                        boolean putInside = y >= height * 0.25 && y <= height * 0.75;
                        boolean bl = putAfter = y > height * 0.75;
                        if (this.isDraggable((TreeItem<CmsElement>)targetItem, putBefore, putInside, putAfter)) {
                            CmsElement targetElement = (CmsElement)targetItem.getValue();
                            if (putInside) {
                                this.dropZone.setStyle("-fx-background-color: " + color + "; -fx-text-color: white; -fx-padding: " + this.getPadding(targetElement));
                            } else if (putBefore) {
                                this.dropZone.setStyle("-fx-border-color: " + color + " white #cccccc white; -fx-border-width: 1 0 1 0; -fx-padding: " + this.getPadding(targetElement));
                            } else if (putAfter) {
                                this.dropZone.setStyle("-fx-border-color: " + color + "; -fx-border-width: 0 0 1 0; -fx-padding: " + this.getPadding(targetElement));
                            }
                        }
                    }
                });
                cell.setOnMouseDragReleased(event -> {
                    TreeItem targetItem;
                    if (null != this.dropZone) {
                        this.dropZone.setStyle(this.getDefaultStyle((CmsElement)this.dropZone.getItem()));
                    }
                    if (null == (targetItem = cell.getTreeItem())) {
                        return;
                    }
                    if (targetItem.equals(this.draggedItem)) {
                        return;
                    }
                    if (null != this.dropZone) {
                        boolean putAfter;
                        Point2D sceneCoordinates = cell.localToScene(0.0, 0.0);
                        double height = cell.getHeight();
                        double y = event.getSceneY() - sceneCoordinates.getY();
                        boolean putBefore = y < height * 0.25;
                        boolean putInside = y >= height * 0.25 && y <= height * 0.75;
                        boolean bl = putAfter = y > height * 0.75;
                        if (this.isDraggable((TreeItem<CmsElement>)targetItem, putBefore, putInside, putAfter)) {
                            if (!event.isControlDown()) {
                                this.draggedItem.getParent().getChildren().remove(this.draggedItem);
                            } else {
                                this.draggedItem = TemplateEditorPane.this.copyTreeItem((TreeItem<CmsElement>)this.draggedItem);
                            }
                            if (putInside) {
                                if ("observationtemplate".equals(((CmsElement)this.draggedItem.getValue()).getElementcode())) {
                                    TreeItem child;
                                    int lastObsIndex = 0;
                                    Iterator iterator = targetItem.getChildren().iterator();
                                    while (iterator.hasNext() && "observationtemplate".equals(((CmsElement)(child = (TreeItem)iterator.next()).getValue()).getElementcode())) {
                                        ++lastObsIndex;
                                    }
                                    targetItem.getChildren().add(lastObsIndex, this.draggedItem);
                                } else if ("locationtemplate".equals(((CmsElement)this.draggedItem.getValue()).getElementcode())) {
                                    TreeItem child;
                                    int lastLocIndex = 0;
                                    Iterator iterator = targetItem.getChildren().iterator();
                                    while (iterator.hasNext() && !"locationgroup".equals(((CmsElement)(child = (TreeItem)iterator.next()).getValue()).getElementcode())) {
                                        ++lastLocIndex;
                                    }
                                    targetItem.getChildren().add(lastLocIndex, this.draggedItem);
                                } else {
                                    targetItem.getChildren().add(this.draggedItem);
                                }
                            } else if (putBefore) {
                                int index = targetItem.getParent().getChildren().indexOf((Object)targetItem);
                                targetItem.getParent().getChildren().add(index, this.draggedItem);
                            } else if (putAfter) {
                                int index = targetItem.getParent().getChildren().indexOf((Object)targetItem);
                                targetItem.getParent().getChildren().add(index + 1, this.draggedItem);
                            }
                            view.getSelectionModel().select(this.draggedItem);
                        }
                    }
                });
                cell.setOnMouseDragEntered(event -> {
                    if (null != this.dropZone) {
                        this.dropZone.setStyle(this.getDefaultStyle((CmsElement)this.dropZone.getItem()));
                    }
                });
                cell.setOnDragExited(event -> {
                    if (null != this.dropZone) {
                        this.dropZone.setStyle(this.getDefaultStyle((CmsElement)this.dropZone.getItem()));
                    }
                });
                return cell;
            }

            private String getDefaultStyle(CmsElement element) {
                String style = "-fx-border-color: #e5e5e5; -fx-border-width: 0 0 1 0;";
                if (element != null && "locationgroup".equals(element.getElementcode())) {
                    style = style + " -fx-font-weight: bold;";
                }
                style = style + " -fx-padding: " + this.getPadding(element);
                return style;
            }

            private String getPadding(CmsElement element) {
                String result = "8 8 8 0";
                if (element != null) {
                    if ("observationtemplate".equals(element.getElementcode())) {
                        result = "8 8 8 20";
                    } else if ("measuretemplate".equals(element.getElementcode())) {
                        result = "8 8 8 40";
                    }
                }
                return result;
            }

            private boolean isDraggable(TreeItem<CmsElement> targetItem, boolean putBefore, boolean putInside, boolean putAfter) {
                boolean result = true;
                CmsElement targetElement = (CmsElement)targetItem.getValue();
                if (null == targetElement) {
                    result = false;
                } else {
                    CmsElement draggedElement = (CmsElement)this.draggedItem.getValue();
                    CmsElement parentElement = null;
                    CmsElement prevElement = null;
                    CmsElement nextElement = null;
                    TreeItem parentItem = targetItem.getParent();
                    if (null != parentItem) {
                        TreeItem nextItem;
                        int nextIndex;
                        TreeItem prevItem;
                        parentElement = (CmsElement)parentItem.getValue();
                        int index = parentItem.getChildren().indexOf(targetItem);
                        int prevIndex = index - 1;
                        if (prevIndex > 0 && null != (prevItem = (TreeItem)parentItem.getChildren().get(prevIndex))) {
                            prevElement = (CmsElement)prevItem.getValue();
                        }
                        if ((nextIndex = index + 1) < parentItem.getChildren().size() && null != (nextItem = (TreeItem)parentItem.getChildren().get(nextIndex))) {
                            nextElement = (CmsElement)nextItem.getValue();
                        }
                    }
                    if (TemplateEditorPane.this.isFiltered()) {
                        result = false;
                    } else if (this.draggedItem.getParent() == null) {
                        result = false;
                    } else if (this.isParent(this.draggedItem, targetItem)) {
                        result = false;
                    } else if (targetElement.getId() == draggedElement.getId()) {
                        result = false;
                    } else if ("locationgroup".equals(draggedElement.getElementcode())) {
                        if (putInside) {
                            if (!"locationgroup".equals(targetElement.getElementcode())) {
                                result = false;
                            }
                            if (this.getParentCount(targetItem) + this.getMaxChildGroupDepth(this.draggedItem) > 2) {
                                result = false;
                            }
                        } else {
                            if (this.getParentCount(targetItem) + this.getMaxChildGroupDepth(this.draggedItem) > 3) {
                                result = false;
                            }
                            if (null == targetItem.getParent()) {
                                result = false;
                            }
                            if (null != parentElement && !"locationgroup".equals(parentElement.getElementcode())) {
                                result = false;
                            }
                        }
                    } else if ("locationtemplate".equals(draggedElement.getElementcode())) {
                        if (putInside) {
                            if (!"locationgroup".equals(targetElement.getElementcode())) {
                                result = false;
                            }
                        } else {
                            if (null == targetItem.getParent()) {
                                result = false;
                            }
                            if (null != parentElement && !"locationgroup".equals(parentElement.getElementcode())) {
                                result = false;
                            }
                        }
                    } else if ("observationtemplate".equals(draggedElement.getElementcode())) {
                        if (putInside) {
                            if ("observationtemplate".equals(targetElement.getElementcode())) {
                                result = false;
                            }
                            if ("measuretemplate".equals(targetElement.getElementcode())) {
                                result = false;
                            }
                        } else {
                            if (null == targetItem.getParent()) {
                                result = false;
                            }
                            if (null != parentElement) {
                                if ("observationtemplate".equals(parentElement.getElementcode())) {
                                    result = false;
                                }
                                if ("measuretemplate".equals(parentElement.getElementcode())) {
                                    result = false;
                                }
                            }
                        }
                    } else if ("measuretemplate".equals(draggedElement.getElementcode())) {
                        if (putInside) {
                            if (!"observationtemplate".equals(targetElement.getElementcode())) {
                                result = false;
                            }
                        } else {
                            if (null == targetItem.getParent()) {
                                result = false;
                            }
                            if (null != parentElement && !"observationtemplate".equals(parentElement.getElementcode())) {
                                result = false;
                            }
                        }
                    }
                }
                return result;
            }

            private int getParentCount(TreeItem<CmsElement> child) {
                int result = 0;
                for (TreeItem parent = child.getParent(); null != parent && null != parent.getValue(); parent = parent.getParent()) {
                    ++result;
                }
                return result;
            }

            private int getMaxChildGroupDepth(TreeItem<CmsElement> item) {
                int result = 0;
                for (TreeItem child : item.getChildren()) {
                    int childDepth = 0;
                    if ("locationgroup".equals(((CmsElement)child.getValue()).getElementcode())) {
                        ++childDepth;
                        childDepth += this.getMaxChildGroupDepth((TreeItem<CmsElement>)child);
                    }
                    if (result >= childDepth) continue;
                    result = childDepth;
                }
                return result;
            }

            private boolean isParent(TreeItem<CmsElement> dragged, TreeItem<CmsElement> target) {
                boolean result = false;
                for (TreeItem targetParent = target.getParent(); !result && null != targetParent && null != targetParent.getValue(); targetParent = targetParent.getParent()) {
                    CmsElement draggedElement = (CmsElement)dragged.getValue();
                    if (null == draggedElement) continue;
                    result = draggedElement.getId() == ((CmsElement)targetParent.getValue()).getId();
                }
                return result;
            }
        });
        return result;
    }

    private void updateRelation(CmsElement ele, CmsElement parent) {
        switch (ele.getElementcode()) {
            case "locationgroup": {
                if (ele.hasAttributeValue("parentgroup")) {
                    ele.getLongAttribute("parentgroup").clear();
                }
                if (null == parent) break;
                ele.getLongAttribute("parentgroup").setValue(parent.getId());
                break;
            }
            case "locationtemplate": {
                if (ele.hasAttributeValue("locationgroup")) {
                    ele.getRelationAttribute("locationgroup").clear();
                }
                if (null == parent) break;
                ele.getRelationAttribute("locationgroup").set(parent.getId());
                break;
            }
            case "observationtemplate": {
                if (ele.hasAttributeValue("locationgroup")) {
                    ele.getRelationAttribute("locationgroup").clear();
                }
                if (ele.hasAttributeValue("location")) {
                    ele.getRelationAttribute("location").clear();
                }
                if (null != parent) {
                    if ("locationgroup".equals(parent.getElementcode())) {
                        ele.getRelationAttribute("locationgroup").set(parent.getId());
                    } else if ("locationtemplate".equals(parent.getElementcode())) {
                        ele.getRelationAttribute("location").set(parent.getId());
                    }
                }
                ((CmsObservationTemplate)ele).setAttributeVisibility();
                break;
            }
            case "measuretemplate": {
                if (ele.hasAttributeValue("observationtemplate")) {
                    ele.getRelationAttribute("observationtemplate").clear();
                }
                if (null == parent || !"observationtemplate".equals(parent.getElementcode())) break;
                ele.getRelationAttribute("observationtemplate").set(parent.getId());
                break;
            }
        }
    }

    private TreeItem<CmsElement> copyTreeItem(TreeItem<CmsElement> item) {
        TreeItem result = new TreeItem((Object)((CmsElement)item.getValue()).copy());
        for (TreeItem child : item.getChildren()) {
            result.getChildren().add(this.copyTreeItem((TreeItem<CmsElement>)child));
        }
        return result;
    }

    private boolean isFiltered() {
        return null != this.searchField && !"".equals(this.searchField.getText());
    }

    private ThemisAttributeFxPanel getAttributePanel(CmsElement element) {
        if (this.attributePanel == null) {
            this.attributePanel = new ThemisAttributeFxPanel(element);
            this.attributePanel.setPadding(Insets.EMPTY);
            this.attributePanel.setFitToHeight(true);
            this.attributePanel.setFitToWidth(true);
            this.attributePanel.setStyle("-fx-background-color: #ffffff; -fx-border-color: #cccccc; -fx-border-width: 1;");
            VBox.setVgrow((Node)this.attributePanel, (Priority)Priority.ALWAYS);
            this.attributePanel.populate();
        } else {
            this.attributePanel.populate(element);
        }
        return this.attributePanel;
    }

    private ArrayList<TreeItem<CmsElement>> generateGroups(List<DataRecord> recs) {
        ArrayList<TreeItem<CmsElement>> result = new ArrayList<TreeItem<CmsElement>>();
        for (DataRecord rc : recs) {
            CmsElement group = this.project.loadElement(rc.getLong("meta_id"), this.project.getUser());
            TreeItem groupItem = new TreeItem((Object)group);
            ArrayList<TreeItem<CmsElement>> obsTemplates = this.generateObservations(this.manager.getObservationTemplates(group.getId(), -1L));
            groupItem.getChildren().addAll(obsTemplates);
            ArrayList<TreeItem<CmsElement>> locTemplates = this.generateLocations(this.manager.getLocationTemplates(group.getId()));
            groupItem.getChildren().addAll(locTemplates);
            ArrayList<TreeItem<CmsElement>> children = this.generateGroups(this.manager.getLocationGroups(group.getId()));
            groupItem.getChildren().addAll(children);
            result.add((TreeItem<CmsElement>)groupItem);
        }
        return result;
    }

    private ArrayList<TreeItem<CmsElement>> generateLocations(List<DataRecord> recs) {
        ArrayList<TreeItem<CmsElement>> result = new ArrayList<TreeItem<CmsElement>>();
        for (DataRecord rc : recs) {
            CmsElement loc = this.project.loadElement(rc.getLong("meta_id"), this.project.getUser());
            TreeItem locItem = new TreeItem((Object)loc);
            ArrayList<TreeItem<CmsElement>> obsTemplates = this.generateObservations(this.manager.getObservationTemplates(-1L, loc.getId()));
            locItem.getChildren().addAll(obsTemplates);
            result.add((TreeItem<CmsElement>)locItem);
        }
        return result;
    }

    private ArrayList<TreeItem<CmsElement>> generateObservations(List<DataRecord> recs) {
        ArrayList<TreeItem<CmsElement>> result = new ArrayList<TreeItem<CmsElement>>();
        for (DataRecord rc : recs) {
            CmsElement obs = this.project.loadElement(rc.getLong("meta_id"), this.project.getUser());
            TreeItem obsItem = new TreeItem((Object)obs);
            ArrayList<TreeItem<CmsElement>> msrTemplates = this.generateMeasures(this.manager.getMeasureTemplates(obs.getId()));
            obsItem.getChildren().addAll(msrTemplates);
            result.add((TreeItem<CmsElement>)obsItem);
        }
        return result;
    }

    private ArrayList<TreeItem<CmsElement>> generateMeasures(List<DataRecord> recs) {
        ArrayList<TreeItem<CmsElement>> result = new ArrayList<TreeItem<CmsElement>>();
        for (DataRecord rc : recs) {
            CmsElement msr = this.project.loadElement(rc.getLong("meta_id"), this.project.getUser());
            TreeItem msrItem = new TreeItem((Object)msr);
            result.add((TreeItem<CmsElement>)msrItem);
        }
        return result;
    }

    private GridPane generateButtonGrid() {
        GridPane result = new GridPane();
        VBox.setVgrow((Node)result, (Priority)Priority.NEVER);
        ColumnConstraints cc = new ColumnConstraints();
        cc.setPercentWidth(20.0);
        result.getColumnConstraints().add((Object)cc);
        result.getColumnConstraints().add((Object)cc);
        result.getColumnConstraints().add((Object)cc);
        result.getColumnConstraints().add((Object)cc);
        result.getColumnConstraints().add((Object)cc);
        RowConstraints rc = new RowConstraints();
        rc.setMinHeight(50.0);
        rc.setMaxHeight(50.0);
        rc.setPrefHeight(50.0);
        result.getRowConstraints().add((Object)rc);
        Button upBtn = this.generateIconButton("up.png");
        upBtn.setOnAction(event -> this.moveUp());
        Button downBtn = this.generateIconButton("down.png");
        downBtn.setOnAction(event -> this.moveDown());
        Button copyBtn = this.generateIconButton("copy.png");
        copyBtn.setOnAction(event -> this.duplicate());
        Button deleteBtn = this.generateIconButton("delete.png");
        deleteBtn.setOnAction(event -> this.delete());
        result.addRow(0, new Node[]{upBtn, downBtn, new Region(), copyBtn, deleteBtn});
        return result;
    }

    private void delete() {
        if (null != this.treeView) {
            if (!this.isFiltered()) {
                boolean delete;
                TreeItem selectedItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
                if (null != selectedItem && null != selectedItem.getParent() && (delete = Dialogs.showConfirmDialog((String)("\"" + ((CmsElement)selectedItem.getValue()).getTitle() + "\" wirklich l\u00f6schen?")))) {
                    selectedItem.getParent().getChildren().remove((Object)selectedItem);
                    this.elementsToBeDeleted.add((CmsElement)selectedItem.getValue());
                }
            } else {
                Dialogs.showWarningDialog((String)"Bitte l\u00f6schen Sie zuerst den Filter!");
            }
            this.treeView.requestFocus();
        }
    }

    private void duplicate() {
        if (null != this.treeView) {
            if (!this.isFiltered()) {
                TreeItem parent;
                TreeItem selectedItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
                if (null != selectedItem && null != (parent = selectedItem.getParent())) {
                    TreeItem<CmsElement> copy = this.copyTreeItem((TreeItem<CmsElement>)selectedItem);
                    int selectedIndex = parent.getChildren().indexOf((Object)selectedItem);
                    parent.getChildren().add(selectedIndex + 1, copy);
                    this.treeView.getSelectionModel().select(copy);
                    this.treeView.scrollTo(selectedIndex);
                }
            } else {
                Dialogs.showWarningDialog((String)"Bitte l\u00f6schen Sie zuerst den Filter!");
            }
            this.treeView.requestFocus();
        }
    }

    private void moveUp() {
        if (null != this.treeView) {
            if (!this.isFiltered()) {
                int selectedIndex;
                TreeItem parent;
                TreeItem selectedItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
                if (null != selectedItem && null != (parent = selectedItem.getParent()) && (selectedIndex = parent.getChildren().indexOf((Object)selectedItem)) > 0) {
                    CmsElement prevElement = (CmsElement)((TreeItem)parent.getChildren().get(selectedIndex - 1)).getValue();
                    if (((CmsElement)selectedItem.getValue()).getElementcode().equals(prevElement.getElementcode())) {
                        parent.getChildren().remove((Object)selectedItem);
                        parent.getChildren().add(selectedIndex - 1, (Object)selectedItem);
                        this.treeView.getSelectionModel().select((Object)selectedItem);
                        this.treeView.scrollTo(selectedIndex - 1);
                    }
                }
            } else {
                Dialogs.showWarningDialog((String)"Bitte l\u00f6schen Sie zuerst den Filter!");
            }
            this.treeView.requestFocus();
        }
    }

    private void moveDown() {
        if (null != this.treeView) {
            if (!this.isFiltered()) {
                int selectedIndex;
                TreeItem parent;
                TreeItem selectedItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
                if (null != selectedItem && null != (parent = selectedItem.getParent()) && (selectedIndex = parent.getChildren().indexOf((Object)selectedItem)) < parent.getChildren().size() - 1) {
                    CmsElement nextElement = (CmsElement)((TreeItem)parent.getChildren().get(selectedIndex + 1)).getValue();
                    if (((CmsElement)selectedItem.getValue()).getElementcode().equals(nextElement.getElementcode())) {
                        parent.getChildren().remove((Object)selectedItem);
                        parent.getChildren().add(selectedIndex + 1, (Object)selectedItem);
                        this.treeView.getSelectionModel().select((Object)selectedItem);
                        this.treeView.scrollTo(selectedIndex + 1);
                    }
                }
            } else {
                Dialogs.showWarningDialog((String)"Bitte l\u00f6schen Sie zuerst den Filter!");
            }
            this.treeView.requestFocus();
        }
    }

    private Button generateIconButton(String icon) {
        Button result = new Button();
        result.setGraphic((Node)new ImageView(new Image(TemplateEditorPane.class.getResourceAsStream("media/" + icon), 20.0, 20.0, true, true)));
        result.setMaxHeight(Double.MAX_VALUE);
        result.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)result, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)result, (Priority)Priority.ALWAYS);
        return result;
    }

    public void populate() {
        Task<Void> initializationTask = new Task<Void>(){

            protected Void call() throws Exception {
                CmsElement rootElement = TemplateEditorPane.this.project.getDefaultElement("locationgroup");
                rootElement.setAttributeValue("title", "Textvorlagen");
                TemplateEditorPane.this.tree = new TreeItem((Object)rootElement);
                TemplateEditorPane.this.tree.setExpanded(true);
                TemplateEditorPane.this.tree.expandedProperty().addListener((ov, oldValue, newValue) -> {
                    if (!newValue.booleanValue()) {
                        TemplateEditorPane.this.tree.setExpanded(true);
                    }
                });
                ArrayList observations = TemplateEditorPane.this.generateObservations(TemplateEditorPane.this.manager.getObservationTemplates(-1L, -1L));
                TemplateEditorPane.this.tree.getChildren().addAll((Collection)observations);
                ArrayList locations = TemplateEditorPane.this.generateLocations(TemplateEditorPane.this.manager.getLocationTemplates(-1L));
                TemplateEditorPane.this.tree.getChildren().addAll((Collection)locations);
                ArrayList groups = TemplateEditorPane.this.generateGroups(TemplateEditorPane.this.manager.getLocationGroups());
                TemplateEditorPane.this.tree.getChildren().addAll((Collection)groups);
                return null;
            }
        };
        initializationTask.setOnSucceeded(t -> {
            this.treeView = this.generateTreeView();
            this.treeView.setRoot(this.tree);
            this.treeBox.getChildren().remove((Object)this.loadingBox);
            this.treeBox.getChildren().add(1, this.treeView);
        });
        Thread initializationThread = new Thread((Runnable)initializationTask);
        initializationThread.start();
    }

    public void applyToTemplates() {
        if (null != this.treeView) {
            this.treeView.getSelectionModel().select(null);
            this.applyItem((TreeItem<CmsElement>)this.treeView.getRoot(), 0);
            for (CmsElement element : this.elementsToBeDeleted) {
                element.remove();
            }
        }
    }

    private int applyItem(TreeItem<CmsElement> baseitem, int counter) {
        if (null != baseitem.getParent()) {
            CmsElement ele = (CmsElement)baseitem.getValue();
            ele.setAttributeValue("itemsort", Integer.toString(counter));
            CmsElement parentEle = null;
            if (baseitem.getParent().getParent() != null) {
                parentEle = (CmsElement)baseitem.getParent().getValue();
            }
            this.updateRelation(ele, parentEle);
            ele.save();
            ++counter;
        }
        ObservableList items = baseitem.getChildren();
        for (TreeItem item : items) {
            counter = this.applyItem((TreeItem<CmsElement>)item, counter);
        }
        return counter;
    }
}

