/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.templateeditor;

import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

abstract class TemplateEditorTreeCell
extends TreeCell<CmsElement> {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();

    public TemplateEditorTreeCell() {
        this.setAlignment(Pos.CENTER_LEFT);
    }

    public void updateItem(CmsElement item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.clearCell();
        } else {
            this.updateCell(item);
        }
    }

    private void clearCell() {
        this.setText(null);
        this.setGraphic(null);
        this.setStyle(null);
    }

    private void updateCell(CmsElement item) {
        int dimIcon = 20;
        if (null != item) {
            String type;
            MenuItem groupItem = new MenuItem("Gruppe");
            groupItem.setOnAction(event -> this.addNew(this, "locationgroup"));
            MenuItem locationItem = new MenuItem("Gegenstand");
            locationItem.setOnAction(event -> this.addNew(this, "locationtemplate"));
            MenuItem observationItem = new MenuItem("Beobachtung");
            observationItem.setOnAction(event -> this.addNew(this, "observationtemplate"));
            MenuItem measureItem = new MenuItem("Ma\u00dfnahme");
            measureItem.setOnAction(event -> this.addNew(this, "measuretemplate"));
            String itemPadding = "8 8 8 0";
            ArrayList<MenuItem> menus = new ArrayList<MenuItem>();
            Image image = null;
            boolean boldItem = false;
            switch (type = item.getElementcode()) {
                case "locationgroup": {
                    if (this.countParents(this) < 3) {
                        menus.add(groupItem);
                    }
                    menus.add(locationItem);
                    menus.add(observationItem);
                    boldItem = true;
                    break;
                }
                case "locationtemplate": {
                    try {
                        String imagePath = item.getAttributeValue("iconfile");
                        if (imagePath != null && !"".equals(imagePath)) {
                            File f = new File(this.project.getFileLocation("icon"), imagePath);
                            image = new Image((InputStream)new FileInputStream(f), (double)dimIcon, (double)dimIcon, true, true);
                        }
                    }
                    catch (IOException imagePath) {
                        // empty catch block
                    }
                    menus.add(observationItem);
                    break;
                }
                case "observationtemplate": {
                    itemPadding = "8 8 8 20";
                    String icon = "default_marker.png";
                    KeyAttribute observationType = item.getKeyAttribute("type");
                    switch ((int)observationType.getId()) {
                        case 1: {
                            icon = "defect_marker.png";
                            break;
                        }
                        case 2: {
                            icon = "check_marker.png";
                            break;
                        }
                        case 3: {
                            icon = "info_marker.png";
                            break;
                        }
                        case 4: {
                            icon = "task_marker.png";
                        }
                    }
                    image = new Image(TemplateEditorTreeCell.class.getResourceAsStream("media/" + icon), (double)(dimIcon - 5), (double)(dimIcon - 5), true, true);
                    if (!this.app.getSettings().getObservationAttribute("measure").isUsed()) break;
                    menus.add(measureItem);
                    break;
                }
                case "measuretemplate": {
                    itemPadding = "8 8 8 40";
                }
            }
            this.setStyle("-fx-padding: " + itemPadding + "; -fx-border-color: #e5e5e5; -fx-border-width: 0 0 1 0; " + (boldItem ? "-fx-font-weight: bold;" : ""));
            HBox box = new HBox();
            box.setMaxWidth(Double.MAX_VALUE);
            box.setAlignment(Pos.CENTER_LEFT);
            box.setPadding(Insets.EMPTY);
            box.setSpacing(10.0);
            if (null != image) {
                box.getChildren().add((Object)new ImageView(image));
            }
            Label titleLabel = new Label(item.getTitle());
            box.getChildren().add((Object)titleLabel);
            Region region = new Region();
            HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
            box.getChildren().add((Object)region);
            if (!menus.isEmpty()) {
                MenuButton button = new MenuButton();
                button.setMinWidth(50.0);
                button.setGraphic((Node)new ImageView(new Image(TemplateEditorTreeCell.class.getResourceAsStream("media/add.png"), 20.0, 20.0, true, true)));
                button.getItems().addAll(menus);
                box.getChildren().add((Object)button);
            }
            this.setGraphic((Node)box);
        }
    }

    private int countParents(TemplateEditorTreeCell cell) {
        int result = 0;
        for (TreeItem parent = cell.getTreeItem().getParent(); null != parent; parent = parent.getParent()) {
            ++result;
        }
        return result;
    }

    public abstract void addNew(TemplateEditorTreeCell var1, String var2);
}

