/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.util;

import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.javafx.JavaFxDialogs;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.JavaFxIcon;
import at.grid.themis.ontology.javafx.util.DirectoryChangeListener;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class DirectoryTreeFxPane
extends VBox {
    private final TreeView<File> tree = new TreeView();
    private File rootFolder;
    private File selectedFolder;
    private int maxLevel = 1;
    private List<DirectoryChangeListener> listeners = new ArrayList<DirectoryChangeListener>();

    public DirectoryTreeFxPane() {
        this.setPadding(new Insets(10.0));
        this.setSpacing(10.0);
        this.tree.setCellFactory(p -> {
            TreeCell<File> cell = new TreeCell<File>(){

                protected void updateItem(File item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    String style = "-fx-font: 22px \"Calibri\";";
                    if (empty || item == null) {
                        this.setText("");
                        this.setGraphic(null);
                    } else {
                        String name = item.getName();
                        if (name == null || name.trim().isEmpty()) {
                            name = item.getAbsolutePath();
                        }
                        this.setText(name);
                        this.setGraphic((Node)new JavaFxIcon(JavaFxIcon.FOLDER_OUTLINED, (Paint)Color.BLACK, 24.0));
                        if (DirectoryTreeFxPane.this.selectedFolder != null && DirectoryTreeFxPane.this.selectedFolder.getAbsolutePath().equals(item.getAbsolutePath())) {
                            style = style + "-fx-text-fill: black; -fx-background-color: #c8c8c8;";
                        }
                    }
                    this.setStyle(style);
                }
            };
            cell.setOnMousePressed(arg_0 -> this.lambda$null$4((TreeCell)cell, arg_0));
            return cell;
        });
        VBox.setVgrow(this.tree, (Priority)Priority.ALWAYS);
        this.getChildren().add(this.tree);
        HBox buttonBox = new HBox();
        buttonBox.setSpacing(10.0);
        buttonBox.setAlignment(Pos.CENTER_RIGHT);
        Button btnSelect = JavaFxFactory.createSvgButton(JavaFxIcon.FOLDER_OUTLINED, this::selectRootFolder);
        buttonBox.getChildren().add((Object)btnSelect);
        Button btnRefresh = JavaFxFactory.createSvgButton(JavaFxIcon.AUTO_RENEW, this::refresh);
        buttonBox.getChildren().add((Object)btnRefresh);
        this.getChildren().add((Object)buttonBox);
    }

    private void refresh(Event event) {
        this.populate();
        this.tree.getSelectionModel().selectFirst();
        this.setSelectedFolder(this.rootFolder);
    }

    private void setSelectedFolder(File folder) {
        this.selectedFolder = folder;
        for (DirectoryChangeListener listener : this.listeners) {
            listener.onDirectoryChanged(this.selectedFolder);
        }
    }

    private void selectRootFolder(Event event) {
        File newRootFolder = JavaFxDialogs.showDirectoryChooser(this.rootFolder);
        if (newRootFolder != null) {
            this.setRootFolder(newRootFolder);
        }
    }

    private void populate() {
        if (this.rootFolder == null) {
            return;
        }
        TreeItem item = new TreeItem((Object)this.rootFolder);
        item.setExpanded(true);
        this.tree.setRoot(item);
        this.createTree((TreeItem<File>)item, 0);
    }

    private void createTree(TreeItem<File> item, int level) {
        if (item == null || item.getValue() == null || level > this.maxLevel) {
            return;
        }
        Runnable r = () -> {
            File[] array = ((File)item.getValue()).listFiles(file -> file.isDirectory() && !file.isHidden() && !ThemisProject.isProjectFolder(file));
            if (array == null) {
                return;
            }
            List<File> subFolder = Arrays.asList(array);
            ObservableList existing = item.getChildren();
            ArrayList<TreeItem> remove = new ArrayList<TreeItem>();
            for (TreeItem ex : existing) {
                if (subFolder.stream().filter(f -> f.getAbsolutePath().equals(((File)ex.getValue()).getAbsolutePath())).findAny().isPresent()) continue;
                remove.add(ex);
            }
            ArrayList<TreeItem> newItems = new ArrayList<TreeItem>();
            for (File folder : subFolder) {
                TreeItem subItem;
                Optional<TreeItem> found = existing.stream().filter(t -> ((File)t.getValue()).getAbsolutePath().equals(folder.getAbsolutePath())).findAny();
                if (found.isPresent()) {
                    subItem = found.get();
                } else {
                    subItem = new TreeItem((Object)folder);
                    newItems.add(subItem);
                }
                int newLevel = level + 1;
                this.createTree((TreeItem<File>)subItem, newLevel);
            }
            Platform.runLater(() -> {
                remove.forEach(i -> item.getChildren().remove(i));
                newItems.forEach(i -> item.getChildren().add(i));
                item.getChildren().sort((a, b) -> ((File)a.getValue()).getAbsolutePath().compareToIgnoreCase(((File)b.getValue()).getAbsolutePath()));
            });
        };
        new Thread(r).start();
    }

    public void setRootFolder(File rootFolder) {
        this.rootFolder = rootFolder;
        this.maxLevel = ThemisUtil.isOnNetworkDrive(this.rootFolder) ? 1 : 2;
        this.populate();
    }

    public void registerListener(DirectoryChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void unregisterListener(DirectoryChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private /* synthetic */ void lambda$null$4(TreeCell cell, MouseEvent event) {
        TreeItem item = cell.getTreeItem();
        if (item != null) {
            this.setSelectedFolder((File)item.getValue());
            boolean expanded = ((File)item.getValue()).getAbsolutePath().equalsIgnoreCase(this.rootFolder.getAbsolutePath()) || !item.isExpanded() || !((File)item.getValue()).getAbsolutePath().equalsIgnoreCase(this.selectedFolder.getAbsolutePath());
            item.setExpanded(expanded);
            if (item.isExpanded()) {
                this.createTree((TreeItem<File>)item, 0);
            }
            this.tree.refresh();
        }
        if (event.isSecondaryButtonDown()) {
            MenuItem menuItem;
            ContextMenu menu = new ContextMenu();
            if (!((File)item.getValue()).equals(this.rootFolder)) {
                menuItem = new MenuItem();
                menuItem.setStyle("-fx-font: 14px \"Calibri\";");
                menuItem.setText("Als Verzeichnis w\u00e4hlen");
                menuItem.setOnAction(t -> this.setRootFolder((File)item.getValue()));
                menu.getItems().add((Object)menuItem);
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            menuItem = new MenuItem();
            menuItem.setStyle("-fx-font: 14px \"Calibri\";");
            menuItem.setText("Ordner anlegen");
            menuItem.setOnAction(t -> {
                String fn = JavaFxDialogs.showInputDialog("Neuen Ordner anlegen");
                if (fn == null || fn.trim().isEmpty()) {
                    return;
                }
                File newFolder = new File((File)item.getValue(), fn);
                if (!newFolder.exists()) {
                    newFolder.mkdirs();
                }
                this.createTree((TreeItem<File>)item, 0);
            });
            menu.getItems().add((Object)menuItem);
            if (((File)item.getValue()).listFiles().length == 0) {
                menuItem = new MenuItem();
                menuItem.setStyle("-fx-font: 14px \"Calibri\";");
                menuItem.setText("Ordner l\u00f6schen");
                menuItem.setOnAction(t -> {
                    ((File)item.getValue()).delete();
                    this.createTree((TreeItem<File>)item.getParent(), 0);
                });
                menu.getItems().add((Object)menuItem);
            }
            menuItem = new MenuItem();
            menuItem.setStyle("-fx-font: 14px \"Calibri\";");
            menuItem.setText("Ordner anzeigen");
            menuItem.setOnAction(t -> {
                try {
                    Desktop.getDesktop().open((File)item.getValue());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            menu.getItems().add((Object)menuItem);
            menu.show((Node)cell, event.getScreenX(), event.getScreenY());
        }
    }
}

