/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.javafx.wizard;

import at.grid.themis.ontology.javafx.wizard.JavaFxPage;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;

public abstract class JavaFxPageListPane
extends HBox {
    private JavaFxPage selected;
    private final ListView<JavaFxPage> list = new ListView();
    private final ScrollPane pageScroll = new ScrollPane();
    private final HBox buttonBox = new HBox();
    JFXPanel fxPanel = null;

    public JavaFxPageListPane() {
        this.render();
    }

    public void setFxPanel(JFXPanel p) {
        this.fxPanel = p;
    }

    public Window getWindow() {
        Scene scene;
        if (this.fxPanel != null && (scene = this.fxPanel.getScene()) != null) {
            return scene.getWindow();
        }
        return null;
    }

    private void render() {
        this.setPadding(new Insets(10.0));
        this.setSpacing(10.0);
        this.getChildren().clear();
        this.list.setStyle("-fx-background-insets: 0; -fx-focus-color: transparent; -fx-faint-focus-color: transparent;");
        this.list.setMaxWidth(200.0);
        this.list.setPrefWidth(200.0);
        this.list.setMinWidth(200.0);
        this.list.getItems().clear();
        this.list.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.list.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.selectPage((JavaFxPage)newValue));
        this.list.setCellFactory(p -> new ListCell<JavaFxPage>(){

            protected void updateItem(JavaFxPage page, boolean empty) {
                super.updateItem((Object)page, empty);
                this.setStyle("-fx-background-color: white;");
                if (empty) {
                    this.setText(null);
                } else {
                    int index = JavaFxPageListPane.this.list.getItems().indexOf((Object)page);
                    this.setText(index + 1 + ". " + page.getTitle());
                    if (index == JavaFxPageListPane.this.list.getItems().indexOf((Object)JavaFxPageListPane.this.getSelected())) {
                        this.setStyle(this.getStyle() + " -fx-text-fill: black; -fx-font-weight: bold;");
                    } else {
                        this.setStyle(this.getStyle() + " -fx-text-fill: gray;");
                    }
                }
            }
        });
        this.getChildren().add(this.list);
        VBox details = new VBox();
        details.setSpacing(10.0);
        details.getChildren().clear();
        HBox.setHgrow((Node)details, (Priority)Priority.ALWAYS);
        this.pageScroll.setStyle("-fx-background-color: white;");
        this.pageScroll.setFitToHeight(true);
        this.pageScroll.setFitToWidth(true);
        this.pageScroll.setContent(null);
        this.pageScroll.setPadding(new Insets(10.0));
        VBox.setVgrow((Node)this.pageScroll, (Priority)Priority.ALWAYS);
        details.getChildren().add((Object)this.pageScroll);
        this.buttonBox.setSpacing(10.0);
        this.buttonBox.setAlignment(Pos.CENTER);
        details.getChildren().add((Object)this.buttonBox);
        this.getChildren().add((Object)details);
    }

    public void addPage(JavaFxPage page) {
        this.list.getItems().add((Object)page);
    }

    public void selectNextPage() {
        this.selectPage(this.list.getItems().indexOf((Object)this.selected) + 1);
    }

    public void selectPrevPage() {
        this.selectPage(this.list.getItems().indexOf((Object)this.selected) - 1);
    }

    public void selectPage(int index) {
        if (index >= 0 && index < this.list.getItems().size()) {
            this.selectPage((JavaFxPage)this.list.getItems().get(index));
        }
    }

    public void selectPage(JavaFxPage page) {
        boolean change;
        boolean bl = change = this.selected != null ? this.onPageChange(this.selected, page) : true;
        if (change) {
            this.selected = page;
            this.selected.getPage().setStyle("-fx-background-color: white;");
            this.pageScroll.setContent(this.selected.getPage());
            this.list.refresh();
            this.onPageChanged(this.selected);
        }
    }

    public HBox getButtonBox() {
        return this.buttonBox;
    }

    public JavaFxPage getSelected() {
        return this.selected;
    }

    protected abstract boolean onPageChange(JavaFxPage var1, JavaFxPage var2);

    protected abstract void onPageChanged(JavaFxPage var1);
}

