/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.license;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.CryptoUtilites;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.json.JSONObject;

public class LicenseDetails {
    private String licenseKey;
    private String hardwareID;
    private String computerName;
    private Date validUntil;
    private boolean valid = false;
    private String product;
    HashMap<String, String> features = new HashMap();
    private int clientID;
    private String clientUsername;
    private String clientEmail;
    private String clientCompany;
    String errorMessage = null;
    ThemisLicense.ActivationError errorType = ThemisLicense.ActivationError.NO_ERROR;

    public void clear() {
        this.validUntil = null;
        this.valid = false;
        this.product = null;
        this.features.clear();
        this.clientID = 0;
        this.clientUsername = null;
        this.clientEmail = null;
        this.clientCompany = null;
        this.errorMessage = null;
        this.errorType = ThemisLicense.ActivationError.NO_ERROR;
    }

    public void readLicenseKey() {
        File f = ThemisApplication.getInstance().getApplicationDataLicenseKeyFile();
        if (f.isFile()) {
            try {
                this.setLicenseKey(Util.fileToString((File)f));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public File getFile() {
        return ThemisApplication.getInstance().getApplicationDataLicenseFile();
    }

    public File getKeyFile() {
        return ThemisApplication.getInstance().getApplicationDataLicenseKeyFile();
    }

    public void deleteFile() {
        try {
            Files.deleteIfExists(Paths.get(this.getFile().getAbsolutePath(), new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.deleteIfExists(Paths.get(this.getKeyFile().getAbsolutePath(), new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void fromFile() {
        try {
            String fString = Util.fileToString((File)this.getFile());
            String jsonString = CryptoUtilites.decryptAes((String)fString);
            JSONObject o = new JSONObject(jsonString);
            this.fromJSON(o);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            // empty catch block
        }
    }

    public void fromString(String s) {
        try {
            String responseAsString = CryptoUtilites.decryptAes((String)s);
            JSONObject o = new JSONObject(responseAsString);
            this.fromJSON(o);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            // empty catch block
        }
    }

    public void fromJSON(JSONObject o) {
        Object features;
        if (o == null || o.isEmpty()) {
            this.setError(ThemisLicense.ActivationError.SERVER_ERROR, Util.getJSONString((JSONObject)o, (String)"errorMessage", null));
            return;
        }
        this.clear();
        if (o.has("errorCode")) {
            switch (o.getString("errorCode")) {
                case "server-error": {
                    this.setError(ThemisLicense.ActivationError.SERVER_ERROR, Util.getJSONString((JSONObject)o, (String)"errorMessage", null));
                    break;
                }
                case "invalid-body": {
                    this.setError(ThemisLicense.ActivationError.OTHER, Util.getJSONString((JSONObject)o, (String)"errorMessage", null));
                    break;
                }
                case "invalid-product": {
                    this.setError(ThemisLicense.ActivationError.OTHER, Util.getJSONString((JSONObject)o, (String)"errorMessage", null));
                    break;
                }
                case "no-license-for-key": {
                    this.setError(ThemisLicense.ActivationError.KEY_UNKOWN, Util.getJSONString((JSONObject)o, (String)"errorMessage", null));
                    break;
                }
                case "no-activations-available": {
                    this.setError(ThemisLicense.ActivationError.ALL_IN_USE, Util.getJSONString((JSONObject)o, (String)"errorMessage", null));
                    break;
                }
                case "undefined-error": {
                    this.setError(ThemisLicense.ActivationError.SERVER_ERROR, Util.getJSONString((JSONObject)o, (String)"errorMessage", null));
                    break;
                }
                default: {
                    this.setError(ThemisLicense.ActivationError.OTHER, Util.getJSONString((JSONObject)o, (String)"errorMessage", null));
                }
            }
            return;
        }
        this.setLicenseKey(Util.getJSONString((JSONObject)o, (String)"licenseKey", null));
        this.setHardwareID(Util.getJSONString((JSONObject)o, (String)"hardwareId", null));
        String validUntilString = o.getString("expireDate");
        this.setValidUntil(Util.parseDate((String)validUntilString, (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone(), null));
        this.setProduct(Util.getJSONString((JSONObject)o, (String)"product", null));
        this.setClientCompany(Util.getJSONString((JSONObject)o, (String)"clientCompany", null));
        this.setClientEmail(Util.getJSONString((JSONObject)o, (String)"clientEmail", null));
        this.setClientUsername("(unbekannt)");
        this.setValid(o.getBoolean("valid"));
        this.features.clear();
        if (o.has("features") && (features = o.get("features")) instanceof JSONObject) {
            this.setFeatures((JSONObject)o.get("features"));
        }
        int id = 0;
        if (o.has("clientId")) {
            o.getInt("clientId");
            if (id == 0) {
                String f = this.getFeature("clientid");
                id = Util.parseInt((String)f, (int)0);
            }
        }
        this.setClientID(id);
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put("clientId", this.clientID);
        o.put("licenseKey", (Object)this.getLicenseKey());
        o.put("hardwareId", (Object)this.getHardwareID());
        o.put("expireDate", (Object)Util.formatDate((Date)this.getValidUntil(), (String)Util.DATE_READ, (TimeZone)TimeZone.getDefault()));
        o.put("product", (Object)this.getProduct());
        o.put("clientCompany", (Object)this.getClientCompany());
        o.put("clientEmail", (Object)this.getClientEmail());
        o.put("clientUsername", (Object)this.getClientUsername());
        o.put("valid", this.isValid());
        o.put("features", this.getFeatures());
        return o;
    }

    public void toFile() {
        try {
            Util.stringToFile((String)this.getLicenseKey(), (File)this.getKeyFile());
            JSONObject o = this.toJSON();
            String jsonString = o.toString();
            String crypt = CryptoUtilites.encryptAes((String)jsonString);
            Util.stringToFile((String)crypt, (File)this.getFile());
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            // empty catch block
        }
    }

    public void addFeature(String f, String v) {
        this.features.put(f, v);
    }

    public void setFeatures(JSONObject map) {
        this.features.clear();
        for (String key : map.keySet()) {
            this.addFeature(key, map.getString(key));
        }
    }

    public String getFeature(String f) {
        return this.features.get(f);
    }

    public boolean hasFeature(String f) {
        String feature = this.getFeature(f);
        return "1".equals(feature) || "yes".equalsIgnoreCase(feature) || "ok".equalsIgnoreCase(feature) || "ja".equalsIgnoreCase(feature) || "true".equalsIgnoreCase(feature);
    }

    public HashMap<String, String> getFeatures() {
        return this.features;
    }

    public ThemisLicense.LicenseLevel getApplicationLicenseLevel() {
        if (this.getProduct() == null) {
            return ThemisLicense.LicenseLevel.NONE;
        }
        if (!this.isValid()) {
            return ThemisLicense.LicenseLevel.NONE;
        }
        switch (this.getProduct()) {
            case "Brandschutzbuch": {
                return ThemisLicense.LicenseLevel.APP;
            }
            case "THEMIS Vollversion": 
            case "THEMIS Desktop": 
            case "Vollversion": {
                return ThemisLicense.LicenseLevel.FULL;
            }
        }
        return ThemisLicense.LicenseLevel.NONE;
    }

    public ThemisLicense.LicenseLevel getLicenseLevel() {
        if (this.getProduct() == null) {
            ThemisApplication.getLogger().warning("Checking license: not activated - license refused");
            return ThemisLicense.LicenseLevel.NONE;
        }
        if (this.getValidUntil() == null && !this.hasFeature("permanent")) {
            ThemisApplication.getLogger().warning("Checking license: no date - license refused");
            return ThemisLicense.LicenseLevel.NONE;
        }
        if (!this.isValid()) {
            ThemisApplication.getLogger().warning("Checking license: license expired on '" + Util.formatDate((Date)this.getValidUntil(), (String)Util.DATE_READ, (TimeZone)TimeZone.getDefault()) + "' - license refused");
            return ThemisLicense.LicenseLevel.NONE;
        }
        ThemisProject project = ThemisApplication.getInstance().getProject();
        int projectLicenseLevel = -1;
        if (project.isOpen()) {
            projectLicenseLevel = project.getLicenseLevel();
        }
        switch (this.getProduct()) {
            case "Brandschutzbuch": {
                if (projectLicenseLevel == 10) {
                    ThemisApplication.getLogger().warning("Checking license: trying to open full project with brandschutzbuch - license refused");
                    return ThemisLicense.LicenseLevel.NONE;
                }
                return ThemisLicense.LicenseLevel.APP;
            }
            case "THEMIS Vollversion": 
            case "THEMIS Desktop": 
            case "Vollversion": {
                if (projectLicenseLevel == 5) {
                    return ThemisLicense.LicenseLevel.APP;
                }
                return ThemisLicense.LicenseLevel.FULL;
            }
        }
        ThemisApplication.getLogger().warning("Checking license: undefined product '" + this.getProduct() + "' - license refused");
        return ThemisLicense.LicenseLevel.NONE;
    }

    public int getApplicationLicenseLevelValue() {
        switch (this.getApplicationLicenseLevel()) {
            case APP: {
                return 5;
            }
            case FULL: {
                return 10;
            }
        }
        return 0;
    }

    public int getLicenseLevelValue() {
        switch (this.getLicenseLevel()) {
            case APP: {
                return 5;
            }
            case FULL: {
                return 10;
            }
        }
        return 0;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(String licenseKey) {
        if (licenseKey != null) {
            this.licenseKey = licenseKey;
        }
    }

    public String getHardwareID() {
        if (this.hardwareID == null) {
            return ThemisApplication.getInstance().getLicense().getHardwareId();
        }
        return this.hardwareID;
    }

    public void setHardwareID(String hardwareID) {
        this.hardwareID = hardwareID;
    }

    public String getComputerName() {
        if (this.computerName == null) {
            return Util.getHostname();
        }
        return this.computerName;
    }

    public void setComputerName(String computername) {
        this.computerName = computername;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public int getClientID() {
        return this.clientID;
    }

    public void setClientID(int clientID) {
        this.clientID = clientID;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getClientUsername() {
        return this.clientUsername;
    }

    public void setClientUsername(String registeredUsername) {
        this.clientUsername = registeredUsername;
    }

    public String getClientEmail() {
        return this.clientEmail;
    }

    public void setClientEmail(String registeredEmail) {
        this.clientEmail = registeredEmail;
    }

    public String getClientCompany() {
        return this.clientCompany;
    }

    public void setClientCompany(String registeredCompany) {
        this.clientCompany = registeredCompany;
    }

    public void setValid(boolean v) {
        this.valid = v;
    }

    public boolean isValid() {
        return this.valid && new Date().before(this.getValidUntil());
    }

    public String getLicenseStatus() {
        if (this.product == null) {
            return "license.error.no-activation";
        }
        if (this.hardwareID == null || !this.hardwareID.equals(ThemisApplication.getInstance().getLicense().getHardwareId())) {
            return "license.error.invalid-hardwareid";
        }
        if (this.validUntil != null && this.validUntil.before(new Date())) {
            return "license.error.expired";
        }
        if (this.errorType == ThemisLicense.ActivationError.KEY_UNKOWN) {
            return "license.invalid";
        }
        if (this.errorType == ThemisLicense.ActivationError.ALL_IN_USE) {
            return "license.error.activation-max-reached";
        }
        if (!this.isValid()) {
            return "license.nolicense";
        }
        int projectLicenseLevel = -1;
        if (ThemisApplication.getInstance().getProject().isOpen()) {
            projectLicenseLevel = ThemisApplication.getInstance().getProject().getLicenseLevel();
        }
        if ("Brandschutzbuch".equals(this.getProduct()) && projectLicenseLevel == 10) {
            return "Unzureichend f\u00fcr aktuelles Projekt";
        }
        return "OK";
    }

    public String getLicenseStatusDescription() {
        boolean hasMaintenance;
        TimeZone z = TimeZone.getDefault();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getResourceText("license.date-time")).append(":");
        sb.append("\n  ").append(Util.formatDate((Date)new Date(), (String)Util.DATETIME_READ, (TimeZone)z));
        sb.append("\n").append(this.getResourceText("license.information")).append(":");
        String themisVersion = ThemisApplication.getInstance().getProject().getVersion();
        sb.append("\n  ").append(Util.expandString((String)this.getResourceText("license.info.themisversion"), (String)" ", (int)18)).append(": ").append(themisVersion);
        String productEdition = this.getProduct();
        long clientId = this.getClientID();
        String userFullname = this.getClientUsername();
        String userCompany = this.getClientCompany();
        String userEMail = this.getClientEmail();
        Date validUntil = this.getValidUntil();
        boolean bl = hasMaintenance = !this.hasFeature("permanent");
        if (ThemisApplication.getInstance().getLicense().isFloatingLicense()) {
            sb.append("\n  ").append(Util.expandString((String)this.getResourceText("license.info.floating"), (String)" ", (int)18)).append(": ").append(ThemisApplication.getInstance().getLicense().getFloatingServerWithPort());
        }
        if (this.product == null) {
            sb.append("\n  ").append(Util.expandString((String)this.getResourceText("license.info.error"), (String)" ", (int)18)).append(": ").append(this.getResourceText("license.error.no-activation"));
        } else {
            sb.append("\n  ").append(Util.expandString((String)this.getResourceText("license.info.customer"), (String)" ", (int)18)).append(": ").append(userCompany == null ? "-" : userCompany);
            sb.append("\n  ").append(Util.expandString((String)this.getResourceText("license.info.mail"), (String)" ", (int)18)).append(": ").append(userEMail == null ? "-" : userEMail);
            sb.append("\n  ").append(Util.expandString((String)this.getResourceText("license.info.customernr"), (String)" ", (int)18)).append(": ").append(clientId <= 0L ? "-" : Long.valueOf(clientId));
            sb.append("\n  ").append(Util.expandString((String)this.getResourceText("license.info.product"), (String)" ", (int)18)).append(": ").append(productEdition == null ? "-" : productEdition);
            sb.append("\n  ").append(Util.expandString((String)this.getResourceText("license.info.valid-until"), (String)" ", (int)18)).append(": ").append(Util.formatDate((Date)validUntil, (String)Util.DATE_READ, (TimeZone)TimeZone.getDefault()));
        }
        sb.append("\n").append(this.getResourceText("license.hardware-info"));
        sb.append("\n  ").append(Util.expandString((String)this.getResourceText("license.computer"), (String)" ", (int)18)).append(": ").append(this.getComputerName());
        sb.append("\n  ").append(Util.expandString((String)this.getResourceText("license.hardwareid"), (String)" ", (int)18)).append(": ").append(this.getHardwareID());
        ThemisApplication.getLogger().info("License status: " + sb.toString());
        return sb.toString();
    }

    public String getResourceText(String key) {
        return ThemisApplication.getInstance().getProject().getResourceText(key);
    }

    public void setError(ThemisLicense.ActivationError type, String message) {
        this.errorMessage = message;
        this.errorType = type;
    }

    public ThemisLicense.ActivationError getErrorType() {
        if (this.errorType == null) {
            this.errorType = ThemisLicense.ActivationError.NO_ERROR;
        }
        return this.errorType;
    }

    public String toString() {
        return this.getLicenseStatus();
    }
}

