/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.license;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.license.ThemisLicense;

public class LicenseUtils {
    private static boolean noSpecificClient = false;

    public static boolean isClientEquals(Client client) {
        Client licenseClient = LicenseUtils.getLicenseClient();
        return licenseClient != null && client.equals((Object)licenseClient);
    }

    public static boolean isClientEquals(String clientID, Client client) {
        if (clientID == null) {
            return LicenseUtils.isClientEquals(client);
        }
        Client licenseClient = LicenseUtils.getLicenseClient(clientID);
        return licenseClient != null && client.equals((Object)licenseClient);
    }

    private static Client getLicenseClient() {
        ThemisLicense license = ThemisApplication.getInstance().getLicense();
        if (license == null) {
            return null;
        }
        return LicenseUtils.getLicenseClient(Integer.toString(license.getClientID()));
    }

    private static Client getLicenseClient(String clientID) {
        if (clientID == null || clientID.isEmpty() || noSpecificClient) {
            return null;
        }
        return Client.getClient(clientID);
    }

    public static void setNoSpecificClient() {
        noSpecificClient = true;
        ThemisApplication.getInstance().getActionProvider().invokeAction(ThemisAction.LICENSE_CHANGED);
    }

    public static enum Client {
        GRID_IT,
        KUBUS360,
        FIX,
        KAEFER,
        BELLINGER,
        THYSSEN,
        TERRA,
        OEHMKE,
        KYBERNA,
        GB_T,
        ENDRESS,
        OK_ING,
        KEMPENKRAUSE,
        WIENERWOHNEN,
        SECURITAS,
        UKM,
        IBS,
        IPB_BACHMANN,
        LIPPMANN;


        public static Client getClient(String id) {
            if (id == null || id.isEmpty()) {
                return null;
            }
            switch (id) {
                case "GRID-IT": 
                case "1097": {
                    return GRID_IT;
                }
                case "KUBUS360 GmbH": 
                case "32030": {
                    return KUBUS360;
                }
                case "34366": {
                    return FIX;
                }
                case "33140": {
                    return KAEFER;
                }
                case "52920": {
                    return BELLINGER;
                }
                case "36791": {
                    return THYSSEN;
                }
                case "55041": {
                    return TERRA;
                }
                case "28934": {
                    return OEHMKE;
                }
                case "66168": {
                    return KYBERNA;
                }
                case "28722": {
                    return GB_T;
                }
                case "36268": {
                    return ENDRESS;
                }
                case "78842": {
                    return OK_ING;
                }
                case "42579": {
                    return KEMPENKRAUSE;
                }
                case "33094": {
                    return KEMPENKRAUSE;
                }
                case "42694": {
                    return WIENERWOHNEN;
                }
                case "73113": {
                    return SECURITAS;
                }
                case "82684": {
                    return UKM;
                }
                case "28716": {
                    return IBS;
                }
                case "44559": {
                    return IPB_BACHMANN;
                }
                case "45925": {
                    return LIPPMANN;
                }
            }
            return null;
        }
    }
}

