/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.license;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.license.FloatingLicenseHandler;
import at.grid.themis.ontology.license.LicenseDetails;
import at.grid.util.CryptoUtilites;
import at.grid.util.Util;
import com.license4j.HardwareID;
import com.license4j.License;
import com.license4j.LicenseText;
import com.license4j.LicenseValidator;
import com.license4j.ValidationStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.HttpsURLConnection;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;

public class ThemisLicense {
    public static final float VERSION = 6.1f;
    public static final int APP_MAX_PLANS = 15;
    public static final int APP_MAX_FOTOS = 1;
    public static final String PRODUCT_BFA_BRANDSCHUTZBUCH = "Brandschutzbuch";
    public static final String PRODUCT_VDS_ARBEITSSICHERHEIT = "VdS-Arbeitssicherheit";
    public static final String PRODUCT_TEST_ZIP = "ZIP-TEST";
    protected int floatingPortnumber = 0;
    private String licenseServerAddr = "https://license.themis-software.at";
    private String serviceBase = "/themis";
    private String serviceBaseTest = "/themistest";
    private String serviceActivate = "/api/desktop/v2/license/activate";
    private String serviceDeactivate = "/api/desktop/v2/license/deactivate";
    private boolean updateLicenseDetailsRunning = false;
    Timer floatingLicenseCheckTimer = null;
    protected ThemisApplication app;
    protected LicenseDetails license = new LicenseDetails();
    protected License licenseL4J = null;
    boolean useTestService = false;

    public ThemisLicense() {
        boolean debug = false;
    }

    public ThemisLicense(ThemisApplication app) {
        this.initLicense(app);
    }

    private void initLicense(ThemisApplication app) {
        this.app = app;
        app.setThemisLicense(this);
        this.license.readLicenseKey();
        this.activateLicense();
    }

    public void removeLicense() {
        if (!this.isFloatingLicense()) {
            this.getLicenseDetails().deleteFile();
        }
    }

    public LicenseDetails getLicenseDetails() {
        if (this.license == null) {
            this.license = new LicenseDetails();
            this.license.readLicenseKey();
        }
        return this.license;
    }

    public int getClientID() {
        return this.license.getClientID();
    }

    public String getProductEdition() {
        return this.getLicenseDetails().getProduct();
    }

    public boolean hasFeature(String f) {
        this.checkLicenseAfterTime();
        return this.getLicenseDetails().hasFeature(f);
    }

    public boolean hasLicense() {
        return this.hasFloatingLicense() || this.getLicenseDetails().getLicenseLevel() != LicenseLevel.NONE;
    }

    public boolean hasLicenseApp() {
        return this.getLicenseDetails().getLicenseLevel() == LicenseLevel.APP;
    }

    public boolean hasLicenseFull() {
        return this.getLicenseDetails().getLicenseLevel() == LicenseLevel.FULL;
    }

    public boolean hasMaintenance() {
        this.checkLicenseAfterTime();
        return !this.hasFeature("permanent");
    }

    public boolean isTestLicense() {
        return this.hasFeature("testlizenz");
    }

    public boolean isInternalLicense() {
        int clientId = this.getClientID();
        return clientId == 1097;
    }

    @Deprecated
    public static int getLicenseLevel(ThemisApplication app) {
        return app.getLicense().license.getLicenseLevelValue();
    }

    public static boolean isLicenseLevelAtLeast(LicenseLevel requiredLevel) {
        switch (requiredLevel) {
            case NONE: {
                return true;
            }
            case APP: {
                return ThemisApplication.getInstance().getLicense().getLicenseDetails().getLicenseLevel() != LicenseLevel.NONE;
            }
            case FULL: {
                return ThemisApplication.getInstance().getLicense().getLicenseDetails().getLicenseLevel() == LicenseLevel.FULL;
            }
        }
        return false;
    }

    public static boolean isLicenseLevelLessThan(LicenseLevel level) {
        switch (level) {
            case NONE: {
                return false;
            }
            case APP: {
                return ThemisApplication.getInstance().getLicense().getLicenseDetails().getLicenseLevel() == LicenseLevel.NONE;
            }
            case FULL: {
                return ThemisApplication.getInstance().getLicense().getLicenseDetails().getLicenseLevel() != LicenseLevel.FULL;
            }
        }
        return false;
    }

    public static boolean isLicenseLevelExact(LicenseLevel requiredLevel) {
        LicenseLevel level = ThemisApplication.getInstance().getLicense().getLicenseDetails().getLicenseLevel();
        switch (requiredLevel) {
            case NONE: {
                return level == LicenseLevel.NONE;
            }
            case APP: {
                return level == LicenseLevel.APP;
            }
            case FULL: {
                return level == LicenseLevel.FULL;
            }
        }
        return false;
    }

    public static boolean isActionDeniedForNoProject(ThemisApplication app) {
        if (app.getProject() == null || !app.getProject().isOpen()) {
            app.getDialog().showWarningDialog(app.getProject().getResourceText("app.core.text.noproject", app.getLocale()));
            return true;
        }
        return false;
    }

    public static boolean isActionDeniedForViewer(ThemisApplication app) {
        if (!app.getLicense().hasLicense()) {
            app.getDialog().showErrorDialog(app.getProject().getResourceText("license.no-license", app.getLocale()));
            return true;
        }
        return false;
    }

    public static boolean isActionDeniedForBSbuch(ThemisApplication app) {
        if (!app.getLicense().hasLicense()) {
            app.getDialog().showErrorDialog(app.getProject().getResourceText("license.no-license", app.getLocale()));
            return true;
        }
        if (ThemisLicense.isLicenseLevelExact(LicenseLevel.APP)) {
            app.getDialog().showErrorDialog(app.getProject().getResourceText("license.not-for-bsbuch", app.getLocale()));
            return true;
        }
        return false;
    }

    public static boolean isActionLimitedForBSbuch(ThemisApplication app, boolean condition, String msg) {
        if (!app.getLicense().hasLicense()) {
            app.getDialog().showErrorDialog(app.getProject().getResourceText("license.no-license", app.getLocale()));
            return true;
        }
        if (ThemisLicense.isLicenseLevelExact(LicenseLevel.NONE)) {
            app.getDialog().showErrorDialog(app.getProject().getResourceText("license.not-for-viewer", app.getLocale()));
            return true;
        }
        if (ThemisLicense.isLicenseLevelExact(LicenseLevel.APP) && condition) {
            if (msg != null) {
                app.getDialog().showErrorDialog(app.getProject().getResourceText(msg, app.getLocale()));
            } else {
                app.getDialog().showErrorDialog(app.getProject().getResourceText("license.not-for-bsbuch", app.getLocale()));
            }
            return true;
        }
        return false;
    }

    public boolean checkServerConnection() {
        if (this.isFloatingLicense()) {
            String floatingServer = this.getFloatingServer();
            if (floatingServer == null) {
                return false;
            }
            try {
                InetAddress inet = InetAddress.getByName(floatingServer);
                return inet.isReachable(2000);
            }
            catch (UnknownHostException ex) {
                ThemisApplication.getLogger().severe("Error, unknown host for floating server: " + floatingServer + ": " + ex.getMessage());
                return false;
            }
            catch (IOException ex) {
                ThemisApplication.getLogger().severe("Error, cannot acces floating server '" + floatingServer + "' using a standard ping: " + ex.getMessage());
                return false;
            }
        }
        try {
            URL u = new URL(this.getActivationAddress());
            HttpsURLConnection con = (HttpsURLConnection)u.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String readLine = br.readLine();
            con.disconnect();
        }
        catch (MalformedURLException ex) {
            ThemisApplication.getLogger().severe("Error in activation server address: " + this.getActivationAddress() + ": " + ex.getMessage());
            return false;
        }
        catch (IOException ex) {
            ThemisApplication.getLogger().severe("No access to activation server: " + ex.getMessage());
            return false;
        }
        return true;
    }

    public void activateLicense() {
        if (this.isFloatingLicense()) {
            this.activateFloatingLicense();
        } else {
            String licenseKey = this.getLicenseDetails().getLicenseKey();
            ThemisApplication.getLogger().info("activating license using key " + licenseKey);
            this.activateLicenseOnServer(licenseKey);
            if (this.license.getErrorType() == ActivationError.SERVER_ERROR) {
                ThemisApplication.getLogger().info("server error " + this.license.errorMessage + " ... reading from file");
                this.license.fromFile();
            }
            this.getLicenseDetails().getLicenseStatusDescription();
            if (this.floatingLicenseCheckTimer != null) {
                this.floatingLicenseCheckTimer.cancel();
                this.floatingLicenseCheckTimer = null;
            }
        }
        this.getLicenseDetails().getLicenseStatusDescription();
        ThemisApplication.getInstance().getProject().getLogger().info("... done activating license");
        this.app.getGUImanager().setTitle();
    }

    public void activateLicenseOnServer(String licenseKey) {
        this.setFloatingServer(null);
        if (this.license == null) {
            this.license = new LicenseDetails();
        }
        if (licenseKey == null) {
            this.license.clear();
            return;
        }
        if (!this.isLicenseServerAvailable(this.licenseServerAddr)) {
            this.license.setError(ActivationError.SERVER_ERROR, "Server not reachable");
            return;
        }
        try {
            int numRead;
            String server = this.getActivationAddress();
            HttpPost httpPost = new HttpPost(server);
            ThemisApplication.getLogger().info("activating license via " + server + " using license key " + licenseKey);
            JSONObject jsonRequest = new JSONObject();
            jsonRequest.put("licenseKey", (Object)licenseKey);
            jsonRequest.put("hardwareId", (Object)this.getHardwareId());
            jsonRequest.put("computerOs", (Object)"Windows");
            jsonRequest.put("computerName", (Object)this.getHostname());
            jsonRequest.put("internalString", (Object)"1483631478408");
            jsonRequest.put("lang", (Object)ThemisApplication.getInstance().getLocale().getLanguage());
            String jsonString = jsonRequest.toString();
            String crpyt = CryptoUtilites.encryptAes((String)jsonString);
            httpPost.setEntity((HttpEntity)new StringEntity(crpyt));
            CloseableHttpClient client = HttpClients.createDefault();
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            int bufferSize = 1024;
            char[] buffer = new char[bufferSize];
            StringBuilder out = new StringBuilder();
            InputStreamReader in = new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8);
            while ((numRead = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
                out.append(buffer, 0, numRead);
            }
            String crpytResponse = out.toString();
            String responseAsString = CryptoUtilites.decryptAes((String)crpytResponse);
            JSONObject o = this.createJsonFromResonse(responseAsString);
            this.license.fromJSON(o);
            this.license.setLicenseKey(licenseKey);
            this.license.toFile();
        }
        catch (Exception ex) {
            this.license.setError(ActivationError.SERVER_ERROR, ex.getLocalizedMessage());
            ex.printStackTrace();
        }
    }

    public void deactivateLicenseOnServer(String licenseKey) {
        try {
            int numRead;
            String server = this.getDeactivationAddress();
            HttpPost httpPost = new HttpPost(server);
            ThemisApplication.getLogger().info("activating license via " + server + " using license key " + licenseKey);
            JSONObject jsonRequest = new JSONObject();
            jsonRequest.put("licenseKey", (Object)licenseKey);
            jsonRequest.put("hardwareId", (Object)this.getHardwareId());
            jsonRequest.put("computerOs", (Object)"Windows");
            jsonRequest.put("computerName", (Object)this.getHostname());
            jsonRequest.put("internalString", (Object)"1483631478408");
            jsonRequest.put("lang", (Object)ThemisApplication.getInstance().getLocale().getLanguage());
            String jsonString = jsonRequest.toString();
            String crpyt = CryptoUtilites.encryptAes((String)jsonString);
            httpPost.setEntity((HttpEntity)new StringEntity(crpyt));
            CloseableHttpClient client = HttpClients.createDefault();
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            int bufferSize = 1024;
            char[] buffer = new char[bufferSize];
            StringBuilder out = new StringBuilder();
            InputStreamReader in = new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8);
            while ((numRead = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
                out.append(buffer, 0, numRead);
            }
            String crpytResponse = out.toString();
            String responseAsString = CryptoUtilites.decryptAes((String)crpytResponse);
            JSONObject o = this.createJsonFromResonse(responseAsString);
            if (o.getBoolean("deactivated")) {
                ThemisApplication.getLogger().info("licnese with key '" + licenseKey + "' deactivated on server, hardware-ID: " + this.getHardwareId());
            } else {
                ThemisApplication.getLogger().warning("licnese with key '" + licenseKey + "', deactivation not successfull, hardware-ID: " + this.getHardwareId());
            }
            this.app.getDialog().showInfoDialog("license.deactivate.success");
        }
        catch (Exception ex) {
            this.license.setError(ActivationError.SERVER_ERROR, ex.getLocalizedMessage());
            ex.printStackTrace();
            this.app.getDialog().showInfoDialog("license.deactivate.server-error");
        }
    }

    public void setTestService(boolean flg) {
        this.useTestService = flg;
    }

    public String getServiceBase() {
        return this.useTestService ? this.serviceBaseTest : this.serviceBase;
    }

    public String getActivationAddress() {
        return this.licenseServerAddr + this.getServiceBase() + this.serviceActivate;
    }

    private String getDeactivationAddress() {
        return this.licenseServerAddr + this.getServiceBase() + this.serviceDeactivate;
    }

    public JSONObject createJsonFromResonse(String responseAsString) throws UnsupportedEncodingException, IOException {
        JSONObject o = null;
        if (responseAsString != null && responseAsString.trim().length() > 0) {
            try {
                o = new JSONObject(responseAsString);
            }
            catch (Exception e) {
                o = new JSONObject();
                ThemisApplication.getLogger().severe("cannot build JSON using response text: " + responseAsString);
            }
            ThemisApplication.getLogger().info("received JSON string");
        } else {
            o = new JSONObject();
            ThemisApplication.getLogger().warning("recieved empty result");
        }
        return o;
    }

    public boolean isDeactivationAllowed() {
        return this.hasFeature("floating");
    }

    public void deactivate() {
        if (this.license == null) {
            return;
        }
        if (this.isFloatingLicense()) {
            this.releaseFloatingLicense();
        } else {
            ThemisApplication.getInstance().getProject().getLogger().info("Deactivating license");
            this.deactivateLicenseOnServer(this.license.getLicenseKey());
            this.removeLicense();
            this.license.clear();
            this.app.getActionProvider().invokeAction(ThemisAction.LICENSE_CHANGED);
        }
        this.getLicenseDetails().getLicenseStatusDescription();
        this.app.getGUImanager().setTitle();
    }

    public String getFloatingServerWithPort() {
        String floatingServer = ThemisApplication.getInstance().getSettings().getLicenseFloatingServer();
        if (floatingServer == null || "".equals(floatingServer)) {
            return null;
        }
        return floatingServer;
    }

    public String getFloatingServer() {
        String floatingServer = ThemisApplication.getInstance().getSettings().getLicenseFloatingServer();
        if (floatingServer == null || "".equals(floatingServer)) {
            return null;
        }
        String[] serverAndPort = floatingServer.split(":");
        return serverAndPort[0];
    }

    public int getFloatingServerPort() {
        String floatingServer = ThemisApplication.getInstance().getSettings().getLicenseFloatingServer();
        if (floatingServer == null || "".equals(floatingServer)) {
            return 0;
        }
        String[] serverAndPort = floatingServer.split(":");
        if (serverAndPort.length > 1) {
            return Integer.parseInt(serverAndPort[1]);
        }
        return 0;
    }

    public void setFloatingServer(String server) {
        boolean hasFloating;
        ThemisApplication.getInstance().getSettings().setLicenseFloatingServer(server);
        boolean bl = hasFloating = server != null && !"".equals(server);
        if (hasFloating) {
            ThemisApplication.getInstance().getSettings().setLicenseType(1);
        } else {
            ThemisApplication.getInstance().getSettings().setLicenseType(0);
        }
    }

    public boolean isFloatingLicense() {
        String floatingServer = this.getFloatingServer();
        return floatingServer != null && !"".equals(floatingServer);
    }

    public boolean hasFloatingLicense() {
        return this.isFloatingLicense() && this.licenseL4J != null;
    }

    public boolean checkFloatingLicense() {
        if (!this.isFloatingLicense()) {
            return true;
        }
        this.activateFloatingLicense();
        return this.license != null && this.license.isValid();
    }

    public void activateFloatingLicense() {
        if (!this.isFloatingLicense()) {
            return;
        }
        String pkey = "30819f300d06092a864886f70d010101050003818d003081893032301006072a8648ce3d02002EC311215SHA512withECDSA106052b81040006031e00047ef315bbf91c28c779c5b0f82c4dc5edf392703803a3de98dd5c8285G02818100ce28f1d2ed7bc8ee923bba28737eb3451a351fb9b44528a4c64dcd47798903f20ec40927b9194fbd9f80ce6ac01b22b488eb6966c86719ceaa1387edf1debf831bcdcce46f492520433de97ba1ae91fb129c7aee88182c55053df5b3c097871503RSA4102413SHA512withRSA30428ba0bd3c6a2d49aede773d9813464a27720382040de0cbc2d591911f5a790203010001";
        String intStr = "1483631478408";
        String prodId = "1097-THEMIS";
        if (this.licenseL4J != null) {
            ThemisApplication.getInstance().getProject().getLogger().info("Deactivating ... releasing floating license");
            this.licenseL4J.releaseFloatingLicense();
        }
        String floatingServer = this.getFloatingServerWithPort();
        this.licenseL4J = LicenseValidator.validateFloatingLicenseText(pkey, prodId, null, null, floatingServer, new FloatingLicenseHandler(), "");
        ValidationStatus validationStatus = this.licenseL4J.getValidationStatus();
        this.license.clear();
        String floatingErrorCode = null;
        switch (validationStatus) {
            case LICENSE_VALID: {
                ThemisApplication.getInstance().getProject().getLogger().fine("Floating License Server - ok, valid license");
                LicenseText lt = this.licenseL4J.getLicenseText();
                if (lt != null) {
                    this.license.setProduct(lt.getLicenseValidProductEdition());
                    this.license.setClientID(Util.parseInt((String)lt.getCustomSignedFeature("clientid"), (int)0));
                    this.license.setClientUsername(lt.getUserFullName());
                    this.license.setClientEmail(lt.getUserCompany());
                    this.license.setClientCompany(lt.getUserEMail());
                    this.license.setValidUntil(lt.getLicenseExpireDate());
                    this.license.setValid(true);
                    for (String k : lt.getCustomSignedFeatures().keySet()) {
                        this.license.addFeature(k, lt.getCustomSignedFeature(k));
                    }
                }
                ThemisApplication.getInstance().getGUImanager().setTitle();
                break;
            }
            case FLOATING_LICENSE_NOT_AVAILABLE_ALL_IN_USE: {
                ThemisApplication.getInstance().getProject().getLogger().severe("Floating License Server - all licenses in use");
                this.licenseL4J = null;
                floatingErrorCode = "license.error.floating-all-in-use";
                break;
            }
            case FLOATING_LICENSE_SERVER_NOT_AVAILABLE: {
                ThemisApplication.getInstance().getProject().getLogger().severe("Floating License Server - license server not available");
                this.licenseL4J = null;
                floatingErrorCode = "license.error.floating-server-no-connection";
                break;
            }
            case FLOATING_LICENSE_NOT_FOUND: {
                ThemisApplication.getInstance().getProject().getLogger().severe("Floating License Server - license server not found");
                this.licenseL4J = null;
                floatingErrorCode = "license.error.floating-server-no-license-found";
            }
        }
        if (!this.license.isValid()) {
            if (this.floatingLicenseCheckTimer != null) {
                this.floatingLicenseCheckTimer.cancel();
            }
            ThemisApplication.getInstance().getGUImanager().setTitle();
            this.app.getActionProvider().invokeAction(ThemisAction.LICENSE_CHANGED);
            this.app.getDialog().showWarningDialog(floatingErrorCode == null ? "warning.license-lost" : floatingErrorCode);
        }
        long timer = 300000L;
        if (this.floatingLicenseCheckTimer == null) {
            this.floatingLicenseCheckTimer = new Timer();
            this.floatingLicenseCheckTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ThemisLicense.this.activateFloatingLicense();
                }
            }, 300000L, 300000L);
        }
    }

    public void releaseFloatingLicense() {
        if (this.licenseL4J != null) {
            ThemisApplication.getInstance().getProject().getLogger().info("Deactivating ... releasing floating license");
            if (this.floatingLicenseCheckTimer != null) {
                this.floatingLicenseCheckTimer.cancel();
            }
            this.licenseL4J.releaseFloatingLicense();
            this.licenseL4J = null;
        }
    }

    public String getHardwareId() {
        return HardwareID.getHardwareIDFromHDDSerial() + HardwareID.getHardwareIDFromVolumeSerialNumber() + HardwareID.getHardwareIDFromHostName();
    }

    public String getHostname() {
        return Util.getHostname();
    }

    public String getComputerInfo() {
        return "\n  Computer:    " + this.getHostname() + "\n  Hardware-ID: " + this.getHardwareId();
    }

    protected void licenseChanged() {
        this.app.getActionProvider().invokeAction(ThemisAction.LICENSE_CHANGED);
        this.app.getDialog().showWarningDialog("warning.license-lost");
    }

    protected void checkLicenseAfterTime() {
    }

    public String getResourceText(String key) {
        if (this.app != null) {
            return this.app.getProject().getResourceText(key);
        }
        return key.replace("license.", "");
    }

    private boolean isLicenseServerAvailable(String address) {
        try {
            URL u = new URL(address);
            URLConnection c = u.openConnection();
            c.connect();
            ThemisApplication.getLogger().info("checking THEMIS server connection ... OK");
            return true;
        }
        catch (IOException ex) {
            ThemisApplication.getLogger().severe("checking THEMIS server connection ... no connection available: " + ex.getMessage());
            return false;
        }
    }

    public static enum ActivationError {
        SERVER_ERROR,
        KEY_UNKOWN,
        ALL_IN_USE,
        OTHER,
        NO_ERROR;

    }

    public static enum LicenseLevel {
        NONE,
        APP,
        FULL;

    }
}

