/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.project;

import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;

public class ProjectExport {
    public static void exportProject(File folder, Date fromdate) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!project.isOpen()) {
            return;
        }
        File fld = new File(folder, project.getThemisFile().getFolderName());
        fld.mkdirs();
        ThemisFile tf = ProjectExport.getPlansThemisFile(project);
        try {
            tf.saveToFile(new File(fld, "plans.themis"), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tf = ProjectExport.getTemplatesThemisFile(project);
        try {
            tf.saveToFile(new File(fld, "templates.themis"), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tf = ProjectExport.getContentThemisFile(project);
        try {
            tf.saveToFile(new File(fld, "project" + Util.formatDate((Date)new Date(), (String)Util.DATETIME_ISO_NO_MILI, (TimeZone)TimeZone.getDefault()) + ".themis"), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList recs = project.getEventSearchResult(fromdate, null).getResultAsBasicElements();
        for (CmsBasicElement be : recs) {
            CmsEvent ev = (CmsEvent)project.loadElement(be.getId(), project.getUser());
            tf = ProjectExport.getEventThemisFile(project, ev);
            Date eventdate = ev.getEventDate();
            String eventtitle = ev.getEventTitle();
            try {
                tf.saveToFile(new File(fld, "event_" + Util.formatDate((Date)eventdate, (String)Util.DATETIME_ISO_NO_MILI, (TimeZone)TimeZone.getDefault()) + "_" + eventtitle + ".themis"), true);
            }
            catch (IOException iOException) {}
        }
    }

    public static ThemisFile getPlansThemisFile(ThemisProject project) {
        if (!project.isOpen()) {
            return null;
        }
        ThemisFile tf = new ThemisFile().setAsSpecific();
        ArrayList<CmsElementSummary> buildings = project.getBuildings();
        for (CmsElementSummary ele : buildings) {
            tf.addContent(ele.getId());
        }
        ArrayList<CmsElementSummary> plans = project.getPlans();
        for (CmsElementSummary ele : plans) {
            tf.addPlan(ele.getId());
        }
        return tf;
    }

    public static ThemisFile getContentThemisFile(ThemisProject project) {
        if (!project.isOpen()) {
            return null;
        }
        ThemisFile tf = new ThemisFile();
        tf.setWithAllImages();
        tf.setWithoutTemplates();
        tf.setWithoutIcons();
        ThemisFilter filter = ThemisApplication.getInstance().getFilter().getCopy();
        filter.setTriggerEnabled(false);
        filter.clearAll(false, null);
        tf.addContent(filter.getFilteredElementIds());
        return tf;
    }

    public static ThemisFile getEventThemisFile(ThemisProject project, CmsEvent ev) {
        if (!project.isOpen()) {
            return null;
        }
        ThemisFile tf = new ThemisFile();
        tf.setWithRelevantImages();
        tf.setWithoutTemplates();
        tf.setWithoutIcons();
        tf.setEvent(ev);
        tf.setContentType(ThemisFile.ContentType.EVENT);
        return tf;
    }

    public static ThemisFile getTemplatesThemisFile(ThemisProject project) {
        if (!project.isOpen()) {
            return null;
        }
        return new ThemisFile().setContentType(ThemisFile.ContentType.TEMPLATE);
    }
}

