/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import java.util.ArrayList;
import org.jdom.Element;

public class AttributeSqlPair {
    String label;
    String sql;
    Reference ref;

    public AttributeSqlPair(String label, String sql) {
        this.label = label;
        this.sql = sql;
    }

    public AttributeSqlPair(Reference ref, String label, String sql) {
        this.ref = ref;
        this.label = label;
        this.sql = sql;
    }

    public Element toXmlElement() {
        Element e = new Element("sort");
        e.setAttribute("sql", this.sql);
        e.setAttribute("label", this.label);
        if (this.ref != null) {
            e.setAttribute("reference", this.ref.toString());
        }
        return e;
    }

    public static AttributeSqlPair fromXmlElement(Element e) {
        String l = e.getAttributeValue("label");
        String sql = e.getAttributeValue("sql");
        String r = e.getAttributeValue("reference");
        AttributeSqlPair a = new AttributeSqlPair(Reference.getReference(r), l, sql);
        return a;
    }

    public String getLabel() {
        return this.label == null ? "" : this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public String getSql() {
        return this.sql;
    }

    public String getCode() {
        return this.sql;
    }

    public Reference getReference() {
        return this.ref;
    }

    public boolean isNone() {
        return this.sql == null;
    }

    public boolean equals(String sql) {
        if (sql == null) {
            return this.sql == null;
        }
        return sql.equals(this.sql);
    }

    public boolean equals(AttributeSqlPair p) {
        if (p == null) {
            return false;
        }
        if (this.ref != p.ref) {
            return false;
        }
        if (p.sql == null) {
            return this.sql == null;
        }
        return p.sql.equals(this.sql);
    }

    public String toString() {
        return this.label;
    }

    public String toStringSpecification() {
        return this.label;
    }

    public static ArrayList<AttributeSqlPair> getPairsWithSqlSelect(ThemisApplication app) {
        return AttributeSqlPair.getPairs(app, CodeSpecification.SQLSELECT);
    }

    public static ArrayList<AttributeSqlPair> getPairsWithSqlSort(ThemisApplication app) {
        return AttributeSqlPair.getPairs(app, CodeSpecification.SQLSORT);
    }

    public static ArrayList<AttributeSqlPair> getPairsWithCode(ThemisApplication app) {
        return AttributeSqlPair.getPairs(app, CodeSpecification.CODE);
    }

    private static ArrayList<AttributeSqlPair> getPairs(ThemisApplication app, CodeSpecification spec) {
        String c;
        boolean isUsed;
        ArrayList<AttributeSqlPair> result = new ArrayList<AttributeSqlPair>();
        for (ThemisAttribute att : app.getSettings().getLocationAttributes()) {
            isUsed = att.isUsed();
            c = AttributeSqlPair.getCode(att, spec);
            if (!att.isUsed() || c == null) continue;
            result.add(new AttributeSqlPair(Reference.LOCATION, "G." + att.getLabel(), c));
        }
        for (ThemisAttribute att : app.getSettings().getObservationAttributes()) {
            isUsed = att.isUsed();
            c = AttributeSqlPair.getCode(att, spec);
            if (!att.isUsed() || c == null) continue;
            result.add(new AttributeSqlPair(Reference.OBSERVATION, "B." + att.getLabel(), c));
        }
        return result;
    }

    private static String getCode(ThemisAttribute att, CodeSpecification spec) {
        switch (spec) {
            case CODE: {
                return att.getCmsCode();
            }
            case SQLSORT: {
                return att.getSqlSort();
            }
            case SQLSELECT: {
                return att.getSqlCode();
            }
        }
        return null;
    }

    public static enum CodeSpecification {
        CODE,
        SQLSORT,
        SQLSELECT;

    }

    public static enum Reference {
        OBSERVATION("B"),
        LOCATION("G");

        String code;

        private Reference(String c) {
            this.code = c;
        }

        public String toString() {
            return this.code;
        }

        public static Reference getReference(String c) {
            if ("G".equals(c)) {
                return LOCATION;
            }
            return OBSERVATION;
        }
    }
}

