/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.cms.content.UploadItem;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;

public class ExportUtil {
    public static ArrayList<UploadItem> getImages(CmsReport rep, CmsLocation loc, CmsObservation obs, CmsHistory hist) {
        ArrayList<UploadItem> imageUploadItems = null;
        if (!ThemisApplication.getInstance().getProject().isOpen()) {
            return imageUploadItems;
        }
        if (ThemisApplication.getInstance().getSettings().getImageForObservation()) {
            if (rep.exportWithHistories) {
                imageUploadItems = ThemisApplication.getExportImages(hist.getUploadAttribute("files"));
                for (UploadItem item : imageUploadItems) {
                    item.setProperty("date", Util.formatDate((Date)hist.getDateAttribute("eventdate").getDate(), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
                }
            } else if (rep.exportImages == CmsReport.ImageIntegration.EVENT) {
                if (rep.event != null) {
                    imageUploadItems = ThemisApplication.getExportImages(hist.getUploadAttribute("files"));
                    for (UploadItem item : imageUploadItems) {
                        item.setProperty("date", Util.formatDate((Date)rep.event.getDateAttribute("date").getDate(), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
                    }
                } else {
                    imageUploadItems = ThemisApplication.getExportImages(obs.getUploads(true));
                }
            } else {
                imageUploadItems = rep.exportImages == CmsReport.ImageIntegration.LAST ? ThemisApplication.getExportImages(obs.getLatestUploads(true)) : ThemisApplication.getExportImages(obs.getUploads(true));
            }
        } else {
            imageUploadItems = ThemisApplication.getExportImages(loc.getUploadAttribute("files"));
        }
        return imageUploadItems;
    }

    public static ArrayList<UploadItem> getObservationImages(CmsReport rep, CmsObservation obs, CmsHistory hist) {
        ArrayList<UploadItem> imageUploadItems = new ArrayList<UploadItem>();
        if (!ThemisApplication.getInstance().getProject().isOpen()) {
            return imageUploadItems;
        }
        if (ThemisApplication.getInstance().getSettings().getImageForObservation()) {
            if (rep.exportWithHistories) {
                if (hist == null) {
                    return imageUploadItems;
                }
                imageUploadItems = ThemisApplication.getExportImages(hist.getUploadAttribute("files"));
            } else if (rep.exportImages == CmsReport.ImageIntegration.EVENT) {
                if (rep.event != null) {
                    if (hist == null) {
                        return imageUploadItems;
                    }
                    imageUploadItems = ThemisApplication.getExportImages(hist.getUploadAttribute("files"));
                } else {
                    if (obs == null) {
                        return imageUploadItems;
                    }
                    imageUploadItems = ThemisApplication.getExportImages(obs.getUploads(true));
                }
            } else if (rep.exportImages == CmsReport.ImageIntegration.LAST) {
                if (obs == null) {
                    return imageUploadItems;
                }
                imageUploadItems = ThemisApplication.getExportImages(obs.getLatestUploads(true));
            } else {
                if (obs == null) {
                    return imageUploadItems;
                }
                imageUploadItems = ThemisApplication.getExportImages(obs.getUploads(true));
            }
        }
        return imageUploadItems;
    }

    public static ArrayList<UploadItem> getLocationImages(CmsReport rep, CmsLocation loc) {
        ArrayList<UploadItem> imageUploadItems = new ArrayList<UploadItem>();
        if (!ThemisApplication.getInstance().getProject().isOpen()) {
            return imageUploadItems;
        }
        if (ThemisApplication.getInstance().getSettings().getImageForLocation()) {
            imageUploadItems = ThemisApplication.getExportImages(loc.getUploadAttribute("files"));
        }
        return imageUploadItems;
    }
}

