/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.report.LayoutRow;
import at.grid.themis.ontology.report.PdfParagraphFormat;
import at.grid.util.Util;
import org.jdom.Element;

public class LayoutCell {
    ThemisProject project = ThemisApplication.getInstance().getProject();
    LayoutRow row;
    int colFrom = -1;
    int colTo = -1;
    int span = 1;
    String content;
    float border = 1.0f;
    String fontFamily = "Arial";
    int fontSize = 10;
    int fontColor = 0;
    boolean fontBold = false;
    boolean fontUnderlined = false;
    boolean fontItalic = false;
    ColorOption color = new ColorOption(this.project.getResourceText("ColorOption.none"));
    Align align = Align.LEFT;

    public void setFormat(PdfParagraphFormat formatTitle) {
        this.setFontFamily(formatTitle.font.getFamilyname());
        this.setFontSize((int)formatTitle.font.getSize());
        this.setFontBold(formatTitle.font.isBold());
        this.setFontItalic(formatTitle.font.isItalic());
    }

    public LayoutCell(LayoutRow row) {
        this.row = row;
    }

    public LayoutCell derive(int fontSize, boolean bold) {
        LayoutCell c = new LayoutCell(this.row);
        c.span = this.span;
        c.content = this.content;
        c.border = this.border;
        c.fontFamily = this.fontFamily;
        c.fontSize = fontSize;
        c.fontColor = this.fontColor;
        c.fontBold = bold;
        c.fontUnderlined = this.fontUnderlined;
        c.fontItalic = this.fontItalic;
        c.color = this.color;
        return c;
    }

    public LayoutCell setAlign(Align a) {
        this.align = a;
        return this;
    }

    public Align getAlign() {
        return this.align;
    }

    public LayoutCell setBorder(float b) {
        this.border = b;
        return this;
    }

    public float getBorder() {
        return this.border;
    }

    public boolean hasBorder() {
        return this.border > 0.0f;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public boolean isFontBold() {
        return this.fontBold;
    }

    public void setFontBold(boolean fontBold) {
        this.fontBold = fontBold;
    }

    public boolean isFontUnderlined() {
        return this.fontUnderlined;
    }

    public void setFontUnderlined(boolean fontUnderlined) {
        this.fontUnderlined = fontUnderlined;
    }

    public boolean isFontItalic() {
        return this.fontItalic;
    }

    public void setFontItalic(boolean fontItalic) {
        this.fontItalic = fontItalic;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
    }

    public void span() {
        this.setSpan(this.span + 1);
    }

    public void unspan() {
        this.setSpan(1);
    }

    public void setSpan(int s) {
        this.setSpan(s, true);
    }

    public void setSpan(int s, boolean mergeCells) {
        if (this.span != s && mergeCells && this.row != null) {
            int col = this.row.getColForCell(this);
            if (col + s - this.span >= this.row.getLayout().getNumberOfCols()) {
                return;
            }
            s = this.row.changeCellSpan(this, this.span, s);
        }
        this.span = s;
    }

    public int getSpan() {
        return this.span;
    }

    public LayoutRow getRow() {
        return this.row;
    }

    public int getColumnIndex() {
        if (this.row == null) {
            return 0;
        }
        int idx = this.row.getCells().indexOf(this);
        int col = 0;
        for (int ii = 0; ii < idx; ++ii) {
            col += this.row.getCellByIndex((int)ii).span;
        }
        return col;
    }

    public void setContent(String text) {
        this.content = text;
    }

    public String getContent() {
        return this.content;
    }

    public ColorOption getBackground() {
        return this.color;
    }

    public void setBackground(ColorOption opt) {
        this.color.update(opt);
    }

    public void setBackground(String co) {
        this.color = ColorOption.fromString(co);
    }

    public String getBackgroundAsString() {
        return this.color == null ? "none" : this.color.toStringDefinition();
    }

    public Integer getBackgroundColor(CmsLocation loc, CmsObservation obs) {
        return this.color == null ? null : this.color.getColor(loc, obs);
    }

    public Integer getForegroundColor(CmsLocation loc, CmsObservation obs) {
        return this.color == null ? null : this.color.getForegroundColor(loc, obs);
    }

    public Element getAsElement() {
        String align = "left";
        switch (this.getAlign()) {
            case CENTER: {
                align = "center";
                break;
            }
            case RIGHT: {
                align = "right";
            }
        }
        Element e = new Element("cell");
        e.setAttribute("border", Float.toString(this.getBorder())).setAttribute("align", align).setAttribute("fontfamily", this.getFontFamily()).setAttribute("fontsize", Integer.toString(this.getFontSize())).setAttribute("fontbold", this.isFontBold() ? "true" : "false").setAttribute("fontunterdlined", this.isFontUnderlined() ? "true" : "false").setAttribute("fontitalic", this.isFontItalic() ? "true" : "false").setAttribute("background", this.getBackgroundAsString()).setAttribute("span", Integer.toString(this.getSpan())).setText(this.content);
        return e;
    }

    public void setFromElement(Element e, boolean ignoreContent) {
        String a = e.getAttributeValue("align");
        if (a == null) {
            a = "left";
        }
        switch (a.toLowerCase()) {
            case "left": {
                this.setAlign(Align.LEFT);
                break;
            }
            case "center": {
                this.setAlign(Align.CENTER);
                break;
            }
            case "right": {
                this.setAlign(Align.RIGHT);
                break;
            }
            case "default": {
                this.setAlign(Align.LEFT);
            }
        }
        String s = e.getAttributeValue("span");
        this.setSpan(Util.parseInt((String)s, (int)1), true);
        String b = e.getAttributeValue("border");
        this.setBorder(Util.parseFloat((String)b, (float)0.8f));
        String bg = e.getAttributeValue("background");
        this.setBackground(bg);
        this.setFontFamily(e.getAttributeValue("fontfamily", "Arial"));
        this.setFontSize(Util.parseInt((String)e.getAttributeValue("fontsize", "12"), (int)12));
        this.setFontBold("true".equalsIgnoreCase(e.getAttributeValue("fontbold", "false")));
        this.setFontUnderlined("true".equalsIgnoreCase(e.getAttributeValue("fontunterdlined", "false")));
        this.setFontItalic("true".equalsIgnoreCase(e.getAttributeValue("fontitalic", "false")));
        if (!ignoreContent) {
            this.setContent(e.getText());
        }
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

