/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.themis.ontology.report.LayoutCell;
import at.grid.themis.ontology.report.ReportTableLayout;
import java.util.ArrayList;

public class LayoutRow {
    ReportTableLayout layout;
    ArrayList<LayoutCell> cells = new ArrayList();
    int height = -1;

    public LayoutRow(ReportTableLayout layout) {
        this.layout = layout;
        for (int ii = 0; ii < layout.getNumberOfCols(); ++ii) {
            this.addCell();
        }
    }

    public ReportTableLayout getLayout() {
        return this.layout;
    }

    public int getRowIndex() {
        return this.layout.rows.indexOf(this);
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getHeight() {
        return this.height;
    }

    public LayoutCell addCell() {
        LayoutCell cell = new LayoutCell(this);
        this.cells.add(cell);
        int colIdx = this.getColForCell(cell);
        return cell;
    }

    public LayoutCell addCell(int index) {
        LayoutCell cell = new LayoutCell(this);
        this.cells.add(index, cell);
        return cell;
    }

    public ArrayList<LayoutCell> getCells() {
        return this.cells;
    }

    public LayoutCell getCellByIndex(int idx) {
        if (idx < 0 || idx >= this.cells.size()) {
            return null;
        }
        return this.cells.get(idx);
    }

    public int getCellIndex(LayoutCell c) {
        return this.cells.indexOf(c);
    }

    public LayoutCell getCell(int colIdx) {
        int cellColumnIndex = 0;
        for (LayoutCell c : this.cells) {
            if (cellColumnIndex + c.getSpan() - 1 >= colIdx) {
                return c;
            }
            cellColumnIndex += c.getSpan();
        }
        return null;
    }

    protected int changeCellSpan(LayoutCell cell, int oldSpan, int newSpan) {
        int resultSpan = newSpan;
        ArrayList<String> content = new ArrayList<String>();
        int idx = this.cells.indexOf(cell);
        if (idx >= 0) {
            while (oldSpan < newSpan) {
                if (idx + 1 < this.cells.size()) {
                    LayoutCell nextCell = this.cells.get(idx + 1);
                    content.add(nextCell.getContent());
                    resultSpan += nextCell.getSpan() - 1;
                } else {
                    return oldSpan;
                }
                this.cells.remove(idx + 1);
                ++oldSpan;
            }
            while (oldSpan > newSpan) {
                this.cells.add(idx + 1, new LayoutCell(this));
                ++newSpan;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(cell.getContent());
        for (String c : content) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(c);
        }
        return resultSpan;
    }

    public int getColForCell(LayoutCell cell) {
        int idx = this.cells.indexOf(cell);
        int cc = 0;
        for (int ii = 0; ii < idx; ++ii) {
            cc += this.cells.get(ii).getSpan();
        }
        return cc;
    }

    public boolean isEmptyImageRow() {
        boolean emptyImageRow = true;
        emptyImageRow = emptyImageRow && this.cells.size() == 1;
        return emptyImageRow;
    }
}

