/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.report.PdfContentAnnualOverview;
import at.grid.themis.ontology.report.PdfContentContactList;
import at.grid.themis.ontology.report.PdfContentDocumentList;
import at.grid.themis.ontology.report.PdfContentEventList;
import at.grid.themis.ontology.report.PdfContentForm;
import at.grid.themis.ontology.report.PdfContentHeaderEvent;
import at.grid.themis.ontology.report.PdfContentHeaderProject;
import at.grid.themis.ontology.report.PdfContentHeaderReport;
import at.grid.themis.ontology.report.PdfContentHeading1;
import at.grid.themis.ontology.report.PdfContentHeading2;
import at.grid.themis.ontology.report.PdfContentPagebreak;
import at.grid.themis.ontology.report.PdfContentParagraph;
import at.grid.themis.ontology.report.PdfContentPicture;
import at.grid.themis.ontology.report.PdfContentSignature;
import at.grid.themis.ontology.report.PdfContentStandardTable;
import at.grid.themis.ontology.report.PdfContentStandardTableOpen;
import at.grid.themis.ontology.report.PdfContentTable;
import at.grid.themis.ontology.report.PdfContentTitle;
import at.grid.themis.ontology.report.PdfContentTitlepage;
import at.grid.util.Util;
import org.jdom.Element;

public abstract class PdfContent {
    String label;

    public String toString() {
        return this.label;
    }

    public abstract PdfContent getNewInstance();

    public abstract Element toXml();

    public static PdfContent fromXml(Element xml) {
        if (xml == null) {
            return null;
        }
        PdfContent pdf = null;
        switch (xml.getName().toLowerCase()) {
            case "paragraph": {
                pdf = new PdfContentParagraph();
                ((PdfContentParagraph)pdf).setText(xml.getText());
                break;
            }
            case "title": {
                pdf = new PdfContentTitle();
                break;
            }
            case "projectpicture": {
                pdf = new PdfContentPicture();
                ((PdfContentPicture)pdf).setWidth(xml.getAttributeValue("width"));
                break;
            }
            case "headerreport": {
                pdf = new PdfContentHeaderReport();
                break;
            }
            case "headerproject": {
                pdf = new PdfContentHeaderProject();
                break;
            }
            case "headerevent": {
                pdf = new PdfContentHeaderEvent();
                break;
            }
            case "titlepage": {
                pdf = new PdfContentTitlepage();
                ((PdfContentTitlepage)pdf).withImage = "true".equals(xml.getAttributeValue("withImage", "false"));
                ((PdfContentTitlepage)pdf).withEventDetails = "true".equals(xml.getAttributeValue("withEventDetails", "false"));
                ((PdfContentTitlepage)pdf).withProjectDetails = "true".equals(xml.getAttributeValue("withProjectDetails", "false"));
                ((PdfContentTitlepage)pdf).withReportHeader = "true".equals(xml.getAttributeValue("withReportHeader", "false"));
                break;
            }
            case "heading1": {
                pdf = new PdfContentHeading1();
                ((PdfContentHeading1)pdf).setText(xml.getText());
                break;
            }
            case "heading2": {
                pdf = new PdfContentHeading2();
                ((PdfContentHeading2)pdf).setText(xml.getText());
                break;
            }
            case "pagebreak": {
                pdf = new PdfContentPagebreak();
                break;
            }
            case "signature": {
                pdf = new PdfContentSignature();
                break;
            }
            case "annualoverview": {
                pdf = new PdfContentAnnualOverview();
                break;
            }
            case "contactlist": {
                pdf = new PdfContentContactList();
                break;
            }
            case "documentlist": {
                pdf = new PdfContentDocumentList();
                break;
            }
            case "eventlist": {
                pdf = new PdfContentEventList();
                break;
            }
            case "standardtable": {
                pdf = new PdfContentStandardTable();
                break;
            }
            case "standardtableopen": {
                pdf = new PdfContentStandardTableOpen();
                break;
            }
            case "form": {
                pdf = new PdfContentForm();
                ((PdfContentForm)pdf).setForm(ThemisApplication.getInstance().getProject().getFormByAlias(xml.getAttributeValue("alias")));
                break;
            }
            case "table": {
                pdf = new PdfContentTable();
                ((PdfContentTable)pdf).setLayoutName(xml.getAttributeValue("layout"));
                String c = xml.getAttributeValue("pagebreak");
                if (c == null) break;
                int pg = Util.parseInt((String)c, (int)0);
                ((PdfContentTable)pdf).setPagebreak(CmsReport.ListPagebreak.getPagebreak(pg));
            }
        }
        return pdf;
    }
}

