/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsFormular;
import at.grid.themis.ontology.element.CmsFormularHistory;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.javafx.formeditor.FormItem;
import at.grid.themis.ontology.report.ExportUtil;
import at.grid.themis.ontology.report.PlaceholderReference;
import at.grid.themis.ontology.signature.ThemisSignature;
import at.grid.util.ExtStringTokenizer;
import at.grid.util.Util;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.openide.util.Exceptions;

public class Placeholder {
    CmsReport rep = null;
    String noEventMessage = "";
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    Properties mapping;
    Properties mappingsql;
    Properties specialPlaceholderValues = new Properties();
    String exceptionMsg = null;
    Exception exception = null;
    long lastObservationId = -1L;
    int observationCounter = 0;
    long lastLocationId = -1L;
    int locationCounter = 0;
    long lastHistoryId = -1L;
    int historyCounter = 0;
    int locationCounterGrouping = 0;
    int pagenumber = 1;
    HashMap<String, CmsFormularHistory> forms = new HashMap();
    ArrayList<UploadItem> currentUploadItems = new ArrayList();
    protected HashMap<Long, Integer> imageIds = new HashMap();
    protected int currentImageNumber = 1;

    public Placeholder(CmsReport rep) {
        this.rep = rep;
        if (this.rep == null) {
            this.rep = new CmsReport();
        }
        this.loadMapping();
    }

    public final void loadMapping() {
        try {
            this.mapping = Placeholder.loadMapping("placeholder_mapping.properties");
            this.mapping.putAll((Map<?, ?>)Placeholder.loadMapping("placeholder_mapping_v4.properties"));
            this.mapping.putAll((Map<?, ?>)Placeholder.loadMapping("placeholder_mapping_param.properties"));
            this.mapping.putAll((Map<?, ?>)Placeholder.loadMapping("placeholder_mapping_documents.properties"));
            for (String k : this.mapping.stringPropertyNames()) {
                if (k.indexOf("#") < 0) continue;
                String v = this.mapping.getProperty(k);
                for (int ii = 1; ii <= 30; ++ii) {
                    this.mapping.put(k.replaceAll("#", Integer.toString(ii)), v.replaceAll("#", Integer.toString(ii)));
                }
            }
            this.mappingsql = Placeholder.loadMapping("placeholder-sql_mapping.properties");
        }
        catch (IOException ex) {
            this.exceptionMsg = "error.read-placeholder-mapping";
            this.exception = ex;
        }
    }

    public static final Properties loadMapping(String propsFileName) throws IOException {
        Properties props = new Properties();
        InputStream in = Placeholder.class.getResourceAsStream(propsFileName);
        props.load(in);
        in.close();
        return props;
    }

    public ArrayList<String> getPlaceholderKeys() {
        ArrayList<String> phs = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        for (String k : this.mapping.stringPropertyNames()) {
            if (phs.contains(this.mapping.getProperty(k))) continue;
            keys.add(k);
            phs.add(this.mapping.getProperty(k));
        }
        Collections.sort(keys);
        return keys;
    }

    public static String replacePlaceholder(String content, String oldKey, String newKey) {
        String replacekey = newKey.replaceAll("#!#", "");
        content = content.replaceAll("#!#" + oldKey + "#!#", "#!#" + replacekey + "#!#");
        content = content.replaceAll("#!#" + oldKey + "=", "#!#" + replacekey + "=");
        content = content.replaceAll("=" + oldKey + "#!#", "=" + replacekey + "#!#");
        return content;
    }

    public static String replaceWithContent(String content, String key, String value) {
        content = content.replaceAll("#!#" + key + "#!#", value);
        return content;
    }

    public String getPlaceholderSql(String placeholder) {
        String ph = this.mapping.getProperty(placeholder, placeholder);
        String sql = this.mappingsql.getProperty(ph);
        return sql;
    }

    public static ArrayList<String> getPlaceholders(String content) {
        ArrayList<String> result = new ArrayList<String>();
        if (content != null) {
            int firstIndex = content.indexOf("#!#");
            int lastIndex = content.indexOf("#!#", firstIndex + 1);
            while (firstIndex >= 0 && lastIndex > firstIndex) {
                result.add(content.substring(firstIndex + 3, lastIndex));
                firstIndex = content.indexOf("#!#", lastIndex + 1);
                lastIndex = content.indexOf("#!#", firstIndex + 1);
            }
        }
        return result;
    }

    public void clearSpecialPlaceholder() {
        this.specialPlaceholderValues.clear();
    }

    public void addSpecialPlaceholder(String key, String val) {
        this.specialPlaceholderValues.setProperty(key, val);
    }

    public void setEvent(CmsEvent ev) {
        this.rep.event = ev;
    }

    public void setReportSpecification(CmsReport rep) {
        this.rep = rep;
    }

    public void resetCounter() {
        this.resetObservationCounter();
        this.resetLocationCounter();
        this.resetLocationCounterGrouping();
    }

    public void resetObservationCounter() {
        this.observationCounter = 0;
    }

    public void resetLocationCounter() {
        this.locationCounter = 0;
    }

    public void resetLocationCounterGrouping() {
        this.locationCounterGrouping = 0;
    }

    public void setPagenumber(int nr) {
        this.pagenumber = nr;
    }

    public String getPagenumber() {
        return Integer.toString(this.pagenumber);
    }

    public String apply(String text, DataRecord item) {
        ArrayList<String> placeholders = Placeholder.getPlaceholders(text);
        String result = text;
        for (String ph : placeholders) {
            if (ph == null || result == null) continue;
            String phc = this.getPlaceholderContent(ph, null, null, null, item);
            result = result.replaceAll("#!#" + ph + "#!#", phc == null ? "" : phc);
        }
        return result == null ? "" : result;
    }

    public String apply(String text) {
        ArrayList<String> placeholders = Placeholder.getPlaceholders(text);
        for (String ph : placeholders) {
            text = text.replaceAll("#!#" + ph + "#!#", this.getPlaceholderContent(ph, null, null, null, null));
        }
        return text;
    }

    public String applyAndFinalise(String text, String phKey, String val) {
        ArrayList<String> placeholders = Placeholder.getPlaceholders(text);
        for (String ph : placeholders) {
            text = text.replaceAll("#!#" + ph + "#!#", this.getPlaceholderContent(ph, null, null, null, null));
        }
        String ph = this.mapping.getProperty(phKey.toLowerCase(), phKey).toLowerCase();
        text = text.replaceAll("#!#" + phKey + "#!#", "#!#" + ph + "#!#");
        return this.removeUnusedPlaceholders(text.replaceAll("#!#" + ph + "#!#", val));
    }

    public String removeUnusedPlaceholders(String text) {
        ArrayList<String> placeholders = Placeholder.getPlaceholders(text);
        for (String ph : placeholders) {
            text = text.replaceAll("#!#" + ph + "#!#", "");
        }
        return text;
    }

    private CmsFormularHistory getFormByName(String name) {
        if (name == null) {
            return null;
        }
        if (this.forms.containsKey(name)) {
            return this.forms.get(name);
        }
        CmsFormular f = this.project.getFormByAlias(name);
        if (f == null) {
            return null;
        }
        CmsFormularHistory fh = null;
        fh = this.rep.event != null ? f.getFormHistory(this.rep.event) : f.getLatestFormHistory();
        this.forms.put(name, fh);
        return fh;
    }

    public String apply(String text, CmsLocation loc, CmsObservation obs, CmsHistory hist, DataRecord item) {
        ArrayList<String> placeholders = Placeholder.getPlaceholders(text);
        for (String ph : placeholders) {
            if (ph.startsWith("form.")) {
                String action;
                int idx = ph.indexOf("=");
                String paramKey = ph;
                String paramVal = "";
                if (idx >= 0) {
                    paramKey = ph.substring(0, idx);
                    if (idx < ph.length()) {
                        paramVal = ph.substring(idx + 1);
                    }
                }
                ExtStringTokenizer tok = new ExtStringTokenizer(paramKey, ".");
                tok.nextToken();
                String formName = tok.nextToken();
                CmsFormularHistory fh = this.getFormByName(formName);
                if (fh == null) {
                    return "";
                }
                String itemId = tok.nextToken().trim();
                FormItem it = fh.getItemById(itemId);
                if (it == null) {
                    return "";
                }
                String v = it.getValue();
                if (v == null) {
                    v = "";
                }
                if ((action = tok.nextTokenOrDefault(null)) == null) {
                    return v;
                }
                switch (action.toLowerCase()) {
                    case "value": {
                        return v;
                    }
                    case "check": {
                        if ("".equals(paramVal)) {
                            return v.equalsIgnoreCase("x") ? "\u2611" : "\u2610";
                        }
                        if (paramVal.endsWith("*")) {
                            return v.startsWith(paramVal.substring(0, paramVal.length() - 1)) ? "\u2611" : "\u2610";
                        }
                        return v.equals(paramVal) ? "\u2611" : "\u2610";
                    }
                }
                return "";
            }
            String cellContent = this.getPlaceholderContent(ph, loc, obs, hist, item);
            cellContent = cellContent.trim();
            text = text.replaceAll("#!#" + ph + "#!#", cellContent);
        }
        return text;
    }

    public String getPlaceholderContent(String placeholder) {
        return this.getPlaceholderContent(placeholder, null, null, null, null);
    }

    public String getPlaceholderContent(String placeholder, String key, String val) {
        return this.getPlaceholderContent(placeholder, null, null, null, null);
    }

    public String getPlaceholderContent(String placeholder, DataRecord item) {
        return this.getPlaceholderContent(placeholder, null, null, null, item);
    }

    public String getPlaceholderContent(String placeholder, CmsLocation loc, CmsObservation obs, CmsHistory hist) {
        return this.getPlaceholderContent(placeholder, loc, obs, hist, null);
    }

    public String getPlaceholderLabel(String placeholder) {
        return placeholder;
    }

    public String getTranslatedPlaceholderKey(String ph) {
        String phKey = Placeholder.getPlaceholderKey(ph);
        return this.mapping.getProperty(phKey.toLowerCase(), phKey).toLowerCase();
    }

    public String getPlaceholderContent(String placeholder, CmsLocation loc, CmsObservation obs, CmsHistory hist, DataRecord item) {
        String ph;
        String v;
        String phKey = Placeholder.getPlaceholderKey(placeholder);
        String phVal = Placeholder.getPlaceholderValue(placeholder, "");
        if ("bez".equals(phVal)) {
            phVal = "label";
        } else if ("zeile".equals(phVal)) {
            phVal = "row";
        }
        if ("label".equalsIgnoreCase(phVal)) {
            boolean bl = false;
        }
        if ((v = this.getPlaceholderContentValue(ph = this.mapping.getProperty(phKey.toLowerCase(), phKey).toLowerCase(), phVal, loc, obs, hist, item, false)) == null) {
            v = this.specialPlaceholderValues.getProperty(ph, "");
        }
        if ("label".equalsIgnoreCase(phVal) && !"".equals(v)) {
            String lbl = new PlaceholderReference(v, ph).getLabel();
            return lbl + ("".equals(lbl) ? "" : ": ") + v;
        }
        return v;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private String getPlaceholderContentValue(String ph, String phVal, CmsLocation loc, CmsObservation obs, CmsHistory hist, DataRecord item, boolean label) {
        if ("attributes".equals(ph) && phVal != null) {
            String[] attPhs = phVal.split(",");
            StringBuilder sb = new StringBuilder();
            String[] stringArray = attPhs;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attPh = stringArray[n2];
                String attPhMapped = this.mapping.getProperty(attPh.toLowerCase(), attPh).toLowerCase();
                String result = this.getPlaceholderContentValue(attPhMapped, null, loc, obs, hist, item, label);
                String string = new PlaceholderReference(result, attPhMapped).getLabel();
                if (result != null && !"".equals(result)) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(string + ": " + result);
                }
                ++n2;
            }
            return sb.toString();
        }
        boolean updateUploads = false;
        if (loc != null && loc.getId() != this.lastLocationId) {
            updateUploads = true;
            ++this.locationCounter;
            ++this.locationCounterGrouping;
            this.lastLocationId = loc.getId();
        }
        if (obs != null && obs.getId() != this.lastObservationId) {
            updateUploads = true;
            ++this.observationCounter;
            this.lastObservationId = obs.getId();
        }
        if (hist == null && obs != null) {
            hist = obs.getLatestHistory();
        }
        if (hist != null && hist.getId() != this.lastHistoryId) {
            updateUploads = true;
            ++this.historyCounter;
            this.lastHistoryId = hist.getId();
        }
        if (updateUploads) {
            this.currentUploadItems.clear();
            this.currentUploadItems.addAll(ExportUtil.getObservationImages(this.rep, obs, hist));
            this.currentUploadItems.addAll(ExportUtil.getLocationImages(this.rep, loc));
            for (UploadItem upload : this.currentUploadItems) {
                this.getImageNumber(upload);
            }
        }
        CmsPlan plan = null;
        String planfile = null;
        if (loc != null && (plan = loc.getPlan()) != null) {
            planfile = plan.getCurrentPlanfileName();
        }
        String itemcode = this.mappingsql.getProperty(ph);
        String attcode = null;
        long obsType = -1L;
        Object var16_27 = null;
        long groupid = -1L;
        CmsProject projectEle = this.project.getProjectElement();
        switch (ph) {
            case "rep.project-number": {
                String string;
                if (label) {
                    string = ph;
                    return string;
                }
                if (projectEle == null) {
                    return "";
                }
                string = projectEle.getAttributeValue("projectnumber");
                return string;
            }
            case "rep.project-location": {
                String string;
                if (label) {
                    string = ph;
                    return string;
                }
                if (projectEle == null) {
                    return "";
                }
                string = projectEle.getAttributeValue("projectlocation");
                return string;
            }
            case "rep.project-client": {
                String string;
                if (label) {
                    string = ph;
                    return string;
                }
                if (projectEle == null) {
                    return "";
                }
                string = projectEle.getAttributeValue("customer");
                return string;
            }
            case "rep.project-title": {
                String string;
                if (label) {
                    string = ph;
                    return string;
                }
                if (projectEle == null) {
                    return "";
                }
                string = projectEle.getAttributeValue("projecttitle");
                return string;
            }
            case "rep.project-description": {
                String string;
                if (label) {
                    string = ph;
                    return string;
                }
                if (projectEle == null) {
                    return "";
                }
                string = projectEle.getAttributeValue("info");
                return string;
            }
            case "rep.project-photo": 
            case "rep.project-logo": {
                if (!label) return "";
                String string = ph;
                return string;
            }
            case "rep.report-title": {
                if (this.rep == null) {
                    return "";
                }
                if (label) {
                    return "";
                }
                String string = this.rep.protTitel;
                return string;
            }
            case "rep.report-number": {
                if (this.rep == null) {
                    return "";
                }
                if (label) {
                    return "";
                }
                String string = this.rep.protNummer;
                return string;
            }
            case "rep.report-date": {
                if (this.rep == null) {
                    return "";
                }
                if (label) {
                    return "";
                }
                String string = this.rep.protDatum;
                return string;
            }
            case "rep.report-dateiso": {
                String string;
                if (this.rep == null) {
                    return "";
                }
                Date dt = Util.parseDate((String)this.rep.protDatum, (TimeZone)this.app.getTimeZone());
                if (dt == null) {
                    string = this.rep.protDatum;
                    return string;
                }
                string = Util.formatDate((Date)dt, (String)Util.DATE_ISO, (TimeZone)this.app.getTimeZone());
                return string;
            }
            case "rep.report-datefile": {
                String string;
                if (this.rep == null) {
                    return "";
                }
                Date dt = Util.parseDate((String)this.rep.protDatum, (TimeZone)this.app.getTimeZone());
                if (dt == null) {
                    string = this.rep.protDatum;
                    return string;
                }
                string = Util.formatDate((Date)dt, (String)Util.DATE_FILE, (TimeZone)this.app.getTimeZone());
                return string;
            }
            case "rep.report-author": {
                if (this.rep == null) {
                    return "";
                }
                if (label) {
                    return "";
                }
                String string = this.rep.protVerfasser;
                return string;
            }
            case "rep.report-version": {
                if (this.rep == null) {
                    return "";
                }
                if (label) {
                    return "";
                }
                String string = this.rep.protVersion;
                return string;
            }
            case "rep.report-distribution": {
                if (this.rep == null) {
                    return "";
                }
                if (label) {
                    return "";
                }
                String string = this.rep.protVerteiler;
                return string;
            }
            case "rep.report-distribution2": {
                if (this.rep == null) {
                    return "";
                }
                if (label) {
                    return "";
                }
                String string = this.rep.protKenntnis;
                return string;
            }
            case "rep.report-signature1": 
            case "rep.report-signature2": {
                return "";
            }
            case "rep.event-date": {
                String string;
                if (this.rep.event == null) {
                    string = this.rep.textNoEvent;
                    return string;
                }
                if (label) {
                    return "";
                }
                string = Util.formatDate((Date)this.rep.event.getDateAttribute("date").getDate(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone());
                return string;
            }
            case "rep.event-title": {
                String string;
                if (this.rep.event == null) {
                    string = this.rep.textNoEvent;
                    return string;
                }
                if (label) {
                    return "";
                }
                string = this.rep.event.getAttributeValue("title");
                return string;
            }
            case "rep.event-comment": {
                String string;
                if (this.rep.event == null) {
                    string = this.rep.textNoEvent;
                    return string;
                }
                if (label) {
                    return "";
                }
                string = this.rep.event.getAttributeValue("comment");
                return string;
            }
            case "rep.event-place": {
                String string;
                if (this.rep.event == null) {
                    string = this.rep.textNoEvent;
                    return string;
                }
                if (label) {
                    return "";
                }
                string = this.rep.event.getAttributeValue("place");
                return string;
            }
            case "rep.event-time": {
                String string;
                if (this.rep.event == null) {
                    string = this.rep.textNoEvent;
                    return string;
                }
                if (label) {
                    return "";
                }
                string = this.rep.event.getAttributeValue("time");
                return string;
            }
            case "rep.event-participant": {
                String string;
                if (this.rep.event == null) {
                    string = this.rep.textNoEvent;
                    return string;
                }
                if (label) {
                    return "";
                }
                string = this.rep.event.getAttributeValue("participants");
                return string;
            }
            case "rep.event-signature": {
                return "";
            }
            case "rep.eventlist": {
                String string;
                if (label) {
                    return "";
                }
                if (this.rep.event == null) {
                    string = this.rep.textNoEvent;
                    return string;
                }
                if (label) {
                    return "";
                }
                string = this.rep.event.getAttributeValue("participants");
                return string;
            }
            case "rep.now-date": {
                if (label) {
                    return "";
                }
                String string = Util.formatDate((Date)new Date(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone());
                return string;
            }
            case "rep.now-dateiso": {
                if (label) {
                    return "";
                }
                String string = Util.formatDate((Date)new Date(), (String)Util.DATE_ISO, (TimeZone)this.project.getTimeZone());
                return string;
            }
            case "rep.now-datefile": {
                if (label) {
                    return "";
                }
                String string = Util.formatDate((Date)new Date(), (String)Util.DATE_FILE, (TimeZone)this.project.getTimeZone());
                return string;
            }
            case "rep.now-datetime": {
                if (label) {
                    return "";
                }
                String string = Util.formatDate((Date)new Date(), (String)Util.DATETIME_READ, (TimeZone)this.project.getTimeZone());
                return string;
            }
            case "rep.now-datetimeiso": {
                if (label) {
                    return "";
                }
                String string = Util.formatDate((Date)new Date(), (String)Util.DATETIME_ISO, (TimeZone)this.project.getTimeZone());
                return string;
            }
            case "rep.now-datetimefile": {
                if (label) {
                    return "";
                }
                String string = Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.project.getTimeZone());
                return string;
            }
            case "rep.pagenumber": {
                if (label) {
                    return "";
                }
                String string = this.getPagenumber();
                return string;
            }
            case "obs.attributes": {
                ArrayList<String> ignoreAtts = new ArrayList<String>();
                ArrayList<String> ignoreAttsCms = new ArrayList<String>();
                if (phVal != null && !"".equals(phVal)) {
                    ignoreAtts.addAll(Arrays.asList(phVal.split(",")));
                    for (String att : ignoreAtts) {
                        ThemisAttribute obsAtt;
                        String trans = this.getTranslatedPlaceholderKey("b." + att);
                        String[] attCodes = trans.substring(4).split("-");
                        String attCode = attCodes[0];
                        if (attCodes.length > 1) {
                            attCode = attCodes[1];
                        }
                        ignoreAttsCms.add((obsAtt = this.app.getSettings().getObservationAttribute(attCode)) == null ? att : obsAtt.getCmsCode());
                    }
                }
                if (obs == null) return "";
                return obs.toStringWithIgnoreString("", "\n", true, ignoreAttsCms);
            }
            case "obs.uuid": {
                String string;
                if (label) {
                    return "UUID";
                }
                if (obs != null) {
                    string = obs.getUUID().toString();
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.id": {
                String string;
                if (label) {
                    return "ID";
                }
                if (obs != null) {
                    string = Long.toString(obs.getId());
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.creator": {
                String string;
                if (label) {
                    return ph;
                }
                if (obs != null) {
                    string = obs.getAttributeValue("meta_iduser_name");
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.observation-creationdate": {
                String string;
                if (label) {
                    return ph;
                }
                if (obs != null) {
                    string = Util.formatDate((Date)obs.getDateAttribute("creationdate").getDate(), (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone());
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.observation-systemcreationdate": {
                String string;
                if (label) {
                    return ph;
                }
                if (obs != null) {
                    string = Util.formatDate((Date)obs.getDateAttribute("meta_created").getDate(), (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone());
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.observation-systemcreationtime": {
                String string;
                if (label) {
                    return ph;
                }
                if (obs != null) {
                    string = Util.formatDate((Date)obs.getDateAttribute("meta_created").getDate(), (String)Util.DATETIME_READ, (TimeZone)this.app.getTimeZone());
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.counter": {
                if (!label) return Integer.toString(this.observationCounter);
                return ph;
            }
            case "obs.observation-number": 
            case "obs.observation-type": 
            case "obs.observation-title": 
            case "obs.observation-observationtype": 
            case "obs.observation-donedate": {
                String string;
                if (label) {
                    return ph;
                }
                attcode = ph.substring("obs.observation-".length());
                if (obs != null) {
                    string = obs.getAttributeValue(attcode);
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.history-title": 
            case "obs.history-code": 
            case "obs.history-freetext1": 
            case "obs.history-freetext2": 
            case "obs.history-freetext3": 
            case "obs.history-langtext1": 
            case "obs.history-langtext2": 
            case "obs.history-topic": 
            case "obs.history-priority": 
            case "obs.history-float1": 
            case "obs.history-float2": 
            case "obs.history-float3": 
            case "obs.history-float4": 
            case "obs.history-quantity": 
            case "obs.history-description": 
            case "obs.history-measure": 
            case "obs.history-responsible": 
            case "obs.history-eventdate": {
                String string;
                if (label) {
                    return ph;
                }
                attcode = ph.substring("obs.history-".length());
                if (hist != null) {
                    string = hist.getAttributeValue(attcode);
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.history-event": {
                if (label) {
                    return ph;
                }
                if (hist == null) {
                    boolean bl = true;
                }
                if (hist == null) {
                    return "-";
                }
                if (hist.getEvent() == null) {
                    return "";
                }
                String string = hist.getEvent().getTitle();
                return string;
            }
            case "obs.history-event-title": {
                if (label) {
                    return ph;
                }
                if (hist == null) {
                    return "-";
                }
                if (hist.getEvent() == null) {
                    return "";
                }
                String string = hist.getEvent().getEventTitle();
                return string;
            }
            case "obs.history-event-participants": {
                if (label) {
                    return ph;
                }
                if (hist == null) {
                    return "-";
                }
                if (hist.getEvent() == null) {
                    return "";
                }
                String string = hist.getEvent().getAttributeValue("participants", attcode);
                return string;
            }
            case "obs.history-duedate": {
                String string;
                if (label) {
                    return ph;
                }
                if (obs == null) return "";
                if (obs.getKeyAttribute("type").getId() == 3L) {
                    return "";
                }
                if (hist != null) {
                    string = hist.getAttributeValue("duedate");
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.history-done": {
                String string;
                if (label) {
                    return ph;
                }
                if (obs == null) {
                    return "";
                }
                obsType = obs.getKeyAttribute("type").getId();
                if (obsType == 2L) return "";
                if (obsType == 3L) {
                    return "";
                }
                if (hist == null) {
                    if (item == null) return "";
                    if (itemcode == null) return "";
                    string = item.getString(itemcode);
                    return string;
                }
                if (hist.getBooleanAttribute("done").isSet()) {
                    string = this.rep.textStatusDone;
                    return string;
                }
                string = this.rep.textStatusOpen;
                return string;
            }
            case "obs.histories-dates": {
                if (label) {
                    return ph;
                }
                if (obs == null) {
                    return "";
                }
                List<CmsElement> hists = obs.getHistories();
                ArrayList<String> dates = new ArrayList<String>();
                Iterator<CmsElement> trans = hists.iterator();
                while (trans.hasNext()) {
                    CmsElement h = trans.next();
                    Date dt = h.getDateAttribute("eventdate").getDate();
                    if (dt == null) continue;
                    dates.add(Util.formatDate((Date)dt, (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
                }
                return Util.toString(dates, (String)", ");
            }
            case "obs.histories-count": {
                if (label) {
                    return ph;
                }
                if (obs == null) {
                    return "";
                }
                String string = Integer.toString(obs.getHistories().size());
                return string;
            }
            case "obs.location-attributes": {
                ArrayList<String> ignoreAtts = new ArrayList<String>();
                ArrayList<String> ignoreAttsCms = new ArrayList<String>();
                if (phVal == null) return loc.toStringWithIgnoreString("", "\n", true, ignoreAttsCms);
                if ("".equals(phVal)) return loc.toStringWithIgnoreString("", "\n", true, ignoreAttsCms);
                ignoreAtts.addAll(Arrays.asList(phVal.split(",")));
                Iterator hists = ignoreAtts.iterator();
                while (hists.hasNext()) {
                    ThemisAttribute locAtt;
                    String att = (String)hists.next();
                    String trans = this.getTranslatedPlaceholderKey("g." + att);
                    String[] attCodes = trans.substring(13).split("-");
                    String attCode = attCodes[0];
                    if (attCodes.length > 1) {
                        attCode = attCodes[1];
                    }
                    ignoreAttsCms.add((locAtt = this.app.getSettings().getLocationAttribute(attCode)) == null ? att : locAtt.getCmsCode());
                }
                return loc.toStringWithIgnoreString("", "\n", true, ignoreAttsCms);
            }
            case "obs.location-systemcreationdate": {
                String string;
                if (label) {
                    return ph;
                }
                if (loc != null) {
                    string = Util.formatDate((Date)loc.getDateAttribute("meta_created").getDate(), (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone());
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.location-systemcreationtime": {
                String string;
                if (label) {
                    return ph;
                }
                if (loc != null) {
                    string = Util.formatDate((Date)loc.getDateAttribute("meta_created").getDate(), (String)Util.DATETIME_READ, (TimeZone)this.app.getTimeZone());
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.location-creationdate": {
                String string;
                if (label) {
                    return ph;
                }
                if (loc != null) {
                    string = Util.formatDate((Date)loc.getDateAttribute("meta_created").getDate(), (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone());
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.location-counter": {
                if (!label) return Integer.toString(this.locationCounter);
                return ph;
            }
            case "obs.location-counter-grouping": {
                if (!label) return Integer.toString(this.locationCounterGrouping);
                return ph;
            }
            case "obs.location-number": 
            case "obs.location-prenumber": 
            case "obs.location-postnumber": 
            case "obs.location-title": 
            case "obs.location-locationgroup": 
            case "obs.location-barcode": 
            case "obs.location-code2": 
            case "obs.location-text3": 
            case "obs.location-text4": 
            case "obs.location-list1": 
            case "obs.location-list2": 
            case "obs.location-code": 
            case "obs.location-longtext1": 
            case "obs.location-longtext2": 
            case "obs.location-longtext3": 
            case "obs.location-longtext4": 
            case "obs.location-list3": 
            case "obs.location-list4": 
            case "obs.location-description": 
            case "obs.location-quantity": 
            case "obs.location-boolean1": 
            case "obs.location-boolean2": 
            case "obs.location-boolean3": 
            case "obs.location-boolean4": {
                String string;
                if (label) {
                    return ph;
                }
                attcode = ph.substring("obs.location-".length());
                if (loc != null) {
                    string = loc.getAttributeValue(attcode);
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.location-buildingtitle": {
                String string;
                if (label) {
                    return ph;
                }
                attcode = ph.substring("obs.location-".length());
                if (loc != null) {
                    string = loc.getBuildingTitle();
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.location-date1": 
            case "obs.location-date2": 
            case "obs.location-date3": 
            case "obs.location-date4": {
                String string;
                if (label) {
                    return ph;
                }
                attcode = ph.substring("obs.location-".length());
                if (loc != null) {
                    string = loc.getAttributeValue(attcode);
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getDateAsString(itemcode, this.project.getTimeZone(), Util.DATE_READ);
                return string;
            }
            case "obs.location-uuid": {
                String string;
                if (label) {
                    return ph;
                }
                if (loc != null) {
                    string = loc.getUUID().toString();
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.location-id": {
                String string;
                if (label) {
                    return "G-ID";
                }
                if (loc != null) {
                    string = Long.toString(loc.getId());
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.location-fullnumber": {
                String string;
                if (label) {
                    return ph;
                }
                if (loc != null) {
                    string = loc.getFullNumber();
                    return string;
                }
                if (item == null) return "";
                if (itemcode == null) return "";
                string = item.getString(itemcode);
                return string;
            }
            case "obs.location-plan": {
                String string;
                if (label) {
                    return ph;
                }
                if (plan != null) {
                    string = plan.getTitle();
                    return string;
                }
                if (item == null) {
                    return "";
                }
                string = item.getString("plantitle");
                return string;
            }
            case "obs.location-plansnippet": {
                return "";
            }
            case "obs.location-plan-file": {
                if (label) {
                    return ph;
                }
                if (planfile == null) {
                    return "";
                }
                String string = planfile;
                return string;
            }
            case "obs.location-plan-x": {
                if (label) {
                    return ph;
                }
                if (plan == null) {
                    return "";
                }
                String string = Double.toString(loc.getPosition().getPoint().getX());
                return string;
            }
            case "obs.location-plan-y": {
                if (label) {
                    return ph;
                }
                if (plan == null) {
                    return "";
                }
                String string = Double.toString(loc.getPosition().getPoint().getY());
                return string;
            }
            case "obs.location-plansnippet-per-location": {
                return "";
            }
            case "obs.location-locationgroup-full": {
                if (loc != null) {
                    groupid = loc.getRelationAttribute("locationgroup").getFirstElementId();
                    return this.project.getDatastorage().getElementAttribute(groupid, "groupfullname");
                }
                if (item == null) return "";
                groupid = Util.parseLong((String)item.getString("idlocationgroup"), (long)-1L);
                return this.project.getDatastorage().getElementAttribute(groupid, "groupfullname");
            }
            case "obs.location-locationgroup1": 
            case "obs.location-locationgroup2": 
            case "obs.location-locationgroup3": {
                groupid = -1L;
                if (loc != null) {
                    groupid = loc.getRelationAttribute("locationgroup").getFirstElementId();
                } else {
                    if (item == null) return "";
                    groupid = Util.parseLong((String)item.getString("idlocationgroup"), (long)-1L);
                }
                String idsStr = this.project.getDatastorage().getElementAttribute(groupid, "groupfullid");
                String[] ids = idsStr.split("\\.");
                int level = Util.parseInt((String)ph.substring(ph.length() - 1), (int)0);
                if (level <= 0) return "";
                if (level > ids.length) return "";
                groupid = Util.parseLong((String)ids[level - 1], (long)-1L);
                return this.project.getDatastorage().getElementAttribute(groupid, "title");
            }
            case "obs.location-locationgroup-chapter": {
                if (loc != null) {
                    groupid = loc.getRelationAttribute("locationgroup").getFirstElementId();
                    return this.project.getDatastorage().getElementAttribute(groupid, "chapter");
                }
                if (item == null) return "";
                groupid = Util.parseLong((String)item.getString("idlocationgroup"), (long)-1L);
                return this.project.getDatastorage().getElementAttribute(groupid, "chapter");
            }
            case "obs.location-locationgroup-description": {
                if (loc != null) {
                    groupid = loc.getRelationAttribute("locationgroup").getFirstElementId();
                    return this.project.getDatastorage().getElementAttribute(groupid, "description");
                }
                if (item == null) return "";
                groupid = Util.parseLong((String)item.getString("idlocationgroup"), (long)-1L);
                return this.project.getDatastorage().getElementAttribute(groupid, "description");
            }
            case "obs.location-dimwidth": 
            case "obs.location-dimheight": 
            case "obs.location-dimdiameter": 
            case "obs.location-dimarea": {
                if (label) {
                    return ph;
                }
                attcode = ph.substring("obs.location-".length());
                if (loc == null) {
                    return "";
                }
                String string = loc.getAttributeValue(attcode);
                return string;
            }
            case "obs.image-number": 
            case "obs.image-comment": 
            case "obs.image-info": 
            case "obs.image-file": 
            case "obs.image-dummy": {
                return "";
            }
            case "obs.image-numbers": {
                ArrayList<Integer> numbers = new ArrayList<Integer>();
                for (UploadItem upload : this.currentUploadItems) {
                    numbers.add(this.getImageNumber(upload));
                }
                if (numbers.isEmpty()) {
                    return "-";
                }
                Collections.sort(numbers);
                ArrayList<NumberRange> ranges = new ArrayList<NumberRange>();
                NumberRange currentRange = new NumberRange((Integer)numbers.get(0));
                for (int ii = 1; ii < numbers.size(); ++ii) {
                    if (currentRange.check((Integer)numbers.get(ii))) continue;
                    ranges.add(currentRange);
                    currentRange = new NumberRange((Integer)numbers.get(ii));
                }
                ranges.add(currentRange);
                StringBuilder sbRange = new StringBuilder();
                boolean firstRange = true;
                Iterator iterator = ranges.iterator();
                while (iterator.hasNext()) {
                    NumberRange range = (NumberRange)iterator.next();
                    if (!firstRange) {
                        sbRange.append(", ");
                    }
                    sbRange.append(range.toString());
                    firstRange = false;
                }
                return sbRange.toString();
            }
            case "obs.document-summary": {
                CmsObservation cmsObservation = obs;
            }
            case "obs.location-document-summary": {
                void var16_31;
                void var16_29;
                if (var16_29 == null) {
                    CmsLocation cmsLocation = loc;
                }
                if (label) {
                    return ph;
                }
                if (var16_31 == null) return "";
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                Iterator iterator = var16_31.getRelationAttribute("infos").getElements().iterator();
                while (iterator.hasNext()) {
                    CmsElementSummary e = (CmsElementSummary)iterator.next();
                    if (!first) {
                        sb.append("\n");
                    }
                    sb.append(e.getTitle());
                    first = false;
                }
                return sb.toString();
            }
            case "obs.document-documenttype": 
            case "obs.document-title": 
            case "obs.document-date": 
            case "obs.document-comment": {
                return "";
            }
            case "obs.history-dummy": 
            case "obs.observation-dummy": 
            case "obs.rowheight": 
            case "obs.pagebreak": 
            case "obs.pagebreak-2": 
            case "obs.pagebreak-3": 
            case "obs.pagebreak-4": 
            case "obs.repeat": {
                return "";
            }
        }
        if (ph.startsWith("obs.contact")) {
            if (obs != null) {
                CmsElementSummary contact = obs.getRelationAttribute("responsible").getFirstElement();
                if (contact == null) {
                    return "";
                }
                CmsElement e = contact.getElement();
                switch (ph) {
                    case "obs.contact": {
                        if (!label) return e.getTitle();
                        return ph;
                    }
                    case "obs.contact-name": {
                        if (!label) return e.getAttributeValue("name");
                        return ph;
                    }
                    case "obs.contact-email": {
                        if (!label) return e.getAttributeValue("email");
                        return ph;
                    }
                    case "obs.contact-tel": {
                        if (!label) return e.getAttributeValue("tel");
                        return ph;
                    }
                }
                return null;
            }
            if (label) {
                return ph;
            }
            if (item == null) {
                return "";
            }
            String string = item.getString("responsible");
            return string;
        }
        if (ph.startsWith("obs.location-image") || ph.startsWith("obs.image")) {
            String[] phSub;
            int idx = 18;
            boolean imageForObs = false;
            if (ph.startsWith("obs.image")) {
                idx = 9;
                imageForObs = true;
            }
            if ((phSub = ph.substring(idx).split("-")).length == 1) {
                return "";
            }
            int nr = Util.parseInt((String)phSub[0], (int)-1);
            ArrayList<UploadItem> uploads = null;
            if (imageForObs) {
                if (obs == null) {
                    return "";
                }
                uploads = ExportUtil.getObservationImages(this.rep, obs, hist);
            } else {
                if (loc == null) {
                    return "";
                }
                uploads = ExportUtil.getLocationImages(this.rep, loc);
            }
            if (uploads == null) return "";
            if (nr < 1) return "";
            if (nr > uploads.size()) {
                return "";
            }
            switch (phSub[1]) {
                case "file": {
                    return "";
                }
                case "number": {
                    if (!label) return Integer.toString(this.getImageNumber(uploads.get(nr - 1)));
                    return ph;
                }
                case "filename": {
                    if (!label) return uploads.get(nr - 1).getName();
                    return ph;
                }
                case "info": {
                    if (!label) return uploads.get(nr - 1).getFileInfo();
                    return ph;
                }
                case "comment": {
                    if (!label) return uploads.get(nr - 1).getFileComment();
                    return ph;
                }
            }
            return null;
        }
        if (!ph.startsWith("rep.report-signature")) return null;
        String sigIdxStr = ph.substring(20, 21);
        int sigIdx = Util.parseInt((String)sigIdxStr, (int)-1) - 1;
        String sigContent = ph.substring(22);
        if (this.rep == null) return "";
        if (label) return "";
        if (sigIdx < 0) return "";
        if (this.rep.signatures.size() <= sigIdx) {
            return "";
        }
        ThemisSignature sig = this.rep.signatures.get(sigIdx);
        switch (sigContent.toLowerCase()) {
            case "name": {
                return sig.getName();
            }
            case "function": {
                return sig.getFunction();
            }
        }
        return null;
    }

    public File getPlaceholderImage(String placeholder, CmsLocation loc, CmsObservation obs, CmsHistory hist) {
        ArrayList<UploadItem> items = this.getPlaceholderUploads(placeholder, loc, obs, hist);
        return items.isEmpty() ? null : items.get(0).getFile();
    }

    public ArrayList<UploadItem> getPlaceholderUploads(String placeholder, CmsLocation loc, CmsObservation obs, CmsHistory hist) {
        ArrayList<UploadItem> result = new ArrayList<UploadItem>();
        String phKey = Placeholder.getPlaceholderKey(placeholder);
        int phVal = Placeholder.getPlaceholderValue(placeholder, 0);
        String ph = this.mapping.getProperty(phKey.toLowerCase(), phKey).toLowerCase();
        if (loc != null && loc.getId() != this.lastLocationId) {
            ++this.locationCounter;
            ++this.locationCounterGrouping;
            this.lastLocationId = loc.getId();
        }
        if (obs != null && obs.getId() != this.lastObservationId) {
            ++this.observationCounter;
            this.lastObservationId = obs.getId();
        }
        if (hist == null && obs != null) {
            hist = obs.getLatestHistory();
        }
        CmsPlan plan = null;
        if (loc != null) {
            plan = loc.getPlan();
        }
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        UploadItem item = null;
        switch (ph) {
            case "rep.project-photo": {
                item = this.project.getProjectElement().getUploadAttribute("projectimage").getFirstUploadItem();
                break;
            }
            case "rep.project-logo": {
                item = this.project.getProjectElement().getUploadAttribute("projectlogo").getFirstUploadItem();
                break;
            }
            case "rep.report-signature1": {
                item = new UploadItem((CmsApplication)this.project);
                item.setFile(this.rep.getSignatureFile(0));
                break;
            }
            case "rep.report-signature2": {
                item = new UploadItem((CmsApplication)this.project, -1L);
                item.setFile(this.rep.getSignatureFile(1));
                break;
            }
            case "rep.report-signature3": {
                item = new UploadItem((CmsApplication)this.project, -1L);
                item.setFile(this.rep.getSignatureFile(2));
                break;
            }
            case "rep.report-signature4": {
                item = new UploadItem((CmsApplication)this.project, -1L);
                item.setFile(this.rep.getSignatureFile(3));
                break;
            }
            case "obs.image-file": {
                ArrayList<UploadItem> uploads;
                if (obs == null || (uploads = ExportUtil.getObservationImages(this.rep, obs, hist)) == null) break;
                items.addAll(uploads);
                break;
            }
            case "obs.image-files": {
                ArrayList<UploadItem> uploads;
                if (obs == null || (uploads = ExportUtil.getObservationImages(this.rep, obs, hist)) == null) break;
                for (UploadItem upload : uploads) {
                    upload.setProperty("all", "true");
                    items.add(upload);
                }
                break;
            }
            case "obs.location-image-file": {
                ArrayList<UploadItem> locationImages;
                if (loc == null || (locationImages = ExportUtil.getLocationImages(this.rep, loc)) == null || locationImages.size() <= 0) break;
                items.addAll(locationImages);
                break;
            }
            case "obs.location-image-files": {
                ArrayList<UploadItem> locationImages;
                if (loc == null || (locationImages = ExportUtil.getLocationImages(this.rep, loc)) == null) break;
                for (UploadItem upload : locationImages) {
                    upload.setProperty("all", "true");
                    items.add(upload);
                }
                break;
            }
            case "obs.location-plansnippet": {
                File f;
                if (loc == null || (f = loc.getPlanSnippetFile(this.rep.getPlanSnippetSize())) == null) break;
                UploadItem u = new UploadItem((CmsApplication)this.project, f.getParentFile(), f.getName(), "jpg", f.length(), null, 3);
                items.add(u);
                break;
            }
            case "obs.location-icon": {
                if (loc == null) break;
                String fn = loc.getAttributeValue("iconfile");
                try {
                    File iconFile = this.app.getProject().getUploadFile("icon", fn);
                    if (!iconFile.isFile()) break;
                    item = new UploadItem((CmsApplication)this.project, iconFile.getParentFile(), iconFile.getName(), "jpg", 0L, new Date(), 0);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            default: {
                String[] split;
                if (ph.startsWith("rep.report-signature") && ph.length() == 21) {
                    String sigIdxStr = ph.substring(20, 21);
                    int sigIdx = Util.parseInt((String)sigIdxStr, (int)-1) - 1;
                    if (this.rep == null || sigIdx < 0 || this.rep.signatures.size() <= sigIdx) {
                        return null;
                    }
                    ThemisSignature sig = this.rep.signatures.get(sigIdx);
                    File fSig = new File(this.project.getTempfileLocation(), "sig1.png");
                    try {
                        ImageIO.write((RenderedImage)sig.getSignature(), "png", fSig);
                        item = new UploadItem((CmsApplication)this.project, fSig.getParentFile(), fSig.getName(), "png", 0L, new Date(), 0);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if ((split = ph.split("\\.")).length < 2) {
                    return result;
                }
                String elementtype = "obs";
                String[] contentSplit = split[1].split("-");
                if (contentSplit.length < 2) {
                    return result;
                }
                String content = contentSplit[0];
                String subcontent = contentSplit[1];
                if (content.toLowerCase().equals("location")) {
                    elementtype = "loc";
                    if (contentSplit.length != 3) {
                        return result;
                    }
                    content = contentSplit[1];
                    subcontent = contentSplit[2];
                }
                if (!content.toLowerCase().startsWith("image") || contentSplit.length < 2) {
                    return result;
                }
                if (!subcontent.toLowerCase().equals("file")) break;
                int imagenr = Util.parseInt((String)content.substring(5), (int)1);
                ArrayList<UploadItem> uploads = null;
                switch (elementtype.toLowerCase()) {
                    case "obs": {
                        uploads = ExportUtil.getObservationImages(this.rep, obs, hist);
                        break;
                    }
                    case "loc": {
                        uploads = ExportUtil.getLocationImages(this.rep, loc);
                    }
                }
                if (uploads == null || uploads.size() < imagenr) break;
                items.add(uploads.get(imagenr - 1));
            }
        }
        result.addAll(items);
        if (item != null) {
            if (phVal >= 0) {
                item.setProperty("width", Integer.toString(phVal));
            }
            result.add(item);
        }
        return result;
    }

    public String getExceptionMsg() {
        return this.exceptionMsg;
    }

    public Exception getException() {
        return this.exception;
    }

    public Properties getMapping() {
        return this.mapping;
    }

    public static String getPlaceholderKey(String ph) {
        String[] split = ph.split(";");
        return split[0];
    }

    public static int getPlaceholderValue(String ph, int defaultValue) {
        String[] split = ph.split(";");
        return split.length == 1 ? defaultValue : Util.parseInt((String)split[1], (int)defaultValue);
    }

    public static float getPlaceholderValue(String ph, float defaultValue) {
        String[] split = ph.split(";");
        return split.length == 1 ? defaultValue : Util.parseFloat((String)split[1], (float)defaultValue);
    }

    public static String getPlaceholderValue(String ph, String defaultValue) {
        String[] split = ph.split(";");
        return split.length == 1 ? defaultValue : split[1];
    }

    public static String getSortString(String sortParam, Properties mapping, String defaultSort) {
        if (sortParam == null) {
            return defaultSort;
        }
        if (mapping == null) {
            mapping = new Properties();
        }
        String[] sorts = sortParam.split(",");
        String sortString = "";
        for (String s : sorts) {
            String s2 = mapping.getProperty(s.toLowerCase(), s);
            if (s2 == null) {
                s2 = s;
            }
            if ("obs.location-fullnumber".equals(s2)) {
                sortString = sortString + (sortString.length() > 0 ? "," : "") + (ThemisApplication.getInstance().getSettings().getLocationAttribute("prefixsuffix").isUsed() ? "ele.prenumber," : "") + "ele.number," + (ThemisApplication.getInstance().getSettings().getLocationAttribute("suffix").isUsed() ? "ele.postnumber," : "") + "observation.number,observation.idelement";
                continue;
            }
            if ("obs.location-locationgroup".equals(s2)) {
                sortString = sortString + (sortString.length() > 0 ? "," : "") + "locationgroupele.title";
                continue;
            }
            if ("obs.location-plan".equals(s2)) {
                sortString = sortString + (sortString.length() > 0 ? "," : "") + "plan.sort";
                continue;
            }
            if (s2.length() > 4 && ".".equals(s2.substring(3, 4))) {
                String[] sortspec = s2.substring(4).split("-");
                CmsAttribute att = null;
                if (sortspec.length > 1) {
                    if (sortspec[0].equals("observation")) {
                        att = ThemisApplication.getInstance().getProject().getDefaultElement("observation").getAttribute(sortspec[1]);
                    } else if (sortspec[0].equals("location")) {
                        att = ThemisApplication.getInstance().getProject().getDefaultElement("location").getAttribute(sortspec[1]);
                    }
                    if (att == null) continue;
                    String tbl = sortspec[0].equals("observation") ? "observation" : "ele";
                    String fld = att.getField();
                    if (att.isOfType(8)) {
                        tbl = att.getCode() + "tbl";
                        fld = att.getCode() + "term";
                    }
                    sortString = sortString + (sortString.length() > 0 ? "," : "") + tbl + "." + fld;
                    continue;
                }
                sortString = sortString + (sortString.length() > 0 ? "," : "") + s2;
                continue;
            }
            sortString = sortString + (sortString.length() > 0 ? "," : "") + s2;
        }
        return sortString.length() > 0 ? sortString : defaultSort;
    }

    public void clearCurrentUploadItems() {
        this.currentUploadItems.clear();
    }

    public boolean addToCurrentUploadItems(UploadItem item) {
        if (this.currentUploadItems.contains(item)) {
            return false;
        }
        this.currentUploadItems.add(item);
        this.getImageNumber(item);
        return true;
    }

    public int getImageNumber(UploadItem item) {
        if (item != null && ("history".equals(item.getElementtype()) || "location".equals(item.getElementtype()))) {
            Integer number = this.imageIds.get(item.getId());
            if (number == null) {
                this.imageIds.put(item.getId(), this.currentImageNumber);
                ++this.currentImageNumber;
                return this.currentImageNumber - 1;
            }
            return number;
        }
        return -1;
    }

    public HashMap<Long, Integer> getImageIds() {
        return this.imageIds;
    }

    class NumberRange {
        int min;
        int max;

        public NumberRange(int nr) {
            this.min = nr;
            this.max = nr;
        }

        boolean check(int nr) {
            if (nr == this.max + 1) {
                this.max = nr;
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.min == this.max) {
                return Integer.toString(this.min);
            }
            if (this.min == this.max - 1) {
                return this.min + ", " + this.max;
            }
            return this.min + "-" + this.max;
        }
    }
}

