/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.cms.storage.DataRecord;
import at.grid.gui.ImagePanel;
import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColors;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsPlanCalibration;
import java.awt.Color;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class PlanCreator1 {
    private static Color colorLabel = ThemisColors.red;
    private static Color colorLabelText = ThemisColors.white;
    private static Color colorPoint = ThemisColors.orange;
    private static Color colorPointSel = ThemisColors.white;
    private static Point labeloffset = null;
    private static boolean nolabelbackground = false;

    public static int loadGeometries(ThemisApplication app, ImagePanel imagePanel, CmsPlan plan, ThemisProject project, float sizeFactor, ArrayList<Long> locationIds, boolean showCalibPoints, List<DataRecord> recs) {
        String labelAttStr;
        if (plan == null) {
            return 0;
        }
        imagePanel.removeGeometries();
        if (plan.isCurrentPlanfileCalibrated()) {
            CmsPlanCalibration calib = plan.getCurrentPlanfileElement().getCalibration();
            if (showCalibPoints && (calib.getMethod() == 1 || calib.getMethod() == 2)) {
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(new Point(calib.getPlanX1(), calib.getPlanY1()));
                points.add(new Point(calib.getPlanX2(), calib.getPlanY2()));
                PlanCreator1.showCalibrationPoints(imagePanel, points, true);
            }
        }
        ThemisAttribute labelAtt = (labelAttStr = app.getSettings().getDisplayLabelAttribute()) == null ? null : app.getSettings().getLocationAttribute(labelAttStr);
        boolean labelWithNumber = app.getSettings().getDisplayLabelNumber();
        boolean moveIconsWithLabel = app.getSettings().getDisplayMoveIconWithLabel();
        labeloffset = app.getSettings().getDisplayLabelOffset();
        if (labeloffset != null) {
            labeloffset.setX(labeloffset.getX() * 300.0 / 254.0);
            labeloffset.setY(labeloffset.getY() * 300.0 / 254.0);
        }
        boolean useIcons = app.getSettings().getLocationAttribute("icon").isUsed();
        int iconSize = (int)((double)app.getSettings().getDisplayIconSize() * 300.0 / 254.0);
        int pointSize = (int)((double)app.getSettings().getDisplayPointSize() * 300.0 / 254.0);
        int fontSize = (int)((double)app.getSettings().getDisplayFontSize() * 300.0 / 254.0);
        int lineSize = (int)((double)app.getSettings().getDisplayLineSize() * 300.0 / 254.0);
        ColorOption co = app.getSettings().getDisplayColorOption();
        colorPoint = ThemisUtil.getColorFromString(app.getSettings().getDisplayColorPoint());
        colorPointSel = ThemisUtil.getColorFromString(app.getSettings().getDisplayColorPointSelected());
        colorLabel = Color.BLUE;
        if (co.getStaticColor() != null) {
            colorLabel = new Color(co.getStaticColor());
        }
        colorLabelText = Color.WHITE;
        if (co.getStaticForegroundColor() != null) {
            colorLabelText = new Color(co.getStaticForegroundColor());
        }
        nolabelbackground = co.getMethod() == ColorOption.Method.NOCOLOR;
        imagePanel.setIconSize(iconSize);
        boolean errorFound = false;
        int counter = 0;
        if (recs == null) {
            recs = new ArrayList<DataRecord>();
            List<DataRecord> filteredLocations = app.getFilter().getFilteredLocations();
            for (DataRecord rec : filteredLocations) {
                if (rec.getLong("planid").longValue() != plan.getId()) continue;
                recs.add(rec);
            }
            project.getLogger().fine("Locations loaded for display in plan " + plan.getTitle() + ", count = " + recs.size());
        }
        for (DataRecord rec : recs) {
            if (rec.getLong("planid").longValue() != plan.getId()) continue;
            try {
                long metaid = rec.getLong("meta_id");
                String att = labelAtt != null && !rec.isEmpty(labelAtt.getSqlCode()) ? rec.get(labelAtt.getSqlCode()) : "";
                String label = PlanCreator1.getLabel(labelWithNumber, rec.get("prenumber"), rec.get("number"), rec.get("postnumber"), att);
                PlanCreator1.createGeometry(app, project, imagePanel, plan, metaid, rec, label, 1, sizeFactor, useIcons, pointSize, fontSize, lineSize, moveIconsWithLabel, co);
                ++counter;
            }
            catch (Exception e) {
                if (!errorFound) {
                    app.getDialog().showErrorDialog("ERROR: " + e.getMessage(), e);
                    errorFound = true;
                }
                e.printStackTrace();
            }
        }
        return counter;
    }

    public static String getLabel(boolean labelWithNumber, String fullnumber, String att) {
        String label = "";
        if (labelWithNumber && fullnumber != null) {
            label = fullnumber;
        }
        if (att != null && !att.isEmpty()) {
            label = label + " " + att.trim();
        }
        return label;
    }

    public static String getLabel(boolean labelWithNumber, String prefix, String number, String suffix, String att) {
        String fullnumber = null;
        ThemisApplication app = ThemisApplication.getInstance();
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        if (labelWithNumber) {
            boolean usePrefix = app.getSettings().getLocationAttribute("prefixsuffix").isUsed();
            boolean useSuffix = app.getSettings().getLocationAttribute("suffix").isUsed();
            fullnumber = (usePrefix ? prefix : "") + number + (useSuffix ? suffix : "");
        }
        return PlanCreator1.getLabel(labelWithNumber, fullnumber, att);
    }

    private static void createGeometry(ThemisApplication app, ThemisProject project, ImagePanel imagePanel, CmsPlan plan, long metaid, DataRecord rec, String label, int status, float sizeFactor, boolean useIcons, int pointSize, int fontSize, int lineSize, boolean moveIcon, ColorOption co) {
        if (rec == null) {
            return;
        }
        try {
            String position = rec.getString("position");
            if (position == null || "".equals(position)) {
                return;
            }
            SimpleGeometry geom = SimpleGeometry.fromWKT((String)position);
            geom.setSizeFactor(sizeFactor);
            if (project.getSelectionManager().getSelectedLocationIds().contains(metaid)) {
                geom.setStatus(3);
            } else {
                geom.setStatus(1);
            }
            if (label == null) {
                label = "";
            }
            geom.setLabel(label);
            if (!rec.isEmpty("labelposition") && !"".equals(label)) {
                geom.setLabelpoint(SimpleGeometry.fromWKT((String)rec.getString("labelposition")).getFirstPoint());
                geom.setMoveIconWithLabel(moveIcon);
                if (labeloffset != null) {
                    geom.setLabelOffset(labeloffset.getX(), labeloffset.getY());
                }
            }
            geom.getDisplay().setLinewidth(Integer.valueOf(lineSize), true);
            geom.getDisplay().setFontSize((float)fontSize, true);
            geom.getDisplay().setLabelColor(colorLabel, true);
            geom.getDisplay().setLabelTextColor(colorLabelText, true);
            geom.getDisplay().setLabelWithBackground(!nolabelbackground, true);
            if (co.getMethod() != ColorOption.Method.STATIC && co.getMethod() != ColorOption.Method.NOCOLOR) {
                Integer bgcolor = co.getColor(rec);
                if (bgcolor == null) {
                    bgcolor = co.getStaticColor();
                }
                if (bgcolor == null) {
                    bgcolor = Color.BLUE.getRGB();
                }
                geom.getDisplay().setLabelColor(new Color(bgcolor), true);
                geom.getDisplay().setLabelTextColor(new Color(ColorOption.getForegroundColor(bgcolor)), true);
            }
            String iconFilename = rec.getString("iconfile");
            Object iconFile = null;
            if (useIcons && iconFilename != null && !"".equals(iconFilename)) {
                Image iconImage = ThemisProject.getIconImage(iconFilename);
                if (iconImage != null) {
                    geom.getDisplay().setPointmarker(iconImage, true);
                } else {
                    String m = project.getResourceText("error.plan-cannot-load-icon", app.getLocale());
                    project.getLogger().warning(m + " (" + iconFilename + ")");
                }
            }
            geom.getDisplay().setDisplay(4, pointSize, colorPoint, true);
            geom.getDisplaySel().setDisplay(4, pointSize, colorPointSel, false);
            geom.getDisplaySel().setLabelColor(Color.YELLOW);
            geom.getDisplaySel().setLabelTextColor(Color.BLACK);
            geom.setId(metaid);
            SimpleGeometry geompanel = geom;
            if (plan.isCalibrated()) {
                geompanel = plan.isCurrentPlanfileCalibrated() ? geom.retransform(imagePanel.getImageHeight(), plan.getGeometry()) : geom.retransform(imagePanel.getImageHeight(), plan.getCalibPlanfileElement().getCalibration().toGeometry());
            }
            if (app.isDebugMode()) {
                project.getLogger().fine("Adding geometry '" + label + "' geom=" + geom.toString() + " -> panel=" + geompanel.toString());
            }
            imagePanel.addGeometry(geompanel);
        }
        catch (Exception ex) {
            String pos = rec.getString("position");
            String id = rec.getString("meta_id");
            String msg = ResourceBundle.getBundle("at/grid/themis/ontology/BundleThemis").getString("error.invalid_wkt");
            ThemisLogger.logger.warning(MessageFormat.format(msg, pos, id));
        }
    }

    public static void showCalibrationPoints(ImagePanel imagePanel, ArrayList<Point> points, boolean doShow) {
        if (points != null && doShow) {
            SimpleGeometry pt1 = new SimpleGeometry(1);
            SimpleGeometry pt2 = new SimpleGeometry(1);
            pt1.add(points.get(0));
            pt1.getDisplay().setDisplay(2, 15, Color.RED);
            pt1.setId(-1000L);
            pt2.add(points.get(1));
            pt2.getDisplay().setDisplay(2, 15, Color.RED);
            pt2.setId(-1001L);
            imagePanel.addGeometry(pt1);
            imagePanel.addGeometry(pt2);
        } else {
            imagePanel.removeGeometry(-1000L);
            imagePanel.removeGeometry(-1001L);
        }
    }
}

