/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.cms.element.CmsElementSummary;
import at.grid.data.Box2D;
import at.grid.gui.ImagePanel;
import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.report.PlanCreator1;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

public class PlanSnippetGenerator {
    ThemisProject project = ThemisApplication.getInstance().getProject();
    private CmsReport rep;
    private HashMap<String, Image> icons = new HashMap();
    private HashMap<String, CmsPlan> plans = new HashMap();
    private int planSnippetSize = 400;
    private int iconSize = 10;
    private boolean useIcons;
    ImagePanel panel;
    long currentPlanId = -1L;
    int errorCounter = 0;
    ThemisApplication app = ThemisApplication.getInstance();

    public PlanSnippetGenerator withIcon() {
        this.useIcons = true;
        return this;
    }

    public PlanSnippetGenerator withoutIcon() {
        this.useIcons = false;
        return this;
    }

    public static HashMap<Long, File> generate(CmsReport rep, List<Long> locationIds) {
        return PlanSnippetGenerator.generate(rep, locationIds, null);
    }

    public static HashMap<Long, File> generate(CmsReport rep, List<Long> locationIds, ProgressHandler ph) {
        PlanSnippetGenerator gen = new PlanSnippetGenerator(rep);
        return gen.loadPlanSnippets(ph, locationIds);
    }

    public static File generate(CmsReport rep, long locationId) {
        return PlanSnippetGenerator.generate(rep, locationId, null);
    }

    public static File generate(CmsReport rep, long locationId, ProgressHandler ph) {
        PlanSnippetGenerator gen = new PlanSnippetGenerator(rep);
        HashMap<Long, File> map = gen.loadPlanSnippets(ph, Arrays.asList(locationId));
        return map.get(locationId);
    }

    public PlanSnippetGenerator(CmsReport rep, List<Long> locationIds) {
        this(rep, locationIds, null);
    }

    public PlanSnippetGenerator(CmsReport rep, List<Long> locationIds, ProgressHandler ph) {
        this.rep = rep;
        this.useIcons = (this.useIcons || rep.planSnippetLabel) && this.app.getSettings().getLocationAttribute("icon").isUsed();
        this.planSnippetSize = rep.getPlanSnippetSize();
        this.iconSize = rep.planIconSize;
        if (locationIds != null && !locationIds.isEmpty()) {
            this.loadPlanSnippets(ph, locationIds);
        }
    }

    public PlanSnippetGenerator(CmsReport rep) {
        this(rep, null, null);
    }

    public HashMap<Long, File> loadPlanSnippets(ProgressHandler ph, List<Long> locationIds) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        ArrayList<Long> planids = new ArrayList<Long>();
        HashMap<Long, File> result = new HashMap<Long, File>();
        int lineSize = (int)((double)this.planSnippetSize * 0.02);
        int fontSize = (int)((double)this.planSnippetSize * 0.05);
        int pointSize = (int)((double)this.planSnippetSize * 0.05);
        int iconSize = (int)((double)(this.planSnippetSize * this.iconSize) / 100.0);
        for (CmsElementSummary p : this.project.getPlans()) {
            planids.add(p.getId());
        }
        this.panel = new ImagePanel(ThemisApplication.getInstance().getProject().getLogger());
        Iterator<Object> iterator = planids.iterator();
        while (iterator.hasNext()) {
            long planid = (Long)iterator.next();
            CmsPlan plan = (CmsPlan)ThemisApplication.getInstance().getProject().loadElement(planid, ThemisApplication.getInstance().getProject().getUser());
            ph.progress("Planausschnitte werden erzeugt ... " + plan.getTitle());
            List locsOnPlan = plan.getRelationAttribute("locations").getElementIds();
            File imagefile = plan.getPlanFile();
            if (imagefile == null) continue;
            if (!imagefile.exists()) {
                imagefile = new File(new File(this.project.getProjectFolder(), "data"), imagefile.getName());
            }
            CmsLocation loc = null;
            try {
                this.panel.setBackgroundImage(imagefile);
                this.panel.setBackgroundTransparency(this.rep.getTransparency());
                Iterator iterator2 = locsOnPlan.iterator();
                while (iterator2.hasNext()) {
                    long id = (Long)iterator2.next();
                    if (!locationIds.contains(id)) continue;
                    File snippetfile = new File(ThemisApplication.getInstance().getProject().getPlansnippetLocation(), id + "_" + this.planSnippetSize + ".jpg");
                    result.put(id, snippetfile);
                    if (snippetfile.isFile()) continue;
                    loc = (CmsLocation)this.project.loadElement(id, this.project.getUser());
                    try {
                        double y0;
                        double h;
                        SimpleGeometry geom = SimpleGeometry.fromWKT((String)loc.getAttributeValue("position"));
                        geom = PlanSnippetGenerator.transformGeometryToPanel(geom, plan, this.panel.getImageHeight());
                        String labelAttStr = this.app.getSettings().getDisplayLabelAttribute();
                        ThemisAttribute labelAtt = labelAttStr == null ? null : this.app.getSettings().getLocationAttribute(labelAttStr);
                        boolean labelWithNumber = this.app.getSettings().getDisplayLabelNumber();
                        String attString = "";
                        if (labelAtt != null && labelAtt.getCmsCode() != null && !labelAtt.getCmsCode().isEmpty()) {
                            attString = loc.getAttributeValue(labelAtt.getCmsCode());
                        }
                        String label = PlanCreator1.getLabel(labelWithNumber, loc.getFullNumber(), attString);
                        if (this.rep.planSnippetLabel) {
                            geom.setLabel(label);
                            ColorOption co = this.app.getSettings().getDisplayColorOption();
                            geom.getDisplay().setLabelColor(new Color(co.getStaticColor()));
                            geom.getDisplay().setLabelTextColor(new Color(co.getStaticForegroundColor()));
                        }
                        geom.getDisplay().setLinewidth(lineSize);
                        geom.getDisplay().setFontSize((float)fontSize);
                        String iconFilename = loc.getAttributeValue("iconfile");
                        File iconFile = null;
                        if (this.useIcons && iconFilename != null && !"".equals(iconFilename)) {
                            if (this.icons.containsKey(iconFilename)) {
                                geom.getDisplayStandard().setPointmarker(this.icons.get(iconFilename));
                                geom.getDisplaySel().setPointmarker(this.icons.get(iconFilename));
                                geom.getDisplayOff().setPointmarker(this.icons.get(iconFilename));
                            } else {
                                iconFile = ThemisApplication.getInstance().getProject().getUploadFile("icon", iconFilename);
                                if (iconFile.isFile()) {
                                    Image icon = ImagePanel.readIcon((File)iconFile);
                                    geom.getDisplayStandard().setPointmarker(icon);
                                    geom.getDisplaySel().setPointmarker(icon);
                                    geom.getDisplayOff().setPointmarker(icon);
                                    this.icons.put(iconFilename, icon);
                                } else {
                                    String m = this.project.getResourceText("error.plan-cannot-load-icon", ThemisApplication.getInstance().getLocale());
                                    this.project.getLogger().warning(m + " (" + iconFile.getName() + ")");
                                }
                            }
                        } else {
                            geom.getDisplay().setDisplay(4, pointSize, new Color(this.app.getColorManager().getColorFromString(this.app.getSettings().getDisplayColorPoint())));
                        }
                        this.panel.removeGeometries();
                        this.panel.setIconSize(iconSize);
                        this.panel.addGeometry(geom);
                        Box2D box = geom.getBox();
                        double w = box.getWidth();
                        if (w < (double)this.planSnippetSize) {
                            w = this.planSnippetSize;
                        }
                        if ((h = box.getHeight()) < (double)this.planSnippetSize) {
                            h = this.planSnippetSize;
                        }
                        h = Math.max(h * 1.5, w * 1.5);
                        w = Math.max(h, w * 1.5);
                        Point centerPoint = geom.getCenterPoint();
                        double x0 = centerPoint.getX() - 0.5 * w;
                        int imageHeight = this.panel.getImageHeight();
                        int imageWidht = this.panel.getImageWidth();
                        if (x0 < 0.0) {
                            x0 = 0.0;
                        }
                        if (x0 + w >= (double)imageWidht) {
                            if (w > (double)imageWidht) {
                                h = w = (double)imageWidht;
                                x0 = 0.0;
                            } else {
                                x0 = (double)imageWidht - w - 1.0;
                            }
                        }
                        if ((y0 = centerPoint.getY() - 0.5 * h) < 0.0) {
                            y0 = 0.0;
                        }
                        if (y0 + h >= (double)imageHeight) {
                            if (h > (double)imageHeight) {
                                h = imageHeight;
                                y0 = 0.0;
                                w = h;
                                x0 = centerPoint.getX() - 0.5 * w;
                                if (x0 < 0.0) {
                                    x0 = 0.0;
                                } else if (x0 + w > (double)imageWidht) {
                                    x0 = (double)imageWidht - w - 1.0;
                                }
                            } else {
                                y0 = (double)imageHeight - h - 1.0;
                            }
                        }
                        ImageIO.write((RenderedImage)this.panel.getImageSubset((int)x0, (int)y0, (int)w, (int)h), "jpg", snippetfile);
                    }
                    catch (Exception e) {
                        if (this.errorCounter == 0) {
                            this.app.getDialog().showErrorDialog(this.project.getResourceText("error.plansnippet-create") + ": " + e.getLocalizedMessage(), new Object[]{loc.getTitle()});
                            ++this.errorCounter;
                        } else {
                            this.app.getDialog().showErrorDialog(this.project.getResourceText("error.plansnippet-create-many") + ": " + e.getLocalizedMessage(), new Object[]{loc.getTitle()});
                        }
                        e.printStackTrace();
                    }
                    if (!ph.isCancelled()) continue;
                    return null;
                }
            }
            catch (Exception e) {
                this.app.getDialog().showErrorDialog(this.project.getResourceText("error.plansnippet-create-loadmap") + ": " + e.getLocalizedMessage(), new Object[]{plan.getTitle()});
            }
        }
        return result;
    }

    public void resetErrorCounter() {
        this.errorCounter = 0;
    }

    @Deprecated
    public File getPlanSnippetFile(CmsLocation loc, ProgressHandler ph) {
        if (loc == null) {
            return null;
        }
        CmsPlan plan = loc.getPlan();
        if (plan == null) {
            return null;
        }
        int lineSize = (int)((double)this.planSnippetSize * 0.02);
        int fontSize = (int)((double)this.planSnippetSize * 0.05);
        int pointSize = (int)((double)this.planSnippetSize * 0.05);
        int iconSize = (int)((double)(this.planSnippetSize * this.iconSize) / 100.0);
        File snippetfile = new File(ThemisApplication.getInstance().getProject().getPlansnippetLocation(), loc.getId() + "_" + this.planSnippetSize + ".jpg");
        if (snippetfile.isFile()) {
            return snippetfile;
        }
        File imagefile = plan.getPlanFile();
        if (imagefile == null || !imagefile.isFile()) {
            return null;
        }
        try {
            if (this.panel == null) {
                this.panel = new ImagePanel(ThemisApplication.getInstance().getProject().getLogger());
            }
            if (this.currentPlanId != plan.getId()) {
                this.panel.setBackgroundImage(imagefile);
                this.panel.setBackgroundTransparency(this.rep.getTransparency());
                this.currentPlanId = plan.getId();
            }
            try {
                double y0;
                double h;
                SimpleGeometry geom = SimpleGeometry.fromWKT((String)loc.getAttributeValue("position"));
                geom = PlanSnippetGenerator.transformGeometryToPanel(geom, plan, this.panel.getImageHeight());
                ThemisApplication app = ThemisApplication.getInstance();
                String labelAttStr = app.getSettings().getDisplayLabelAttribute();
                ThemisAttribute labelAtt = labelAttStr == null ? null : app.getSettings().getLocationAttribute(labelAttStr);
                boolean labelWithNumber = app.getSettings().getDisplayLabelNumber();
                String attString = "";
                if (labelAtt != null && labelAtt.getCmsCode() != null && !labelAtt.getCmsCode().isEmpty()) {
                    attString = loc.getAttributeValue(labelAtt.getCmsCode());
                }
                String label = PlanCreator1.getLabel(labelWithNumber, loc.getFullNumber(), attString);
                if (this.rep.planSnippetLabel) {
                    geom.setLabel(label);
                    ColorOption co = app.getSettings().getDisplayColorOption();
                    if (co.getMethod() != ColorOption.Method.STATIC && co.getMethod() != ColorOption.Method.NOCOLOR) {
                        Integer bgcolor = co.getColor(loc, null);
                        if (bgcolor == null) {
                            bgcolor = co.getStaticColor();
                        }
                        if (bgcolor == null) {
                            bgcolor = Color.BLUE.getRGB();
                        }
                        geom.getDisplay().setLabelColor(new Color(bgcolor), true);
                        geom.getDisplay().setLabelTextColor(new Color(ColorOption.getForegroundColor(bgcolor)), true);
                    } else {
                        geom.getDisplay().setLabelColor(new Color(co.getStaticColor()));
                        geom.getDisplay().setLabelTextColor(new Color(co.getStaticForegroundColor()));
                    }
                }
                geom.getDisplay().setLinewidth(lineSize);
                geom.getDisplay().setFontSize((float)fontSize);
                String iconFilename = loc.getAttributeValue("iconfile");
                File iconFile = null;
                if (this.useIcons && iconFilename != null && !"".equals(iconFilename)) {
                    if (this.icons.containsKey(iconFilename)) {
                        geom.getDisplayStandard().setPointmarker(this.icons.get(iconFilename));
                        geom.getDisplaySel().setPointmarker(this.icons.get(iconFilename));
                        geom.getDisplayOff().setPointmarker(this.icons.get(iconFilename));
                    } else {
                        iconFile = ThemisApplication.getInstance().getProject().getUploadFile("icon", iconFilename);
                        if (iconFile.isFile()) {
                            Image icon = ImagePanel.readIcon((File)iconFile);
                            geom.getDisplayStandard().setPointmarker(icon);
                            geom.getDisplaySel().setPointmarker(icon);
                            geom.getDisplayOff().setPointmarker(icon);
                            this.icons.put(iconFilename, icon);
                        } else {
                            String m = this.project.getResourceText("error.plan-cannot-load-icon", ThemisApplication.getInstance().getLocale());
                            this.project.getLogger().warning(m + " (" + iconFile.getName() + ")");
                        }
                    }
                } else {
                    geom.getDisplay().setDisplay(4, pointSize, new Color(app.getColorManager().getColorFromString(app.getSettings().getDisplayColorPoint())));
                }
                this.panel.removeGeometries();
                this.panel.setIconSize(iconSize);
                this.panel.addGeometry(geom);
                Box2D box = geom.getBox();
                double w = box.getWidth();
                if (w == 0.0 || w < (double)this.rep.getPlanSnippetSize()) {
                    w = this.rep.getPlanSnippetSize();
                }
                if ((h = box.getHeight()) == 0.0 || h < (double)this.rep.getPlanSnippetSize()) {
                    h = this.rep.getPlanSnippetSize();
                }
                h = Math.max(h * 1.5, w * 1.5);
                w = Math.max(h, w * 1.5);
                Point centerPoint = geom.getCenterPoint();
                double x0 = centerPoint.getX() - 0.5 * w;
                int imageHeight = this.panel.getImageHeight();
                int imageWidht = this.panel.getImageWidth();
                if (x0 < 0.0) {
                    x0 = 0.0;
                }
                if (x0 + w >= (double)imageWidht) {
                    if (w > (double)imageWidht) {
                        h = w = (double)imageWidht;
                        x0 = 0.0;
                    } else {
                        x0 = (double)imageWidht - w - 1.0;
                    }
                }
                if ((y0 = centerPoint.getY() - 0.5 * h) < 0.0) {
                    y0 = 0.0;
                }
                if (y0 + h >= (double)imageHeight) {
                    if (h > (double)imageHeight) {
                        h = imageHeight;
                        y0 = 0.0;
                        w = h;
                        x0 = centerPoint.getX() - 0.5 * w;
                        if (x0 < 0.0) {
                            x0 = 0.0;
                        } else if (x0 + w > (double)imageWidht) {
                            x0 = (double)imageWidht - w - 1.0;
                        }
                    } else {
                        y0 = (double)imageHeight - h - 1.0;
                    }
                }
                boolean write = ImageIO.write((RenderedImage)this.panel.getImageSubset((int)x0, (int)y0, (int)w, (int)h), "jpg", snippetfile);
                return snippetfile;
            }
            catch (Exception e) {
                if (this.errorCounter == 0) {
                    this.app.getDialog().showErrorDialog(this.project.getResourceText("error.plansnippet-create") + ": " + e.getLocalizedMessage(), new Object[]{loc.getTitle()});
                    ++this.errorCounter;
                } else {
                    this.app.getDialog().showErrorDialog(this.project.getResourceText("error.plansnippet-create-many") + ": " + e.getLocalizedMessage(), new Object[]{loc.getTitle()});
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (this.errorCounter == 0) {
                this.app.getDialog().showErrorDialog(this.project.getResourceText("error.plansnippet-create-loadmap") + ": " + e.getLocalizedMessage(), new Object[]{plan.getTitle()});
                ++this.errorCounter;
            }
            e.printStackTrace();
        }
        return null;
    }

    public static SimpleGeometry transformGeometryToPanel(SimpleGeometry geom, CmsPlan plan, int imageHeight) {
        if (plan.isCalibrated()) {
            if (plan.isCurrentPlanfileCalibrated()) {
                return geom.retransform(imageHeight, plan.getGeometry());
            }
            return geom.retransform(imageHeight, plan.getCalibPlanfileElement().getCalibration().toGeometry());
        }
        return geom;
    }

    public static SimpleGeometry transformGeometryToPlan(SimpleGeometry geom, CmsPlan plan, int imageHeight) {
        if (plan.isCalibrated()) {
            if (plan.isCurrentPlanfileCalibrated()) {
                return geom.transform(imageHeight, plan.getGeometry());
            }
            return geom.transform(imageHeight, plan.getCalibPlanfileElement().getCalibration().toGeometry());
        }
        return geom;
    }
}

