/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.themis.ontology.report.Placeholder;
import java.util.List;

public class ReportColumnItem {
    private String header;
    private String content;
    private String html;
    private int width;
    private boolean isForLoc = false;
    private boolean isImage = false;
    private boolean isPlanSnippet = false;
    private boolean isIcon = false;
    private List<String> placeholders;
    private Align align;

    public ReportColumnItem(String header, String content, String html, int width, boolean isForLoc, Align align) {
        this.header = header;
        this.content = content;
        this.html = html;
        this.width = width;
        this.isForLoc = isForLoc;
        this.align = align;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getHeader() {
        return this.header;
    }

    public String getContent() {
        return this.content;
    }

    public String getHtml() {
        return this.html;
    }

    public int getWidth() {
        return this.width;
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public boolean isForLoc() {
        return this.isForLoc;
    }

    public void setIsForLoc(boolean isForLoc) {
        this.isForLoc = isForLoc;
    }

    public boolean isImage() {
        return this.isImage;
    }

    public boolean isPlanSnippet() {
        return this.isPlanSnippet;
    }

    public boolean isText() {
        return !this.isImage && !this.isPlanSnippet;
    }

    public void findPlaceholders() {
        this.placeholders = Placeholder.getPlaceholders(this.content);
        for (String ph : this.placeholders) {
            if (this.isImage(ph)) {
                this.isImage = true;
                break;
            }
            if (this.isPlanSnippet(ph)) {
                this.isPlanSnippet = true;
                break;
            }
            if (!this.isIcon(ph)) continue;
            this.isIcon = true;
            break;
        }
    }

    public List<String> getPlaceholders() {
        return this.placeholders;
    }

    private boolean isImage(String placeholder) {
        switch (placeholder) {
            case "b.bild": 
            case "b.bild1": 
            case "b.bild2": 
            case "b.bild3": 
            case "b.bild4": 
            case "b.bild5": 
            case "b.bild6": 
            case "b.bild7": 
            case "b.bild8": 
            case "b.bild9": 
            case "b.g-bild": 
            case "b.g-bild1": 
            case "b.g-bild2": 
            case "b.g-bild3": 
            case "b.g-bild4": 
            case "b.g-bild5": 
            case "b.g-bild6": 
            case "b.g-bild7": 
            case "b.g-bild8": 
            case "b.g-bild9": {
                return true;
            }
        }
        return false;
    }

    private boolean isPlanSnippet(String placeholder) {
        switch (placeholder) {
            case "b.g-plan-ausschnitt": 
            case "b.g-planausschnitt": {
                return true;
            }
        }
        return false;
    }

    private boolean isIcon(String placeholder) {
        return placeholder.equals("b.g-icon");
    }

    public boolean isIcon() {
        return this.isIcon;
    }

    public static enum Align {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        private final int pdfPCellAlign;

        private Align(int pdfPCellAlign) {
            this.pdfPCellAlign = pdfPCellAlign;
        }

        public int getPdfPCellAlign() {
            return this.pdfPCellAlign;
        }
    }
}

