/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.gui.ImagePanel;
import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.report.LayoutCell;
import at.grid.themis.ontology.report.LayoutRow;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.PlanSnippetGenerator;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;

public abstract class ReportGenerator {
    protected PlanSnippetGenerator planSnippetGenerator = null;
    protected ArrayList<Long> documentIds = new ArrayList();
    protected ArrayList<Long> locationIds = new ArrayList();
    private String specialSort = null;
    protected float imagePadding = 0.18f;
    protected Placeholder ph;
    protected CmsReport rep;
    protected ProgressHandler progress = null;
    protected double progressStep = 0.0;
    protected double progressCurrent = 0.0;
    protected double progressFrom = 0.0;
    protected double progressTo = 100.0;
    protected ThemisApplication app = ThemisApplication.getInstance();
    protected ThemisProject project = this.app.getProject();
    protected CmsProject projectElement = this.project.getProjectElement();

    public ReportGenerator(CmsReport rep) {
        this.rep = rep;
        this.ph = new Placeholder(rep);
        this.planSnippetGenerator = new PlanSnippetGenerator(rep);
    }

    public ArrayList<Long> getDocumentIds() {
        return this.documentIds;
    }

    public ArrayList<Long> getLocationIds() {
        return this.locationIds;
    }

    public HashMap<Long, Integer> getImageIds() {
        return this.ph.getImageIds();
    }

    protected abstract void addPagebreak();

    protected abstract float getPageWidth();

    protected abstract void addTable();

    protected abstract void addParagraph(String var1);

    protected abstract boolean hasTable();

    protected abstract void createTable(float[] var1, int var2);

    protected abstract void createCell(String var1, LayoutCell var2, Color var3);

    protected void createCell(String c, LayoutCell l, Color cBG, boolean keepTogether) {
        this.createCell(c, l, cBG);
    }

    protected abstract void createImageCell(LayoutCell var1, ArrayList<SimpleGeometry> var2, File var3, float var4, String var5);

    protected void createImageCell(LayoutCell l, UploadItem item, float colCm) {
        this.createImageCell(l, this.project.getDrawings(item.getId()), item.getFile(), colCm, item.getProperty("date", null));
    }

    protected abstract void createMultipleImageCell(LayoutCell var1, ArrayList<ImageSpecification> var2, float var3, float var4);

    protected abstract void setCellColSpan(int var1);

    protected abstract void setCellBackground(Color var1);

    protected abstract void addCellToTable();

    protected abstract void completeTableRow();

    protected void setSpecialSort(String sort) {
        this.specialSort = sort;
    }

    protected String getSort() {
        return this.specialSort == null ? this.rep.getSortSql() : this.specialSort;
    }

    protected void createTable(String tablename) {
        this.createTable(tablename, CmsReport.ListPagebreak.ZERO);
    }

    protected void createTable(String tablename, CmsReport.ListPagebreak pagebreak) {
        try {
            String groupPlaceholder;
            int countPerPage = pagebreak != null ? pagebreak.getCount() : 0;
            CmsUser user = this.project.getUser();
            if (this.ph == null) {
                this.ph = new Placeholder(this.rep);
            }
            this.ph.resetCounter();
            ReportTableLayout rtl = this.project.getReportTableLayout(tablename);
            if (rtl == null) {
                this.app.getDialog().showErrorDialog("<html>Die in der Vorlage geforderte Tabelle '" + tablename + "' ist im Projekt nicht definiert. Pr\u00fcfen Sie die verf\u00fcgbaren Tabellen in den Projekteinstellungen.</html>");
                return;
            }
            ThemisFilter filter = new ThemisFilter(ThemisApplication.getInstance());
            boolean filterFromTable = false;
            if (this.rep.filter != null) {
                filter.setFilter(this.rep.filter);
            }
            if (rtl.getFilterName() != null) {
                filter.loadFilter(this.project.getFilterByName(rtl.getFilterName()));
                filterFromTable = true;
                if (filter.isCurrentEvent() && this.rep.contentType == CmsReport.Content.EVENT) {
                    filter.setCurrentEvent(false);
                    filter.getEventId().clear(this);
                    filter.getEventId().addItem(this.rep.event.getId(), this);
                }
            } else {
                switch (this.rep.contentType) {
                    case EVENT: {
                        if (this.rep.event != null) {
                            filter.clearAll();
                            filter.getEventId().setItem(this.rep.event.getId(), this);
                            break;
                        }
                    }
                    case FILTER: {
                        filter.setFilter(ThemisApplication.getInstance().getFilter(), false);
                        break;
                    }
                    case SELECTION: {
                        break;
                    }
                    case PERIOD: {
                        ThemisFilter f = new ThemisFilter(ThemisApplication.getInstance());
                        f.setTriggerEnabled(false);
                        f.setEventRange(this.rep.getPeriodFromDate(), this.rep.getPeriodUntilDate(), this);
                        filter.setFilter(f, false);
                    }
                }
            }
            this.rep.sortUse = this.getSort();
            if (rtl.getSort() != null && rtl.getSort().getSql() != null) {
                this.rep.sortUse = rtl.getSort().getSql();
            }
            if ((groupPlaceholder = rtl.getGroupPlaceholder()) != null && !groupPlaceholder.contains("#!#")) {
                groupPlaceholder = "#!#" + groupPlaceholder.trim() + "#!#";
            }
            int groupRowFrom = rtl.getGroupRowFrom();
            int groupRowTo = rtl.getGroupRowTo();
            String groupAttValue = null;
            int[] colWidthRelative = new int[rtl.getNumberOfCols()];
            for (int cc = 0; cc < rtl.getNumberOfCols(); ++cc) {
                colWidthRelative[cc] = rtl.getCol(cc);
            }
            int totalWidthObs = 0;
            for (int w : colWidthRelative) {
                totalWidthObs += w;
            }
            float[] colWidthCm = new float[colWidthRelative.length];
            float pageWidthCm = this.getPageWidth();
            for (int i = 0; i < colWidthRelative.length; ++i) {
                colWidthCm[i] = pageWidthCm * (float)colWidthRelative[i] / (float)totalWidthObs;
            }
            ArrayList<Object> elementIds = new ArrayList();
            elementIds = filterFromTable ? (this.rep.exportOnlyLocations ? filter.getFilteredLocationIds(this.rep.sortUse, null, false) : filter.getFilteredElementIds(this.rep.sortUse, null)) : (this.rep.contentType == CmsReport.Content.SELECTION ? filter.getSelectedObservationIds(this.getSort()) : (this.rep.exportOnlyLocations ? filter.getFilteredLocationIds(this.rep.sortUse, null, false) : filter.getFilteredElementIds(this.rep.sortUse, null)));
            this.progressStep = (this.progressTo - this.progressFrom) / (double)elementIds.size();
            if (this.progress != null) {
                this.progress.setDisplayName("Beobachtungen werden geladen, der Bericht wird erstellt");
            }
            ArrayList<CmsHistory> histories = new ArrayList<CmsHistory>();
            int itemCountePerPage = 0;
            boolean createNewTable = true;
            int noGroupRowFrom = -1;
            int noGroupRowTo = -1;
            this.planSnippetGenerator.resetErrorCounter();
            long previousLocId = -1L;
            long currentLocId = -1L;
            boolean firstGrouping = true;
            if (elementIds.isEmpty()) {
                this.addParagraph("Keine Eintr\u00e4ge vorhanden");
            }
            Iterator<Object> iterator = elementIds.iterator();
            while (iterator.hasNext()) {
                long eleId = (Long)iterator.next();
                if (this.progress.isCancelled()) {
                    return;
                }
                this.progressCurrent += this.progressStep;
                if (this.progress != null && (double)((int)this.progressCurrent) < this.progressTo) {
                    this.progress.progress((int)this.progressCurrent);
                }
                CmsPlan plan = null;
                boolean planHasBuilding = false;
                noGroupRowFrom = -1;
                noGroupRowTo = -1;
                boolean newGrouping = false;
                CmsElement ele = this.project.loadElement(eleId, user);
                long locId = -1L;
                CmsLocation loc = null;
                long obsId = -1L;
                CmsObservation obs = null;
                if (ele instanceof CmsObservation) {
                    obsId = eleId;
                    obs = (CmsObservation)ele;
                    locId = obs.getRelationAttribute("location").getFirstElementId();
                    if (locId >= 0L) {
                        loc = (CmsLocation)this.project.loadElement(locId, user);
                    }
                    Iterator<Object> iterator2 = obs.getRelationAttribute("infos").getElementIds(false).iterator();
                    while (iterator2.hasNext()) {
                        long docId = (Long)iterator2.next();
                        if (this.documentIds.contains(docId)) continue;
                        this.documentIds.add(docId);
                    }
                } else {
                    if (!(ele instanceof CmsLocation)) continue;
                    locId = eleId;
                    loc = (CmsLocation)ele;
                }
                if (loc != null) {
                    if (!this.locationIds.contains(loc.getId())) {
                        this.locationIds.add(loc.getId());
                    }
                    if (!loc.getRelationAttribute("plan").isEmpty()) {
                        plan = (CmsPlan)loc.getRelationAttribute("plan").getFirstElement().getElement();
                        planHasBuilding = plan.hasAttributeValue("building");
                    }
                    File planSnippetFile = this.planSnippetGenerator.withIcon().getPlanSnippetFile(loc, this.progress);
                    Iterator docId = loc.getRelationAttribute("infos").getElementIds(false).iterator();
                    while (docId.hasNext()) {
                        long docId2 = (Long)docId.next();
                        if (this.documentIds.contains(docId2)) continue;
                        this.documentIds.add(docId2);
                    }
                }
                if (createNewTable) {
                    this.createTable(colWidthCm, rtl.getHeaderRowCount());
                    this.addRows(colWidthCm, rtl.getHeaderRows(), this.ph, loc, obs, null);
                    createNewTable = false;
                }
                if (obs == null) {
                    histories.clear();
                    histories.add((CmsHistory)this.project.getDefaultElement("history"));
                } else {
                    histories.clear();
                    if (this.rep.exportWithHistories) {
                        for (CmsElement h : obs.getHistories()) {
                            histories.add((CmsHistory)h);
                        }
                    } else {
                        histories.add(this.rep.event == null ? obs.getLatestHistory() : obs.getHistory(this.rep.event));
                    }
                }
                for (CmsHistory hist : histories) {
                    if (groupPlaceholder != null && !"".equals(groupPlaceholder)) {
                        String attValue = this.ph.apply(groupPlaceholder, loc, obs, hist, null);
                        newGrouping = attValue == null ? groupAttValue != null : !attValue.equals(groupAttValue);
                        groupAttValue = attValue;
                        if (newGrouping) {
                            this.ph.resetLocationCounterGrouping();
                            if (this.hasTable()) {
                                if (rtl.getGroupNewTable() && !firstGrouping) {
                                    this.addTable();
                                    if (rtl.getGroupPagebreak()) {
                                        this.addPagebreak();
                                    }
                                    createNewTable = true;
                                } else {
                                    noGroupRowFrom = -1;
                                    noGroupRowTo = -1;
                                }
                            }
                        } else {
                            noGroupRowFrom = groupRowFrom;
                            noGroupRowTo = groupRowTo;
                        }
                        firstGrouping = false;
                    }
                    if (createNewTable) {
                        this.createTable(colWidthCm, rtl.getHeaderRowCount());
                        this.addRows(colWidthCm, rtl.getHeaderRows(), this.ph, loc, obs, hist);
                        createNewTable = false;
                    }
                    if (obs == null) {
                        if (this.rep.exportLocationsWithoutObservations || this.rep.exportOnlyLocations) {
                            this.addRows(colWidthCm, rtl.getDataRows(noGroupRowFrom, noGroupRowTo), this.ph, loc, null, null);
                        }
                    } else {
                        obs.applyHistory(hist);
                        this.addRows(colWidthCm, rtl.getDataRows(noGroupRowFrom, noGroupRowTo), this.ph, loc, obs, hist);
                    }
                    if (!this.checkItemCounter(++itemCountePerPage, countPerPage)) continue;
                    itemCountePerPage = 0;
                    createNewTable = true;
                    this.addTable();
                    this.addPagebreak();
                }
            }
            if (!createNewTable) {
                this.addTable();
            }
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("error.report-generation", ex);
            ex.printStackTrace();
        }
    }

    private boolean checkItemCounter(int counter, int countPerPage) {
        return countPerPage > 0 && counter == countPerPage;
    }

    private void addRows(float[] colWidthCm, ArrayList<LayoutRow> rows, Placeholder ph, CmsLocation loc, CmsObservation obs, CmsHistory hist) {
        this.addRows(colWidthCm, rows, ph, loc, obs, hist, false);
    }

    private void addRows(float[] colWidthCm, ArrayList<LayoutRow> rows, Placeholder ph, CmsLocation loc, CmsObservation obs, CmsHistory hist, boolean keepTogether) {
        ArrayList<ImageSpecification> remainingImages = new ArrayList<ImageSpecification>();
        float imageColWidth = -1.0f;
        LayoutCell imageLayout = null;
        for (LayoutRow row : rows) {
            int cellcount = 0;
            for (LayoutCell cell : row.getCells()) {
                ArrayList<ImageSpecification> images = this.getImages(cell.getContent(), loc, obs, hist);
                String cellContentOrig = cell.getContent();
                ArrayList<String> placeholders = Placeholder.getPlaceholders(cellContentOrig);
                if (images.isEmpty()) {
                    if (row.getCells().size() == 1 && placeholders.size() == 1 && ph.getTranslatedPlaceholderKey(placeholders.get(0)).contains("image-files")) continue;
                    String cellContent = ph.apply(cell.getContent(), loc, obs, hist, null);
                    cellContent = ph.removeUnusedPlaceholders(cellContent);
                    Integer cInt = cell.getBackgroundColor(loc, obs);
                    Color c = cInt == null ? null : new Color(cInt);
                    this.createCell(cellContent, cell, c, keepTogether);
                } else {
                    imageLayout = cell;
                    boolean allImagesInOneCell = images.get((int)0).item.getProperty("all", "").equals("true");
                    ImageSpecification is = allImagesInOneCell ? images.get(0) : images.remove(0);
                    float width = 0.0f;
                    for (int ii = 0; ii < cell.getSpan(); ++ii) {
                        width += colWidthCm[cellcount + ii];
                    }
                    if (is.size <= 0.0f) {
                        is.size = allImagesInOneCell ? 5.5f : width - 2.0f * this.imagePadding;
                    }
                    if (is != null) {
                        imageColWidth = is.size;
                    }
                    if (allImagesInOneCell) {
                        if (images.size() > 0) {
                            this.createMultipleImageCell(cell, images, imageColWidth, width - 2.0f * this.imagePadding);
                        }
                        remainingImages.clear();
                    } else {
                        this.createImageCell(cell, is.item, is.size);
                        remainingImages.addAll(images);
                    }
                }
                this.setCellColSpan(cell.getSpan());
                Integer backgroundColor = cell.getBackgroundColor(loc, obs);
                if (backgroundColor != null) {
                    this.setCellBackground(new Color(backgroundColor));
                }
                this.addCellToTable();
                cellcount += cell.getSpan();
            }
            this.completeTableRow();
        }
        if (remainingImages.size() > 0) {
            this.createMultipleImageCell(imageLayout, remainingImages, imageColWidth, this.getPageWidth() - 2.0f * this.imagePadding);
            this.setCellColSpan(colWidthCm.length);
            this.addCellToTable();
            this.completeTableRow();
        }
    }

    public ArrayList<ImageSpecification> getImages(String text, CmsLocation loc, CmsObservation obs, CmsHistory hist) {
        ArrayList<ImageSpecification> images = new ArrayList<ImageSpecification>();
        ArrayList<String> placeholders = Placeholder.getPlaceholders(text);
        for (String placeholder : placeholders) {
            ArrayList<UploadItem> items = this.ph.getPlaceholderUploads(placeholder, loc, obs, hist);
            for (UploadItem item : items) {
                ImageSpecification is = new ImageSpecification(item);
                is.size = Placeholder.getPlaceholderValue(placeholder, 0.0f);
                images.add(is);
            }
        }
        return images;
    }

    protected BufferedImage getImageWithDrawings(File imagefile, ArrayList<SimpleGeometry> drawings, int pixelLongSide, String text) {
        try {
            if (drawings == null || drawings.isEmpty()) {
                BufferedImage bi = ImageIO.read(imagefile);
                if (bi == null) {
                    return null;
                }
                return Util.resizeImageOnLongSide((BufferedImage)bi, (int)pixelLongSide);
            }
            ImagePanel panel = new ImagePanel(ThemisApplication.getInstance().getProject().getLogger());
            panel.setBackgroundImage(imagefile);
            for (SimpleGeometry geometry : drawings) {
                for (int ii = 0; ii < geometry.size(); ++ii) {
                    Point p = (Point)geometry.getPoints().get(ii);
                }
                geometry.getDisplay().setLinewidth(8);
                panel.addGeometry(geometry);
            }
            BufferedImage bi = Util.resizeImageOnLongSide((BufferedImage)panel.getAsBufferedImage(), (int)pixelLongSide);
            if (this.rep.showDateInImage && text != null && !"".equals(text)) {
                int px = Math.min(bi.getHeight(), bi.getWidth());
                int fontsize = px / 12;
                Graphics2D gO = bi.createGraphics();
                gO.setColor(Color.red);
                Font font = new Font("Arial", 1, fontsize);
                gO.setFont(font);
                gO.drawString(text, 2, 2 + fontsize);
            }
            return bi;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static float cmToPixel(float cm) {
        return ReportGenerator.cmToPixel(cm, 72);
    }

    public static float cmToPixel(float cm, int dpi) {
        float inch = cm / 2.54f;
        return inch * (float)dpi;
    }

    public static float pixelToCm(float pixel) {
        return ReportGenerator.pixelToCm(pixel, 72);
    }

    public static float pixelToCm(float pixel, int dpi) {
        float inch = pixel / (float)dpi;
        return inch * 2.54f;
    }

    public static BigInteger cmToUnits(double cm) {
        return BigInteger.valueOf((int)(cm * 567.0));
    }

    public static float unitsToCm(BigInteger units) {
        if (units == null) {
            return 0.0f;
        }
        return units.floatValue() / 567.0f;
    }

    protected class ImageSpecification {
        public UploadItem item;
        public float size;

        public ImageSpecification(UploadItem item) {
            this.item = item;
        }
    }
}

