/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.util.Util;
import org.jdom.Content;
import org.jdom.Element;

public class ReportPageSetup {
    public float borderTop = 3.0f;
    public float borderLeft = 1.5f;
    public float borderRight = 1.5f;
    public float borderBottom = 2.0f;
    public boolean borderSync = false;
    public float headerOffset = 1.0f;
    public float footerOffset = 1.0f;
    public PageSize size = PageSize.DINA4;
    public PageOrientation orientation = PageOrientation.PORTRAIT;
    public String headerLeft = "#!#Projekttitel#!# - #!#Protokolltitel#!#";
    public String headerCenter = "";
    public String headerRight = "";
    public String footerLeft = "";
    public String footerCenter = "erstellt mit THEMIS-Software am #!#Jetzt#!#";
    public String footerRight = "#!#Seite#!#";
    public LogoPosition logoPosition = LogoPosition.TOPRIGHT;
    public float logoWidth = 4.0f;

    public Element toXml() {
        Element root = new Element("pageformat");
        Element page = new Element("page");
        switch (this.orientation) {
            case LANDSCAPE: {
                page.setAttribute("orientation", "landscape");
                break;
            }
            case PORTRAIT: {
                page.setAttribute("orientation", "portrait");
            }
        }
        switch (this.size) {
            case DINA4: {
                page.setAttribute("size", "a4");
                break;
            }
            case DINA3: {
                page.setAttribute("size", "a3");
            }
        }
        root.addContent((Content)page);
        root.addContent((Content)new Element("border").setAttribute("top", Float.toString(this.borderTop)).setAttribute("left", Float.toString(this.borderLeft)).setAttribute("bottom", Float.toString(this.borderBottom)).setAttribute("right", Float.toString(this.borderRight)).setAttribute("sync", this.borderSync ? "true" : "false"));
        Element header = new Element("header");
        header.addContent((Content)new Element("left").setText(this.headerLeft));
        header.addContent((Content)new Element("center").setText(this.headerCenter));
        header.addContent((Content)new Element("right").setText(this.headerRight));
        header.addContent((Content)new Element("offset").setText(Float.toString(this.headerOffset)));
        root.addContent((Content)header);
        Element footer = new Element("footer");
        footer.addContent((Content)new Element("left").setText(this.footerLeft));
        footer.addContent((Content)new Element("center").setText(this.footerCenter));
        footer.addContent((Content)new Element("right").setText(this.footerRight));
        footer.addContent((Content)new Element("offset").setText(Float.toString(this.footerOffset)));
        root.addContent((Content)footer);
        Element logo = new Element("logo");
        logo.setAttribute("width", Float.toString(this.logoWidth));
        switch (this.logoPosition) {
            case BOTTOMCENTER: {
                logo.setAttribute("position", "bottomcenter");
                break;
            }
            case BOTTOMRIGHT: {
                logo.setAttribute("position", "bottomright");
                break;
            }
            case BOTTOMLEFT: {
                logo.setAttribute("position", "bottomleft");
                break;
            }
            case TOPCENTER: {
                logo.setAttribute("position", "topcenter");
                break;
            }
            case TOPLEFT: {
                logo.setAttribute("position", "topleft");
                break;
            }
            case TOPRIGHT: {
                logo.setAttribute("position", "topright");
                break;
            }
            case NONE: {
                logo.setAttribute("position", "none");
            }
        }
        root.addContent((Content)logo);
        return root;
    }

    public void fromXml(Element root) {
        Element logo;
        Element footer;
        Element header;
        Element page = root.getChild("page");
        this.size = "a3".equalsIgnoreCase(page.getAttributeValue("size")) ? PageSize.DINA3 : PageSize.DINA4;
        this.orientation = "landscape".equalsIgnoreCase(page.getAttributeValue("orientation")) ? PageOrientation.LANDSCAPE : PageOrientation.PORTRAIT;
        Element border = root.getChild("border");
        if (border != null) {
            this.borderTop = Util.parseFloat((String)border.getAttributeValue("top"), (float)1.5f);
            this.borderLeft = Util.parseFloat((String)border.getAttributeValue("left"), (float)1.7f);
            this.borderRight = Util.parseFloat((String)border.getAttributeValue("right"), (float)1.5f);
            this.borderBottom = Util.parseFloat((String)border.getAttributeValue("bottom"), (float)1.5f);
            this.borderSync = "true".equalsIgnoreCase(border.getAttributeValue("sync"));
            if (this.borderSync) {
                this.borderLeft = this.borderTop;
                this.borderRight = this.borderTop;
                this.borderBottom = this.borderTop;
            }
        }
        if ((header = root.getChild("header")) != null) {
            this.headerLeft = header.getChildText("left");
            this.headerCenter = header.getChildText("center");
            this.headerRight = header.getChildText("right");
            this.headerOffset = Util.parseFloat((String)header.getChildText("offset"), (float)this.headerOffset);
        }
        if ((footer = root.getChild("footer")) != null) {
            this.footerLeft = footer.getChildText("left");
            this.footerCenter = footer.getChildText("center");
            this.footerRight = footer.getChildText("right");
            this.footerOffset = Util.parseFloat((String)footer.getChildText("offset"), (float)this.footerOffset);
        }
        if ((logo = root.getChild("logo")) != null) {
            this.logoWidth = Util.parseFloat((String)logo.getAttributeValue("width"), (float)3.0f);
            switch (logo.getAttributeValue("position", "topright")) {
                case "topcenter": {
                    this.logoPosition = LogoPosition.TOPCENTER;
                    break;
                }
                case "topright": {
                    this.logoPosition = LogoPosition.TOPRIGHT;
                    break;
                }
                case "bottomleft": {
                    this.logoPosition = LogoPosition.BOTTOMLEFT;
                    break;
                }
                case "bottomcenter": {
                    this.logoPosition = LogoPosition.BOTTOMCENTER;
                    break;
                }
                case "bottomright": {
                    this.logoPosition = LogoPosition.BOTTOMRIGHT;
                    break;
                }
                case "none": {
                    this.logoPosition = LogoPosition.NONE;
                    break;
                }
                default: {
                    this.logoPosition = LogoPosition.TOPLEFT;
                }
            }
        }
    }

    public static enum LogoPosition {
        TOPLEFT,
        TOPCENTER,
        TOPRIGHT,
        BOTTOMLEFT,
        BOTTOMCENTER,
        BOTTOMRIGHT,
        NONE;

    }

    public static enum PageOrientation {
        PORTRAIT,
        LANDSCAPE;

    }

    public static enum PageSize {
        DINA4,
        DINA3;

    }
}

