/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.themis.ontology.ThemisApplication;
import java.util.Date;
import java.util.GregorianCalendar;

public class ReportPeriod {
    Date fromDate;
    Date untilDate;

    public static ReportPeriod getQuarter(int year, int quarter) {
        ReportPeriod p = new ReportPeriod();
        GregorianCalendar cal = new GregorianCalendar(ThemisApplication.getInstance().getTimeZone());
        switch (quarter) {
            case 2: {
                cal.set(year, 3, 1);
                break;
            }
            case 3: {
                cal.set(year, 6, 1);
                break;
            }
            case 4: {
                cal.set(year, 9, 1);
                break;
            }
            default: {
                cal.set(year, 0, 1);
            }
        }
        p.fromDate = new Date(cal.getTimeInMillis());
        cal.roll(2, 3);
        cal.roll(5, -1);
        p.untilDate = new Date(cal.getTimeInMillis());
        return p;
    }

    public static ReportPeriod getYear(int year) {
        ReportPeriod p = new ReportPeriod();
        GregorianCalendar cal = new GregorianCalendar(ThemisApplication.getInstance().getTimeZone());
        cal.set(year, 0, 1);
        p.fromDate = new Date(cal.getTimeInMillis());
        cal.set(year, 11, 31);
        p.untilDate = new Date(cal.getTimeInMillis());
        return p;
    }

    public static ReportPeriod getMonth(int year, int month) {
        ReportPeriod p = new ReportPeriod();
        GregorianCalendar cal = new GregorianCalendar(ThemisApplication.getInstance().getTimeZone());
        cal.set(year, month - 1, 1);
        p.fromDate = new Date(cal.getTimeInMillis());
        cal.roll(2, 1);
        cal.roll(5, -1);
        p.untilDate = new Date(cal.getTimeInMillis());
        return p;
    }
}

