/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report;

import at.grid.cms.element.CmsElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsFilter;
import at.grid.themis.ontology.element.ThemisElement;
import at.grid.themis.ontology.report.AttributeSqlPair;
import at.grid.themis.ontology.report.LayoutCell;
import at.grid.themis.ontology.report.LayoutRow;
import at.grid.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.util.Exceptions;

public class ReportTableLayout
extends ThemisElement {
    ArrayList<LayoutRow> rows = new ArrayList();
    ArrayList<Integer> cols = new ArrayList();
    String name = null;
    private int headerRows;
    private int groupRowFrom;
    private int groupRowTo;
    private String groupPlaceholder;
    private boolean groupNewPage;
    private boolean groupNewTable = false;
    AttributeSqlPair sort = null;
    CmsFilter filter;

    public ReportTableLayout setRowCol(int rows, int cols) {
        int ii;
        for (ii = 0; ii < rows; ++ii) {
            this.addRow();
        }
        for (ii = 0; ii < rows; ++ii) {
            this.addColumn(1);
        }
        return this;
    }

    public String getTitle() {
        return this.getName();
    }

    public String getName() {
        if (this.name == null || this.name.isEmpty()) {
            this.name = this.themis.getProject().getNewReportTableName("Protokoll-Tabelle");
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public void clear() {
        this.rows.clear();
        this.cols.clear();
        this.addRow();
        this.addColumn(1);
    }

    public void setFilter(String filtername) {
        this.filter = ThemisApplication.getInstance().getProject().getFilterByName(filtername);
    }

    public long getFilterId() {
        return this.filter == null ? -1L : this.filter.getId();
    }

    public String getFilterName() {
        return this.filter == null ? null : this.filter.getName();
    }

    public AttributeSqlPair getSort() {
        return this.sort;
    }

    public void setSort(AttributeSqlPair s) {
        if (s != null && s.getSql() == null) {
            s = null;
        }
        this.sort = s;
    }

    public int getHeaderRowCount() {
        return this.headerRows;
    }

    public void setHeaderRowCount(int r) {
        this.headerRows = r;
    }

    public void setGroupRows(String txt) {
        if (txt == null || "".equals(txt)) {
            this.setGroupRows(-1, -1);
        } else {
            String[] split = txt.split("-");
            int row1 = Util.parseInt((String)split[0], (int)-1);
            if (split.length > 1) {
                int row2 = Util.parseInt((String)split[1], (int)-1);
                this.setGroupRows(row1, row2);
            } else {
                this.setGroupRows(row1, row1);
            }
        }
    }

    public void setGroupRows(int from, int to) {
        this.groupRowFrom = from;
        this.groupRowTo = to;
    }

    public void setGroupPlaceholder(String p) {
        this.groupPlaceholder = "".equals(p) ? null : p;
    }

    public int getGroupRowFrom() {
        return this.groupRowFrom;
    }

    public int getGroupRowTo() {
        return this.groupRowTo;
    }

    public String getGroupRowsAsString() {
        if (this.groupRowFrom < 0) {
            return "";
        }
        if (this.groupRowFrom == this.groupRowTo) {
            return Integer.toString(this.groupRowFrom);
        }
        return Integer.toString(this.groupRowFrom) + "-" + Integer.toString(this.groupRowTo);
    }

    public String getGroupPlaceholder() {
        return this.groupPlaceholder == null ? "" : this.groupPlaceholder;
    }

    public void setGroupPagebreak(boolean f) {
        this.groupNewPage = f;
    }

    public boolean getGroupPagebreak() {
        return this.groupNewPage;
    }

    public void setGroupNewTable(boolean f) {
        this.groupNewTable = f;
    }

    public boolean getGroupNewTable() {
        return this.groupNewTable || this.groupNewPage;
    }

    public void fromXML(Element xml) {
        String xmlstr = Util.toXml((Element)xml);
        this.rows.clear();
        this.cols.clear();
        try {
            this.setName(xml.getAttributeValue("name"));
            this.setHeaderRowCount(Util.parseInt((String)xml.getAttributeValue("headerrows", "0"), (int)0));
            if (xml.getAttributeValue("groupcode") != null) {
                this.groupPlaceholder = xml.getAttributeValue("groupreference", "G") + "." + xml.getAttributeValue("groupcode");
                this.setGroupRows(xml.getAttributeValue("grouprows"));
                this.setGroupPagebreak("yes".equalsIgnoreCase(xml.getAttributeValue("grouppagebreak")));
                this.setGroupNewTable("yes".equalsIgnoreCase(xml.getAttributeValue("groupnewtable")));
            } else if (xml.getAttributeValue("groupplaceholder") != null) {
                this.setGroupPlaceholder(xml.getAttributeValue("groupplaceholder"));
                this.setGroupRows(xml.getAttributeValue("grouprows"));
                this.setGroupPagebreak("yes".equalsIgnoreCase(xml.getAttributeValue("grouppagebreak")));
                this.setGroupNewTable("yes".equalsIgnoreCase(xml.getAttributeValue("groupnewtable")));
            } else {
                this.groupPlaceholder = null;
                this.setGroupRows("");
                this.setGroupPagebreak(false);
            }
            List cols = xml.getChild("columns").getChildren("col");
            for (Element col : cols) {
                String w = col.getAttributeValue("width");
                this.addColumn(Util.parseInt((String)w, (int)1));
            }
            List rows = xml.getChild("rows").getChildren("row");
            for (Element row : rows) {
                LayoutRow r = new LayoutRow(this);
                int rowheight = Util.parseInt((String)row.getAttributeValue("height", "-1"), (int)-1);
                r.setHeight(rowheight);
                List cells = row.getChildren("cell");
                int idx = 0;
                for (Element cell : cells) {
                    LayoutCell c = r.getCellByIndex(idx);
                    c.setFromElement(cell, false);
                    ++idx;
                }
                this.rows.add(r);
            }
            this.filter = ThemisApplication.getInstance().getProject().getFilterByName(xml.getChildText("filter"));
            this.sort = xml.getChild("sort") != null ? AttributeSqlPair.fromXmlElement(xml.getChild("sort")) : null;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void setXml(String xml) {
        try {
            this.fromXML(Util.fromXml((String)xml));
        }
        catch (IOException | JDOMException ex) {
            this.app.getLogger().severe("Error while reading XML: " + ex.getMessage());
        }
    }

    public String getXmlAsString() {
        return Util.toXml((Element)this.getXml());
    }

    public Element getXml() {
        Element root = new Element("layout").setAttribute("version", "0").setAttribute("headerrows", Integer.toString(this.headerRows)).setAttribute("name", this.getName());
        if (this.groupPlaceholder != null && !"".equals(this.groupPlaceholder)) {
            root.setAttribute("grouprows", Integer.toString(this.groupRowFrom) + "-" + Integer.toString(this.groupRowTo)).setAttribute("groupplaceholder", this.groupPlaceholder).setAttribute("grouppagebreak", this.groupNewPage ? "yes" : "no").setAttribute("groupnewtable", this.groupNewTable ? "yes" : "no");
        }
        if (this.groupPlaceholder != null && !"".equals(this.groupPlaceholder)) {
            root.setAttribute("grouprows", Integer.toString(this.groupRowFrom) + "-" + Integer.toString(this.groupRowTo)).setAttribute("groupplaceholder", this.groupPlaceholder).setAttribute("grouppagebreak", this.groupNewPage ? "yes" : "no").setAttribute("groupnewtable", this.groupNewTable ? "yes" : "no");
        }
        Element columns = new Element("columns");
        root.addContent((Content)columns);
        for (int col : this.getCols()) {
            columns.addContent((Content)new Element("col").setAttribute("width", Integer.toString(col)));
        }
        Element rows = new Element("rows");
        root.addContent((Content)rows);
        for (LayoutRow row : this.getRows()) {
            Element r = new Element("row");
            if (row.getHeight() >= 0) {
                r.setAttribute("height", Integer.toString(row.getHeight()));
            }
            rows.addContent((Content)r);
            for (LayoutCell cell : row.getCells()) {
                Element c = cell.getAsElement();
                r.addContent((Content)c);
            }
        }
        if (this.filter != null) {
            Element filter = new Element("filter");
            root.addContent((Content)filter);
            filter.setText(this.getFilterName());
        }
        if (this.sort != null && this.sort.getSql() != null) {
            root.addContent((Content)this.sort.toXmlElement());
        }
        return root;
    }

    public ArrayList<LayoutCell> addRow() {
        LayoutRow row = new LayoutRow(this);
        this.rows.add(row);
        return row.getCells();
    }

    public ArrayList<LayoutCell> addRow(int idx) {
        LayoutRow row = new LayoutRow(this);
        this.rows.add(idx, row);
        return row.getCells();
    }

    public ArrayList<LayoutCell> delRow(LayoutRow row) {
        if (this.rows.contains(row)) {
            this.rows.remove(row);
            if (this.rows.isEmpty()) {
                this.addRow();
            }
            return row.getCells();
        }
        return new ArrayList<LayoutCell>();
    }

    public ArrayList<LayoutCell> removeRow(int idx) {
        if (idx >= 0 && idx < this.rows.size()) {
            LayoutRow row = this.rows.remove(idx);
            return row.getCells();
        }
        return new ArrayList<LayoutCell>();
    }

    public int getNumberOfRows() {
        return this.rows.size();
    }

    public LayoutRow getRow(int idx) {
        if (idx >= 0 && idx < this.rows.size()) {
            return this.rows.get(idx);
        }
        return null;
    }

    public ArrayList<LayoutRow> getRows() {
        return this.rows;
    }

    public ArrayList<LayoutRow> getDataRows(int ignoreRowFrom, int ignoreRowTo) {
        ArrayList<LayoutRow> result = new ArrayList<LayoutRow>();
        for (int ii = 0; ii < this.rows.size(); ++ii) {
            if (ii < this.headerRows || ii >= ignoreRowFrom - 1 && ii <= ignoreRowTo - 1) continue;
            result.add(this.rows.get(ii));
        }
        return result;
    }

    public ArrayList<LayoutRow> getHeaderRows() {
        ArrayList<LayoutRow> result = new ArrayList<LayoutRow>();
        for (int ii = 0; ii < this.rows.size(); ++ii) {
            if (ii >= this.headerRows) continue;
            result.add(this.rows.get(ii));
        }
        return result;
    }

    public ArrayList<LayoutCell> addColumn(int width) {
        this.cols.add(width);
        ArrayList<LayoutCell> newCells = new ArrayList<LayoutCell>();
        for (LayoutRow row : this.rows) {
            newCells.add(row.addCell());
        }
        return newCells;
    }

    public ArrayList<LayoutCell> addColumn(int index, int width) {
        this.cols.add(index, width);
        ArrayList<LayoutCell> newCells = new ArrayList<LayoutCell>();
        for (LayoutRow row : this.rows) {
            LayoutCell cell;
            int idx = row.getCellIndex(cell = row.getCell(index - 1));
            if (idx + cell.getSpan() > index) {
                cell.setSpan(cell.getSpan() + 1, false);
                continue;
            }
            newCells.add(row.addCell(idx + 1));
        }
        return newCells;
    }

    public int getNumberOfCols() {
        return this.cols.size();
    }

    public ArrayList<Integer> getCols() {
        return this.cols;
    }

    public int getCol(int idx) {
        if (idx >= 0 && idx < this.cols.size()) {
            return this.cols.get(idx);
        }
        return -1;
    }

    public void setColWidth(int idx, int width) {
        if (idx >= 0 && idx < this.cols.size()) {
            this.cols.remove(idx);
            this.cols.add(idx, width);
        }
    }

    public ArrayList<LayoutCell> removeColumn(int colIdx) {
        ArrayList<LayoutCell> cells = new ArrayList<LayoutCell>();
        if (colIdx < 0 || colIdx >= this.getNumberOfCols()) {
            return cells;
        }
        for (LayoutRow r : this.getRows()) {
            LayoutCell c = r.getCell(colIdx);
            int idx = r.getCellIndex(c);
            if (c.getSpan() == 1) {
                r.cells.remove(c);
                cells.add(c);
                continue;
            }
            c.setSpan(c.getSpan() - 1, false);
        }
        this.cols.remove(colIdx);
        return cells;
    }

    public LayoutCell getCell(int rr, int cc) {
        LayoutRow row = this.getRow(rr);
        if (row == null) {
            return null;
        }
        return row.getCell(cc);
    }

    public String toString() {
        return this.getName();
    }

    public void preSave() {
        this.setAttributeValue("name", this.getName());
        this.setAttributeValue("xml", Util.toXml((Element)this.getXml()));
    }

    public void postLoad() {
        try {
            this.fromXML(Util.fromXml((String)this.getAttributeValue("xml")));
        }
        catch (IOException | JDOMException ex) {
            this.app.getLogger().severe("Error while reading XML: " + ex.getMessage());
        }
    }

    public void postUpdate() {
        try {
            this.setAttributeValue("name", this.getName());
            this.fromXML(Util.fromXml((String)this.getAttributeValue("xml")));
        }
        catch (IOException | JDOMException ex) {
            this.app.getLogger().severe("Error while reading XML: " + ex.getMessage());
        }
    }

    public static void loadLayout(File f) {
        if (f == null || !f.isFile()) {
            return;
        }
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        app.setPathTemplateLocationObservation(f.getParentFile());
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(f);
            Element layout = (Element)doc.getRootElement().detach();
            String xmlStr = Util.toXml((Element)layout);
            Element filterElement = layout.getChild("filters");
            HashMap<String, Object> renamedFilter = new HashMap<String, Object>();
            if (filterElement != null) {
                List filters = filterElement.getChildren();
                for (Element filter : filters) {
                    CmsElement ele = project.createElement("filter");
                    ele.update(filter, null);
                    String oldName = ele.getAttributeValue("name");
                    String newName = project.getNewFilterName(oldName);
                    if (!oldName.equals(newName)) {
                        renamedFilter.put(oldName, newName);
                    }
                    ele.setAttributeValue("name", newName);
                    ele.save();
                }
                app.getActionProvider().invokeAction(ThemisAction.FILTER_LOADED);
            }
            ArrayList<Element> layouts = new ArrayList<Element>();
            Element tables = layout.getChild("tables");
            if (tables != null) {
                List layoutsInXml = layout.getChild("tables").getChildren("layout");
                for (Element l : layoutsInXml) {
                    layouts.add(l);
                }
            } else {
                layouts.add(layout);
            }
            for (Element l : layouts) {
                ReportTableLayout layoutElement = (ReportTableLayout)project.createElement("reporttable");
                for (String filtername : renamedFilter.keySet()) {
                    Element fe;
                    if (!filtername.equals((fe = l.getChild("filter")).getText())) continue;
                    fe.setText((String)renamedFilter.get(filtername));
                }
                layoutElement.fromXML(l);
                String n = layoutElement.getName();
                layoutElement.setName(project.getNewReportTableName(n));
                layoutElement.save();
            }
        }
        catch (JDOMException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

