/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report.pdf;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.report.PdfParagraphFormat;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.ReportGenerator;
import at.grid.themis.ontology.report.ReportPageSetup;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import org.openide.util.Exceptions;

public class PageEvent
extends PdfPageEventHelper {
    PdfParagraphFormat formatFooter = new PdfParagraphFormat(new Font(1, 9.0f, 0), 0.0f, 0.0f);
    PdfParagraphFormat formatHeader = new PdfParagraphFormat(new Font(1, 9.0f, 0), 0.0f, 0.0f);
    int pageNumber = 1;
    String headerLeft = "";
    String headerCenter = "";
    String headerRight = "";
    String footerLeft = "";
    String footerCenter = "";
    String footerRight = "";
    float headerOffset;
    float footerOffset;
    Image logoImage = null;
    ReportPageSetup.LogoPosition logoPos;
    Placeholder ph;
    CmsReport rep;

    public PageEvent(CmsReport rep) {
        this.ph = new Placeholder(rep);
        this.rep = rep;
        this.initialise(rep);
    }

    public void initialise(CmsReport rep) {
        this.headerLeft = this.ph.apply(rep.pageFormat.headerLeft);
        this.headerCenter = this.ph.apply(rep.pageFormat.headerCenter);
        this.headerRight = this.ph.apply(rep.pageFormat.headerRight);
        this.footerLeft = this.ph.apply(rep.pageFormat.footerLeft);
        this.footerCenter = this.ph.apply(rep.pageFormat.footerCenter);
        this.footerRight = this.ph.apply(rep.pageFormat.footerRight);
        this.headerOffset = ReportGenerator.cmToPixel(rep.pageFormat.headerOffset);
        this.footerOffset = ReportGenerator.cmToPixel(rep.pageFormat.footerOffset);
        this.pageNumber = 1;
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (project.isOpen()) {
            File logofile = project.getProjectElement().getUploadAttribute("projectlogo").getFirstUploadItemFile();
            try {
                if (logofile == null) {
                    this.logoImage = Image.getInstance((URL)((Object)((Object)this)).getClass().getResource("/at/grid/themis/ontology/media/themis-logo-4c.png"));
                } else if (logofile.isFile()) {
                    this.logoImage = Image.getInstance((byte[])Files.readAllBytes(logofile.toPath()));
                }
            }
            catch (BadElementException | IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.logoImage != null) {
            float scale = ReportGenerator.cmToPixel(rep.pageFormat.logoWidth) / this.logoImage.getWidth();
            this.logoImage.scalePercent(100.0f * scale);
            this.logoPos = rep.pageFormat.logoPosition;
        }
    }

    public void setFormatFooter(PdfParagraphFormat fmt) {
        this.formatFooter = fmt;
    }

    public void setFormatHeader(PdfParagraphFormat fmt) {
        this.formatHeader = fmt;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void increasePageNumber() {
        ++this.pageNumber;
        this.ph.setPagenumber(this.pageNumber);
    }

    public void onEndPage(PdfWriter writer, Document document) {
        float left = document.left();
        float right = document.right();
        float top = document.top();
        float bottom = document.bottom();
        String pagenumberString = Integer.toString(this.getPageNumber());
        this.ph.addSpecialPlaceholder("rep.pagenumber", pagenumberString);
        this.addText(writer, new Paragraph(this.ph.apply(this.rep.pageFormat.headerLeft).trim(), this.formatHeader.font), POS.TL, document);
        this.addText(writer, new Paragraph(this.ph.apply(this.rep.pageFormat.headerCenter).trim(), this.formatHeader.font), POS.TC, document);
        this.addText(writer, new Paragraph(this.ph.apply(this.rep.pageFormat.headerRight).trim(), this.formatHeader.font), POS.TR, document);
        this.addText(writer, new Paragraph(this.ph.apply(this.rep.pageFormat.footerLeft).trim(), this.formatFooter.font), POS.BL, document);
        this.addText(writer, new Paragraph(this.ph.apply(this.rep.pageFormat.footerCenter).trim(), this.formatFooter.font), POS.BC, document);
        this.addText(writer, new Paragraph(this.ph.apply(this.rep.pageFormat.footerRight).trim(), this.formatFooter.font), POS.BR, document);
        if (this.logoImage != null && this.logoPos != null) {
            try {
                float logoX = (right + left) / 2.0f;
                float logoY = document.getPageSize().getHeight() - this.headerOffset;
                switch (this.logoPos) {
                    case TOPLEFT: {
                        logoX = left;
                        logoY = document.getPageSize().getHeight() - this.headerOffset - this.logoImage.getScaledHeight();
                        break;
                    }
                    case TOPCENTER: {
                        logoX = (right + left) / 2.0f - this.logoImage.getScaledWidth() / 2.0f;
                        logoY = document.getPageSize().getHeight() - this.headerOffset - this.logoImage.getScaledHeight();
                        break;
                    }
                    case TOPRIGHT: {
                        logoX = right - this.logoImage.getScaledWidth();
                        logoY = document.getPageSize().getHeight() - this.headerOffset - this.logoImage.getScaledHeight();
                        break;
                    }
                    case BOTTOMLEFT: {
                        logoX = left;
                        logoY = this.footerOffset;
                        break;
                    }
                    case BOTTOMCENTER: {
                        logoX = (right + left) / 2.0f - this.logoImage.getScaledWidth() / 2.0f;
                        logoY = this.footerOffset;
                        break;
                    }
                    case BOTTOMRIGHT: {
                        logoX = right - this.logoImage.getScaledWidth();
                        logoY = this.footerOffset;
                        break;
                    }
                    case NONE: {
                        this.logoImage = null;
                    }
                }
                if (this.logoImage != null) {
                    this.logoImage.setAbsolutePosition(logoX, logoY);
                    writer.getDirectContent().addImage(this.logoImage, true);
                }
            }
            catch (DocumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.increasePageNumber();
    }

    protected void addText(PdfWriter writer, Paragraph p, POS position, Document document) {
        try {
            float llx = document.left();
            float urx = document.right();
            float lly = document.top();
            float ury = document.getPageSize().getHeight() - this.headerOffset;
            int halign = 0;
            int valign = 4;
            switch (position) {
                case BL: 
                case BC: 
                case BR: {
                    lly = this.footerOffset;
                    ury = document.bottom();
                    valign = 6;
                }
            }
            switch (position) {
                case TL: {
                    break;
                }
                case TC: {
                    halign = 1;
                    break;
                }
                case TR: {
                    halign = 2;
                    break;
                }
                case BL: {
                    halign = 0;
                    break;
                }
                case BC: {
                    halign = 1;
                    break;
                }
                case BR: {
                    halign = 2;
                }
            }
            ColumnText ct = new ColumnText(writer.getDirectContent());
            ct.setSimpleColumn(llx, lly, urx, ury);
            PdfPTable tbl = new PdfPTable(1);
            tbl.setWidths(new int[]{1});
            tbl.setWidthPercentage(100.0f);
            p.setAlignment(halign);
            PdfPCell cell = new PdfPCell((Phrase)p);
            cell.setBorder(0);
            cell.setFixedHeight(ury - lly);
            cell.setVerticalAlignment(valign);
            cell.setHorizontalAlignment(halign);
            tbl.addCell(cell);
            ct.addElement((Element)tbl);
            ct.go();
        }
        catch (DocumentException ex) {
            ex.printStackTrace();
        }
    }

    public void onStartPage(PdfWriter writer, Document dcmnt) {
        super.onStartPage(writer, dcmnt);
    }

    static enum POS {
        TL,
        TC,
        TR,
        BL,
        BC,
        BR;

    }
}

