/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.ontology.report.pdf;

import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.cms.util.Pair;
import at.grid.gui.ImagePanel;
import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColors;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsCompany;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsFormular;
import at.grid.themis.ontology.element.CmsFormularHistory;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.javafx.formeditor.FormItem;
import at.grid.themis.ontology.report.ExportUtil;
import at.grid.themis.ontology.report.LayoutCell;
import at.grid.themis.ontology.report.LayoutRow;
import at.grid.themis.ontology.report.PdfParagraphFormat;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.PlanSnippetGenerator;
import at.grid.themis.ontology.report.ReportGenerator;
import at.grid.themis.ontology.report.ReportPageSetup;
import at.grid.themis.ontology.report.pdf.PageEvent;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.themis.ontology.signature.ThemisSignature;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openide.util.Exceptions;

public abstract class PdfExportBase
extends ReportGenerator {
    ByteArrayOutputStream fos = new ByteArrayOutputStream();
    public Document document = null;
    PageEvent pageEvent;
    int fontFamily = 1;
    float paragraphSpacing = 2.0f;
    float imageSpacing = 0.7f;
    float tableCellPadding = 5.0f;
    LayoutCell cellLayout = new LayoutCell(null);
    LayoutCell cellLayoutNoBorder = new LayoutCell(null).setBorder(0.0f);
    protected PdfParagraphFormat formatText = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 11.0f, 0), 6.0f, 6.0f);
    protected PdfParagraphFormat formatBullet = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 11.0f, 0), 2.0f, 2.0f);
    protected PdfParagraphFormat formatTableHeader = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 9.0f, 1), 2.0f, 2.0f);
    protected PdfParagraphFormat formatTable = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 9.0f, 0), 2.0f, 2.0f);
    protected PdfParagraphFormat formatTableHeading = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 10.0f, 1), 2.0f, 2.0f);
    protected PdfParagraphFormat formatTableSmall = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 7.0f, 0), 2.0f, 2.0f);
    protected PdfParagraphFormat formatBold = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 11.0f, 1), 4.0f, 4.0f);
    protected PdfParagraphFormat formatSmall = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 10.0f, 0), 4.0f, 4.0f);
    protected PdfParagraphFormat formatVerysmall = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 8.0f, 0), 4.0f, 4.0f);
    protected PdfParagraphFormat formatFooter = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 9.0f, 0), 0.0f, 0.0f);
    protected PdfParagraphFormat formatHeading1 = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 16.0f, 1), 32.0f, 20.0f);
    protected PdfParagraphFormat formatHeading2 = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 13.0f, 1), 20.0f, 12.0f);
    protected PdfParagraphFormat formatTitle = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 24.0f, 1), 30.0f, 20.0f);
    protected PdfParagraphFormat formatTitle2 = new PdfParagraphFormat(new com.lowagie.text.Font(this.fontFamily, 18.0f, 1), 20.0f, 20.0f);
    protected static final int IMG_LONG_SIDE = 400;
    protected static final int IMG_SCALE = 35;
    int pagenumber = 1;
    Image themisLogo = null;
    Image themisQRCode = null;
    public boolean pdfTitlePage = false;
    PdfParagraphFormat format;
    public ArrayList<Long> elementIds = new ArrayList();
    ArrayList<Long> observationIdsInTable = new ArrayList();
    public int[] tableWidths = new int[]{50, 100, 50, 100};
    public PdfPCell tableCell;
    public PdfPTable table = null;

    public PdfExportBase() {
        this(new CmsReport());
    }

    public PdfExportBase(CmsReport r) {
        super(r);
        this.pageEvent = new PageEvent(this.rep);
    }

    public Rectangle getPageSize() {
        Rectangle pageSize = PageSize.A4;
        switch (this.rep.pageFormat.size) {
            case DINA3: {
                pageSize = PageSize.A3;
                break;
            }
            default: {
                pageSize = PageSize.A4;
            }
        }
        if (this.rep.pageFormat.orientation == ReportPageSetup.PageOrientation.LANDSCAPE) {
            pageSize = pageSize.rotate();
        }
        return pageSize;
    }

    public void initialiseDocument() {
        this.document = new Document(this.getPageSize());
        this.document.setMargins(ReportGenerator.cmToPixel(this.rep.pageFormat.borderLeft), ReportGenerator.cmToPixel(this.rep.pageFormat.borderRight), ReportGenerator.cmToPixel(this.rep.pageFormat.borderTop), ReportGenerator.cmToPixel(this.rep.pageFormat.borderBottom));
    }

    public PageEvent getPageEvent() {
        return this.pageEvent;
    }

    public String getHeaderText() {
        String h1 = this.rep.protTitel == null ? "" : this.rep.protTitel;
        String h2 = this.projectElement == null ? "" : this.projectElement.getTitle();
        String t = h1;
        if (!h1.isEmpty() && !h2.isEmpty()) {
            t = t + " - ";
        }
        t = t + (h2.isEmpty() ? "" : "Projekt: " + h2);
        return t;
    }

    public int getPageNumber() {
        return this.pagenumber;
    }

    public void increasePageNumber() {
        ++this.pagenumber;
    }

    public Image getThemisLogo() {
        if (this.themisLogo == null) {
            try {
                this.themisLogo = Image.getInstance((URL)this.getClass().getResource("/at/grid/themis/export/media/themis-logo-4c.png"));
                this.themisLogo.scaleToFit(45.0f, 30.0f);
                this.themisLogo.setAbsolutePosition((this.document.right() - this.document.left()) / 2.0f + this.document.leftMargin() - 22.5f, this.document.bottom() - 13.0f);
            }
            catch (BadElementException ex) {
                Logger.getLogger(PdfExportBase.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(PdfExportBase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.themisLogo;
    }

    public Image getThemisQRCode() {
        if (this.themisQRCode == null) {
            try {
                this.themisQRCode = Image.getInstance((URL)this.getClass().getResource("/at/grid/themis/ontology/media/qr-code.png"));
                this.themisQRCode.scaleToFit(30.0f, 30.0f);
                this.themisQRCode.setAbsolutePosition(this.document.left() + 50.0f, this.document.bottom() - 18.0f);
            }
            catch (BadElementException ex) {
                Logger.getLogger(PdfExportBase.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(PdfExportBase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.themisQRCode;
    }

    public void exportToPdf(File f, CmsReport rep, CmsUser user) {
        this.exportToPdf(f, rep, user, null, 0, 100);
    }

    public void exportToPdf(File f, CmsReport rep, CmsUser user, ProgressHandler ph, int phFrom, int phTo) {
        this.progress = ph;
        this.progressFrom = phFrom;
        this.progressTo = phTo;
        if (this.progress == null) {
            this.progress = new DefaultProgressHandler();
        }
        try {
            this.initialiseDocument();
            this.fos = new ByteArrayOutputStream();
            PdfWriter writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.fos);
            this.pageEvent.initialise(this.rep);
            writer.setPageEvent((PdfPageEvent)this.pageEvent);
            this.document.open();
            this.createContent(user);
            this.document.close();
            if (f != null) {
                FileOutputStream file = new FileOutputStream(f);
                this.fos.writeTo(file);
                file.close();
            }
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("error.report-pdf-generation", ex);
            ex.printStackTrace();
        }
    }

    public abstract void createContent(CmsUser var1) throws DocumentException;

    public void createTitlePage() {
        PdfPTable tbl = this.createTitlePageTable();
        boolean bildNebenProjektinfo = true;
        this.createTitle(tbl);
        this.createEmptyTableRow(tbl);
        if (!bildNebenProjektinfo) {
            File imageFile = this.getProjectImageFile();
            if (imageFile != null) {
                try {
                    Image img = Image.getInstance((byte[])Files.readAllBytes(imageFile.toPath()));
                    float pxWidth = img.getWidth();
                    float pxHeight = img.getHeight();
                    float widthCm = 18.0f;
                    float pxWidthSoll = (float)((double)(72.0f * widthCm) / 2.54);
                    float scale = pxWidthSoll / pxWidth;
                    float pxHeightSoll = pxHeight * scale;
                    float heightCm = (float)((double)pxHeightSoll * 2.54 / 72.0);
                    float maxHeightCm = 6.0f;
                    if (heightCm > maxHeightCm) {
                        scale = scale * maxHeightCm / heightCm;
                    }
                    img.scalePercent(100.0f * scale);
                    this.addToDocument((Element)img);
                    this.addToDocument((Element)this.createParagraph(" ", this.formatText));
                }
                catch (BadElementException | IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.addToDocument((Element)this.createParagraph("", this.formatText));
                this.addToDocument((Element)this.createParagraph("", this.formatText));
            }
        }
        this.createReportInfoTable(tbl);
        this.createEmptyTableRow(tbl);
        if (bildNebenProjektinfo) {
            this.createProjectInfoTableWithImage(tbl);
        } else {
            this.createProjectInfoTable(tbl);
        }
        this.createEmptyTableRow(tbl);
        this.createEventInfoTable(tbl);
        this.addToDocument((Element)tbl);
        this.document.newPage();
    }

    protected PdfPTable createTitlePageTable() {
        PdfPTable tbl = new PdfPTable(4);
        tbl.setWidthPercentage(100.0f);
        try {
            tbl.setWidths(this.tableWidths);
        }
        catch (DocumentException ex) {
            this.app.getDialog().showErrorDialog("error.report-pdf-generation", (Exception)((Object)ex));
        }
        tbl.setHorizontalAlignment(0);
        return tbl;
    }

    public void createEmptyTableRow(PdfPTable tbl) {
        LayoutCell cellLayoutTitle = this.cellLayoutNoBorder.derive(9, false);
        cellLayoutTitle.setSpan(tbl.getNumberOfColumns());
        tbl.addCell(this.createPdfCell(" ", cellLayoutTitle, null));
    }

    public void createTitle() {
        PdfPTable tbl = this.createTitlePageTable();
        this.createTitle(tbl);
        this.addToDocument((Element)tbl);
    }

    public void createTitle(PdfPTable tbl) {
        LayoutCell cellLayoutTitle = this.cellLayoutNoBorder.derive(12, true);
        cellLayoutTitle.setSpan(tbl.getNumberOfColumns());
        cellLayoutTitle.setFormat(this.formatTitle);
        String reportTitle = this.rep.protTitel;
        if (reportTitle == null || reportTitle.isEmpty()) {
            reportTitle = "Protokoll";
        }
        tbl.addCell(this.createPdfCell(reportTitle, cellLayoutTitle, null));
    }

    public Image getProjectImage(double widthInCM) {
        UploadItem projectImage;
        if (this.projectElement != null && (projectImage = this.projectElement.getUploadAttribute("projectimage").getFirstUploadItem()) != null) {
            projectImage.setProperty("width", "200");
            return this.createImage(projectImage, widthInCM);
        }
        return null;
    }

    public File getProjectImageFile() {
        UploadItem projectImage;
        if (this.projectElement != null && (projectImage = this.projectElement.getUploadAttribute("projectimage").getFirstUploadItem()) != null) {
            return projectImage.getFile();
        }
        return null;
    }

    public void createProjectImage(double width) {
        UploadItem projectImage;
        if (this.projectElement != null && (projectImage = this.projectElement.getUploadAttribute("projectimage").getFirstUploadItem()) != null) {
            projectImage.setProperty("width", "200");
            this.addToDocument((Element)this.createImage(projectImage, width));
        }
    }

    public void createProjectInfoTable() {
        PdfPTable tbl = this.createTitlePageTable();
        this.createProjectInfoTable(tbl);
        this.addToDocument((Element)tbl);
    }

    public void createProjectInfoTable(PdfPTable table) {
        if (this.projectElement == null) {
            return;
        }
        try {
            LayoutCell cellLayoutTitle = this.cellLayoutNoBorder.derive(12, true);
            cellLayoutTitle.setSpan(4);
            LayoutCell cellLayoutInfo = this.cellLayoutNoBorder.derive(12, true);
            cellLayoutInfo.setSpan(3);
            table.addCell(this.createPdfCell("Information zum Projekt", cellLayoutTitle, null));
            this.completeTableRow();
            table.addCell(this.createPdfCell("Projekt:", this.cellLayoutNoBorder, null));
            table.addCell(this.createPdfCell(this.projectElement.getTitle(), cellLayoutInfo, null));
            this.completeTableRow();
            if (this.projectElement.hasAttributeValue("projectnumber")) {
                table.addCell(this.createPdfCell("Nummer:", this.cellLayoutNoBorder, null));
                table.addCell(this.createPdfCell(this.projectElement.getAttributeValue("projectnumber"), cellLayoutInfo, null));
                table.completeRow();
            }
            if (this.projectElement.hasAttributeValue("projectlocation")) {
                table.addCell(this.createPdfCell("Ort:", this.cellLayoutNoBorder, null));
                table.addCell(this.createPdfCell(this.projectElement.getAttributeValue("projectlocation"), cellLayoutInfo, null));
                table.completeRow();
            }
            if (this.projectElement.hasAttributeValue("customer")) {
                table.addCell(this.createPdfCell("Auftraggeber:", this.cellLayoutNoBorder, null));
                table.addCell(this.createPdfCell(this.projectElement.getAttributeValue("customer"), cellLayoutInfo, null));
                table.completeRow();
            }
            if (this.projectElement.hasAttributeValue("info")) {
                table.addCell(this.createPdfCell("Sonstiges:", this.cellLayoutNoBorder, null));
                table.addCell(this.createPdfCell(this.projectElement.getAttributeValue("info"), cellLayoutInfo, null));
                table.completeRow();
            }
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("error.report-pdf-generation", ex);
        }
    }

    public void createProjectInfoTableWithImage() {
        PdfPTable tbl = this.createTitlePageTable();
        this.createProjectInfoTableWithImage(this.createTitlePageTable());
        this.addToDocument((Element)tbl);
    }

    public void createProjectInfoTableWithImage(PdfPTable tbl) {
        if (this.projectElement == null) {
            return;
        }
        try {
            PdfPCell imageCell = this.createPdfCell("", this.cellLayoutNoBorder, null);
            imageCell.setRowspan(5);
            imageCell.setHorizontalAlignment(2);
            Paragraph p = new Paragraph();
            p.setSpacingAfter(this.imageSpacing);
            p.setSpacingBefore(0.0f);
            p.add((Object)new Chunk(this.getProjectImage(6.0), 0.0f, 0.0f, true));
            imageCell.setBorder(0);
            imageCell.addElement((Element)p);
            LayoutCell cellLayoutTitle = this.cellLayoutNoBorder.derive(12, true);
            cellLayoutTitle.setSpan(tbl.getNumberOfColumns());
            boolean rowCounter = false;
            tbl.addCell(this.createPdfCell("Information zum Projekt", cellLayoutTitle, null));
            this.completeTableRow();
            tbl.addCell(this.createPdfCell("Projekt:", this.cellLayoutNoBorder, null));
            tbl.addCell(this.createPdfCell(this.projectElement.getTitle(), this.cellLayoutNoBorder, null));
            tbl.addCell(imageCell);
            tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
            tbl.completeRow();
            if (this.projectElement.hasAttributeValue("projectnumber")) {
                tbl.addCell(this.createPdfCell("Nummer:", this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell(this.projectElement.getAttributeValue("projectnumber"), this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                tbl.completeRow();
            }
            if (this.projectElement.hasAttributeValue("projectlocation")) {
                tbl.addCell(this.createPdfCell("Ort:", this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell(this.projectElement.getAttributeValue("projectlocation"), this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                tbl.completeRow();
            }
            if (this.projectElement.hasAttributeValue("customer")) {
                tbl.addCell(this.createPdfCell("Auftraggeber:", this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell(this.projectElement.getAttributeValue("customer"), this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                tbl.completeRow();
            }
            if (this.projectElement.hasAttributeValue("info")) {
                tbl.addCell(this.createPdfCell("Sonstiges:", this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell(this.projectElement.getAttributeValue("info"), this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                tbl.completeRow();
            }
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("error.report-pdf-generation", ex);
        }
    }

    public void createEventInfoTable() {
        PdfPTable tbl = this.createTitlePageTable();
        this.createEventInfoTable(this.createTitlePageTable());
        this.addToDocument((Element)tbl);
    }

    public void createEventInfoTable(PdfPTable table) {
        if (this.rep.event == null) {
            return;
        }
        try {
            LayoutCell cellLayoutTitle = this.cellLayoutNoBorder.derive(12, true);
            cellLayoutTitle.setSpan(4);
            LayoutCell cellLayoutInfo = this.cellLayoutNoBorder.derive(9, false);
            cellLayoutInfo.setSpan(3);
            table.addCell(this.createPdfCell("Information zum Ereignis", cellLayoutTitle, null));
            this.completeTableRow();
            table.addCell(this.createPdfCell("Ereignis:", this.cellLayoutNoBorder, null));
            table.addCell(this.createPdfCell(this.rep.event.getEventTitle(), cellLayoutInfo, null));
            this.completeTableRow();
            table.addCell(this.createPdfCell("Datum/Zeit:", this.cellLayoutNoBorder, null));
            String dt = Util.formatDate((Date)this.rep.event.getDateAttribute("date").getDate(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone());
            if (this.rep.event.hasAttributeValue("time")) {
                dt = dt + ", " + this.rep.event.getAttributeValue("time");
            }
            table.addCell(this.createPdfCell(dt, cellLayoutInfo, null));
            table.completeRow();
            if (this.rep.event.hasAttributeValue("comment")) {
                table.addCell(this.createPdfCell("Bemerkung:", this.cellLayoutNoBorder, null));
                table.addCell(this.createPdfCell(this.rep.event.getAttributeValue("comment"), cellLayoutInfo, null));
                table.completeRow();
            }
            if (this.rep.event.hasAttributeValue("place")) {
                table.addCell(this.createPdfCell("Ort:", this.cellLayoutNoBorder, null));
                table.addCell(this.createPdfCell(this.rep.event.getAttributeValue("place"), cellLayoutInfo, null));
                table.completeRow();
            }
            if (this.rep.event.hasAttributeValue("participants")) {
                table.addCell(this.createPdfCell("Teilnehmer:", this.cellLayoutNoBorder, null));
                table.addCell(this.createPdfCell(this.rep.event.getAttributeValue("participants"), cellLayoutInfo, null));
                table.completeRow();
            }
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("error.report-pdf-generation", ex);
        }
    }

    public void createReportInfoTable() {
        PdfPTable tbl = this.createTitlePageTable();
        this.createReportInfoTable(this.createTitlePageTable());
        this.addToDocument((Element)tbl);
    }

    public void createReportInfoTable(PdfPTable tbl) {
        try {
            LayoutCell cellLayoutTitle = this.cellLayoutNoBorder.derive(12, true);
            cellLayoutTitle.setSpan(4);
            tbl.addCell(this.createPdfCell("Protokollkopf", cellLayoutTitle, null));
            this.completeTableRow();
            int cols = 0;
            if (Util.hasStringValue((String)this.rep.protNummer)) {
                tbl.addCell(this.createPdfCell("Nummer:", this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell(this.rep.protNummer, this.cellLayoutNoBorder, null));
                ++cols;
            }
            if (Util.hasStringValue((String)this.rep.protVersion)) {
                tbl.addCell(this.createPdfCell("Version:", this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell(this.rep.protVersion, this.cellLayoutNoBorder, null));
                ++cols;
            }
            if (cols > 0) {
                if (cols == 1) {
                    tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                    tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                }
                tbl.completeRow();
            }
            cols = 0;
            if (Util.hasStringValue((String)this.rep.protVerfasser)) {
                tbl.addCell(this.createPdfCell("Verfasser:", this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell(this.rep.protVerfasser, this.cellLayoutNoBorder, null));
                ++cols;
            }
            if (Util.hasStringValue((String)this.rep.protDatum)) {
                tbl.addCell(this.createPdfCell("Datum:", this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell(this.rep.protDatum, this.cellLayoutNoBorder, null));
                ++cols;
            }
            if (cols > 0) {
                if (cols == 1) {
                    tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                    tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                }
                tbl.completeRow();
            }
            cols = 0;
            if (Util.hasStringValue((String)this.rep.protVerteiler)) {
                tbl.addCell(this.createPdfCell("Verteiler:", this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell(this.rep.protVerteiler, this.cellLayoutNoBorder, null));
                ++cols;
            }
            if (Util.hasStringValue((String)this.rep.protKenntnis)) {
                tbl.addCell(this.createPdfCell("Zur Kenntnis:", this.cellLayoutNoBorder, null));
                tbl.addCell(this.createPdfCell(this.rep.protKenntnis, this.cellLayoutNoBorder, null));
                ++cols;
            }
            if (cols > 0) {
                if (cols == 1) {
                    tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                    tbl.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                }
                tbl.completeRow();
            }
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("error.report-pdf-generation", ex);
        }
    }

    public void createReportEventInfoTable() {
        PdfPTable tbl = this.createTitlePageTable();
        this.createReportEventInfoTable(this.createTitlePageTable());
        this.addToDocument((Element)tbl);
    }

    public void createReportEventInfoTable(PdfPTable table) {
        try {
            LayoutCell cellLayoutTitle = this.cellLayoutNoBorder.derive(12, true);
            cellLayoutTitle.setSpan(2);
            ArrayList<Pair> protDetails = new ArrayList<Pair>();
            if (Util.hasStringValue((String)this.rep.protNummer)) {
                protDetails.add(new Pair((Object)"Nummer", (Object)this.rep.protNummer));
            }
            if (Util.hasStringValue((String)this.rep.protVersion)) {
                protDetails.add(new Pair((Object)"Version", (Object)this.rep.protVersion));
            }
            if (Util.hasStringValue((String)this.rep.protVerfasser)) {
                protDetails.add(new Pair((Object)"Verfasser", (Object)this.rep.protVerfasser));
            }
            if (Util.hasStringValue((String)this.rep.protDatum)) {
                protDetails.add(new Pair((Object)"Datum", (Object)this.rep.protDatum));
            }
            if (Util.hasStringValue((String)this.rep.protVerteiler)) {
                protDetails.add(new Pair((Object)"Verteiler", (Object)this.rep.protVerteiler));
            }
            if (Util.hasStringValue((String)this.rep.protKenntnis)) {
                protDetails.add(new Pair((Object)"Zur Kenntnis", (Object)this.rep.protKenntnis));
            }
            ArrayList<Pair> eventDetails = new ArrayList<Pair>();
            if (this.rep.event != null) {
                eventDetails.add(new Pair((Object)"Ereignis", (Object)this.rep.event.getEventTitle()));
                String dt = Util.formatDate((Date)this.rep.event.getDateAttribute("date").getDate(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone());
                if (this.rep.event.hasAttributeValue("time")) {
                    dt = dt + ", " + this.rep.event.getAttributeValue("time");
                }
                eventDetails.add(new Pair((Object)"Datum/Zeit", (Object)dt));
                if (this.rep.event.hasAttributeValue("comment")) {
                    eventDetails.add(new Pair((Object)"Bemerkung", (Object)this.rep.event.getAttributeValue("comment")));
                }
                if (this.rep.event.hasAttributeValue("place")) {
                    eventDetails.add(new Pair((Object)"Ort", (Object)this.rep.event.getAttributeValue("place")));
                }
                if (this.rep.event.hasAttributeValue("participants")) {
                    eventDetails.add(new Pair((Object)"Teilnehmer", (Object)this.rep.event.getAttributeValue("participants")));
                }
            }
            int maxRows = Math.max(protDetails.size(), eventDetails.size());
            if (protDetails.size() > 0) {
                table.addCell(this.createPdfCell("\u00dcber das Protokoll", cellLayoutTitle, null));
            } else {
                table.addCell(this.createPdfCell("", cellLayoutTitle, null));
            }
            if (eventDetails.size() > 0) {
                table.addCell(this.createPdfCell("Infos zum Ereignis", cellLayoutTitle, null));
            } else {
                table.addCell(this.createPdfCell("", cellLayoutTitle, null));
            }
            if (maxRows > 0) {
                this.completeTableRow();
            }
            for (int row = 0; row < maxRows; ++row) {
                if (protDetails.size() > row) {
                    table.addCell(this.createPdfCell((String)((Pair)protDetails.get((int)row)).value1 + ":", this.cellLayoutNoBorder, null));
                    table.addCell(this.createPdfCell((String)((Pair)protDetails.get((int)row)).value2, this.cellLayoutNoBorder, null));
                } else {
                    table.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                    table.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                }
                if (eventDetails.size() > row) {
                    table.addCell(this.createPdfCell((String)((Pair)eventDetails.get((int)row)).value1 + ":", this.cellLayoutNoBorder, null));
                    table.addCell(this.createPdfCell((String)((Pair)eventDetails.get((int)row)).value2, this.cellLayoutNoBorder, null));
                } else {
                    table.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                    table.addCell(this.createPdfCell("", this.cellLayoutNoBorder, null));
                }
                table.completeRow();
            }
            if (maxRows > 0) {
                this.addToDocument((Element)table);
                this.addToDocument((Element)this.createParagraph(" ", this.formatText));
            }
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("error.report-pdf-generation", ex);
        }
    }

    public void createSignatureInText() throws DocumentException {
        for (ThemisSignature sig : this.rep.signatures) {
            StringBuilder sb = new StringBuilder();
            sb.append(sig.getName());
            if (sig.hasFunction()) {
                sb.append(" (").append(sig.getFunction()).append(")");
            }
            File signatureFile = sig.getSignatureFile();
            float imageWidth = ReportGenerator.cmToPixel(7.0f);
            Image img = this.createImage((ArrayList<SimpleGeometry>)null, signatureFile, 150, (String)null);
            this.addToDocument((Element)img);
            this.addToDocument((Element)this.createParagraph(sb.toString(), this.formatSmall));
        }
    }

    public void createSignature() throws DocumentException {
        float pageWidth = this.getPageWidth();
        float[] widths = new float[]{pageWidth * 0.35f, pageWidth * 0.15f, pageWidth * 0.35f, pageWidth * 0.15f};
        this.createTable(widths, 0);
        this.table.addCell(this.createPdfCell("Datum: " + Util.formatDate((Date)new Date(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone()), false, this.formatTable, 0, 2));
        this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
        this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
        this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
        this.table.completeRow();
        LayoutCell cell = new LayoutCell(null);
        cell.setBorder(0.0f);
        int sigRows = (this.rep.signatures.size() + 1) / 2;
        for (int ii = 0; ii < sigRows; ++ii) {
            ThemisSignature sig1 = this.rep.signatures.get(ii * 2);
            ThemisSignature sig2 = null;
            if (this.rep.signatures.size() > ii * 2 + 1) {
                sig2 = this.rep.signatures.get(ii * 2 + 1);
            }
            this.tableCell = null;
            this.createImageCell(cell, null, sig1.getSignatureFile(), 7.0f, null);
            this.table.addCell(this.tableCell);
            this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
            if (sig2 != null) {
                this.createImageCell(cell, null, sig2.getSignatureFile(), 7.0f, null);
                this.table.addCell(this.tableCell);
                this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
            } else {
                this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
                this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
            }
            this.table.completeRow();
            StringBuilder sb = new StringBuilder();
            sb.append(sig1.getName());
            if (sig1.hasFunction()) {
                sb.append(" (").append(sig1.getFunction()).append(")");
            }
            this.table.addCell(this.createPdfCell(sb.toString(), false, this.formatTable, 0, 2));
            this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
            if (sig2 != null) {
                sb = new StringBuilder();
                sb.append(sig2.getName());
                if (sig2.hasFunction()) {
                    sb.append(" (").append(sig2.getFunction()).append(")");
                }
                this.table.addCell(this.createPdfCell(sb.toString(), false, this.formatTable, 0, 2));
                this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
            } else {
                this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
                this.table.addCell(this.createPdfCell("", false, this.formatTable, 0, 2));
            }
            this.table.completeRow();
        }
        this.document.add((Element)this.table);
        this.table = null;
    }

    public void createEventListTable(ArrayList<Long> eventIds) throws DocumentException {
        if (eventIds == null || eventIds.isEmpty()) {
            this.document.add((Element)this.createParagraph("Keine Eintr\u00e4ge", this.formatHeading2));
            return;
        }
        int[] widths = new int[]{4, 8, 12, 5};
        int totalWidthObs = 0;
        for (int w : widths) {
            totalWidthObs += w;
        }
        float pageWidth = this.getPageWidth();
        float[] colWidthCm = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            colWidthCm[i] = pageWidth * (float)widths[i] / (float)totalWidthObs;
        }
        ArrayList<PdfPCell> headerCells = new ArrayList<PdfPCell>();
        headerCells.add(this.createPdfCell("Datum", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Ereignis", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Information", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Erfassung", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        this.createTable(colWidthCm, 1);
        this.addHeader(headerCells, this.table);
        for (long id : eventIds) {
            this.progressCurrent += this.progressStep;
            if (this.progress != null) {
                // empty if block
            }
            CmsEvent event = (CmsEvent)this.project.loadElement(id, this.project.getUser());
            this.table.addCell(this.createPdfCell(Util.formatDate((Date)event.getDateAttribute("date").getDate(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone()) + (event.hasAttributeValue("time") ? " " + event.getAttributeValue("time") : ""), true, this.formatTable, 0, 2));
            this.table.addCell(this.createPdfCell(event.getEventTitle(), true, this.formatTable, 0, 2));
            StringBuilder infoText = new StringBuilder();
            if (event.hasAttributeValue("comment")) {
                infoText.append(infoText.length() > 0 ? "\n" : "").append(infoText.length() > 0 ? "\n" : "").append(event.getAttributeValue("comment"));
            }
            if (event.hasAttributeValue("participants")) {
                infoText.append(infoText.length() > 0 ? "\n" : "").append("Teilnehmer:\n  ").append(event.getAttributeValue("participants").replaceAll("\\n", "\\n  "));
            }
            if (event.hasAttributeValue("place")) {
                infoText.append(infoText.length() > 0 ? "\n" : "").append("Ort:\n  ").append(event.getAttributeValue("place"));
            }
            if (event.isSigned()) {
                infoText.append(infoText.length() > 0 ? "\n" : "").append("Das Ereignis ist versiegelt!");
            }
            this.table.addCell(this.createPdfCell(infoText.toString(), true, this.formatTable, 0, 2));
            infoText = new StringBuilder();
            Properties props = event.getEventStatistics();
            if (Util.parseInt((String)props.getProperty("obs.type1", "0"), (int)0) > 0) {
                infoText.append(this.app.getSettings().getTerm(ThemisSettings.Term.TypMangel)).append(": ").append(props.getProperty("obs.type1", "0"));
            }
            if (Util.parseInt((String)props.getProperty("obs.type2", "0"), (int)0) > 0) {
                infoText.append("\n").append(this.app.getSettings().getTerm(ThemisSettings.Term.TypKontrolle)).append(": ").append(props.getProperty("obs.type2", "-"));
            }
            if (Util.parseInt((String)props.getProperty("obs.type3", "0"), (int)0) > 0) {
                infoText.append("\n").append(this.app.getSettings().getTerm(ThemisSettings.Term.TypInformation)).append(": ").append(props.getProperty("obs.type3", "-"));
            }
            if (Util.parseInt((String)props.getProperty("obs.type4", "0"), (int)0) > 0) {
                infoText.append("\n").append(this.app.getSettings().getTerm(ThemisSettings.Term.TypAufgabe)).append(": ").append(props.getProperty("obs.type4", "-"));
            }
            this.table.addCell(this.createPdfCell(infoText.toString(), true, this.formatTable, 0, 2));
            this.table.completeRow();
            if (!this.progress.isCancelled()) continue;
            return;
        }
        this.document.add((Element)this.table);
        this.document.add((Element)this.createParagraph("", this.formatText));
    }

    public void createAnnualControlTable(String columnPlaceholder, int year) throws DocumentException {
        boolean emptyTable = true;
        ThemisFilter filter = new ThemisFilter(ThemisApplication.getInstance());
        filter.setTriggerEnabled(false);
        filter.setControlFilter();
        ArrayList<DataRecord> records = new ArrayList<DataRecord>();
        records.addAll(filter.getFilteredObservations(null, null, false));
        ArrayList eventIds = this.project.getEventSearchResult(year).getResultIds();
        ArrayList<CmsEvent> events = new ArrayList<CmsEvent>();
        Iterator iterator = eventIds.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            events.add((CmsEvent)this.project.loadElement(id, this.project.getUser()));
        }
        int countTotal = records.size();
        this.progressStep = (this.progressTo - this.progressFrom) / (double)countTotal;
        this.progressCurrent = this.progressFrom;
        HashMap<Long, int[]> tbl = new HashMap<Long, int[]>();
        for (DataRecord rec : records) {
            int[] monthcount = new int[12];
            for (CmsEvent ev : events) {
                int month;
                ArrayList<Long> observationIds = ev.getObservationIds();
                if (!observationIds.contains(rec.getLong("observationid"))) continue;
                Date dt = ev.getDateAttribute("date").getDate();
                Calendar cal = Calendar.getInstance();
                cal.setTime(dt);
                int n = month = cal.get(2);
                monthcount[n] = monthcount[n] + 1;
                emptyTable = false;
            }
            tbl.put(rec.getLong("observationid"), monthcount);
            if (!this.progress.isCancelled()) continue;
            return;
        }
        if (emptyTable) {
            this.document.add((Element)this.createParagraph("Keine Eintr\u00e4ge", this.formatHeading2));
            return;
        }
        int[] widths = new int[]{10, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int totalWidthObs = 0;
        for (int w : widths) {
            totalWidthObs += w;
        }
        String groupAttribute = "g.uuid";
        String groupText = "[#!#g.nummer#!#] #!#g.titel#!#";
        boolean groupPagebreak = false;
        String col1 = "b.titel";
        String col2 = columnPlaceholder;
        String lastGroupValue = null;
        String currentGroupValue = null;
        Color headerColor = new Color(225, 225, 225);
        ArrayList<PdfPCell> headerCells = new ArrayList<PdfPCell>();
        headerCells.add(this.createPdfCell("Kontrolle", this.formatTableHeader, 1.0f, 0, 2, headerColor, 5.0f));
        headerCells.add(this.createPdfCell("Int", this.formatTableHeader, 1.0f, 1, 2, headerColor, 5.0f));
        for (int ii = 1; ii <= 12; ++ii) {
            headerCells.add(this.createPdfCell(Integer.toString(ii), this.formatTableSmall, 1.0f, 1, 2, headerColor, 5.0f));
        }
        float pageWidth = this.getPageWidth();
        float[] colWidthCm = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            colWidthCm[i] = pageWidth * (float)widths[i] / (float)totalWidthObs;
        }
        Object colPixelsLoc = null;
        this.createTable(colWidthCm, 1);
        this.addHeader(headerCells, this.table);
        boolean firstRecord = true;
        boolean newGroup = true;
        if (emptyTable) {
            PdfPCell cell = this.createPdfCell("Keine Eintr\u00e4ge", this.formatTable, 1.0f, 0, 2, null, 5.0f);
            cell.setColspan(15);
            this.table.addCell(cell);
        } else {
            for (DataRecord rec : records) {
                this.progressCurrent += this.progressStep;
                if (this.progress != null) {
                    // empty if block
                }
                if (this.progress.isCancelled()) {
                    return;
                }
                if (groupAttribute != null && (currentGroupValue = this.ph.getPlaceholderContent(groupAttribute, rec)) != null && !currentGroupValue.equals(lastGroupValue) && !firstRecord) {
                    if (groupPagebreak) {
                        try {
                            this.document.add((Element)this.table);
                        }
                        catch (DocumentException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        this.addPagebreak();
                        this.createTable(colWidthCm, 1);
                        this.addHeader(headerCells, this.table);
                    }
                    newGroup = true;
                }
                if (newGroup && currentGroupValue != null) {
                    String pdfText = this.ph.apply(groupText, rec);
                    PdfPCell cell = this.createPdfCell(pdfText, this.formatTableHeading, 1.0f, 0, 2, new Color(245, 245, 245), 5.0f);
                    cell.setColspan(15);
                    this.table.addCell(cell);
                }
                newGroup = false;
                lastGroupValue = currentGroupValue;
                firstRecord = false;
                ArrayList<Paragraph> paras = new ArrayList<Paragraph>();
                paras.add(this.createParagraph(this.ph.getPlaceholderContent(col1, rec), this.formatTable));
                paras.add(this.createParagraph(this.ph.getPlaceholderContent(col2, rec), this.formatTableSmall));
                this.table.addCell(this.createPdfCell(paras, 1.0f, 0, 2, Color.WHITE, 5.0f));
                String interval = "";
                Integer idrepeat = rec.getInt("idrepeat");
                if (idrepeat != null) {
                    switch (idrepeat) {
                        case 1: {
                            interval = rec.getString("repeatcount") + " T";
                            break;
                        }
                        case 2: {
                            interval = rec.getString("repeatcount") + " W";
                            break;
                        }
                        case 3: {
                            interval = rec.getString("repeatcount") + " M";
                            break;
                        }
                        case 4: {
                            interval = rec.getString("repeatcount") + " J";
                        }
                    }
                }
                this.table.addCell(this.createPdfCell(interval, this.formatTable, 1.0f, 1, 2, Color.WHITE, 5.0f));
                int[] months = (int[])tbl.get(rec.getLong("observationid"));
                for (int ii = 0; ii < 12; ++ii) {
                    this.table.addCell(this.createPdfCell(months[ii] > 0 ? "X" : "", this.formatTable, 1.0f, 1, 2, Color.WHITE, 5.0f));
                }
                this.table.completeRow();
            }
        }
        this.addTable();
        this.addPagebreak();
    }

    public void createStandardTable() throws DocumentException {
        ArrayList<Long> ids = this.getContentIds();
        this.createStandardTable(ids);
        this.observationIdsInTable.addAll(ids);
    }

    public void createStandardTableOpen() throws DocumentException {
        ArrayList<Long> ids;
        CmsEvent ev = this.rep.getLastEvent();
        if (ev != null) {
            ArrayList<Long> ids2 = ev.getOpenTasks();
            ids = new ArrayList();
            for (long id : ids2) {
                if (this.observationIdsInTable.contains(id)) continue;
                ids.add(id);
            }
        } else {
            ids = this.getOpenTasks(this.observationIdsInTable);
        }
        if (!ids.isEmpty()) {
            this.createStandardTable(ids);
        } else {
            this.document.add((Element)this.createParagraph("Keine Eintr\u00e4ge", this.formatHeading2));
        }
    }

    public void createStandardTable(ArrayList<Long> ids) throws DocumentException {
        boolean hasPlans = !ThemisApplication.getInstance().getProject().getPlans().isEmpty();
        int[] widths = hasPlans ? new int[]{12, 65, 38, 30, 20} : new int[]{12, 95, 38, 20};
        int totalWidthObs = 0;
        for (int w : widths) {
            totalWidthObs += w;
        }
        HashMap<Long, CmsEvent> events = new HashMap<Long, CmsEvent>();
        boolean useMeasure = this.app.getSettings().getObservationAttribute("measure").isUsed();
        boolean useStatus = this.app.getSettings().getObservationAttribute("done").isUsed();
        ArrayList<ThemisAttribute> ignoreAtts = new ArrayList<ThemisAttribute>();
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("donedate"));
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("type"));
        ArrayList<PdfPCell> headerCells = new ArrayList<PdfPCell>();
        headerCells.add(this.createPdfCell("Pos", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Gegenstand/Plan, Beobachtung" + (useMeasure ? ", Ma\u00dfnahme" : ""), this.formatTableHeader, 1.0f, 0, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Datum", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        if (hasPlans) {
            headerCells.add(this.createPdfCell("Plan", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        }
        headerCells.add(this.createPdfCell("Status", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        float pageWidth = this.getPageWidth();
        float[] colWidthCm = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            colWidthCm[i] = pageWidth * (float)widths[i] / (float)totalWidthObs;
        }
        Object colPixelsLoc = null;
        long lastLoc = -1L;
        File planSnippetfile = null;
        ArrayList<CmsHistory> histories = new ArrayList<CmsHistory>();
        int counter = 1;
        String statusText = "";
        Placeholder ph = new Placeholder(this.rep);
        if (this.rep.event != null) {
            ph.setEvent(this.rep.event);
        }
        if (this.progress != null) {
            this.progress.progress("Planausschnitte werden erzeugt");
        }
        PlanSnippetGenerator.generate(this.rep, this.locationIds, this.progress);
        if (this.progress != null) {
            this.progress.progress("Beobachtungen werden geladen, PDF wird erstellt");
        }
        this.createTable(colWidthCm, 1);
        this.addHeader(headerCells, this.table);
        if (ids.isEmpty()) {
            PdfPCell c = this.createPdfCell("Keine Eintr\u00e4ge", true, this.formatTable, 2, 2);
            c.setColspan(this.table.getNumberOfColumns());
            this.table.addCell(c);
        }
        for (long id : ids) {
            long docId;
            CmsLocation loc;
            CmsObservation obs;
            if (this.progress.isCancelled()) {
                return;
            }
            this.progressCurrent += this.progressStep;
            if (this.progress != null) {
                // empty if block
            }
            CmsPlan plan = null;
            boolean planHasBuilding = false;
            CmsElement ele = this.project.loadElement(id, this.project.getUser());
            if ("observation".equals(ele.getElementcode())) {
                obs = (CmsObservation)ele;
                loc = null;
            } else {
                obs = (CmsObservation)this.project.getDefaultElement("observation");
                loc = (CmsLocation)ele;
                if (!this.rep.exportLocationsWithoutObservations) continue;
            }
            if (obs != null) {
                Iterator iterator = obs.getRelationAttribute("infos").getElementIds(false).iterator();
                while (iterator.hasNext()) {
                    docId = (Long)iterator.next();
                    if (this.documentIds.contains(docId)) continue;
                    this.documentIds.add(docId);
                }
                if (loc == null) {
                    long locid = obs.getRelationAttribute("location").getFirstElementId();
                    if (locid >= 0L) {
                        loc = (CmsLocation)this.project.loadElement(locid, this.project.getUser());
                    }
                } else {
                    long locid = loc.getId();
                }
            }
            if (loc != null) {
                if (!this.locationIds.contains(loc.getId())) {
                    this.locationIds.add(loc.getId());
                }
                if (!loc.getRelationAttribute("plan").isEmpty()) {
                    plan = (CmsPlan)loc.getRelationAttribute("plan").getFirstElement().getElement();
                    planHasBuilding = plan.hasAttributeValue("building");
                }
                Iterator locid = loc.getRelationAttribute("infos").getElementIds(false).iterator();
                while (locid.hasNext()) {
                    docId = (Long)locid.next();
                    if (this.documentIds.contains(docId)) continue;
                    this.documentIds.add(docId);
                }
                planSnippetfile = new File(ThemisApplication.getInstance().getProject().getPlansnippetLocation(), loc.getId() + "_" + this.rep.getPlanSnippetSize() + ".jpg");
            }
            histories.clear();
            if (this.rep.exportWithHistories) {
                if (obs.getHistories() != null) {
                    for (CmsElement h : obs.getHistories()) {
                        if (h == null) continue;
                        long historyEventId = ((CmsHistory)h).getEventId();
                        if (this.rep.contentType == CmsReport.Content.PERIOD) {
                            ArrayList<Long> eventids = this.rep.getPeriodEventIds();
                            if (!eventids.contains(historyEventId)) continue;
                            histories.add((CmsHistory)h);
                            continue;
                        }
                        histories.add((CmsHistory)h);
                    }
                }
            } else {
                CmsEvent e = this.rep.getLastEvent();
                CmsHistory h = e == null ? obs.getLatestHistory() : obs.getHistoryOrBefore(e);
                if (h != null) {
                    histories.add(h);
                }
            }
            if (histories.isEmpty() && this.rep.contentType != CmsReport.Content.PERIOD) {
                histories.add((CmsHistory)this.project.getDefaultElement("history"));
            }
            for (CmsHistory hist : histories) {
                obs.applyHistory(hist);
                this.table.addCell(this.createPdfCell(loc == null ? "" : loc.getFullNumber() + (obs.getId() >= 0L ? "." + obs.getAttributeValue("number") : ""), true, this.formatTable, 1, 2));
                StringBuilder infoText = new StringBuilder();
                if (this.rep.exportWithHistories) {
                    long idEvent = hist.getEventId();
                    CmsEvent ev = null;
                    if (events.containsKey(idEvent)) {
                        ev = (CmsEvent)((Object)events.get(idEvent));
                    } else {
                        ev = hist.getEvent();
                        if (ev != null) {
                            events.put(ev.getId(), ev);
                        }
                    }
                    if (ev != null) {
                        infoText.append("Ereignis: ").append(ev.getTitle()).append("\n");
                    }
                }
                if (loc != null) {
                    infoText.append(loc.getAttributeValue("title") + (loc.getRelationAttribute("plan").isEmpty() ? "" : " / " + (planHasBuilding ? "[" + plan.getRelationAttribute("building").getFirstElementTitle() + "] " : "") + loc.getRelationAttribute("plan").getFirstElementTitle()));
                    infoText.append("\n");
                    ArrayList<ThemisAttribute> atts = new ArrayList<ThemisAttribute>();
                    block24: for (ThemisAttribute att : this.app.getSettings().getLocationAttributesUsed()) {
                        switch (att.getCmsCode()) {
                            case "title": 
                            case "building": 
                            case "plan": {
                                continue block24;
                            }
                        }
                        atts.add(att);
                    }
                    String otherAtts = ThemisUtil.toString(loc, "", "\n", false, atts, false);
                    infoText.append(otherAtts).append("\n");
                }
                infoText.append(obs.toStringWithIgnore("", "\n", false, ignoreAtts));
                this.table.addCell(this.createPdfCell(infoText.toString(), true, this.formatTable, 0, 2));
                if (obs.getId() >= 0L) {
                    String dateText = "Erstellt: " + obs.getAttributeValue("creationdate") + "\nKontrolliert: " + hist.getAttributeValue("eventdate");
                    if (hist.hasAttributeValue("duedate")) {
                        dateText = dateText + "\n" + (obs.isOfType(2) ? "Termin: " : "F\u00e4llig: ") + hist.getAttributeValue("duedate");
                    }
                    if (useStatus && obs.getBooleanAttribute("done").isSet() && (obs.isOfType(1) || obs.isOfType(4))) {
                        dateText = dateText + "\nErledigt: " + obs.getAttributeValue("donedate");
                    }
                    this.table.addCell(this.createPdfCell(dateText, true, this.formatTable, 2, 2));
                } else {
                    this.table.addCell(this.createPdfCell("", true, this.formatTable, 2, 2));
                }
                if (hasPlans) {
                    if (planSnippetfile != null && planSnippetfile.isFile()) {
                        this.createImageCell(null, null, planSnippetfile, colWidthCm[3] - 2.0f * this.imagePadding, null);
                        this.table.addCell(this.tableCell);
                    } else {
                        this.table.addCell(this.createPdfCell("", true, this.formatTable, 2, 2));
                    }
                }
                if (obs.getId() >= 0L) {
                    String obstype = "";
                    switch ((int)obs.getKeyAttribute("type").getId()) {
                        case 2: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypKontrolle);
                            break;
                        }
                        case 1: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypMangel);
                            break;
                        }
                        case 3: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypInformation);
                            break;
                        }
                        case 4: {
                            obstype = this.app.getSettings().getTerm(ThemisSettings.Term.TypAufgabe);
                        }
                    }
                    Color bgColor = null;
                    if (useStatus && obs.isOfType(1) || obs.isOfType(4)) {
                        statusText = obstype + ("".equals(obstype) ? "" : "\n") + (obs.getBooleanAttribute("done").isSet() ? this.rep.textStatusDone : this.rep.textStatusOpen);
                        bgColor = obs.getBooleanAttribute("done").isSet() ? ThemisColors.lightgreen : ThemisColors.COLOR_DEFECT;
                    } else {
                        statusText = obstype;
                    }
                    this.table.addCell(this.createPdfCell(statusText, this.formatTable, 1.0f, 1, 2, bgColor, 5.0f));
                } else {
                    this.table.addCell(this.createPdfCell("", true, this.formatTable, 2, 2));
                }
                this.table.completeRow();
                ArrayList<UploadItem> imageUploadItems = ExportUtil.getImages(this.rep, loc, obs, hist);
                try {
                    this.addImageRow(imageUploadItems, this.table);
                }
                catch (BadElementException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                ++counter;
            }
        }
        this.document.add((Element)this.table);
        this.document.add((Element)this.createParagraph("", this.formatText));
    }

    public void createDocumentList() throws DocumentException {
        ArrayList<CmsElementSummary> documents = this.project.getDocuments();
        if (documents == null || documents.isEmpty()) {
            this.document.add((Element)this.createParagraph("Keine Eintr\u00e4ge", this.formatHeading2));
            return;
        }
        int[] widths = new int[]{10, 6, 10, 10};
        int totalWidthObs = 0;
        for (int w : widths) {
            totalWidthObs += w;
        }
        float pageWidth = this.getPageWidth();
        float[] colWidthCm = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            colWidthCm[i] = pageWidth * (float)widths[i] / (float)totalWidthObs;
        }
        ArrayList<PdfPCell> headerCells = new ArrayList<PdfPCell>();
        headerCells.add(this.createPdfCell("Titel", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Datum", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Beschreibung", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Dateien", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        this.createTable(colWidthCm, 1);
        this.addHeader(headerCells, this.table);
        HashMap documentMap = new HashMap();
        ArrayList<String> documentTypes = new ArrayList<String>();
        for (CmsElementSummary ele : documents) {
            CmsInfo doc = (CmsInfo)this.project.loadElement(ele.getId(), this.project.getUser());
            String type = doc.getKeyAttribute("documenttype").getValue();
            if (type == null) {
                type = "";
            }
            if (!documentTypes.contains(type)) {
                documentTypes.add(type);
            }
            ArrayList<CmsInfo> docs = documentMap.getOrDefault(type, new ArrayList());
            docs.add(doc);
            documentMap.put(type, docs);
        }
        if (documentMap.isEmpty()) {
            LayoutCell l = new LayoutCell(null);
            l.setSpan(widths.length);
            this.table.addCell(this.createPdfCell("Keine Dokumente", l, null));
            this.table.completeRow();
            this.document.add((Element)this.table);
            return;
        }
        boolean showDocumentType = documentTypes.size() > 1 || !"".equals(documentTypes.get(0));
        for (String type : documentTypes) {
            if (showDocumentType) {
                LayoutCell l = new LayoutCell(null);
                l.setSpan(widths.length);
                this.table.addCell(this.createPdfCell(type, l, Color.LIGHT_GRAY));
                this.table.completeRow();
            }
            ArrayList docs = (ArrayList)documentMap.get(type);
            for (CmsInfo doc : docs) {
                this.progressCurrent += this.progressStep;
                if (this.progress != null) {
                    // empty if block
                }
                this.table.addCell(this.createPdfCell(doc.getAttributeValue("title"), true, this.formatTable, 0, 2));
                this.table.addCell(this.createPdfCell(doc.getAttributeValue("date"), true, this.formatTable, 0, 2));
                this.table.addCell(this.createPdfCell(doc.getAttributeValue("comment"), true, this.formatTable, 0, 2));
                StringBuilder files = new StringBuilder();
                boolean first = true;
                for (UploadItem item : doc.getUploadAttribute("files").getUploadItems()) {
                    files.append(first ? "- " : "\n- ").append(item.getName());
                    first = false;
                }
                this.table.addCell(this.createPdfCell(files.toString(), true, this.formatTable, 0, 2));
                this.table.completeRow();
            }
        }
        this.document.add((Element)this.table);
        this.document.add((Element)this.createParagraph("", this.formatText));
    }

    public void createContactList() throws DocumentException {
        ArrayList<CmsBasicElement> contactlist = this.project.getContacts();
        if (contactlist.isEmpty()) {
            this.document.add((Element)this.createParagraph("Keine Eintr\u00e4ge", this.formatHeading2));
            return;
        }
        int[] widths = new int[]{10, 10, 10};
        int totalWidthObs = 0;
        for (int w : widths) {
            totalWidthObs += w;
        }
        float pageWidth = this.getPageWidth();
        float[] colWidthCm = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            colWidthCm[i] = pageWidth * (float)widths[i] / (float)totalWidthObs;
        }
        ArrayList<PdfPCell> headerCells = new ArrayList<PdfPCell>();
        headerCells.add(this.createPdfCell("Name", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("E-Mail", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        headerCells.add(this.createPdfCell("Telefon", this.formatTableHeader, 1.0f, 1, 2, Color.lightGray, 5.0f));
        this.createTable(colWidthCm, 1);
        this.addHeader(headerCells, this.table);
        ArrayList<CmsCompany> contacts = new ArrayList<CmsCompany>();
        for (CmsBasicElement ele : this.project.getContacts()) {
            contacts.add((CmsCompany)this.project.loadElement(ele.getId(), this.project.getUser()));
        }
        if (contacts.isEmpty()) {
            LayoutCell l = new LayoutCell(null);
            l.setSpan(widths.length);
            this.table.addCell(this.createPdfCell("Keine Kontakte", l, null));
            this.table.completeRow();
            this.document.add((Element)this.table);
            return;
        }
        for (CmsCompany contact : contacts) {
            this.progressCurrent += this.progressStep;
            if (this.progress != null) {
                // empty if block
            }
            this.table.addCell(this.createPdfCell(contact.getAttributeValue("name"), true, this.formatTable, 0, 2));
            this.table.addCell(this.createPdfCell(contact.getAttributeValue("email"), true, this.formatTable, 0, 2));
            this.table.addCell(this.createPdfCell(contact.getAttributeValue("tel"), true, this.formatTable, 0, 2));
            this.table.completeRow();
        }
        this.document.add((Element)this.table);
        this.document.add((Element)this.createParagraph("", this.formatText));
    }

    public void createForm(CmsFormular f) throws DocumentException {
        int[] widths = new int[]{10, 100, 60};
        int totalWidthObs = 0;
        for (int w : widths) {
            totalWidthObs += w;
        }
        float pageWidth = this.getPageWidth();
        float[] colWidthCm = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            colWidthCm[i] = pageWidth * (float)widths[i] / (float)totalWidthObs;
        }
        CmsFormularHistory fh = this.rep.hasEvent() ? f.getFormHistory(this.rep.event) : f.getLatestFormHistory();
        if (fh == null) {
            this.createParagraph("Kein ausgef\u00fclltes Formular verf\u00fcgbar", this.formatText);
            return;
        }
        this.createTable(colWidthCm, 0);
        PdfParagraphFormat fmt = this.formatSmall;
        boolean row = false;
        for (FormItem item : fh.getItems()) {
            if (item.checkCondition()) {
                switch (item.getType()) {
                    case "heading1": {
                        PdfPCell c = this.createPdfCell(item.getLabel(), false, this.formatHeading1, 0, 2);
                        c.setColspan(3);
                        this.table.addCell(c);
                        break;
                    }
                    case "heading2": {
                        PdfPCell c = this.createPdfCell(item.getLabel(), false, this.formatHeading2, 0, 2);
                        c.setColspan(3);
                        this.table.addCell(c);
                        break;
                    }
                    case "info": {
                        PdfPCell c = this.createPdfCell(item.getLabel(), false, fmt, 0, 2);
                        c.setColspan(3);
                        this.table.addCell(c);
                        break;
                    }
                    case "date": 
                    case "select": 
                    case "shorttext": {
                        PdfPCell c = this.createPdfCell(item.getLabel(), false, fmt, 0, 2);
                        c.setColspan(2);
                        this.table.addCell(c);
                        c = this.createPdfCell(item.getValue(), false, fmt, 0, 2);
                        this.table.addCell(c);
                        break;
                    }
                    case "checkbox": {
                        String v = item.getValue();
                        if (v == null || "".equals(v)) {
                            v = "O";
                        }
                        PdfPCell c = this.createPdfCell(v.toUpperCase() + "  " + item.getLabel(), false, fmt, 0, 2);
                        c.setColspan(3);
                        this.table.addCell(c);
                        break;
                    }
                    case "text": 
                    case "longtext": {
                        PdfPCell c = this.createPdfCell(item.getLabel(), false, fmt, 0, 2);
                        c.setColspan(3);
                        this.table.addCell(c);
                        this.table.completeRow();
                        c = this.createPdfCell("", false, fmt, 0, 2);
                        this.table.addCell(c);
                        c = this.createPdfCell(item.getValue(), false, fmt, 0, 2);
                        c.setColspan(2);
                        this.table.addCell(c);
                    }
                }
            }
            this.table.completeRow();
        }
        this.document.add((Element)this.table);
        this.document.add((Element)this.createParagraph("", fmt));
    }

    protected void addToDocument(Element e) {
        try {
            if (e != null) {
                this.document.add(e);
            }
        }
        catch (DocumentException ex) {
            this.project.getLogger().severe("Error while adding content to PDF: " + ex.getMessage());
        }
    }

    protected Paragraph createParagraph(String content, PdfParagraphFormat fmt) {
        Paragraph paragraph = new Paragraph(content, fmt.font);
        paragraph.setSpacingBefore(fmt.spacingBefore);
        paragraph.setSpacingAfter(fmt.spacingAfter);
        return paragraph;
    }

    protected PdfPCell createPdfCell(String c, LayoutCell l, Color cBG) {
        this.createCell(c, l, cBG);
        return this.tableCell;
    }

    protected PdfPCell createPdfCell(String content, boolean border, PdfParagraphFormat fmt, int align, int indent) {
        return this.createPdfCell(content, fmt, border ? 1.0f : 0.0f, align, indent, null, 5.0f);
    }

    protected PdfPCell createPdfCell(ArrayList<Paragraph> paras, float borderwidth, int align, int indent, Color c, float padding) {
        this.tableCell = new PdfPCell();
        this.tableCell.setBorderWidth(borderwidth);
        this.tableCell.setHorizontalAlignment(align);
        this.tableCell.setPadding(padding);
        this.tableCell.setUseBorderPadding(true);
        this.tableCell.setUseAscender(true);
        this.tableCell.setUseDescender(true);
        for (Paragraph p : paras) {
            this.tableCell.addElement((Element)p);
        }
        if (c != null) {
            this.tableCell.setBackgroundColor(c);
        }
        return this.tableCell;
    }

    protected PdfPCell createPdfCell(String content, PdfParagraphFormat fmt, float borderwidth, int align, int indent, Color c, float padding) {
        LayoutCell l = new LayoutCell(null);
        l.setFontSize((int)fmt.font.getSize());
        l.setBorder(borderwidth);
        this.createCell(content, l, c);
        this.tableCell.setHorizontalAlignment(align);
        this.tableCell.setBorderWidth(borderwidth);
        this.tableCell.setPadding(padding);
        return this.tableCell;
    }

    @Override
    protected void createCell(String c, LayoutCell l, Color cBG) {
        this.createCell(c, l, cBG, false);
    }

    @Override
    protected void createCell(String c, LayoutCell l, Color cBG, boolean keepTogether) {
        int rowheight;
        LayoutRow r;
        this.tableCell = new PdfPCell();
        int align = 0;
        com.lowagie.text.Font font = new com.lowagie.text.Font(this.fontFamily, 9.0f, 0);
        if (l != null) {
            int fontSpec = 0;
            int fontsize = 12;
            int fontfamily = 1;
            fontSpec = 0 + (l.isFontBold() ? 1 : 0) + (l.isFontItalic() ? 2 : 0) + (l.isFontUnderlined() ? 4 : 0);
            fontsize = l.getFontSize();
            font = new com.lowagie.text.Font(fontfamily, (float)fontsize, fontSpec);
            if (l.hasBorder()) {
                this.tableCell.setBorderWidth(l.getBorder());
            } else {
                this.tableCell.setBorderWidth(0.0f);
            }
            switch (l.getAlign()) {
                case CENTER: {
                    align = 1;
                    break;
                }
                case RIGHT: {
                    align = 2;
                }
            }
            this.tableCell.setHorizontalAlignment(align);
            this.tableCell.setColspan(l.getSpan());
        } else {
            this.tableCell.setBorderWidth(0.0f);
        }
        if (cBG != null) {
            this.tableCell.setBackgroundColor(cBG);
        }
        this.tableCell.setPadding(this.tableCellPadding);
        this.tableCell.setUseBorderPadding(true);
        this.tableCell.setUseAscender(true);
        this.tableCell.setUseDescender(true);
        if (c != null) {
            Paragraph p = new Paragraph(c, font);
            p.setSpacingAfter(this.paragraphSpacing);
            p.setSpacingBefore(this.paragraphSpacing);
            p.setAlignment(align);
            if (keepTogether) {
                p.setKeepTogether(true);
            }
            this.tableCell.addElement((Element)p);
        }
        LayoutRow layoutRow = r = l == null ? null : l.getRow();
        if (r != null && (rowheight = r.getHeight()) >= 0) {
            this.tableCell.setFixedHeight(ReportGenerator.cmToPixel((float)rowheight / 10.0f));
        }
    }

    @Override
    protected void createMultipleImageCell(LayoutCell l, ArrayList<ReportGenerator.ImageSpecification> imageUploadItems, float imageWidth, float cellWidth) {
        this.tableCell = this.createPdfCell(null, l, null);
        int imagesPerLine = -1;
        if (imageWidth > 0.0f) {
            imagesPerLine = (int)Math.floor(cellWidth / imageWidth);
        }
        if (imageUploadItems.size() > 0) {
            Paragraph p = new Paragraph();
            p.setSpacingAfter(this.imageSpacing);
            p.setSpacingBefore(this.imageSpacing);
            for (int ii = 0; ii < imageUploadItems.size(); ++ii) {
                Image image = this.createImage(imageUploadItems.get((int)ii).item, (int)ReportGenerator.cmToPixel(imageWidth));
                if (image == null) continue;
                p.add((Object)new Chunk(image, 0.0f, 4.0f * this.imageSpacing, true));
                p.add((Object)" ");
            }
            this.tableCell.addElement((Element)p);
        }
    }

    @Override
    protected void setCellColSpan(int cols) {
        if (this.tableCell != null) {
            this.tableCell.setColspan(cols);
        }
    }

    @Override
    protected void setCellBackground(Color c) {
        if (this.tableCell != null) {
            this.tableCell.setBackgroundColor(c);
        }
    }

    @Override
    protected void addCellToTable() {
        if (this.table != null && this.tableCell != null) {
            this.table.addCell(this.tableCell);
        }
    }

    @Override
    protected void createImageCell(LayoutCell cell, ArrayList<SimpleGeometry> drawings, File imagefile, float imageWidth, String text) {
        this.createCell(null, cell, null);
        if (cell == null) {
            this.tableCell.setBorderWidth(1.0f);
        }
        try {
            int imageWidthPixel = imageWidth >= 50.0f ? (int)imageWidth : (int)ReportGenerator.cmToPixel(imageWidth);
            Image img = this.createImage(drawings, imagefile, imageWidthPixel, text);
            if (img != null) {
                Paragraph p = new Paragraph();
                p.setSpacingAfter(this.imageSpacing);
                p.setSpacingBefore(this.imageSpacing);
                p.add((Object)new Chunk(img, 0.0f, 0.0f, true));
                this.tableCell.setHorizontalAlignment(0);
                this.tableCell.addElement((Element)p);
            }
        }
        catch (Exception e) {
            this.tableCell.addElement((Element)new Paragraph("<" + this.project.getResourceText("error.image-missing", this.app.getLocale()) + ">"));
        }
    }

    public Image createImage(UploadItem item) {
        int w = Util.parseInt((String)item.getProperty("width", "-1"), (int)-1);
        return this.createImage(item, w);
    }

    public Image createImage(UploadItem item, int imageWidth) {
        this.ph.getImageNumber(item);
        return this.createImage(ThemisApplication.getInstance().getProject().getDrawings(item.getId()), item.getFile(), imageWidth, item.getProperty("date", null));
    }

    public Image createImage(UploadItem item, double imageWidthCM) {
        this.ph.getImageNumber(item);
        return this.createImage(ThemisApplication.getInstance().getProject().getDrawings(item.getId()), item.getFile(), imageWidthCM, item.getProperty("date", null));
    }

    public Image createImage(ArrayList<SimpleGeometry> drawings, File imagefile, String text) {
        return this.createImage(drawings, imagefile, -1, text);
    }

    public Image createImage(ArrayList<SimpleGeometry> drawings, File imagefile, double longSideCM, String text) {
        int px = (int)(72.0 * longSideCM / 2.54);
        return this.createImage(drawings, imagefile, px, text);
    }

    public Image createImage(ArrayList<SimpleGeometry> drawings, File imagefile, int longSide, String text) {
        if (imagefile == null || !imagefile.isFile()) {
            return null;
        }
        float compression = this.rep.getPdfCompressionValue();
        int dpi = this.rep.getPdfImageResolution();
        int imagePixel = longSide > 0 ? (int)((float)(dpi * longSide) / 72.0f) : 0;
        Image img = null;
        try {
            ImagePanel panel = new ImagePanel(ThemisApplication.getInstance().getProject().getLogger());
            panel.setBackgroundImage(imagefile);
            if (drawings != null) {
                for (SimpleGeometry geometry : drawings) {
                    for (int ii = 0; ii < geometry.size(); ++ii) {
                        Point p = (Point)geometry.getPoints().get(ii);
                    }
                    geometry.getDisplay().setLinewidth(8);
                    panel.addGeometry(geometry);
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedImage bi = Util.resizeImageOnLongSide((BufferedImage)panel.getAsBufferedImage(), (int)imagePixel);
            if (this.rep.showDateInImage && text != null && !"".equals(text)) {
                int px = Math.min(bi.getHeight(), bi.getWidth());
                int fontsize = px / 12;
                Graphics2D gO = bi.createGraphics();
                gO.setColor(Color.red);
                Font font = new Font("Arial", 1, fontsize);
                gO.setFont(font);
                gO.drawString(text, 2, 2 + fontsize);
            }
            ImageIO.write((RenderedImage)bi, "jpg", baos);
            baos.flush();
            img = Image.getInstance((byte[])baos.toByteArray());
            baos.close();
            float ratio = img.getHeight() / img.getWidth();
            if (longSide >= 0) {
                float imgLongSide = img.getWidth() > img.getHeight() ? img.getWidth() : img.getHeight();
                float scale = (float)longSide / imgLongSide;
                img.scalePercent(100.0f * scale);
            } else if (ratio > 1.0f) {
                img.scalePercent(35.0f);
            }
        }
        catch (BadElementException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return img;
    }

    @Override
    protected boolean hasTable() {
        return this.table != null;
    }

    @Override
    protected void addTable() {
        try {
            if (this.table != null) {
                this.document.add((Element)this.table);
                this.document.add((Element)this.createParagraph(" ", this.formatText));
            }
        }
        catch (DocumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    protected void addParagraph(String txt) {
        try {
            this.document.add((Element)this.createParagraph(txt, this.formatText));
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    @Override
    protected void createTable(float[] widths, int headerRows) {
        try {
            this.table = new PdfPTable(widths.length);
            this.table.setWidthPercentage(100.0f);
            this.table.setWidths(widths);
            this.table.setHeaderRows(headerRows);
            this.table.setHorizontalAlignment(0);
        }
        catch (DocumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void addImageRow(List<UploadItem> imageUploadItems, PdfPTable table) throws BadElementException, IOException {
        int numberOfImagesPerRow = this.rep.getNumberOfImagesPerRow();
        float paragraphWidth = this.getPageWidth();
        float widthPercentage = table.getWidthPercentage();
        float tableWidth = widthPercentage * paragraphWidth / 100.0f;
        float imageWidthCm = 0.95f * (tableWidth / (float)numberOfImagesPerRow);
        int imageWidthPixel = (int)((double)(72.0f * imageWidthCm) / 2.54);
        if (imageUploadItems.size() > 0) {
            PdfPCell cell = this.createPdfCell("", true, this.formatTable, 2, 2);
            cell.setColspan(table.getNumberOfColumns());
            Paragraph p = new Paragraph();
            int imageRowSpacing = 5;
            p.setSpacingAfter((float)imageRowSpacing);
            for (int ii = 0; ii < imageUploadItems.size(); ++ii) {
                if (ii % numberOfImagesPerRow == 0 && ii != 0) {
                    cell.addElement((Element)p);
                    p = new Paragraph();
                    p.setSpacingAfter((float)imageRowSpacing);
                }
                imageUploadItems.get(ii).setProperty("width", Integer.toString(imageWidthPixel));
                Image image = this.createImage(imageUploadItems.get(ii));
                if (image == null) continue;
                p.add((Object)new Chunk(image, 0.0f, 0.0f, true));
                p.add((Object)" ");
            }
            cell.addElement((Element)p);
            table.addCell(cell);
        }
    }

    @Override
    protected void completeTableRow() {
        if (this.table != null) {
            this.table.completeRow();
        }
    }

    protected void addHeader(List<PdfPCell> cells, PdfPTable table) {
        if (cells != null && cells.size() > 0) {
            for (PdfPCell cell : cells) {
                table.addCell(cell);
            }
            table.completeRow();
        }
    }

    @Override
    protected float getPageWidth() {
        return 2.54f * (this.document.getPageSize().getWidth() - this.document.leftMargin() - this.document.rightMargin()) / 72.0f;
    }

    @Override
    protected void addPagebreak() {
        this.document.newPage();
    }

    public LayoutCell getCellLayout() {
        return this.cellLayout;
    }

    public LayoutCell getCellLayoutNoBorder() {
        return this.cellLayoutNoBorder;
    }

    public ArrayList<Long> getOpenTasks(ArrayList<Long> excludeIds) {
        if (excludeIds == null) {
            excludeIds = new ArrayList();
        }
        ThemisFilter filter = new ThemisFilter(ThemisApplication.getInstance());
        filter.setTriggerEnabled(false);
        filter.setMangelFilter();
        List<DataRecord> recs = filter.getFilteredObservations(null, null);
        ArrayList<Long> observationIds = new ArrayList<Long>();
        for (DataRecord rec : recs) {
            long id = rec.getLong("observationid");
            if (id <= 0L || observationIds.contains(id) || excludeIds.contains(id)) continue;
            observationIds.add(id);
        }
        return observationIds;
    }

    public ArrayList<Long> getElementIdsFromFilter() {
        ThemisFilter filter = ThemisApplication.getInstance().getFilter();
        return this.getFilteredElementIds(filter);
    }

    public ArrayList<Long> getElementIdsFromEvent(CmsEvent event) {
        if (event == null) {
            return new ArrayList<Long>();
        }
        ThemisFilter filter = new ThemisFilter(ThemisApplication.getInstance());
        filter.setTriggerEnabled(false);
        filter.getEventId().setItem(event.getId(), this);
        return this.getFilteredElementIds(filter);
    }

    private ArrayList<Long> getFilteredElementIds(ThemisFilter filter) {
        List<DataRecord> recs = filter.getFilteredObservations(this.rep.getSortSql(), null);
        ArrayList<Long> elementIds = new ArrayList<Long>();
        for (DataRecord rec : recs) {
            long id = rec.getLong("observationid");
            long idloc = rec.getLong("meta_id");
            if (id > 0L && !elementIds.contains(id)) {
                elementIds.add(id);
            } else if (!elementIds.contains(idloc)) {
                elementIds.add(idloc);
            }
            if (this.locationIds.contains(idloc)) continue;
            this.locationIds.add(idloc);
        }
        return elementIds;
    }

    public CmsObservation setSingleObservation(long id) {
        this.elementIds.clear();
        this.elementIds.add(id);
        CmsObservation obs = (CmsObservation)this.project.loadElement(id, this.project.getUser());
        return obs;
    }

    public void setObservations(ArrayList<Long> ids) {
        this.elementIds.clear();
        this.elementIds.addAll(ids);
    }

    public ArrayList<Long> getElementList() {
        return this.elementIds;
    }

    public ArrayList<Long> getContentIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        switch (this.rep.contentType) {
            case FILTER: {
                ids = this.getElementIdsFromFilter();
                break;
            }
            case EVENT: {
                ids = this.getElementIdsFromEvent(this.rep.event);
                break;
            }
            case SELECTION: {
                ids = this.project.getSelectionManager().getSelectedObservationIds();
                ArrayList<Long> locIds = this.project.getSelectionManager().getSelectedLocationIds();
                ArrayList locObsIds = this.project.getDatastorage().getRelationIds(ids, "locationobservation", false);
                for (long id : locIds) {
                    if (locObsIds.contains(id)) continue;
                    ids.add(id);
                }
                locIds.addAll(locObsIds);
                for (long id : locIds) {
                    if (this.locationIds.contains(id)) continue;
                    this.locationIds.add(id);
                }
                break;
            }
            case PERIOD: {
                ThemisFilter filter = new ThemisFilter(ThemisApplication.getInstance());
                filter.setTriggerEnabled(false);
                filter.setEventRange(this.rep.getPeriodFromDate(), this.rep.getPeriodUntilDate(), this);
                ids = this.getFilteredElementIds(filter);
            }
        }
        return ids;
    }
}

